/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jupiter.mass.log.updator.KakaoSwitchUpdator;
import jupiter.mass.log.updator.ScheduleTblBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.Task;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

public class KakaoMsgUpdator
extends Task {
    private static final Logger log = LoggerFactory.getLogger(KakaoMsgUpdator.class);
    private static ConnectInfo otherConnectInfo = new ConnectInfo();
    private static String querySelectTargetList = null;
    private static String queryAutoUpdateScheduleInfo = null;
    private static String queryCampUpdateScheduleInfo = null;
    private static final String _MASS_ = "MASS";
    private static final String _AUTO_ = "AUTO";
    private static final String _TEST_ = "TEST";
    private eMsConnection oriCon = null;
    private eMsConnection moduleCon = null;
    private eMsResultSet rsSelect = null;
    private eMsPreparedStatement psSelect = null;
    private eMsStatement psSchdUpdate = null;
    private boolean isOtherDb = false;
    private Properties taskProp = null;
    private static int commitInterval = 1000;
    private Map<String, List<Properties>> autoListTarget = new HashMap<String, List<Properties>>();
    private Map<String, List<Properties>> campListTarget = new HashMap<String, List<Properties>>();
    private List<Properties> updateModuleTarget = new ArrayList<Properties>();
    private Map<String, ScheduleTblBean> autoSchdSummary = new HashMap<String, ScheduleTblBean>();
    private Map<String, ScheduleTblBean> campSchdSummary = new HashMap<String, ScheduleTblBean>();

    @Override
    public void setTaskProperty(Properties prop) {
        this.taskProp = prop;
        String currentTime = Cal.getSerialDate();
        this.setName("KakaoMsgUpdator_at_" + currentTime);
        this.setTaskID("KakaoMsgUpdator");
        this.isOtherDb = Boolean.parseBoolean(this.taskProp.getProperty("use.other.db", "false"));
        commitInterval = Integer.parseInt(this.taskProp.getProperty("commitInterval", "1000"));
    }

    @Override
    public void execute_initiate() throws Exception {
        log.info("{}... START", (Object)this.getName());
        this.oriCon = ConnectionPool.getConnection();
        this.moduleCon = ConnectionPool.getConnection(otherConnectInfo);
        this.psSelect = this.moduleCon.prepareStatement(querySelectTargetList, "${", "}");
        this.psSchdUpdate = this.oriCon.createStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        this.rsSelect = this.psSelect.executeQuery(this.taskProp);
        while (this.rsSelect.next()) {
            Properties result = new Properties();
            eMsPreparedStatement psListUpdate = null;
            try {
                this.rsSelect.putToMap(result, false);
                log.debug("Target List Info: {}", (Object)result);
                String sendType = result.getProperty("SEND_TYPE", "").trim();
                String postId = result.getProperty("POST_ID", "");
                String memberId = result.getProperty("MEMBER_ID");
                String listTable = result.getProperty("LIST_TABLE", "");
                if (postId.isEmpty() || memberId.isEmpty() || sendType.isEmpty() || listTable.isEmpty()) continue;
                if (sendType.equals(_AUTO_)) {
                    if (postId.lastIndexOf("_") <= 0) {
                        log.error("[ERROR] The postId format is incorrect : {}", (Object)postId);
                        continue;
                    }
                    result.setProperty("WORKDAY", postId.split("_")[0]);
                    result.setProperty("SEQNO", postId.split("_")[1]);
                    if (memberId.lastIndexOf("_") <= 0) {
                        log.error("[ERROR] The memberId format is incorrect. : {}", (Object)postId);
                        continue;
                    }
                    result.setProperty("MEMBER_ID", memberId.split("_")[0]);
                    result.setProperty("MEMBER_ID_SEQ", memberId.split("_")[1]);
                    List<Properties> autoTarget = this.autoListTarget.get(listTable);
                    if (autoTarget == null) {
                        autoTarget = new ArrayList<Properties>();
                        this.autoListTarget.put(listTable, autoTarget);
                    }
                    autoTarget.add(result);
                    ScheduleTblBean autoBean = this.autoSchdSummary.get(postId);
                    if (autoBean == null) {
                        autoBean = new ScheduleTblBean(postId);
                        this.autoSchdSummary.put(postId, autoBean);
                    }
                    autoBean.addSwitchedCnt();
                    continue;
                }
                if (sendType.equals(_MASS_)) {
                    List<Properties> campTarget = this.campListTarget.get(listTable);
                    if (campTarget == null) {
                        campTarget = new ArrayList<Properties>();
                        this.campListTarget.put(listTable, campTarget);
                    }
                    campTarget.add(result);
                    ScheduleTblBean campBean = this.campSchdSummary.get(postId);
                    if (campBean == null) {
                        campBean = new ScheduleTblBean(postId);
                        this.campSchdSummary.put(postId, campBean);
                    }
                    campBean.addSwitchedCnt();
                    continue;
                }
                if (sendType.equals(_TEST_)) continue;
                log.info("[PASS] Msg Result is not updated. {}", (Object)result);
            }
            catch (Exception e) {
                log.error("[ERROR] Msg Result process.", (Throwable)e);
            }
            finally {
                if (psListUpdate == null) continue;
                psListUpdate.close();
            }
        }
        if (!this.autoListTarget.isEmpty()) {
            this.listUpdate(_AUTO_, this.autoListTarget);
        }
        if (!this.campListTarget.isEmpty()) {
            this.listUpdate(_MASS_, this.campListTarget);
        }
        if (!this.autoSchdSummary.isEmpty()) {
            this.updateSummary(_AUTO_, this.autoSchdSummary);
        }
        if (!this.campSchdSummary.isEmpty()) {
            this.updateSummary(_MASS_, this.campSchdSummary);
        }
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error("execute_initiateError()...", thw);
    }

    @Override
    public void release_Resource() {
        if (this.rsSelect != null) {
            this.rsSelect.close();
        }
        if (this.psSelect != null) {
            this.psSelect.close();
        }
        if (this.psSchdUpdate != null) {
            this.psSchdUpdate.close();
        }
        if (this.moduleCon != null) {
            this.moduleCon.close();
        }
        if (this.oriCon != null) {
            this.oriCon.close();
        }
        log.info("{}... END", (Object)this.getName());
    }

    private void updateSummary(String type, Map<String, ScheduleTblBean> schdMap) {
        StringBuffer buff = new StringBuffer(512);
        try {
            for (Map.Entry<String, ScheduleTblBean> target : schdMap.entrySet()) {
                buff.setLength(0);
                ScheduleTblBean stBean = target.getValue();
                log.debug("{} summary stBean data: {}", (Object)this.getName(), (Object)stBean.toString());
                String targetQuery = type.equals(_AUTO_) ? queryAutoUpdateScheduleInfo : queryCampUpdateScheduleInfo;
                StringConvertUtil.ConvertString(buff, targetQuery, stBean.getElement(type), "${", "}", true, false);
                if (this.psSchdUpdate.executeUpdate(buff.toString()) >= 1) continue;
                log.debug("{} schedule summary fail: {}", (Object)this.getName(), (Object)stBean.getName());
            }
        }
        catch (Exception e) {
            log.error("ERROR schdSummary... ", (Throwable)e);
        }
    }

    private void listUpdate(String type, Map<String, List<Properties>> targetList) {
        StringBuffer buff = new StringBuffer(512);
        log.info("Taget Type is {}", (Object)type);
        try {
            for (Map.Entry<String, List<Properties>> target : targetList.entrySet()) {
                buff.setLength(0);
                String listTable = target.getKey();
                List<Properties> targetListData = target.getValue();
                log.debug("{} updateTarget List table data: {}, {}", new Object[]{this.getName(), targetListData, listTable});
                KakaoSwitchUpdator switchUpdator = new KakaoSwitchUpdator();
                switchUpdator.init(commitInterval);
                switchUpdator.update(targetListData, listTable, type);
                switchUpdator.moduleUpdate(targetListData);
                switchUpdator.release();
            }
        }
        catch (Exception e) {
            log.error("ERROR UpdateError... ", (Throwable)e);
        }
    }

    protected String ppsParseSQL(String source, String mapping, String value, String start, String end) {
        if (mapping == null || source == null) {
            return source;
        }
        return KakaoMsgUpdator.replace_target(source, start + mapping + end, value);
    }

    public static String replace_target(String target, String from, String to) {
        int idx2;
        if (target == null || from == null || to == null) {
            return null;
        }
        int idx1 = 0;
        while ((idx2 = target.indexOf(from, idx1)) != -1) {
            target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
            idx1 = idx2 + to.length();
        }
        return target;
    }

    static {
        querySelectTargetList = SqlManager.getQuery("SWITCHED_UPDATE", "QUERY_SELECT_TARGET_LIST");
        queryAutoUpdateScheduleInfo = SqlManager.getQuery("SWITCHED_UPDATE", "QUERY_UPDATE_AUTO_SCHEDULE_INFO");
        queryCampUpdateScheduleInfo = SqlManager.getQuery("SWITCHED_UPDATE", "QUERY_UPDATE_CAMP_SCHEDULE_INFO");
        otherConnectInfo.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
        otherConnectInfo.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
        otherConnectInfo.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
        otherConnectInfo.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
        otherConnectInfo.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
        otherConnectInfo.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
        otherConnectInfo.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
        otherConnectInfo.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
    }
}

