/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.Task;
import pluto.schedule.TaskManager;
import pluto.util.Cal;

public class KakaoMsgUpdateCheckTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(KakaoMsgUpdateCheckTask.class);
    private static final String IS_OTHER_DB = "use.other.db";
    private static boolean isOtherDb = false;
    private static ConnectInfo otherConnectInfo = new ConnectInfo();
    private static String querySelectTargetRange = null;
    private static String commitInterval = null;
    private static String updatorClassName = "jupiter.mass.log.updator.KakaoMsgUpdator";
    private eMsConnection con = null;
    private eMsStatement stmtSelect = null;
    private eMsResultSet rsSelect = null;

    public KakaoMsgUpdateCheckTask() {
        super((short)2);
        this.setName("KakaoMsgUpdateCheckTask_at" + Cal.getSerialDate());
        this.setTaskID("KakaoMsgUpdateCheckTask");
    }

    public static void init(Object param) {
        Properties prop = (Properties)param;
        isOtherDb = Boolean.parseBoolean(prop.getProperty(IS_OTHER_DB, "false"));
        updatorClassName = prop.getProperty("updator.class.name", "");
        commitInterval = prop.getProperty("commit.interval.size", "1000");
    }

    @Override
    public void execute_initiate() throws Exception {
        log.info("{}... START", (Object)this.getName());
        this.con = isOtherDb ? ConnectionPool.getConnection(otherConnectInfo) : ConnectionPool.getConnection();
        this.stmtSelect = this.con.createStatement();
    }

    @Override
    public void execute() throws Exception {
        Properties result = new Properties();
        this.rsSelect = this.stmtSelect.executeQuery(querySelectTargetRange);
        if (this.rsSelect.next()) {
            this.rsSelect.putToMap(result, false);
        }
        log.debug("SELECT TARGET RANGE: {}", (Object)result);
        if (!result.isEmpty()) {
            result.setProperty(IS_OTHER_DB, String.valueOf(isOtherDb));
            result.setProperty("CHECK_INTERVAL", commitInterval);
            this.executeUpdatorTask(result);
        }
    }

    @Override
    public void release_Resource() {
        if (this.rsSelect != null) {
            this.rsSelect.close();
        }
        if (this.stmtSelect != null) {
            this.stmtSelect.close();
        }
        if (this.con != null) {
            this.con.close();
        }
        log.info("{}... END", (Object)this.getName());
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error("execute_initiateError()...", thw);
    }

    private synchronized void executeUpdatorTask(Properties prop) {
        try {
            Task updatorTask = (Task)this.getInstance(updatorClassName);
            updatorTask.setTaskProperty(prop);
            TaskManager.executeTask(updatorTask);
            try {
                this.wait(1000L);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            log.error("[ERROR] executeUpdatorTask()", (Throwable)e);
        }
        log.info("executeUpdatorTask()... START");
    }

    private Object getInstance(String className) throws Exception {
        return Class.forName(className).newInstance();
    }

    static {
        querySelectTargetRange = SqlManager.getQuery("SWITCHED_UPDATE", "QUERY_SELECT_TARGET_RANGE");
        otherConnectInfo.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
        otherConnectInfo.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
        otherConnectInfo.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
        otherConnectInfo.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
        otherConnectInfo.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
        otherConnectInfo.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
        otherConnectInfo.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
        otherConnectInfo.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
    }
}

