/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.util.Properties;
import jupiter.mass.log.updator.AddBatchIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.eMsResultSet;

public class AddBatchIteratorFactory {
    private static final Logger log = LoggerFactory.getLogger(AddBatchIteratorFactory.class);
    public Object iteratorData;
    private eMsResultSet rs;

    public static AddBatchIterator getInstance(final Object readData) {
        try {
            if (readData instanceof eMsResultSet) {
                return new AddBatchIterator<eMsResultSet>(){
                    eMsResultSet resultSet;
                    {
                        this.resultSet = (eMsResultSet)readData;
                    }

                    @Override
                    public boolean next() throws Exception {
                        return this.resultSet.next();
                    }

                    @Override
                    public eMsResultSet getIterator() {
                        return this.resultSet;
                    }

                    @Override
                    public void close() {
                        this.resultSet.close();
                    }

                    @Override
                    public void putData(Object o) throws Exception {
                        this.resultSet.putToMap((Properties)o, false);
                    }
                };
            }
            return null;
        }
        catch (Exception e) {
            log.error("batch Iterator error", (Throwable)e);
            return null;
        }
    }

    public AddBatchIteratorFactory(Object o) {
        this.iteratorData = o;
        if (o instanceof eMsResultSet) {
            this.rs = (eMsResultSet)o;
        }
    }

    public boolean next() throws Exception {
        return this.rs.next();
    }
}

