/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.actor;

import com.humuson.tms.common.security.HumusonEncryptor;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.CommonType;
import com.humuson.tms.constrants.StatusType;
import com.humuson.tms.mq.model.MgsPush;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import jupiter.mass.actor.AbstractSingleRcptCommunicationActor;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;

public class PushFixedDomainSingleRcptBufferedCommunicationActor
extends AbstractSingleRcptCommunicationActor {
    private static final Logger log = LoggerFactory.getLogger(PushFixedDomainSingleRcptBufferedCommunicationActor.class);
    private eMsConnection EMS_CONNECTION = null;
    private eMsConnection EMS_CONNECTION2 = null;
    private eMsPreparedStatement PSTMT = null;
    private eMsPreparedStatement PSTMT1 = null;
    private eMsPreparedStatement PSTMT3 = null;
    private eMsPreparedStatement PSTMT2 = null;
    private eMsStatement EMS_STATEMENT = null;
    private eMsResultSet rs = null;
    public static int th_cnt = 0;
    public static String QUERY_INSERT_PUSH_SEND = null;
    public static String QUERY_INSERT_INAPP_MSG = null;
    public static String QUERY_UPDATE_SEND_LIST = null;
    public static String QUERY_UPDATE_SCHD_INFO = null;
    public static String QUERY_SELECT_PUSH_CERT_INFO = null;
    public static String QUERY_SELECT_PUSH_OS_INFO = null;
    public static int sparePlusMinute = 0;
    public static int spareCount = 0;
    public static int commitSize = 1000;
    public static String activeMqUseYN = "";
    public static String activeMqAddr = "";
    public static String activeMqQueName = "";
    public static String encryptYn = "";
    public static String encKey = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void work() throws Exception {
        log.info("Push Sending init Start....");
        long startTime = System.currentTimeMillis();
        HashMap<String, String> currentAppKeyMapIos = new HashMap<String, String>();
        HashMap<String, String> currentAppKeyMapAndroid = new HashMap<String, String>();
        int processCount = 0;
        int insertedCount = 0;
        int failedCount = 0;
        ActiveMQConnectionFactory connectionFactory = null;
        Connection connection = null;
        Session session = null;
        Queue destination = null;
        MessageProducer producer = null;
        try {
            this.EMS_CONNECTION = ConnectionPool.getConnection();
            this.PSTMT = this.EMS_CONNECTION.prepareStatement(QUERY_INSERT_PUSH_SEND, "${", "}");
            this.PSTMT1 = this.EMS_CONNECTION.prepareStatement(QUERY_INSERT_INAPP_MSG, "${", "}");
            this.PSTMT3 = this.EMS_CONNECTION.prepareStatement(QUERY_UPDATE_SCHD_INFO, "${", "}");
            HashMap<String, eMsPreparedStatement> updateSendListPreparedMap = new HashMap<String, eMsPreparedStatement>();
            ++th_cnt;
            this.CURR_STEP = (short)-1;
            ArrayList<String[]> currentList = new ArrayList<String[]>();
            MgsPush.Request.Builder gcmRequestBuilder = null;
            MgsPush.Request.Builder apnsRequestBuilder = null;
            MgsPush.Request.Builder gcmFastRequestBuilder = null;
            MgsPush.Request.Builder apnsFastRequestBuilder = null;
            MgsPush.PushPayload.Builder pushPayloadBuilder = null;
            CommonType sendCommonType = null;
            StringBuilder sb = null;
            String id = null;
            if ("Y".equals(activeMqUseYN)) {
                connectionFactory = new ActiveMQConnectionFactory(activeMqAddr);
                connection = connectionFactory.createConnection();
                connection.start();
                session = connection.createSession(false, 1);
                destination = session.createQueue(activeMqQueName);
                producer = session.createProducer((Destination)destination);
                producer.setDeliveryMode(1);
                gcmRequestBuilder = MgsPush.Request.newBuilder();
                gcmFastRequestBuilder = MgsPush.Request.newBuilder();
                apnsRequestBuilder = MgsPush.Request.newBuilder();
                apnsFastRequestBuilder = MgsPush.Request.newBuilder();
                pushPayloadBuilder = MgsPush.PushPayload.newBuilder();
                sb = new StringBuilder();
                Properties prop = null;
                StringBuffer TMP_STRING_BUFFER = new StringBuffer(1024);
                StringConvertUtil.ConvertString(TMP_STRING_BUFFER, QUERY_SELECT_PUSH_CERT_INFO, prop, "${", "}", true, false);
                try {
                    this.EMS_CONNECTION2 = ConnectionPool.getConnection();
                    this.EMS_STATEMENT = this.EMS_CONNECTION2.createStatement();
                    this.rs = this.EMS_STATEMENT.executeQuery(TMP_STRING_BUFFER.toString());
                    while (this.rs.next()) {
                        if ("I".equals(this.rs.getString("OS"))) {
                            currentAppKeyMapIos.put(this.rs.getString("APP_GRP_KEY"), this.rs.getString("APP_KEY"));
                            continue;
                        }
                        if (!"A".equals(this.rs.getString("OS"))) continue;
                        currentAppKeyMapAndroid.put(this.rs.getString("APP_GRP_KEY"), this.rs.getString("APP_KEY"));
                    }
                }
                catch (Exception e) {
                    log.error("[QUERY_SELECT_PUSH_CERT_INFO] Exception... {}", (Throwable)e);
                    throw e;
                }
                finally {
                    if (this.rs != null) {
                        this.rs.close();
                    }
                    if (this.EMS_STATEMENT != null) {
                        this.EMS_STATEMENT.close();
                    }
                    if (this.EMS_CONNECTION2 != null) {
                        this.EMS_CONNECTION2.recycle();
                    }
                }
            }
            while (true) {
                block222: {
                    if (this.RCPT_TO == null) {
                        this.RCPT_TO = this.INNER_BUFFERED_BIN.popupNoWait();
                    }
                    if (this.RCPT_TO == null) {
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        this.log("pop up:" + this.RCPT_TO.toString());
                    }
                    if (this.splitRcptInfo() == null) {
                        if (!log.isDebugEnabled()) continue;
                        this.log("split fail continue");
                        continue;
                    }
                    try {
                        this.EMS_CONNECTION.setAutoCommit(false);
                        long time = System.currentTimeMillis();
                        Map<String, String> __PUSH_SEND_HASH__ = null;
                        while (this.PARSED_RCPT_INFO.size() > 0) {
                            Object NEXT_SPOOL = this.PARSED_RCPT_INFO.removeFirst();
                            if (!this.parseRcptInfo(NEXT_SPOOL)) {
                                if (!log.isDebugEnabled()) continue;
                                this.log("parseRcptInfo fail continue");
                                continue;
                            }
                            if (this.connection_delay > 0) {
                                try {
                                    Thread.currentThread();
                                    Thread.sleep(this.connection_delay);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            currentList.add(this.RCPT_ARRAY);
                            String notiFlag = "N";
                            String os = "A";
                            String appGrpKey = "";
                            String serverId = "01";
                            int priority = 0;
                            String pushType = "MP";
                            try {
                                Integer n;
                                block225: {
                                    int tempCheckTotalCount;
                                    block227: {
                                        block226: {
                                            __PUSH_SEND_HASH__ = this.setMapping(this.RCPT_ARRAY, spareMinute);
                                            if (!"Y".equals(activeMqUseYN)) break block225;
                                            if (updateSendListPreparedMap.containsKey(__PUSH_SEND_HASH__.get("LIST_TABLE"))) {
                                                this.PSTMT2 = (eMsPreparedStatement)updateSendListPreparedMap.get(__PUSH_SEND_HASH__.get("LIST_TABLE"));
                                            } else {
                                                String query = StringConvertUtil.ppsParseSQL(QUERY_UPDATE_SEND_LIST, "LIST_TABLE", __PUSH_SEND_HASH__.get("LIST_TABLE"), "@{", "}");
                                                this.PSTMT2 = this.EMS_CONNECTION.prepareStatement(query, "${", "}");
                                                updateSendListPreparedMap.put(__PUSH_SEND_HASH__.get("LIST_TABLE"), this.PSTMT2);
                                            }
                                            os = __PUSH_SEND_HASH__.get("OS");
                                            notiFlag = __PUSH_SEND_HASH__.get("NOTI_FLAG");
                                            appGrpKey = __PUSH_SEND_HASH__.get("APP_GRP_KEY");
                                            serverId = __PUSH_SEND_HASH__.get("SERVER_ID");
                                            pushType = __PUSH_SEND_HASH__.get("PUSH_TYPE");
                                            if (__PUSH_SEND_HASH__.get("SEND_STATE").equals(CommonType.TEST.getCode())) {
                                                sendCommonType = CommonType.TEST;
                                            }
                                            if ("Y".equals(notiFlag) || CommonType.TEST.equals((Object)sendCommonType)) {
                                                sb.setLength(0);
                                                id = sb.append("PUSH_ID_VALUE").append("&&").append(__PUSH_SEND_HASH__.get("DEVICE_ID")).append("&&").append(__PUSH_SEND_HASH__.get("REQ_UID")).append("&&").append(__PUSH_SEND_HASH__.get("CUST_ID")).toString();
                                                priority = Integer.parseInt(__PUSH_SEND_HASH__.get("PRIORITY"));
                                                if (pushType != null && !"OM".equals(pushType)) {
                                                    if ("I".equals(os) && currentAppKeyMapIos.containsKey(appGrpKey)) {
                                                        if (priority > 0) {
                                                            apnsFastRequestBuilder = this.apnsBuilder(apnsFastRequestBuilder, pushPayloadBuilder, __PUSH_SEND_HASH__, currentAppKeyMapIos, appGrpKey, serverId, id);
                                                        } else {
                                                            apnsRequestBuilder = this.apnsBuilder(apnsRequestBuilder, pushPayloadBuilder, __PUSH_SEND_HASH__, currentAppKeyMapIos, appGrpKey, serverId, id);
                                                        }
                                                    } else if ("A".equals(os) && currentAppKeyMapAndroid.containsKey(appGrpKey)) {
                                                        if (priority > 0) {
                                                            gcmFastRequestBuilder = this.fcmBuilder(gcmFastRequestBuilder, pushPayloadBuilder, __PUSH_SEND_HASH__, currentAppKeyMapAndroid, appGrpKey, serverId, id);
                                                        } else {
                                                            gcmRequestBuilder = this.fcmBuilder(gcmRequestBuilder, pushPayloadBuilder, __PUSH_SEND_HASH__, currentAppKeyMapAndroid, appGrpKey, serverId, id);
                                                        }
                                                    } else {
                                                        log.error("[RequestBuilderError] id: {}", (Object)id);
                                                    }
                                                }
                                            }
                                            if (!"Y".equals(notiFlag)) break block226;
                                            if (!CommonType.TEST.equals((Object)sendCommonType)) {
                                                __PUSH_SEND_HASH__.put("SEND_STATE", StatusType.SENDING.getCode());
                                                __PUSH_SEND_HASH__.put("ERROR_CODE", "05");
                                                if (this.PSTMT2.executeUpdate(__PUSH_SEND_HASH__) <= 0) {
                                                    log.info("[QUERY_UPDATE_SEND_LIST][05] update Count 0");
                                                }
                                            }
                                            break block227;
                                        }
                                        if (!CommonType.TEST.equals((Object)sendCommonType)) {
                                            __PUSH_SEND_HASH__.put("SEND_STATE", StatusType.ERROR.getCode());
                                            __PUSH_SEND_HASH__.put("ERROR_CODE", "44");
                                            if (this.PSTMT2.executeUpdate(__PUSH_SEND_HASH__) > 0) {
                                                if (pushType != null && !"OM".equals(pushType)) {
                                                    log.info("failedCount: {}", (Object)(++failedCount));
                                                }
                                            } else {
                                                log.info("[QUERY_UPDATE_SEND_LIST][44] update Count 0");
                                            }
                                        }
                                    }
                                    if (pushType != null && !"OP".equals(pushType) && this.PSTMT1.executeUpdate(__PUSH_SEND_HASH__) <= 0) {
                                        log.info("INAPP_MSG INSERT FAIL => DEVICE_ID:{}", (Object)__PUSH_SEND_HASH__.get("DEVICE_ID"));
                                    }
                                    if ((tempCheckTotalCount = totalSendCount.incrementAndGet()) % spareCount == 0) {
                                        n = spareMinute;
                                        synchronized (n) {
                                            spareMinute = spareMinute + sparePlusMinute;
                                        }
                                        log.info("Change Spare Minute: getName: {}, totalCount: {}, spareMinute: {}", new Object[]{this.getName(), totalSendCount.get(), spareMinute});
                                    }
                                    if (pushType != null && !"OM".equals(pushType)) {
                                        ++insertedCount;
                                    }
                                    ++processCount;
                                    continue;
                                }
                                if (this.PSTMT.executeUpdate(__PUSH_SEND_HASH__) > 0) {
                                    ++insertedCount;
                                    int tempCheckTotalCount = totalSendCount.incrementAndGet();
                                    if (tempCheckTotalCount % spareCount == 0) {
                                        n = spareMinute;
                                        synchronized (n) {
                                            spareMinute = spareMinute + sparePlusMinute;
                                        }
                                        log.info("Change Spare Minute: getName: {}, totalCount: {}, spareMinute: {}", new Object[]{this.getName(), totalSendCount.get(), spareMinute});
                                    }
                                }
                                ++processCount;
                            }
                            catch (Exception e) {
                                log.error("[PushFixedDomainSingleRcptBufferedCommunicationActor error] e:{}", (Throwable)e);
                                log.error("MEMBER_ID:{},POST_ID:{}", (Object)__PUSH_SEND_HASH__.get("MEMBER_ID"), (Object)__PUSH_SEND_HASH__.get("POST_ID"));
                            }
                            finally {
                                if (processCount % commitSize != 0 || this.EMS_CONNECTION == null) continue;
                                if ("Y".equals(activeMqUseYN)) {
                                    __PUSH_SEND_HASH__.put("PUSHED_CNT", String.valueOf(insertedCount));
                                    __PUSH_SEND_HASH__.put("FAIL_CNT", String.valueOf(failedCount));
                                    if (!CommonType.TEST.equals((Object)sendCommonType) && pushType != null && !"OM".equals(pushType) && this.PSTMT3.executeUpdate(__PUSH_SEND_HASH__) <= 0) {
                                        log.info("CAMP_SCHD_INFO UPDATE CNT IS 0");
                                    }
                                    insertedCount = 0;
                                    processCount = 0;
                                    failedCount = 0;
                                }
                                try {
                                    this.EMS_CONNECTION.commit();
                                }
                                catch (Exception e) {
                                    log.error("Commit error : ", (Throwable)e);
                                    Map<String, String> __PUSH_SEND_HASH__2 = null;
                                    for (String[] queData : currentList) {
                                        eMsPreparedStatement PSTMT2ONE;
                                        block221: {
                                            __PUSH_SEND_HASH__2 = this.setMapping(queData, spareMinute);
                                            PSTMT2ONE = null;
                                            if (__PUSH_SEND_HASH__2.get("SEND_STATE").equals(CommonType.TEST.getCode())) {
                                                sendCommonType = CommonType.TEST;
                                            }
                                            notiFlag = __PUSH_SEND_HASH__2.get("NOTI_FLAG");
                                            pushType = __PUSH_SEND_HASH__2.get("PUSH_TYPE");
                                            if ("Y".equals(activeMqUseYN)) {
                                                QUERY_UPDATE_SEND_LIST = StringConvertUtil.ppsParseSQL(QUERY_UPDATE_SEND_LIST, "LIST_TABLE", __PUSH_SEND_HASH__2.get("LIST_TABLE"), "@{", "}");
                                                PSTMT2ONE = this.EMS_CONNECTION.prepareStatement(QUERY_UPDATE_SEND_LIST, "${", "}");
                                                if (pushType != null && !"OP".equals(pushType)) {
                                                    this.PSTMT1.executeUpdate(__PUSH_SEND_HASH__2);
                                                }
                                                try {
                                                    if (CommonType.TEST.equals((Object)sendCommonType)) break block221;
                                                    if ("Y".equals(notiFlag)) {
                                                        __PUSH_SEND_HASH__2.put("SEND_STATE", StatusType.SENDING.getCode());
                                                        __PUSH_SEND_HASH__2.put("ERROR_CODE", "05");
                                                        __PUSH_SEND_HASH__2.put("PUSHED_CNT", "1");
                                                        __PUSH_SEND_HASH__2.put("FAIL_CNT", "0");
                                                    } else {
                                                        __PUSH_SEND_HASH__2.put("SEND_STATE", StatusType.ERROR.getCode());
                                                        __PUSH_SEND_HASH__2.put("ERROR_CODE", "44");
                                                        __PUSH_SEND_HASH__2.put("PUSHED_CNT", "1");
                                                        __PUSH_SEND_HASH__2.put("FAIL_CNT", "1");
                                                    }
                                                    if (PSTMT2ONE.executeUpdate(__PUSH_SEND_HASH__2) <= 0) {
                                                        log.info("SEND_LIST UPDATE CNT IS 0");
                                                    }
                                                    if (pushType != null && !"OM".equals(pushType) && this.PSTMT3.executeUpdate(__PUSH_SEND_HASH__2) <= 0) {
                                                        log.info("SCHD_INFO UPDATE CNT IS 0");
                                                    }
                                                }
                                                catch (Exception err2) {
                                                    log.error("[Update error]", (Throwable)err2);
                                                }
                                            } else {
                                                this.PSTMT.executeUpdate(__PUSH_SEND_HASH__2);
                                            }
                                        }
                                        this.EMS_CONNECTION.commit();
                                        if (PSTMT2ONE == null) continue;
                                        try {
                                            PSTMT2ONE.close();
                                        }
                                        catch (Exception err2) {}
                                        continue;
                                        catch (Exception err) {
                                            try {
                                                log.error("[Insert TMS_PUSH_QUE error]", (Throwable)err);
                                                if (PSTMT2ONE == null) continue;
                                            }
                                            catch (Throwable throwable) {
                                                if (PSTMT2ONE == null) throw throwable;
                                                try {
                                                    PSTMT2ONE.close();
                                                    throw throwable;
                                                }
                                                catch (Exception exception) {}
                                            }
                                            try {
                                                PSTMT2ONE.close();
                                            }
                                            catch (Exception exception) {}
                                        }
                                    }
                                }
                                finally {
                                    currentList.clear();
                                }
                            }
                        }
                        if (!"Y".equals(activeMqUseYN)) break block222;
                        __PUSH_SEND_HASH__.put("PUSHED_CNT", String.valueOf(insertedCount));
                        __PUSH_SEND_HASH__.put("FAIL_CNT", String.valueOf(failedCount));
                        if (!CommonType.TEST.equals(sendCommonType)) {
                            if (this.PSTMT3.executeUpdate(__PUSH_SEND_HASH__) > 0) {
                                insertedCount = 0;
                                processCount = 0;
                                failedCount = 0;
                            } else {
                                log.info("CAMP_SCHD_INFO UPDATE CNT IS 0");
                            }
                        }
                        if (!apnsRequestBuilder.getPayloadList().isEmpty()) {
                            producer.send(this.toMessage(apnsRequestBuilder.build(), session));
                        }
                        if (!gcmRequestBuilder.getPayloadList().isEmpty()) {
                            producer.send(this.toMessage(gcmRequestBuilder.build(), session));
                        }
                        if (!apnsFastRequestBuilder.getPayloadList().isEmpty()) {
                            producer.send(this.toMessage(apnsFastRequestBuilder.build(), session), 1, 9, 0L);
                        }
                        if (!gcmFastRequestBuilder.getPayloadList().isEmpty()) {
                            producer.send(this.toMessage(gcmFastRequestBuilder.build(), session), 1, 9, 0L);
                        }
                        log.info("ActiveMQ SEND [END] APNS:{},GCM:{},APNS_fast:{},GCM_fast:{}", new Object[]{apnsRequestBuilder.getPayloadList().size(), gcmRequestBuilder.getPayloadList().size(), apnsFastRequestBuilder.getPayloadList().size(), gcmFastRequestBuilder.getPayloadList().size()});
                        if (apnsRequestBuilder != null) {
                            apnsRequestBuilder.clear();
                        }
                        if (gcmRequestBuilder != null) {
                            gcmRequestBuilder.clear();
                        }
                        if (apnsFastRequestBuilder != null) {
                            apnsFastRequestBuilder.clear();
                        }
                        if (gcmFastRequestBuilder == null) break block222;
                        gcmFastRequestBuilder.clear();
                    }
                    catch (JMSException je) {
                        if (connection != null) continue;
                        connectionFactory = new ActiveMQConnectionFactory(activeMqAddr);
                        connection = connectionFactory.createConnection();
                        connection.start();
                        session = connection.createSession(false, 1);
                        destination = session.createQueue(activeMqQueName);
                        producer = session.createProducer((Destination)destination);
                        producer.setDeliveryMode(1);
                        continue;
                    }
                    catch (Exception e) {
                        this.EMS_CONNECTION.rollback();
                        log.error("ROLLBACK!!! PUSH \ub4f1\ub85d \uc624\ub958 [" + this.RCPT_ARRAY.toString() + "]", (Throwable)e);
                    }
                    finally {
                        if (this.EMS_CONNECTION != null) {
                            try {
                                this.EMS_CONNECTION.commit();
                            }
                            catch (Exception e) {
                                log.error("Commit Error:{}", (Throwable)e);
                                Map<String, String> __PUSH_SEND_HASH__3 = null;
                                for (String[] queData : currentList) {
                                    eMsPreparedStatement PSTMT2ONE;
                                    block224: {
                                        __PUSH_SEND_HASH__3 = this.setMapping(queData, spareMinute);
                                        PSTMT2ONE = null;
                                        if (__PUSH_SEND_HASH__3.get("SEND_STATE").equals(CommonType.TEST.getCode())) {
                                            sendCommonType = CommonType.TEST;
                                        }
                                        String notiFlag = __PUSH_SEND_HASH__3.get("NOTI_FLAG");
                                        String pushType = __PUSH_SEND_HASH__3.get("PUSH_TYPE");
                                        if ("Y".equals(activeMqUseYN)) {
                                            QUERY_UPDATE_SEND_LIST = StringConvertUtil.ppsParseSQL(QUERY_UPDATE_SEND_LIST, "LIST_TABLE", __PUSH_SEND_HASH__3.get("LIST_TABLE"), "@{", "}");
                                            PSTMT2ONE = this.EMS_CONNECTION.prepareStatement(QUERY_UPDATE_SEND_LIST, "${", "}");
                                            if (pushType != null && !"OP".equals(pushType)) {
                                                this.PSTMT1.executeUpdate(__PUSH_SEND_HASH__3);
                                            }
                                            try {
                                                if (CommonType.TEST.equals((Object)sendCommonType)) break block224;
                                                if ("Y".equals(notiFlag)) {
                                                    __PUSH_SEND_HASH__3.put("SEND_STATE", StatusType.PENDDING.getCode());
                                                    __PUSH_SEND_HASH__3.put("ERROR_CODE", "05");
                                                    __PUSH_SEND_HASH__3.put("PUSHED_CNT", "1");
                                                    __PUSH_SEND_HASH__3.put("FAIL_CNT", "0");
                                                } else {
                                                    __PUSH_SEND_HASH__3.put("SEND_STATE", StatusType.ERROR.getCode());
                                                    __PUSH_SEND_HASH__3.put("ERROR_CODE", "44");
                                                    __PUSH_SEND_HASH__3.put("PUSHED_CNT", "1");
                                                    __PUSH_SEND_HASH__3.put("FAIL_CNT", "1");
                                                }
                                                if (PSTMT2ONE.executeUpdate(__PUSH_SEND_HASH__3) <= 0) {
                                                    log.info("SEND_LIST UPDATE CNT IS 0");
                                                }
                                                if (pushType != null && !"OM".equals(pushType) && this.PSTMT3.executeUpdate(__PUSH_SEND_HASH__3) <= 0) {
                                                    log.info("CAMP_SCHD_INFO UPDATE CNT IS 0");
                                                }
                                            }
                                            catch (Exception err2) {
                                                log.error("[Update error]", (Throwable)err2);
                                            }
                                        } else {
                                            this.PSTMT.executeUpdate(__PUSH_SEND_HASH__3);
                                        }
                                    }
                                    this.EMS_CONNECTION.commit();
                                    if (PSTMT2ONE == null) continue;
                                    try {
                                        PSTMT2ONE.close();
                                    }
                                    catch (Exception err2) {}
                                    continue;
                                    catch (Exception err) {
                                        try {
                                            log.error("[Insert TMS_PUSH_QUE error]", (Throwable)err);
                                            if (PSTMT2ONE == null) continue;
                                        }
                                        catch (Throwable throwable) {
                                            if (PSTMT2ONE == null) throw throwable;
                                            try {
                                                PSTMT2ONE.close();
                                                throw throwable;
                                            }
                                            catch (Exception exception) {}
                                        }
                                        try {
                                            PSTMT2ONE.close();
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                            }
                            finally {
                                insertedCount = 0;
                                processCount = 0;
                                failedCount = 0;
                                currentList.clear();
                            }
                        }
                        currentList.clear();
                        continue;
                    }
                }
                this.EMS_CONNECTION.commit();
                continue;
                break;
            }
        }
        catch (JMSException je) {
            log.error("JMSExcption()", (Throwable)je);
            throw je;
        }
        finally {
            if (this.PSTMT != null) {
                this.PSTMT.close();
            }
            if (this.PSTMT1 != null) {
                this.PSTMT1.close();
            }
            if (this.PSTMT3 != null) {
                this.PSTMT3.close();
            }
            if (this.EMS_CONNECTION != null) {
                this.EMS_CONNECTION.commit();
                this.EMS_CONNECTION.setAutoCommit(true);
                this.EMS_CONNECTION.recycle();
            }
            if (producer != null) {
                producer.close();
            }
            if (session != null) {
                session.close();
            }
            if (connection != null) {
                connection.stop();
                connection.close();
            }
            log.info("Push Sending End....elapsedTime:{}", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    public Message toMessage(Object object, Session session) throws JMSException {
        BytesMessage byteMessage = session.createBytesMessage();
        if (object instanceof MgsPush.Request) {
            byteMessage.writeBytes(((MgsPush.Request)object).toByteArray());
        } else if (object instanceof MgsPush.Response) {
            byteMessage.writeBytes(((MgsPush.Response)object).toByteArray());
        } else if (object instanceof MgsPush.ApnsFeedback) {
            byteMessage.writeBytes(((MgsPush.ApnsFeedback)object).toByteArray());
        }
        return byteMessage;
    }

    private MgsPush.ApnsMessage makeApnsMqMessage(Map<String, String> pushMessage) {
        MgsPush.ApnsMessage.Builder apnsMsgBuilder = MgsPush.ApnsMessage.newBuilder();
        apnsMsgBuilder.setMessage(pushMessage.get("PUSH_TITLE") + "\n" + pushMessage.get("PUSH_MSG")).setSound(StringUtils.validString((String)"")).setMsgType(pushMessage.get("CONTENT_TYPE")).setMsgId(String.valueOf(pushMessage.get("MSG_UID")));
        if (!StringUtils.isNull((String)pushMessage.get("PUSH_KEY"))) {
            apnsMsgBuilder.setPushKey(pushMessage.get("PUSH_KEY")).setPushValue(StringUtils.validString((String)pushMessage.get("PUSH_VALUE")));
        }
        return apnsMsgBuilder.build();
    }

    private MgsPush.GcmMessage makeGcmMqMessage(Map<String, String> pushMessage) {
        MgsPush.GcmMessage.Builder gcmMsgBuilder = MgsPush.GcmMessage.newBuilder();
        gcmMsgBuilder.setTimeToLive(Integer.parseInt(pushMessage.get("PUSH_TTL"))).setDelayWhileIdle(false).setPushNotiMsg(StringUtils.validString((String)pushMessage.get("PUSH_MSG"))).setPushRichContent(StringUtils.validString((String)pushMessage.get("POPUP_CONTENT").toString())).setPushNotiTitle(StringUtils.validString((String)pushMessage.get("PUSH_TITLE"))).setPushNotiImg(StringUtils.validString((String)pushMessage.get("PUSH_IMG"))).setMsgType(pushMessage.get("CONTENT_TYPE")).setMsgId(pushMessage.get("MSG_UID"));
        JSONObject json = new JSONObject();
        if (!StringUtils.isNull((String)pushMessage.get("PUSH_KEY"))) {
            json.put((Object)"l", (Object)StringUtils.validString((String)pushMessage.get("PUSH_VALUE")));
        }
        gcmMsgBuilder.setPushData(json.toString());
        return gcmMsgBuilder.build();
    }

    @Override
    protected void success_process(String[] _AGENT_ARRAY_) {
        this.resultLog(_AGENT_ARRAY_, "54", "10", "250 PUSH Message accepted for send", (short)2);
    }

    protected void error_process(String[] _AGENT_ARRAY_, String errorMessage) {
        this.resultLog(_AGENT_ARRAY_, "55", this.sendState.getRETURN_CODE(), "PUSH fail " + errorMessage, this.sendState.getLogLevel());
    }

    public Map<String, String> setMapping(String[] array, int spareMinute) throws Exception {
        HashMap<String, String> __PUSH_SEND_HASH__ = new HashMap<String, String>();
        String postId = "";
        String memberId = "";
        String token = "";
        String content = "";
        String contentPop = "";
        String listTable = "";
        String rowId = "";
        String os = "";
        String notiFlag = "";
        int idx1 = 0;
        int idx2 = "/**PUSH_DELIM**/".length();
        long uniKey = System.nanoTime();
        String sUniKey = String.valueOf(uniKey).substring(0, 13);
        String priority = "4";
        int posMid = 0;
        String mId = "";
        String mIdSeq = "";
        String custId = "";
        String deviceId = "";
        ContentInfo sendContentInfo = null;
        Properties prop = null;
        int tokenIdx = 0;
        try {
            postId = array[1];
            memberId = array[2];
            token = array[3];
            content = array[4];
            listTable = array[10];
            rowId = array[12];
            os = array[13];
            notiFlag = array[14];
            if (array.length > 15 && array[15] != null) {
                priority = array[15];
            }
            if (content.length() > 0 && (idx1 = content.indexOf("/**PUSH_DELIM**/")) > -1) {
                contentPop = content.substring(0, idx1).trim();
                content = content.substring(idx1 + idx2, content.length()).trim();
            }
            sendContentInfo = ContentInfoManager.getContentInfo(postId);
            prop = sendContentInfo.getScheduleInfo();
            if (token.length() > 0 && (tokenIdx = token.indexOf("^^")) > -1) {
                String[] tokens = token.split("\\^\\^");
                token = tokens[0];
                deviceId = tokens[1];
                if (tokens.length > 2) {
                    custId = tokens[2];
                }
            }
            if (memberId.lastIndexOf(95) > 0) {
                posMid = memberId.indexOf(95);
                mId = memberId.substring(0, posMid);
                mIdSeq = memberId.substring(posMid + 1);
            }
            String list_table_num = listTable.substring(listTable.lastIndexOf("_") + 1);
            if (prop.getProperty("SEND_STATE").equals("TEST") || prop.getProperty("SEND_STATE").equals("WFTEST")) {
                if (postId.length() > 13 || prop.getProperty("M_TYPE").equals("AUTO")) {
                    __PUSH_SEND_HASH__.put("REQ_UID", "AT" + postId + "^" + memberId + "|" + list_table_num + "-" + sUniKey);
                    __PUSH_SEND_HASH__.put("MSG_UID", postId + "-" + sUniKey);
                    __PUSH_SEND_HASH__.put("MEMBER_ID", mId);
                    __PUSH_SEND_HASH__.put("MEMBER_ID_SEQ", mIdSeq);
                    __PUSH_SEND_HASH__.put("CUST_ID", mId);
                } else {
                    if ("Y".equals(activeMqUseYN)) {
                        __PUSH_SEND_HASH__.put("REQ_UID", "CT" + postId.substring(0, 13) + "^" + custId + "-" + sUniKey);
                    } else {
                        __PUSH_SEND_HASH__.put("REQ_UID", "CT" + postId.substring(0, 13) + "^" + memberId + "-" + sUniKey);
                    }
                    __PUSH_SEND_HASH__.put("MSG_UID", postId + "-" + sUniKey);
                    __PUSH_SEND_HASH__.put("MEMBER_ID", memberId);
                    __PUSH_SEND_HASH__.put("CUST_ID", custId);
                    prop.setProperty("DEVICE_ID", deviceId);
                    if ("Y".equals(activeMqUseYN)) {
                        StringBuffer sb = new StringBuffer(1024);
                        StringConvertUtil.ConvertString(sb, QUERY_SELECT_PUSH_OS_INFO, prop, "${", "}", true, false);
                        try {
                            this.EMS_CONNECTION2 = ConnectionPool.getConnection();
                            this.EMS_STATEMENT = this.EMS_CONNECTION2.createStatement();
                            this.rs = this.EMS_STATEMENT.executeQuery(sb.toString());
                            while (this.rs.next()) {
                                os = this.rs.getString("OS");
                            }
                        }
                        catch (Exception e) {
                            log.error("[QUERY_SELECT_PUSH_OS_INFO] Exception... {}", (Throwable)e);
                            throw e;
                        }
                        finally {
                            if (this.rs != null) {
                                this.rs.close();
                            }
                            if (this.EMS_STATEMENT != null) {
                                this.EMS_STATEMENT.close();
                            }
                            if (this.EMS_CONNECTION2 != null) {
                                this.EMS_CONNECTION2.close();
                            }
                        }
                    }
                }
            } else if (postId.indexOf(95) > -1 && postId.length() != 13) {
                __PUSH_SEND_HASH__.put("REQ_UID", "AA" + postId + "^" + memberId + "|" + list_table_num);
                __PUSH_SEND_HASH__.put("MSG_UID", postId.concat("^").concat(memberId));
                __PUSH_SEND_HASH__.put("MEMBER_ID", mId);
                __PUSH_SEND_HASH__.put("MEMBER_ID_SEQ", mIdSeq);
                __PUSH_SEND_HASH__.put("CUST_ID", mId);
            } else {
                __PUSH_SEND_HASH__.put("REQ_UID", "CC" + postId.substring(0, 13) + "^" + memberId);
                if (prop.getProperty("PUSH_TITLE", "").indexOf("${") >= 0 && prop.getProperty("PUSH_TITLE", "").indexOf("}") >= 0 || prop.getProperty("PUSH_MSG", "").indexOf("${") >= 0 && prop.getProperty("PUSH_MSG", "").indexOf("}") >= 0) {
                    __PUSH_SEND_HASH__.put("MSG_UID", postId.substring(0, 13).concat("^").concat(sUniKey));
                } else {
                    __PUSH_SEND_HASH__.put("MSG_UID", postId.substring(0, 13));
                }
                __PUSH_SEND_HASH__.put("CUST_ID", memberId);
                __PUSH_SEND_HASH__.put("MEMBER_ID", memberId);
                __PUSH_SEND_HASH__.put("TOTAL_TYPE", prop.getProperty("TOTAL_TYPE"));
            }
            __PUSH_SEND_HASH__.put("TOKEN_ID", token);
            __PUSH_SEND_HASH__.put("MEMBER_NAME", this._MEMBER_HASH_.getAsString("TMS_M_NAME", ""));
            __PUSH_SEND_HASH__.put("INFO_CP", "");
            __PUSH_SEND_HASH__.put("APP_GRP_KEY", prop.getProperty("APP_GRP_KEY"));
            __PUSH_SEND_HASH__.put("APP_GRP_ID", prop.getProperty("APP_GRP_ID"));
            __PUSH_SEND_HASH__.put("DEVICE_ID", deviceId);
            StringBuffer buffer = new StringBuffer(512);
            __PUSH_SEND_HASH__.put("CONTENT_TYPE", prop.getProperty("CONTENT_TYPE", "T"));
            Enumeration<?> eNum = prop.propertyNames();
            while (eNum.hasMoreElements()) {
                String key = eNum.nextElement().toString();
                String value = prop.getProperty(key);
                buffer.setLength(0);
                StringConvertUtil.ConvertString(buffer, value, this._MEMBER_HASH_, "${", "}", true, false);
                if (key.equals("CONTENT") || __PUSH_SEND_HASH__.containsKey(key)) continue;
                __PUSH_SEND_HASH__.put(key, StringUtil.trimNull(buffer));
            }
            __PUSH_SEND_HASH__.put("POPUP_CONTENT", contentPop);
            __PUSH_SEND_HASH__.put("INAPP_CONTENT", content);
            __PUSH_SEND_HASH__.put("PUSH_KEY", "I");
            String pushTtl = "".equals(prop.getProperty("PUSH_TTL", "")) ? "1800" : prop.getProperty("PUSH_TTL", "");
            __PUSH_SEND_HASH__.put("PUSH_TTL", pushTtl);
            __PUSH_SEND_HASH__.put("SPARE_MINUTE", spareMinute + "");
            __PUSH_SEND_HASH__.put("ROW_ID", rowId);
            if ("Y".equals(activeMqUseYN)) {
                __PUSH_SEND_HASH__.put("OS", os);
                __PUSH_SEND_HASH__.put("NOTI_FLAG", notiFlag);
                __PUSH_SEND_HASH__.put("LIST_TABLE", listTable);
            }
            __PUSH_SEND_HASH__.put("ETC1", "");
            __PUSH_SEND_HASH__.put("ETC2", "");
            __PUSH_SEND_HASH__.put("ETC3", "");
            __PUSH_SEND_HASH__.put("ETC4", "");
            __PUSH_SEND_HASH__.put("ETC5", "");
            __PUSH_SEND_HASH__.put("ETC6", "");
            __PUSH_SEND_HASH__.put("PRIORITY", priority);
            String swType = prop.getProperty("SWITCH_YN", "N");
            __PUSH_SEND_HASH__.put("RESEND_TYPE", "NO");
            if (!swType.equals("N")) {
                String[] contentSplit = content.split("\\/\\*\\*KAKAO\\_DELIM\\*\\*\\/");
                __PUSH_SEND_HASH__.put("INAPP_CONTENT", contentSplit[0]);
                __PUSH_SEND_HASH__.put("CONTENT", contentSplit[0]);
                boolean isSwMapping = true;
                if (!StringUtils.isNull((String)this._MEMBER_HASH_.getAsString("SWITCH_YN", "")) && "N".equals(this._MEMBER_HASH_.getAsString("SWITCH_YN", ""))) {
                    isSwMapping = false;
                }
                if (isSwMapping && contentSplit.length > 1) {
                    __PUSH_SEND_HASH__.put("SWITCH_MSG", contentSplit[1]);
                    String to_number = this._MEMBER_HASH_.getAsString("TMS_M_PHONE", "");
                    if (postId.indexOf(95) > -1 && postId.length() != 13 && "Y".equals(encryptYn) && to_number != null && !"".equals(to_number)) {
                        to_number = HumusonEncryptor.encrypt((String)to_number, (String)encKey, (boolean)false);
                    }
                    __PUSH_SEND_HASH__.put("TMS_M_PHONE", to_number);
                    if (contentSplit[1] != null && !"".equals(contentSplit[1])) {
                        if (swType.equals("S")) {
                            if (contentSplit[1].getBytes().length <= 90) {
                                __PUSH_SEND_HASH__.put("RESEND_TYPE", "SM");
                            } else {
                                __PUSH_SEND_HASH__.put("RESEND_TYPE", "LM");
                            }
                        } else {
                            __PUSH_SEND_HASH__.put("RESEND_TYPE", "KA");
                        }
                    }
                } else {
                    __PUSH_SEND_HASH__.put("TMS_M_PHONE", "");
                }
            } else {
                __PUSH_SEND_HASH__.put("CONTENT", content);
                __PUSH_SEND_HASH__.put("TMS_M_PHONE", "");
            }
            return __PUSH_SEND_HASH__;
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            throw e;
        }
    }

    protected MgsPush.Request.Builder apnsBuilder(MgsPush.Request.Builder rb, MgsPush.PushPayload.Builder pb, Map<String, String> __PUSH_SEND_HASH__, Map<String, String> appKeyMap, String appGrpKey, String serverId, String id) {
        rb.setAppKey(appKeyMap.get(appGrpKey)).setAckMode(MgsPush.Request.AckMode.ACK).setPushChnType(MgsPush.PushChnType.APNS).setSendType(MgsPush.Request.SendType.ONE2ONE).setSeverId(serverId);
        pb.clear();
        pb.setToken(__PUSH_SEND_HASH__.get("TOKEN_ID")).setId(id).setApnsMessage(this.makeApnsMqMessage(__PUSH_SEND_HASH__));
        rb.addPayload(pb.build());
        return rb;
    }

    protected MgsPush.Request.Builder fcmBuilder(MgsPush.Request.Builder rb, MgsPush.PushPayload.Builder pb, Map<String, String> __PUSH_SEND_HASH__, Map<String, String> appKeyMap, String appGrpKey, String serverId, String id) {
        rb.setAppKey(appKeyMap.get(appGrpKey)).setAckMode(MgsPush.Request.AckMode.ACK).setPushChnType(MgsPush.PushChnType.GCM).setSendType(MgsPush.Request.SendType.ONE2ONE).setSeverId(serverId);
        pb.clear();
        pb.setToken(__PUSH_SEND_HASH__.get("TOKEN_ID")).setId(id).setGcmMessage(this.makeGcmMqMessage(__PUSH_SEND_HASH__));
        rb.addPayload(pb.build());
        return rb;
    }

    @Override
    protected void all_error_process() {
        this.error_process(this.RCPT_ARRAY, "all error");
        this.parsedListAllErrorProcess();
    }

    public static void main(String[] args) {
        String str = "123456789^^1";
        if (str.indexOf("^^") > -1) {
            System.out.println(str.split("\\^\\^")[1]);
        }
        String[] contentSplit = str.split("9");
        System.out.println(contentSplit[0]);
        System.out.println(contentSplit.length);
    }

    static {
        sparePlusMinute = Integer.parseInt(eMsSystem.getProperty("push.spare.time.plus.minute", "0"));
        commitSize = Integer.parseInt(eMsSystem.getProperty("commit.size", "1000"));
        spareCount = Integer.parseInt(eMsSystem.getProperty("push.spare.time.plus.count", "1"));
        activeMqAddr = eMsSystem.getProperty("batch.activemq.addr", "");
        activeMqQueName = eMsSystem.getProperty("batch.activemq.request.que.name", "");
        activeMqUseYN = eMsSystem.getProperty("batch.activemq.use.yn", "Y");
        QUERY_INSERT_PUSH_SEND = SqlManager.getQuery("COMMON", "QUERY_INSERT_PUSH_SEND");
        QUERY_SELECT_PUSH_CERT_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_PUSH_CERT_INFO");
        QUERY_SELECT_PUSH_OS_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_PUSH_OS_INFO");
        QUERY_INSERT_INAPP_MSG = SqlManager.getQuery("COMMON", "QUERY_INSERT_INAPP_MSG");
        QUERY_UPDATE_SEND_LIST = SqlManager.getQuery("COMMON", "QUERY_UPDATE_SEND_LIST");
        QUERY_UPDATE_SCHD_INFO = SqlManager.getQuery("COMMON", "QUERY_UPDATE_SCHD_INFO");
        encryptYn = eMsSystem.getProperty("member.info.encrypt.yn", "N");
        encKey = eMsSystem.getProperty("member.info.encrypt.key");
    }
}

