/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.actor;

import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.ChannelType;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jupiter.mass.actor.AbstractSingleRcptCommunicationActor;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.lang.eMsLocale;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;

public class KakaoFixedDomainSingleRcptBufferedCommunicationActor
extends AbstractSingleRcptCommunicationActor {
    private static final Logger log = LoggerFactory.getLogger(KakaoFixedDomainSingleRcptBufferedCommunicationActor.class);
    private static final String KAKAO_DELIM = "/**KAKAO_DELIM**/";
    private static final String KAKAO_BUTTON = "/**KAKAO_BUTTON**/";
    private static String QUERY_INSERT_KAKAO_SEND = null;
    private static ConnectInfo TARGET_CONNECT_INFO = null;
    private static int th_cnt = 0;
    private eMsConnection TMS_CONNECTION = null;
    private eMsPreparedStatement PSTMT = null;
    private static final int SMS_LIMIT_BYTE = Integer.parseInt(eMsSystem.getProperty("sms.limit.byte", "90"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void work() throws Exception {
        KakaoFixedDomainSingleRcptBufferedCommunicationActor.log.info("QUERY_INSERT_KAKAO_SEND : {}", (Object)KakaoFixedDomainSingleRcptBufferedCommunicationActor.QUERY_INSERT_KAKAO_SEND);
        this.TMS_CONNECTION = ConnectionPool.getConnection(KakaoFixedDomainSingleRcptBufferedCommunicationActor.TARGET_CONNECT_INFO);
        this.PSTMT = this.TMS_CONNECTION.prepareStatement(KakaoFixedDomainSingleRcptBufferedCommunicationActor.QUERY_INSERT_KAKAO_SEND, "${", "}");
        ++KakaoFixedDomainSingleRcptBufferedCommunicationActor.th_cnt;
        this.CURR_STEP = (short)-1;
        while (true) lbl-1000:
        // 6 sources

        {
            if (this.RCPT_TO == null) {
                this.RCPT_TO = this.INNER_BUFFERED_BIN.popupNoWait();
            }
            if (this.RCPT_TO == null) {
                return;
            }
            if (KakaoFixedDomainSingleRcptBufferedCommunicationActor.log.isDebugEnabled()) {
                this.log("pop up:" + this.RCPT_TO.toString());
            }
            if (this.splitRcptInfo() == null) {
                if (!KakaoFixedDomainSingleRcptBufferedCommunicationActor.log.isDebugEnabled()) continue;
                this.log("split fail continue");
                continue;
            }
            KakaoFixedDomainSingleRcptBufferedCommunicationActor.log.debug("START : [th_cnt] => {} / [size] => {}", (Object)KakaoFixedDomainSingleRcptBufferedCommunicationActor.th_cnt, (Object)this.PARSED_RCPT_INFO.size());
            try {
                this.TMS_CONNECTION.setAutoCommit(false);
                time = System.currentTimeMillis();
                kakaoSendHash = null;
                while (this.PARSED_RCPT_INFO.size() > 0) {
                    NEXT_SPOOL = this.PARSED_RCPT_INFO.removeFirst();
                    if (!this.parseRcptInfo(NEXT_SPOOL)) {
                        if (!KakaoFixedDomainSingleRcptBufferedCommunicationActor.log.isDebugEnabled()) continue;
                        this.log("parseRcptInfo fail continue");
                        continue;
                    }
                    if (this.connection_delay > 0) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(this.connection_delay);
                        }
                        catch (Exception var5_6) {
                            // empty catch block
                        }
                    }
                    this.start_process(this.RCPT_ARRAY);
                    try {
                        kakaoSendHash = this.setMapping(this.RCPT_ARRAY);
                        if (this.PSTMT.executeUpdate(kakaoSendHash) > 0) {
                            this.success_process(this.RCPT_ARRAY);
                            continue;
                        }
                        this.error_process(this.RCPT_ARRAY, "KAKAO QUE INSERT CNT IS 0");
                    }
                    catch (Exception e) {
                        KakaoFixedDomainSingleRcptBufferedCommunicationActor.log.error("KAKAO Sender ERROR", (Throwable)e);
                        this.error_process(this.RCPT_ARRAY, e.getMessage());
                    }
                }
                KakaoFixedDomainSingleRcptBufferedCommunicationActor.log.debug("END : [th_cnt] => {} / [size] => {} / [loop_time] => {} ms", new Object[]{KakaoFixedDomainSingleRcptBufferedCommunicationActor.th_cnt, this.PARSED_RCPT_INFO.size(), System.currentTimeMillis() - time});
            }
            catch (Exception e) {
                this.TMS_CONNECTION.rollback();
                KakaoFixedDomainSingleRcptBufferedCommunicationActor.log.error("KAKAO ERROR.", (Throwable)e);
                KakaoFixedDomainSingleRcptBufferedCommunicationActor.log.error("KAKAO 1TO1 - ROLLBACK!!! KAKAO \ub4f1\ub85d \uc624\ub958. {}", (Object)this.RCPT_ARRAY.toString());
            }
            finally {
                if (this.TMS_CONNECTION == null) continue;
                KakaoFixedDomainSingleRcptBufferedCommunicationActor.log.debug("COMMIT TRUE : [th_cnt] {} / [size] {}", (Object)KakaoFixedDomainSingleRcptBufferedCommunicationActor.th_cnt, (Object)this.PARSED_RCPT_INFO.size());
                this.TMS_CONNECTION.commit();
                this.TMS_CONNECTION.setAutoCommit(true);
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            if (this.TMS_CONNECTION != null) {
                this.TMS_CONNECTION.recycle();
            }
            if (this.PSTMT != null) {
                this.PSTMT.close();
            }
        }
    }

    @Override
    protected void success_process(String[] _AGENT_ARRAY_) {
        this.resultLog(_AGENT_ARRAY_, "54", "10", "250 KAKAO Message accepted for send", (short)2);
    }

    protected void error_process(String[] _AGENT_ARRAY_, String errorMessage) {
        this.resultLog(_AGENT_ARRAY_, "55", this.sendState.getRETURN_CODE(), "KAKAO fail " + errorMessage, this.sendState.getLogLevel());
    }

    public Map<String, String> setMapping(String[] array) throws Exception {
        HashMap<String, String> sendHash = new HashMap<String, String>();
        String send_type = "";
        String post_id = "";
        String member_id = "";
        String from_number = "";
        String to_number = "";
        String content = "";
        String list_table = "";
        String rowId = "";
        String smsType = "";
        try {
            send_type = array[0];
            post_id = array[1];
            member_id = array[2];
            from_number = array[6];
            to_number = array[3];
            content = array[4];
            list_table = array[10];
            rowId = array[12];
            sendHash.put("MEMBER_ID", member_id);
            sendHash.put("TO_NUMBER", to_number);
            sendHash.put("POST_ID", post_id);
            sendHash.put("CONTENT", content);
            sendHash.put("ETC1", send_type);
            sendHash.put("ETC2", post_id);
            sendHash.put("ETC3", member_id);
            sendHash.put("ETC4", list_table);
            sendHash.put("ETC5", "N");
            sendHash.put("ROW_ID", rowId);
            ContentInfo sendContentInfo = ContentInfoManager.getContentInfo(post_id);
            Properties scheduleInfoProp = sendContentInfo.getScheduleInfo();
            StringBuffer buffer = new StringBuffer(512);
            Enumeration<?> eNum = scheduleInfoProp.propertyNames();
            while (eNum.hasMoreElements()) {
                String key = eNum.nextElement().toString();
                String value = scheduleInfoProp.getProperty(key);
                buffer.setLength(0);
                StringConvertUtil.ConvertString(buffer, value, this._MEMBER_HASH_, "${", "}", true, false);
                if (key.equals("CONTENT") || sendHash.containsKey(key)) continue;
                sendHash.put(key, StringUtil.trimNull(buffer));
            }
            sendHash.put("BILL_CODE", scheduleInfoProp.getProperty("BILL_CODE", ""));
            sendHash.put("TEMPLATE_CODE", scheduleInfoProp.getProperty("TEMPLATE_CODE", ""));
            String swichYn = scheduleInfoProp.getProperty("SWITCH_YN", "N");
            smsType = scheduleInfoProp.getProperty("SMS_TYPE", "NO");
            String buttonInfos = "";
            if (content.lastIndexOf(KAKAO_BUTTON) > 0 && content.length() > 0) {
                int kakao_button_idx = content.lastIndexOf(KAKAO_BUTTON);
                int kakao_button_length = KAKAO_BUTTON.length();
                buttonInfos = content.substring(kakao_button_idx + kakao_button_length, content.length()).trim();
                content = content.substring(0, kakao_button_idx);
            }
            sendHash.put("KAKAO_BUTTONS", buttonInfos);
            if ("Y".equals(swichYn) || content.indexOf(KAKAO_DELIM) > 0) {
                String kakaoContent = "";
                String smsContent = "";
                if (content.length() > 0) {
                    int idx1 = content.indexOf(KAKAO_DELIM);
                    int idx2 = KAKAO_DELIM.length();
                    kakaoContent = content.substring(0, idx1).trim();
                    smsContent = content.substring(idx1 + idx2, content.length()).trim();
                }
                sendHash.put("RESEND_TYPE", this.getResendType(smsContent));
                sendHash.put("RESEND_CALLBACK", scheduleInfoProp.getProperty("FROM_NUMBER"));
                if ("KA".equals(smsType)) {
                    sendHash.put("RESEND_MT_MESSAGE_REUSE", "Y");
                } else {
                    sendHash.put("RESEND_MT_MESSAGE_REUSE", "N");
                    sendHash.put("RESEND_TITLE", this._MEMBER_HASH_.getAsString("SUBJECT"));
                    sendHash.put("RESEND_MESSAGE", smsContent);
                }
                sendHash.put("KAKAO_CONTENT", kakaoContent);
            } else {
                sendHash.put("RESEND_TYPE", "NO");
                sendHash.put("RESEND_CALLBACK", "");
                sendHash.put("RESEND_TITLE", "");
                sendHash.put("RESEND_MESSAGE", "");
                sendHash.put("RESEND_MT_MESSAGE_REUSE", "N");
                sendHash.put("KAKAO_CONTENT", content);
            }
            sendHash.put("USER_ID", scheduleInfoProp.getProperty("USER_ID", ""));
            sendHash.put("USER_DEPT", scheduleInfoProp.getProperty("USER_DEPT", ""));
            log.debug("============================ SEND HASH START ============================");
            log.debug("{}", sendHash);
            log.debug("============================ SEND HASH END ============================");
            return sendHash;
        }
        catch (Exception e) {
            log.error("KAKAO __KAKAO_SEND_HASH__ put Exception", (Throwable)e);
            this.log("KAKAO __KAKAO_SEND_HASH__ put Exception is " + e.getMessage());
            throw e;
        }
    }

    @Override
    protected void all_error_process() {
        this.error_process(this.RCPT_ARRAY, "ALL ERROR");
        this.parsedListAllErrorProcess();
    }

    private String getResendType(String smsContent) {
        if (StringUtils.isNull((String)smsContent)) {
            return "NO";
        }
        int bytes = this.getBytes(smsContent);
        if (bytes == 0) {
            return "NO";
        }
        if (bytes > SMS_LIMIT_BYTE) {
            return ChannelType.LMS.getCode();
        }
        return ChannelType.SMS.getCode();
    }

    private int getBytes(String content) {
        try {
            return content.getBytes(eMsLocale.CHAR_SET).length;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void main(String[] args) {
        String content = "testetestestsetaaaaaatestestsetsetsaaaae/**KAKAO_BUTTON**/{button:[{name=}]}";
        String buttonInfos = "";
        String kakaoContent = "";
        String smsContent = "";
        boolean buttonUseYn = false;
        boolean resendToSmsUseYn = false;
        int buttonIdx = 0;
        int buttonDelimSize = KAKAO_BUTTON.length();
        int smsContentIdx = 0;
        int smsContentDelimSize = KAKAO_DELIM.length();
        if (content.length() > 0) {
            if (content.indexOf(KAKAO_DELIM) > 0) {
                buttonUseYn = true;
                smsContentIdx = content.indexOf(KAKAO_DELIM);
            }
            if (content.indexOf(KAKAO_BUTTON) > 0) {
                resendToSmsUseYn = true;
                buttonIdx = content.indexOf(KAKAO_BUTTON);
            }
        }
        if (buttonUseYn) {
            // empty if block
        }
        if (resendToSmsUseYn) {
            // empty if block
        }
        int idx1 = content.indexOf(KAKAO_DELIM);
        int idx2 = KAKAO_DELIM.length();
        kakaoContent = content.substring(0, idx1).trim();
        smsContent = content.substring(idx1 + idx2, content.length()).trim();
        System.out.println(kakaoContent);
        System.out.println(smsContent);
        if (content.length() > 0) {
            int idx3 = content.lastIndexOf(KAKAO_BUTTON);
            int idx4 = KAKAO_BUTTON.length();
            buttonInfos = content.substring(idx3 + idx4, content.length()).trim();
            content = content.substring(0, idx3);
            System.out.println(idx3);
            System.out.println(idx4);
        }
        System.out.println(buttonInfos);
        System.out.println(content);
    }

    static {
        QUERY_INSERT_KAKAO_SEND = SqlManager.getQuery("COMMON", "QUERY_INSERT_KAKAO_SEND");
        TARGET_CONNECT_INFO = new ConnectInfo();
        TARGET_CONNECT_INFO.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
        TARGET_CONNECT_INFO.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
        TARGET_CONNECT_INFO.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
        TARGET_CONNECT_INFO.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
        TARGET_CONNECT_INFO.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
        TARGET_CONNECT_INFO.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
        TARGET_CONNECT_INFO.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
        TARGET_CONNECT_INFO.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
    }
}

