/*
 * Decompiled with CFR 0.152.
 */
package jupiter.common.task;

import java.util.LinkedList;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.mail.MailSendingInstanceFactory;
import pluto.schedule.AlreadyRegistTaskException;
import pluto.schedule.Task;
import pluto.schedule.TaskManager;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

public class RealTimeCheckTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(RealTimeCheckTask.class);
    public static String QUERY_SELECT_REAL_SEARCH_TARGET_SCHEDULE = null;
    public static String QUERY_SELECT_REAL_INPUT_TARGET_SCHEDULE = null;
    public static String QUERY_SELECT_INIT_REALTIME_THREAD_STATUS_INFO = null;
    public static String QUERY_UPDATE_INIT_REALTIME_THREAD_STATUS_EACH = null;
    public static String QUERY_UPDATE_INIT_REALTIME_THREAD_STATUS_ALL = null;
    private static int schedule_count = 0;
    private static String mail_thread_size = "";
    protected eMsConnection EMS_CONNECTION = null;
    protected eMsStatement __SELECT_SEARCH_STATEMENT__ = null;
    protected eMsStatement __SELECT_INPUT_STATEMENT__ = null;
    public String MAIL_ID = "";
    public static String LIST_MAKER_CLASS_NAME;

    public RealTimeCheckTask() {
        super((short)2);
        this.setName("RealTimeCheckTask_at_" + System.currentTimeMillis() % 100000L);
        this.setTaskID("RealTimeCheckTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void update_init_thread_status() throws Exception {
        eMsConnection conn = null;
        eMsStatement select_stmt = null;
        eMsStatement stmt = null;
        eMsResultSet rs = null;
        int schedule_count = 0;
        int RESULT_UPDATE = 0;
        try {
            conn = ConnectionPool.getConnection();
            stmt = conn.createStatement();
            select_stmt = conn.createStatement();
            rs = select_stmt.executeQuery(QUERY_SELECT_INIT_REALTIME_THREAD_STATUS_INFO);
            StringBuffer sb = new StringBuffer();
            Properties BASE_SCHDULE = new Properties();
            while (rs.next()) {
                BASE_SCHDULE.clear();
                rs.putToMap(BASE_SCHDULE, false);
                sb.setLength(0);
                StringConvertUtil.ConvertString(sb, QUERY_UPDATE_INIT_REALTIME_THREAD_STATUS_EACH, BASE_SCHDULE, "${", "}", true, false);
                RESULT_UPDATE = stmt.executeUpdate(sb.toString());
                if (RESULT_UPDATE <= 0) continue;
                ++schedule_count;
            }
            if (Integer.parseInt(mail_thread_size) > schedule_count) {
                BASE_SCHDULE.clear();
                sb.setLength(0);
                int target_count = Integer.parseInt(mail_thread_size) - schedule_count;
                BASE_SCHDULE.setProperty("MAX_SIZE", String.valueOf(target_count));
                StringConvertUtil.ConvertString(sb, QUERY_UPDATE_INIT_REALTIME_THREAD_STATUS_ALL, BASE_SCHDULE, "${", "}", true, false);
                stmt.executeUpdate(sb.toString());
            }
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            System.exit(1);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (conn != null) {
                conn.recycleStatement(select_stmt);
                conn.recycleStatement(stmt);
                conn.recycle();
            }
        }
    }

    public static void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        LIST_MAKER_CLASS_NAME = prop.getProperty("make.class");
        mail_thread_size = eMsSystem.getProperty("mail.thread.size", "30");
        try {
            RealTimeCheckTask.update_init_thread_status();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("RealTimeCheckTask_at_".concat(Cal.getSerialDate()));
        if (log.isDebugEnabled()) {
            log.debug("execute_initiate");
        }
        this.EMS_CONNECTION = ConnectionPool.getConnection();
        try {
            this.__SELECT_SEARCH_STATEMENT__ = this.EMS_CONNECTION.createStatement();
            this.__SELECT_INPUT_STATEMENT__ = this.EMS_CONNECTION.createStatement();
        }
        catch (Exception e) {
            this.EMS_CONNECTION = ConnectionPool.getConnection();
            this.__SELECT_SEARCH_STATEMENT__ = this.EMS_CONNECTION.createStatement();
            this.__SELECT_INPUT_STATEMENT__ = this.EMS_CONNECTION.createStatement();
        }
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error("execute_initiateError", thw);
    }

    @Override
    public void release_Resource() {
        if (log.isDebugEnabled()) {
            log.debug("release_Resource");
        }
        if (this.EMS_CONNECTION != null) {
            this.EMS_CONNECTION.recycleStatement(this.__SELECT_SEARCH_STATEMENT__);
            this.EMS_CONNECTION.recycleStatement(this.__SELECT_INPUT_STATEMENT__);
            this.EMS_CONNECTION.recycle();
        }
    }

    @Override
    public void execute() throws Exception {
        this.execute_createTask(QUERY_SELECT_REAL_SEARCH_TARGET_SCHEDULE, QUERY_SELECT_REAL_INPUT_TARGET_SCHEDULE);
        if (log.isDebugEnabled()) {
            log.debug("execute_createTask END");
        }
    }

    private synchronized void execute_createTask(String TARGET_SEARCH_QUERY, String TARGET_INPUT_QUERY) throws Exception {
        eMsResultSet __RESULT_OF_SEARCH_SCHEDULE__ = null;
        eMsResultSet __RESULT_OF_INPUT_SCHEDULE__ = null;
        try {
            Task make_info;
            __RESULT_OF_SEARCH_SCHEDULE__ = this.__SELECT_SEARCH_STATEMENT__.executeQuery(TARGET_SEARCH_QUERY);
            __RESULT_OF_INPUT_SCHEDULE__ = this.__SELECT_INPUT_STATEMENT__.executeQuery(TARGET_INPUT_QUERY);
            LinkedList<Properties> TARGET_SCHEDULE_SEARCH_LIST = null;
            LinkedList<Properties> TARGET_SCHEDULE_INPUT_LIST = null;
            String str = String.valueOf(System.nanoTime());
            schedule_count = 0;
            while (__RESULT_OF_SEARCH_SCHEDULE__.next()) {
                if (Integer.parseInt(mail_thread_size) < ++schedule_count) continue;
                TARGET_SCHEDULE_SEARCH_LIST = new LinkedList<Properties>();
                Properties SCHEDULE_SEARCH_INFO = new Properties();
                SCHEDULE_SEARCH_INFO.setProperty("SEND_TYPE", "O");
                SCHEDULE_SEARCH_INFO.setProperty("SEND_STATE", "REAL");
                SCHEDULE_SEARCH_INFO.setProperty("LIST_MAKER", LIST_MAKER_CLASS_NAME);
                this.MAIL_ID = SCHEDULE_SEARCH_INFO.getProperty("MAIL_ID", "NO ID");
                __RESULT_OF_SEARCH_SCHEDULE__.putToMap(SCHEDULE_SEARCH_INFO, false);
                TARGET_SCHEDULE_SEARCH_LIST.add(SCHEDULE_SEARCH_INFO);
                try {
                    make_info = (Task)MailSendingInstanceFactory.getInstance(SCHEDULE_SEARCH_INFO, (short)4);
                    make_info.setTaskProperty(SCHEDULE_SEARCH_INFO);
                    TaskManager.executeTask(make_info);
                    try {
                        this.wait(500L);
                    }
                    catch (Exception exception) {
                    }
                }
                catch (AlreadyRegistTaskException e) {
                    log.info("AlreadyRegistTaskException is skip [msg:{}]", (Object)e.getMessage());
                }
                catch (Exception e) {
                    log.error(this.getName(), (Throwable)e);
                }
            }
            while (__RESULT_OF_INPUT_SCHEDULE__.next()) {
                if (Integer.parseInt(mail_thread_size) < ++schedule_count) continue;
                TARGET_SCHEDULE_INPUT_LIST = new LinkedList<Properties>();
                Properties SCHEDULE_INPUT_INFO = new Properties();
                SCHEDULE_INPUT_INFO.setProperty("SEND_TYPE", "O");
                SCHEDULE_INPUT_INFO.setProperty("SEND_STATE", "REAL");
                this.MAIL_ID = SCHEDULE_INPUT_INFO.getProperty("MAIL_ID", "NO ID");
                SCHEDULE_INPUT_INFO.setProperty("LIST_MAKER", LIST_MAKER_CLASS_NAME);
                __RESULT_OF_INPUT_SCHEDULE__.putToMap(SCHEDULE_INPUT_INFO, false);
                TARGET_SCHEDULE_INPUT_LIST.add(SCHEDULE_INPUT_INFO);
                try {
                    make_info = (Task)MailSendingInstanceFactory.getInstance(SCHEDULE_INPUT_INFO, (short)4);
                    make_info.setTaskProperty(SCHEDULE_INPUT_INFO);
                    TaskManager.executeTask(make_info);
                    try {
                        this.wait(500L);
                    }
                    catch (Exception exception) {
                    }
                }
                catch (AlreadyRegistTaskException e) {
                    log.error("AlreadyRegistTaskException is skip");
                }
                catch (Exception e) {
                    log.error(this.getName(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (__RESULT_OF_SEARCH_SCHEDULE__ != null) {
                    __RESULT_OF_SEARCH_SCHEDULE__.close();
                }
                if (__RESULT_OF_INPUT_SCHEDULE__ != null) {
                    __RESULT_OF_INPUT_SCHEDULE__.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    static {
        try {
            QUERY_SELECT_REAL_SEARCH_TARGET_SCHEDULE = SqlManager.getQuery("MAIN_SCHEDULE_CHECK", "QUERY_SELECT_REAL_SEARCH_TARGET_SCHEDULE");
            QUERY_SELECT_REAL_INPUT_TARGET_SCHEDULE = SqlManager.getQuery("MAIN_SCHEDULE_CHECK", "QUERY_SELECT_REAL_INPUT_TARGET_SCHEDULE");
            QUERY_SELECT_INIT_REALTIME_THREAD_STATUS_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_INIT_REALTIME_THREAD_STATUS_INFO");
            QUERY_UPDATE_INIT_REALTIME_THREAD_STATUS_EACH = SqlManager.getQuery("COMMON", "QUERY_UPDATE_INIT_REALTIME_THREAD_STATUS_EACH");
            QUERY_UPDATE_INIT_REALTIME_THREAD_STATUS_ALL = SqlManager.getQuery("COMMON", "QUERY_UPDATE_INIT_REALTIME_THREAD_STATUS_ALL");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
        LIST_MAKER_CLASS_NAME = "";
    }
}

