/*
 * Decompiled with CFR 0.152.
 */
package jupiter.common.task;

import java.sql.SQLException;
import jupiter.common.task.AbstractMailSendTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.log.Composer;
import pluto.log.Log;
import pluto.log.SmtpLogger;
import pluto.reporter.Reporter;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

public abstract class AbstractDBMailSendTask
extends AbstractMailSendTask
implements Log {
    private static final Logger log = LoggerFactory.getLogger(AbstractDBMailSendTask.class);
    protected String LIST_TABLE = null;
    protected String INSTANCE_QUERY_CHECK_STOP_FLAG = null;
    protected StringBuffer TMP_STRING_BUFFER = null;
    protected Composer composer = Composer.getComposerInstance();

    protected AbstractDBMailSendTask() throws Exception {
        this(1, 60000L);
    }

    protected AbstractDBMailSendTask(short type) throws Exception {
        this(type, 60000L);
    }

    protected AbstractDBMailSendTask(short type, long interval) throws Exception {
        super(type, interval);
    }

    @Override
    public void execute_initiate() throws Exception {
        super.execute_initiate();
        this.TMP_STRING_BUFFER = new StringBuffer(1024);
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error(this.getName(), thw);
        if (!(thw instanceof SQLException)) {
            Reporter.report(this.POST_ID, this.getName(), "mailsendtask.init.err", thw);
        }
    }

    @Override
    public void doErrorProcess(Throwable thw) {
        log.error(this.getName(), thw);
        Reporter.report(this.POST_ID, this.getName(), "mailsendtask.exec.err", thw);
    }

    @Override
    public void release_Resource() {
        this.TMP_STRING_BUFFER = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean execute_StopCheck() {
        if (this.INSTANCE_QUERY_CHECK_STOP_FLAG == null) {
            return false;
        }
        eMsStatement __EMS_EXEC_STATEMENT__ = null;
        eMsResultSet rs = null;
        eMsConnection emsConnection = null;
        try {
            emsConnection = ConnectionPool.getConnection();
            __EMS_EXEC_STATEMENT__ = emsConnection.createStatement();
            this.TMP_STRING_BUFFER.setLength(0);
            StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.INSTANCE_QUERY_CHECK_STOP_FLAG, this.TASK_PROPERTY, "${", "}", true, false);
            rs = __EMS_EXEC_STATEMENT__.executeQuery(this.TMP_STRING_BUFFER.toString());
            if (rs.next()) {
                if (log.isDebugEnabled()) {
                    log.debug("CHECK STOP SIGNAL--BINGO");
                }
                this.writeSystemLog("SYSTEM", "90", "32");
                boolean bl = true;
                return bl;
            }
            if (log.isDebugEnabled()) {
                log.debug("CHECK STOP SIGNAL--CONTINUE");
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception ignore) {
            log.error(this.getName(), (Throwable)ignore);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            if (__EMS_EXEC_STATEMENT__ != null) {
                emsConnection.recycleStatement(__EMS_EXEC_STATEMENT__);
            }
            if (emsConnection != null) {
                emsConnection.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeSystemLog(String sTYPE, String sCODE_TYPE, String sCODE_CODE) {
        Object object = this.composer.getLock();
        synchronized (object) {
            this.composer.setProperty("STYPE", sTYPE);
            this.composer.setProperty("T_TYPE", sCODE_TYPE);
            this.composer.setProperty("T_CODE", sCODE_CODE);
            this.composer.setProperty("POST_ID", this.POST_ID);
            this.composer.setProperty("M_ID", "noid");
            this.composer.setProperty("STEP", "0");
            this.composer.setProperty("T_DATE", Cal.getDate());
            this.composer.setProperty("MX_RECORD", "");
            this.composer.setProperty("DELAY", "");
            this.composer.setProperty("TOKEN_ID", "noemail");
            this.composer.setProperty("DOMAIN", "");
            this.composer.setProperty("WORKER", this.getName());
            this.composer.setProperty("ETC_LOG", "MailSendTaskEnd");
            this.composer.setProperty("LIST_TABLE", "n");
            SmtpLogger.put(this.composer);
        }
    }
}

