/*
 * Decompiled with CFR 0.152.
 */
package jupiter.common.pool;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import jupiter.common.actor.BufferedCommunicationActor;
import jupiter.common.communicator.SmtpCommunicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import pluto.lang.eMsLocale;
import pluto.log.LogChannelContainer;
import pluto.util.recycle.Bufferable;
import pluto.util.recycle.BufferedObjectPool;
import pluto.util.xml.XMLUtil;

public abstract class BufferedAgentPool
extends BufferedObjectPool {
    private static final Logger log = LoggerFactory.getLogger(BufferedAgentPool.class);
    private static Hashtable pool_list = new Hashtable();
    protected ThreadGroup group;
    protected Integer AGENT_WORK_DELAY = null;
    protected String AGENT_CLASS_NAME = null;
    protected Class AGENT_CLASS = null;
    protected Constructor AGENT_CLASS_CONSTRUCTOR = null;
    protected boolean WAIT_EMPTY = false;
    public int SMTP_REST_LIMIT = eMsLocale.SMTP_REST_LIMIT;
    public int INSTANCE_TIMEOUT_CONNECT = eMsLocale.TIMEOUT_CONNECT;
    public int INSTANCE_TIMEOUT_INIT = eMsLocale.TIMEOUT_INIT;
    public int INSTANCE_TIMEOUT_HELO = eMsLocale.TIMEOUT_HELO;
    public int INSTANCE_TIMEOUT_MAILFROM = eMsLocale.TIMEOUT_MAILFROM;
    public int INSTANCE_TIMEOUT_RCPT = eMsLocale.TIMEOUT_RCPT;
    public int INSTANCE_TIMEOUT_DATAINIT = eMsLocale.TIMEOUT_DATAINIT;
    public int INSTANCE_TIMEOUT_DATABLOCK = eMsLocale.TIMEOUT_DATABLOCK;
    public int INSTANCE_TIMEOUT_RSET = eMsLocale.TIMEOUT_RSET;

    public static synchronized void init(Object prop) throws Exception {
        Element TargetNode = (Element)prop;
        Element SubNode = null;
        String ClassName = null;
        String ZoneName = null;
        String ZoneDomain = null;
        NodeList TargetNodeList = TargetNode.getElementsByTagName("zone");
        int TargetNodeCount = TargetNodeList.getLength();
        for (int i = 0; i < TargetNodeCount; ++i) {
            TargetNode = (Element)TargetNodeList.item(i);
            ZoneName = TargetNode.getAttribute("name");
            ZoneDomain = TargetNode.getAttribute("domain");
            SubNode = (Element)TargetNode.getElementsByTagName("class").item(0);
            ClassName = SubNode.getAttribute("name");
            BufferedAgentPool returnValue = (BufferedAgentPool)Class.forName(ClassName).newInstance();
            returnValue.start();
            returnValue.inner_init(TargetNode, ZoneName.concat(".").concat(ZoneDomain));
            pool_list.put(ZoneName.concat(".").concat(ZoneDomain), returnValue);
            if (!log.isDebugEnabled()) continue;
            log.debug("AgentPool Regist: {}", (Object)ZoneName.concat(".").concat(ZoneDomain));
        }
    }

    public static BufferedAgentPool getBufferedObjectPool(String zone, String domain) throws Exception {
        BufferedAgentPool returnValue = null;
        returnValue = pool_list.containsKey(zone.concat(".").concat(domain.toLowerCase())) ? (BufferedAgentPool)pool_list.get(zone.concat(".").concat(domain.toLowerCase())) : (BufferedAgentPool)pool_list.get(zone.concat(".default"));
        if (log.isDebugEnabled()) {
            returnValue.log("CALL");
        }
        return returnValue;
    }

    public static void resetPoolSize(String zone, String domain, int size) throws Exception {
        if (pool_list.containsKey(zone.concat(".").concat(domain))) {
            ((BufferedObjectPool)pool_list.get(zone.concat(".").concat(domain))).resetWorkerSize(size);
        } else {
            ((BufferedObjectPool)pool_list.get(zone.concat(".default"))).resetWorkerSize(size);
        }
    }

    public static synchronized void flushAll() {
        BufferedObjectPool _POOL_ = null;
        Enumeration myEnum = pool_list.elements();
        while (myEnum.hasMoreElements()) {
            _POOL_ = (BufferedObjectPool)myEnum.nextElement();
            try {
                _POOL_.registFlush();
            }
            catch (Exception e) {
                log.error("POOL FLUSH EXCEPTION", (Throwable)e);
            }
        }
    }

    public BufferedAgentPool() {
        super(60000L, "AgentPoolInnerMonitor");
    }

    protected void inner_init(Element TargetNode, String name) throws Exception {
        this.setName(name);
        String LOGCHANNEL_ID = XMLUtil.getSubElementAttribute(TargetNode, "LOGGER", "ID");
        if (LOGCHANNEL_ID == null) {
            log.error("LOGCHANNEL IS NOT SET.......");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("LOGGER=>" + LOGCHANNEL_ID);
            }
            this.LOG_CHANNEL_INSTANCE = LogChannelContainer.get(LOGCHANNEL_ID);
        }
        Element SubNode = null;
        Element TimeOutNode = (Element)TargetNode.getElementsByTagName("timeout").item(0);
        if (TimeOutNode != null) {
            SubNode = (Element)TimeOutNode.getElementsByTagName("TIMEOUT_CONNECT").item(0);
            this.INSTANCE_TIMEOUT_CONNECT = Integer.parseInt(SubNode.getAttribute("value"));
            SubNode = (Element)TimeOutNode.getElementsByTagName("TIMEOUT_INIT").item(0);
            this.INSTANCE_TIMEOUT_INIT = Integer.parseInt(SubNode.getAttribute("value"));
            if (log.isDebugEnabled()) {
                log.debug("INSTANCE_TIMEOUT_INIT=>" + String.valueOf(this.INSTANCE_TIMEOUT_INIT));
            }
            SubNode = (Element)TimeOutNode.getElementsByTagName("TIMEOUT_HELO").item(0);
            this.INSTANCE_TIMEOUT_HELO = Integer.parseInt(SubNode.getAttribute("value"));
            if (log.isDebugEnabled()) {
                log.debug("INSTANCE_TIMEOUT_HELO=>" + String.valueOf(this.INSTANCE_TIMEOUT_HELO));
            }
            SubNode = (Element)TimeOutNode.getElementsByTagName("TIMEOUT_MAILFROM").item(0);
            this.INSTANCE_TIMEOUT_MAILFROM = Integer.parseInt(SubNode.getAttribute("value"));
            if (log.isDebugEnabled()) {
                log.debug("INSTANCE_TIMEOUT_MAILFROM=>" + String.valueOf(this.INSTANCE_TIMEOUT_MAILFROM));
            }
            SubNode = (Element)TimeOutNode.getElementsByTagName("TIMEOUT_RCPT").item(0);
            this.INSTANCE_TIMEOUT_RCPT = Integer.parseInt(SubNode.getAttribute("value"));
            if (log.isDebugEnabled()) {
                log.debug("INSTANCE_TIMEOUT_RCPT=>" + String.valueOf(this.INSTANCE_TIMEOUT_RCPT));
            }
            SubNode = (Element)TimeOutNode.getElementsByTagName("TIMEOUT_DATAINIT").item(0);
            this.INSTANCE_TIMEOUT_DATAINIT = Integer.parseInt(SubNode.getAttribute("value"));
            if (log.isDebugEnabled()) {
                log.debug("INSTANCE_TIMEOUT_DATAINIT=>" + String.valueOf(this.INSTANCE_TIMEOUT_DATAINIT));
            }
            SubNode = (Element)TimeOutNode.getElementsByTagName("TIMEOUT_DATABLOCK").item(0);
            this.INSTANCE_TIMEOUT_DATABLOCK = Integer.parseInt(SubNode.getAttribute("value"));
            if (log.isDebugEnabled()) {
                log.debug("INSTANCE_TIMEOUT_DATABLOCK=>" + String.valueOf(this.INSTANCE_TIMEOUT_DATABLOCK));
            }
            SubNode = (Element)TimeOutNode.getElementsByTagName("TIMEOUT_RSET").item(0);
            this.INSTANCE_TIMEOUT_RSET = Integer.parseInt(SubNode.getAttribute("value"));
            if (log.isDebugEnabled()) {
                log.debug("INSTANCE_TIMEOUT_RSET=>" + String.valueOf(this.INSTANCE_TIMEOUT_RSET));
            }
        }
        if ((SubNode = (Element)TargetNode.getElementsByTagName("rset").item(0)) != null) {
            this.SMTP_REST_LIMIT = Integer.parseInt(SubNode.getAttribute("value"));
        }
        SubNode = (Element)TargetNode.getElementsByTagName("subclass").item(0);
        this.AGENT_CLASS_NAME = SubNode.getAttribute("value");
        this.AGENT_CLASS = Class.forName(this.AGENT_CLASS_NAME);
        SubNode = (Element)TargetNode.getElementsByTagName("size").item(0);
        int iWorkerSize = Integer.parseInt(SubNode.getAttribute("value"));
        SubNode = (Element)TargetNode.getElementsByTagName("resetsize").item(0);
        int iResetSize = Integer.parseInt(SubNode.getAttribute("value"));
        SubNode = (Element)TargetNode.getElementsByTagName("buffersize").item(0);
        int iBufferSize = Integer.parseInt(SubNode.getAttribute("value"));
        SubNode = (Element)TargetNode.getElementsByTagName("wait").item(0);
        this.WAIT_EMPTY = "true".equals(SubNode.getAttribute("value"));
        SubNode = (Element)TargetNode.getElementsByTagName("delay").item(0);
        String sDelayValue = SubNode.getAttribute("value");
        if (log.isDebugEnabled()) {
            log.debug("{} AgentPool Delay: {}", (Object)name, (Object)sDelayValue);
        }
        this.AGENT_WORK_DELAY = Integer.decode(sDelayValue);
        if (log.isDebugEnabled()) {
            log.debug("{} AgentPool DelayConvert: {}", (Object)name, (Object)this.AGENT_WORK_DELAY.toString());
        }
        this.group = new ThreadGroup(eMsLocale.EMS_ROOT_THREAD_GROUP, "AgentPool=>" + this.getName());
        if (iResetSize == 0) {
            this.setWorkerSize(iWorkerSize);
        } else {
            this.setWorkerSize(iWorkerSize, iResetSize);
        }
        this.resetBufferSize(iBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inner_flush() throws Exception {
        if (this.STACK_OF_BUFFERED_OBJECT.size() == 0) {
            return;
        }
        this.log("FLUSH REMAIN IN BUFFER");
        while (this.BUFFER_IS_MODIFIED && (this.STACK_OF_BUFFERED_OBJECT.size() > 0 || this.STACK_PRIORITY_OF_BUFFERED_OBJECT.size() > 0)) {
            Object object = this.LOCK_OF_OUTPUT;
            synchronized (object) {
                try {
                    this.LOCK_OF_OUTPUT.notifyAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = this.LOCK_OF_NORMAL_INPUT;
            synchronized (object) {
                try {
                    this.LOCK_OF_NORMAL_INPUT.notifyAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = this.LOCK_OF_PRIORITY_INPUT;
            synchronized (object) {
                try {
                    this.LOCK_OF_PRIORITY_INPUT.notifyAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.BUFFER_IS_MODIFIED = false;
            try {
                Thread.currentThread();
                Thread.sleep(3000L);
            }
            catch (Exception exception) {}
        }
        this.log("FLUSH REMAIN IN BUFFER END");
    }

    public abstract void registSpool(String var1, String var2);

    @Override
    protected Bufferable create(int seq, int level) throws Exception {
        if (log.isDebugEnabled()) {
            this.log("INTO CREATE METHOD");
        }
        SmtpCommunicator worker = (SmtpCommunicator)this.AGENT_CLASS.newInstance();
        worker.setTIMEOUT_CONNECT(this.INSTANCE_TIMEOUT_CONNECT);
        worker.setTIMEOUT_INIT(this.INSTANCE_TIMEOUT_INIT);
        worker.setTIMEOUT_HELO(this.INSTANCE_TIMEOUT_HELO);
        worker.setTIMEOUT_MAILFROM(this.INSTANCE_TIMEOUT_MAILFROM);
        worker.setTIMEOUT_RCPT(this.INSTANCE_TIMEOUT_RCPT);
        worker.setTIMEOUT_DATAINIT(this.INSTANCE_TIMEOUT_DATAINIT);
        worker.setTIMEOUT_DATABLOCK(this.INSTANCE_TIMEOUT_DATABLOCK);
        worker.setTIMEOUT_RSET(this.INSTANCE_TIMEOUT_RSET);
        if (log.isDebugEnabled()) {
            this.log("CREATE INSTANCE");
        }
        ((BufferedCommunicationActor)((Object)worker)).setParameter(this, this.group, seq, this.AGENT_WORK_DELAY, this.SMTP_REST_LIMIT);
        if (log.isDebugEnabled()) {
            this.log("CREATE SUCCESS AND RETURN");
        }
        return (Bufferable)((Object)worker);
    }
}

