/*
 * Decompiled with CFR 0.152.
 */
package jupiter.auto.send.task;

import java.util.Properties;
import jupiter.common.actor.ListMaker;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.common.task.SmsAbstractNoDBMailSendTask;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import mercury.contents.common.producer.ContentPD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsStatement;
import pluto.mail.MailSendingInstanceFactory;
import pluto.reporter.Reporter;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import venus.spool.common.basic.InstanceFactory;
import venus.spool.common.task.SpoolControlTask;

public class SmsAutoTestSendTask
extends SmsAbstractNoDBMailSendTask {
    private static final Logger log = LoggerFactory.getLogger(SmsAutoTestSendTask.class);
    protected ListMaker INNER_LIST_MAKER = null;
    protected Properties MAPPING_HEADER_INFO = null;
    public int send_cnt = 0;
    protected String MAIL_ID = "";
    private static String QUERY_LIST_UPDATE_TEST_SCHEDULE = null;

    @Override
    public void setTaskProperty(Properties prop) {
        this.TASK_PROPERTY = prop;
        this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
        this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty("CHANNEL_TYPE");
        this.setTaskID(this.POST_ID);
        this.MAIL_ID = this.TASK_PROPERTY.getProperty("MAIL_ID", "NO ID");
        this.setName("[" + this.MAIL_ID + "] " + this.POST_ID + "_TestSendTask");
        this.WORK_FILE_ID = this.POST_ID.concat("_test_").concat(Cal.getSerialDate());
    }

    @Override
    public void execute_initiate() throws Exception {
    }

    @Override
    protected void execute_ContentLoad() throws Exception {
        ContentPD contentPd = (ContentPD)MailSendingInstanceFactory.getInstance(this.TASK_PROPERTY, (short)5);
        contentPd.process(this.TASK_PROPERTY);
        ContentInfo contentInfo = contentPd.getContentInfo();
        ContentInfoManager.putContentInfo(contentInfo, false);
        ContentInfoManager.registContentInfo(contentInfo);
    }

    @Override
    protected void execute_ListMake() throws Exception {
        this.INNER_LIST_MAKER = (ListMaker)MailSendingInstanceFactory.getInstance(this.TASK_PROPERTY, (short)6);
        this.INNER_LIST_MAKER.process(this.TASK_PROPERTY);
        if (this.MAPPING_HEADER_INFO == null) {
            this.MAPPING_HEADER_INFO = new Properties();
        }
        this.MAPPING_HEADER_INFO.setProperty(this.INNER_LIST_MAKER.getID(), this.INNER_LIST_MAKER.getMAPPING_HEADER());
    }

    @Override
    protected void execute_ListLoad() throws Exception {
        SpoolControlTask targetTask = (SpoolControlTask)InstanceFactory.getInstance(this.TASK_PROPERTY, (short)7);
        this.TASK_PROPERTY.setProperty("TARGET_LIST_FILE", (String)this.INNER_LIST_MAKER.getTargetList());
        targetTask.setTaskProperty(this.TASK_PROPERTY);
        targetTask.setMAPPING_HEADER_INFO(this.MAPPING_HEADER_INFO);
        targetTask.internal_execute();
        this.mailSpoolInfo = targetTask.getSpoolInfo();
    }

    @Override
    public void execute_initiateError(Throwable thw) {
    }

    @Override
    protected void execute_Startup() throws Exception {
        this.update_test_status("30", "--");
    }

    @Override
    protected void execute_SendStartUpdate() throws Exception {
    }

    @Override
    protected void execute_Finish() throws Exception {
        this.update_test_status("40", "30");
    }

    protected void update_test_status(String status, String now_status) throws Exception {
        this.TASK_PROPERTY.setProperty("JOB_STATUS", status);
        this.TASK_PROPERTY.setProperty("UPDATE_JOB_STATUS", status);
        this.TASK_PROPERTY.setProperty("JOB_STATUS_NOW", now_status);
        eMsConnection conn = null;
        eMsStatement stmt = null;
        try {
            conn = ConnectionPool.getConnection();
            stmt = conn.createStatement();
            StringBuffer buffer = new StringBuffer();
            StringConvertUtil.ConvertString(buffer, QUERY_LIST_UPDATE_TEST_SCHEDULE, this.TASK_PROPERTY, "${", "}", true, false);
            stmt.executeUpdate(buffer.toString());
        }
        catch (Exception e) {
            log.error("update test status", (Throwable)e);
            throw new Exception(this.getName() + e);
        }
        finally {
            if (conn != null) {
                conn.recycleStatement(stmt);
                conn.recycle();
            }
        }
    }

    @Override
    protected boolean execute_StopCheck() {
        return false;
    }

    public String getDecryptMsgTo(String enMsgTo) throws Exception {
        return enMsgTo;
    }

    @Override
    protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
        return BufferedAgentPool.getBufferedObjectPool("single", domain);
    }

    @Override
    public void doErrorProcess(Throwable thw) {
        log.error(this.getName(), thw);
        try {
            this.update_test_status("41", "30");
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        Reporter.report(this.getName(), this.getName(), "mailsendtask.exec.err", thw);
    }

    @Override
    public void release_Resource() {
    }

    @Override
    protected void passDomainNotFound(String spool, Throwable ex) throws Exception {
        log.error("TEST SPOOL DOMAIN INVALID", (Object)spool.concat("=>").concat(ex.toString()));
    }

    @Override
    protected void processSyntaxErrorSpool(String spool) throws Exception {
        log.error("TEST SPOOL SYNTAX ERROR", (Object)spool);
    }

    @Override
    protected void passRejectDomain(String spool) throws Exception {
        log.error("TEST SPOOL DOMAIN REJECTED", (Object)spool);
    }

    static {
        try {
            QUERY_LIST_UPDATE_TEST_SCHEDULE = SqlManager.getQuery("MAIN_SCHEDULE_CHECK", "QUERY_LIST_UPDATE_WF_TEST_SCHEDULE");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

