/*
 * Decompiled with CFR 0.152.
 */
package jupiter.auto.send.task;

import java.util.Properties;
import jupiter.auto.send.task.AutoBaseSendTask;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.mass.send.basic.SendStopException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.panopticon.filter.RejectFilter;
import pluto.util.Cal;
import pluto.util.convert.StringConvert;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.popper.Popper;

public class SmsAutoBaseSendTask
extends AutoBaseSendTask {
    private static final Logger log = LoggerFactory.getLogger(SmsAutoBaseSendTask.class);
    private static String QUERY_CHECK_SMS_TYPE = null;
    protected Properties MAPPING_HEADER_INFO = null;

    @Override
    public void setTaskProperty(Properties prop) {
        this.TASK_PROPERTY = prop;
        this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
        this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty("CHANNEL_TYPE");
        this.LIST_TABLE = this.TASK_PROPERTY.getProperty("LIST_TABLE");
        this.WORK_FILE_ID = this.POST_ID.concat("_real_one_").concat(Cal.getSerialDate());
        this.setTaskID(this.POST_ID);
        this.setName(this.POST_ID + "_SmsAutoBaseSendTask");
        this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
        this.INSTANCE_QUERY_CHECK_STOP_FLAG = QUERY_CHECK_STOP_FLAG;
    }

    @Override
    protected synchronized void execute_ListSend() throws Exception {
        int budget;
        boolean flagBudget;
        if (this.mailSpoolInfo != null) {
            this.SPOOL_POPPER = Popper.getInstance();
            if (this.mailSpoolInfo.getSpoolFilesInfo().isEmpty()) {
                log.info(this.getName(), (Object)"No Real Data.... So Skip");
                return;
            }
            try {
                this.SPOOL_POPPER.setTaskProp(this.TASK_PROPERTY);
                this.SPOOL_POPPER.init(this.SPOOL_DIRECTORY, this.mailSpoolInfo.getSpoolFilesInfo());
            }
            catch (Exception ex) {
                log.error("spool poper error", (Throwable)ex);
            }
        } else {
            log.debug("SMS SPOOL INFO IS NULL SO SKIP..");
            return;
        }
        if (this.SPOOL_POPPER == null) {
            log.error(this.getName(), (Object)"No Real Data.... So Skip");
            return;
        }
        if (this.execute_StopCheck()) {
            throw new SendStopException(this.getName() + " receive stop signal");
        }
        RejectFilter instanceRejectFilter = RejectFilter.getFilterInstance(this.TASK_PROPERTY);
        String nextSpool = null;
        String domain = null;
        int spoolPatchCount = 0;
        BufferedAgentPool pool = null;
        String phoneStr = null;
        String phoneEn = null;
        String ori_Spool = null;
        StringBuffer strBuffer = new StringBuffer(1024);
        domain = this.TASK_PROPERTY.getProperty("SMS_TYPE").toLowerCase();
        if ("".equals(domain)) {
            domain = this.getSmstype();
        }
        if (("SMS".equalsIgnoreCase(this.TASK_PROPERTY.getProperty("SMS_TYPE")) || "LMS".equalsIgnoreCase(this.TASK_PROPERTY.getProperty("SMS_TYPE"))) && this.TASK_PROPERTY.getProperty("DONGBO_YN", "N").equals("Y")) {
            domain = domain + "d";
        }
        boolean bl = flagBudget = (budget = Integer.parseInt(this.TASK_PROPERTY.getProperty("BUDGET", "0"))) > 0;
        while ((nextSpool = (String)this.SPOOL_POPPER.next()) != null) {
            if (nextSpool == null || nextSpool.length() < 1) continue;
            if (spoolPatchCount++ % this.instance_STOP_CHECK_RECYCLE == 0 && this.execute_StopCheck()) {
                throw new SendStopException(this.getName() + " receive stop signal");
            }
            if (flagBudget && spoolPatchCount > budget) {
                log.error("POST_ID : " + this.TASK_PROPERTY.getProperty("POST_ID") + " / TOTAL CAMPAIGN SMS budget : " + budget + " / spoolPatchCount : " + spoolPatchCount);
                break;
            }
            try {
                ori_Spool = nextSpool;
                if ("Y".equals(ENC_YN)) {
                    phoneEn = this.getSecureSms(nextSpool);
                    phoneStr = !"PU".equals(this.TASK_PROPERTY.getProperty("CHANNEL_TYPE")) ? this.getDecryptSms(phoneEn) : phoneEn;
                    strBuffer.setLength(0);
                    strBuffer.append(phoneEn).append("<TMS_DECRYPT>").append(phoneStr).append(nextSpool.substring(phoneEn.length())).toString();
                    nextSpool = strBuffer.toString();
                }
                if (domain == null) {
                    this.processSyntaxErrorSpool(nextSpool);
                    continue;
                }
                if (instanceRejectFilter != null) {
                    this.SPOOL_ANALYZER.parse(nextSpool);
                    if (instanceRejectFilter.isFiltered(this.SPOOL_ANALYZER)) continue;
                    nextSpool = this.SPOOL_ANALYZER.composeSingleRcptSend();
                }
                pool = this.getBufferedObjectPool(domain);
                log.debug("registSpool... domain: {} spool: {}", (Object)domain, (Object)nextSpool);
                pool.registSpool(domain, nextSpool);
            }
            catch (OutOfMemoryError outError) {
                log.error(this.getName(), (Throwable)outError);
                System.gc();
                try {
                    this.wait(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    SpoolingManager.registSpool(ori_Spool);
                }
                catch (Exception exception) {
                }
            }
            catch (Throwable err) {
                log.error(this.getName(), err);
                ErrorSpoolLogger.put(nextSpool + " => send : " + err.toString());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("EXEC BufferedAgentPool.flushAll()");
        }
        BufferedAgentPool.flushAll();
        if (log.isDebugEnabled()) {
            log.debug("EXEC execute_ListSend [OK]");
        }
    }

    private String getSmstype() throws Exception {
        eMsConnection emsConnection = null;
        try {
            emsConnection = ConnectionPool.getConnection();
            StringBuffer buffer = new StringBuffer(256);
            StringConvert.ConvertStringUseMap(buffer, QUERY_CHECK_SMS_TYPE, this.TASK_PROPERTY, "${", "}", false, true);
            Properties m = new Properties();
            emsConnection.putSingleResultToMap(buffer.toString(), m);
            String string = m.getProperty("SMS_TYPE");
            return string;
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            throw new Exception(e);
        }
        finally {
            if (emsConnection != null) {
                emsConnection.recycle();
            }
        }
    }

    static {
        try {
            QUERY_CHECK_SMS_TYPE = SqlManager.getQuery("COMMON", "QUERY_CHECK_SMS_TYPE");
        }
        catch (Exception e) {
            log.error("query init error", (Throwable)e);
            System.exit(1);
        }
    }
}

