/*
 * Decompiled with CFR 0.152.
 */
package jupiter.auto.send.task;

import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.reporter.Reporter;
import pluto.schedule.Task;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;

public class ScheduleCreateTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(ScheduleCreateTask.class);
    protected static List QUERY_SELECT_TARGET_MAIL = null;
    public static String QUERY_CHECK_CURRENT_SCHEDULE = null;
    protected static List QUERY_SELECT_INSERT_SCHEDULE_INFO = null;
    protected static List QUERY_INSERT_SCHEDULE_INFO = null;
    protected static Properties DATE_INFORMATION = null;
    protected eMsConnection EMS_CONNECTION = null;
    protected eMsStatement SELECT_STATEMENT = null;
    protected eMsStatement UPDATE_STATEMENT = null;
    protected String MAIL_ID = "";

    public ScheduleCreateTask() {
        super((short)2, 1L);
        this.setName("ScheduleCreateTask");
        this.setTaskID("ScheduleCreateTask");
    }

    @Override
    public void execute_initiate() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(this.getName() + " START");
        }
        this.EMS_CONNECTION = ConnectionPool.getConnection();
        this.SELECT_STATEMENT = this.EMS_CONNECTION.createStatement();
        this.UPDATE_STATEMENT = this.EMS_CONNECTION.createStatement();
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error(this.getName(), thw);
        if (!(thw instanceof SQLException)) {
            Reporter.report("[" + (this.MAIL_ID.equals("") ? "NO ID" : this.MAIL_ID) + "]", this.getName(), "mailsendtask.init.err", thw);
        }
    }

    @Override
    public void doErrorProcess(Throwable thw) {
        log.error(this.getName(), thw);
        Reporter.report("[" + (this.MAIL_ID.equals("") ? "NO ID" : this.MAIL_ID) + "]", this.getName(), "mailsendtask.init.err", thw);
    }

    @Override
    public void release_Resource() {
        if (log.isDebugEnabled()) {
            log.debug(this.getName() + " END");
        }
        if (this.EMS_CONNECTION != null) {
            this.EMS_CONNECTION.recycleStatement(this.UPDATE_STATEMENT);
            this.EMS_CONNECTION.recycleStatement(this.SELECT_STATEMENT);
            this.EMS_CONNECTION.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("{} is execute execute_CheckWork Method...", (Object)this.getName());
        }
        eMsResultSet RS_SELECTED_SCHEDULE_INFO = null;
        DATE_INFORMATION.setProperty("YEAR", Cal.getYear());
        DATE_INFORMATION.setProperty("YYYY", Cal.getYear());
        DATE_INFORMATION.setProperty("MONTH", Cal.getMonth());
        DATE_INFORMATION.setProperty("MM", Cal.getMonth());
        DATE_INFORMATION.setProperty("DAY", Cal.getDay());
        DATE_INFORMATION.setProperty("DD", Cal.getDay());
        DATE_INFORMATION.setProperty("HOUR", Cal.getHour());
        DATE_INFORMATION.setProperty("HH", Cal.getHour());
        DATE_INFORMATION.setProperty("MIN", Cal.getMin());
        DATE_INFORMATION.setProperty("MI", Cal.getMin());
        DATE_INFORMATION.setProperty("WEEK", Cal.getWeekDay());
        DATE_INFORMATION.setProperty("YYYYMMDD", Cal.getDayDate());
        Properties TMP_INFORMATION = new Properties(DATE_INFORMATION);
        StringBuffer buffer = new StringBuffer(256);
        for (String __EXEC_QUERY__ : QUERY_SELECT_TARGET_MAIL) {
            if (__EXEC_QUERY__.trim().length() < 7) continue;
            try {
                buffer.setLength(0);
                StringConvertUtil.ConvertString(buffer, __EXEC_QUERY__.trim(), TMP_INFORMATION, "${", "}", false, false);
                if (log.isDebugEnabled()) {
                    log.debug("exec=>" + buffer.toString());
                }
                RS_SELECTED_SCHEDULE_INFO = this.SELECT_STATEMENT.executeQuery(buffer.toString());
                while (RS_SELECTED_SCHEDULE_INFO.next()) {
                    RS_SELECTED_SCHEDULE_INFO.putToMap(TMP_INFORMATION, false);
                    this.MAIL_ID = TMP_INFORMATION.getProperty("MAIL_ID", "NO ID");
                    this.insert_work(this.UPDATE_STATEMENT, TMP_INFORMATION);
                }
            }
            catch (Exception e) {
                log.error(this.getName(), (Throwable)e);
                Reporter.report("[" + this.MAIL_ID + "] ", this.getName(), "mailsendtask.init.err", e);
            }
            finally {
                try {
                    if (RS_SELECTED_SCHEDULE_INFO == null) continue;
                    RS_SELECTED_SCHEDULE_INFO.close();
                }
                catch (Exception exception) {}
            }
        }
        log.debug(" is execute execute_CheckWork Method...[OK]");
    }

    protected synchronized void insert_work(eMsStatement __EMS_EXEC_STATEMENT__, Properties __INSERT_INFO__) throws Exception {
        eMsResultSet CHECK_RS = null;
        StringBuffer buffer = new StringBuffer(256);
        try {
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, QUERY_CHECK_CURRENT_SCHEDULE, __INSERT_INFO__, "${", "}", false, false);
            if (log.isDebugEnabled()) {
                log.debug("check=>" + buffer.toString());
            }
            if ((CHECK_RS = __EMS_EXEC_STATEMENT__.executeQuery(buffer.toString())).next()) {
                return;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                CHECK_RS.close();
            }
            catch (Exception exception) {}
        }
        eMsResultSet __TMP_RESULT__ = null;
        try {
            for (String __EXEC_QUERY__ : QUERY_SELECT_INSERT_SCHEDULE_INFO) {
                buffer.setLength(0);
                StringConvertUtil.ConvertString(buffer, __EXEC_QUERY__, __INSERT_INFO__, "${", "}", false, false);
                __TMP_RESULT__ = __EMS_EXEC_STATEMENT__.executeQuery(buffer.toString());
                if (!__TMP_RESULT__.next()) {
                    log.error(this.getName(), (Object)"POOR SCHEDULE CREATE INFO");
                    return;
                }
                __TMP_RESULT__.putToMap(__INSERT_INFO__, false);
                try {
                    __TMP_RESULT__.close();
                }
                catch (Exception exception) {}
            }
            if (log.isDebugEnabled()) {
                log.debug("prop", (Object)__INSERT_INFO__.toString());
            }
            if (StringUtil.isNull(__INSERT_INFO__.getProperty("V_SEQNO"))) {
                __INSERT_INFO__.setProperty("V_SEQNO", "1");
            }
            for (String __EXEC_QUERY__ : QUERY_INSERT_SCHEDULE_INFO) {
                buffer.setLength(0);
                StringConvertUtil.ConvertString(buffer, __EXEC_QUERY__, __INSERT_INFO__, "${", "}", false, false);
                __EMS_EXEC_STATEMENT__.executeUpdate(buffer.toString());
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (__TMP_RESULT__ != null) {
                    __TMP_RESULT__.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    static {
        try {
            QUERY_SELECT_TARGET_MAIL = SqlManager.getMultiQuery("COMMON", "QUERY_SELECT_TARGET_MAIL");
            QUERY_CHECK_CURRENT_SCHEDULE = SqlManager.getQuery("COMMON", "QUERY_CHECK_CURRENT_SCHEDULE");
            QUERY_SELECT_INSERT_SCHEDULE_INFO = SqlManager.getMultiQuery("COMMON", "QUERY_SELECT_INSERT_SCHEDULE_INFO");
            QUERY_INSERT_SCHEDULE_INFO = SqlManager.getMultiQuery("COMMON", "QUERY_INSERT_SCHEDULE_INFO");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
        DATE_INFORMATION = new Properties();
    }
}

