/*
 * Decompiled with CFR 0.152.
 */
package jupiter.auto.send.task;

import java.util.Properties;
import jupiter.auto.send.task.RealTimeSendTask;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.mass.send.basic.SendStopException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.panopticon.filter.RejectFilter;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.popper.Popper;

public class SMSRealTimeSendTask
extends RealTimeSendTask {
    private static final Logger log = LoggerFactory.getLogger(SMSRealTimeSendTask.class);

    @Override
    public void setTaskProperty(Properties sendInfo) {
        this.TASK_PROPERTY = sendInfo;
        LIST_MAKER_CLASS_NAME = this.TASK_PROPERTY.getProperty("LIST_MAKER", "");
        String task_seq = String.valueOf(System.nanoTime());
        String msg_type = this.TASK_PROPERTY.getProperty("MSG_TYPE");
        String msg_type_seq = this.TASK_PROPERTY.getProperty("MSG_TYPE_SEQ");
        this.setName("SmsRealTimeSendTask_" + msg_type + "_" + msg_type_seq + "_" + task_seq);
        this.setTaskID("SmsRealTimeSendTask_" + msg_type + "_" + msg_type_seq);
    }

    @Override
    protected synchronized void execute_ListSend() throws Exception {
        this.update_thread_status("E0");
        if (this.spoolInfoList == null || this.spoolInfoList.isEmpty()) {
            log.debug("{} Loading get spoolInfoList is empty", (Object)this.getTaskID());
        } else {
            log.info("{} Loading get spoolInfoList is {}", (Object)this.getTaskID(), (Object)this.spoolInfoList.toString());
        }
        for (SpoolInfo this.mailSpoolInfo : this.spoolInfoList) {
            if (this.mailSpoolInfo != null) {
                this.SPOOL_POPPER = Popper.getInstance();
                if (this.mailSpoolInfo.getSpoolFilesInfo().isEmpty()) {
                    log.debug("No Real Data.... So Skip");
                    return;
                }
                try {
                    this.SPOOL_POPPER.init(this.SPOOL_DIRECTORY, this.mailSpoolInfo.getSpoolFilesInfo());
                }
                catch (Exception ex) {
                    log.error(ex.getMessage());
                }
            } else {
                log.debug("SMS SPOOL INFO IS NULL SO SKIP..");
                return;
            }
            if (this.SPOOL_POPPER == null) {
                log.error("No Real Data.... So Skip");
                return;
            }
            if (this.execute_StopCheck()) {
                throw new SendStopException(this.getName() + " receive stop signal");
            }
            RejectFilter instanceRejectFilter = RejectFilter.getFilterInstance(this.TASK_PROPERTY);
            String nextSpool = null;
            int spoolPatchCount = 0;
            BufferedAgentPool pool = null;
            String smsStr = null;
            String smsEn = null;
            String ori_Spool = null;
            String domain = this.TASK_PROPERTY.getProperty("SMS_TYPE").toLowerCase();
            StringBuilder strBuffer = new StringBuilder(1024);
            while ((nextSpool = (String)this.SPOOL_POPPER.next()) != null) {
                if (nextSpool == null || nextSpool.length() < 1) continue;
                if (spoolPatchCount++ % this.instance_STOP_CHECK_RECYCLE == 0 && this.execute_StopCheck()) {
                    throw new SendStopException(this.getName() + " receive stop signal");
                }
                try {
                    ori_Spool = nextSpool;
                    if ("Y".equals(ENC_YN)) {
                        smsEn = this.getSecureSms(nextSpool);
                        smsStr = this.getDecryptSms(smsEn);
                        strBuffer.setLength(0);
                        nextSpool = strBuffer.append(smsEn).append("<TMS_DECRYPT>").append(smsStr).append(nextSpool.substring(smsEn.length())).toString();
                    } else {
                        smsStr = this.getSecureSms(nextSpool);
                    }
                    if (domain == null) {
                        this.processSyntaxErrorSpool(nextSpool);
                        continue;
                    }
                    if (instanceRejectFilter != null) {
                        this.SPOOL_ANALYZER.parse(nextSpool);
                        if (instanceRejectFilter.isFiltered(this.SPOOL_ANALYZER)) continue;
                        nextSpool = this.SPOOL_ANALYZER.composeSingleRcptSend();
                    }
                    pool = this.getBufferedObjectPool(domain);
                    pool.registSpool(domain, nextSpool);
                }
                catch (OutOfMemoryError outError) {
                    log.error("OOM error", (Throwable)outError);
                    System.gc();
                    try {
                        this.wait(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        SpoolingManager.registSpool(ori_Spool);
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Throwable err) {
                    log.error("error", err);
                    ErrorSpoolLogger.put(nextSpool + " => send : " + err.toString());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("EXEC BufferedAgentPool.flushAll()");
            }
            BufferedAgentPool.flushAll();
            if (log.isDebugEnabled()) {
                log.debug("EXEC execute_ListSend [OK]");
            }
            try {
                this.wait(100L);
            }
            catch (Exception exception) {}
        }
        BufferedAgentPool.flushAll();
    }

    public String pickupMsgType(String spool) throws Exception {
        if (spool == null) {
            return null;
        }
        int idx1 = spool.lastIndexOf("|");
        if (idx1 < 0) {
            return null;
        }
        String msgType = spool.substring(idx1 + 1, spool.length());
        msgType = "SMS".equals(msgType) ? "SMS" : ("LMS".equals(msgType) ? "LMS" : ("MMS".equals(msgType) ? "MMS" : "SMS"));
        return msgType;
    }
}

