/*
 * Decompiled with CFR 0.152.
 */
package jupiter.auto.send.task;

import com.humuson.tms.common.util.FatigueListTableNameUtil;
import com.humuson.tms.constrants.StatusType;
import java.util.Properties;
import jupiter.auto.send.task.SmsCampListMakeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.lang.eMsLocale;
import pluto.util.StringConvertUtil;

public class FatigueFilterSmsCampListMakeTask
extends SmsCampListMakeTask {
    private static final Logger log = LoggerFactory.getLogger(FatigueFilterSmsCampListMakeTask.class);
    protected static String QUERY_SELECT_FILTER_USEYN = null;
    protected static String QUERY_CHECK_SEND_CNT_UPDATE_AVAILABLE = null;
    protected static String QUERY_SEND_CNT_UPDATE = null;
    private static String ORACLE = "ORACLE";
    private static String ORACLE_REPLACE_HINT = "##ORACLE_REPLACE_HINT##";

    @Override
    public void execute_initiate() throws Exception {
        super.execute_initiate();
    }

    @Override
    protected boolean isPossibleProcessing() {
        this.updateTaskState("41", "10");
        return super.isPossibleProcessing();
    }

    @Override
    protected void execute_Startup() throws Exception {
    }

    protected boolean isUseFatigueFilter(Properties TARGET_PROPERTIES) throws Exception {
        boolean useFilter = false;
        eMsStatement __SELECT_STATEMENT__ = null;
        eMsConnection emsConnection = null;
        eMsResultSet rs = null;
        Object ex = null;
        try {
            emsConnection = ConnectionPool.getConnection();
            __SELECT_STATEMENT__ = emsConnection.createStatement();
            this.TMP_STRING_BUFFER.setLength(0);
            StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_SELECT_FILTER_USEYN, TARGET_PROPERTIES, "${", "}", true, false);
            rs = __SELECT_STATEMENT__.executeQuery(this.TMP_STRING_BUFFER.toString());
            if (rs.next()) {
                useFilter = rs.getString("FATIGUE_USE_YN").equals("Y");
            }
        }
        catch (Exception e) {
            log.error(e.toString());
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            if (emsConnection != null) {
                emsConnection.recycleStatement(__SELECT_STATEMENT__);
                emsConnection.recycle();
            }
        }
        return useFilter;
    }

    protected int insertFatigueListSentCnt(Properties TARGET_PROPERTIES) throws Exception {
        int successCnt = 0;
        eMsStatement __UPDATE_STATEMENT__ = null;
        eMsConnection emsConnection = null;
        Object ex = null;
        boolean isFail = false;
        try {
            emsConnection = ConnectionPool.getConnection();
            __UPDATE_STATEMENT__ = emsConnection.createStatement();
            TARGET_PROPERTIES.setProperty("FATIGUE_TABLE", FatigueListTableNameUtil.getFatigueListTableName((String)this.CHANNEL_TYPE));
            this.TMP_STRING_BUFFER.setLength(0);
            StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_SEND_CNT_UPDATE, TARGET_PROPERTIES, "${", "}", true, false);
            String query = this.TMP_STRING_BUFFER.toString();
            if (ORACLE.equalsIgnoreCase(eMsLocale.DB_TYPE)) {
                String pkHint = TARGET_PROPERTIES.getProperty("LIST_TABLE").replace("TMS", "PK");
                query = query.replace(ORACLE_REPLACE_HINT, pkHint);
            }
            successCnt = __UPDATE_STATEMENT__.executeUpdate(query);
        }
        catch (Exception e) {
            isFail = true;
            log.error(e.toString());
            throw e;
        }
        finally {
            if (isFail) {
                this.updateTaskState("41", StatusType.ERROR.getCode());
            }
            if (emsConnection != null) {
                emsConnection.recycleStatement(__UPDATE_STATEMENT__);
                emsConnection.recycle();
            }
        }
        return successCnt;
    }

    static {
        try {
            QUERY_SELECT_FILTER_USEYN = SqlManager.getQuery("FILTER_INFO", "QUERY_SELECT_FILTER_USEYN");
            QUERY_CHECK_SEND_CNT_UPDATE_AVAILABLE = SqlManager.getQuery("FILTER_INFO", "QUERY_CHECK_SEND_CNT_UPDATE_AVAILABLE");
            QUERY_SEND_CNT_UPDATE = SqlManager.getQuery("FILTER_INFO", "QUERY_SEND_CNT_UPDATE");
        }
        catch (Exception ignore) {
            log.error(ignore.getMessage());
        }
    }
}

