/*
 * Decompiled with CFR 0.152.
 */
package jupiter.auto.actor;

import java.io.IOException;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import jupiter.auto.actor.BasicListMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.lang.eMsLocale;
import pluto.log.Composer;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import pluto.util.convert.DelimConvertor;
import venus.spool.common.basic.NoTargetListException;
import venus.spool.common.parser.SpoolAnalyzer;
import venus.spool.common.parser.SpoolHashParser;
import venus.spool.common.parser.SpoolHeaderParser;

public class TestListMaker
extends BasicListMaker {
    private static final Logger log = LoggerFactory.getLogger(TestListMaker.class);
    protected String LIST_TABLE = null;
    protected String PWD = "PWD";
    protected String PWD_STR = "RmG0RhNBwJVlG5klf5pRuA==";
    private static String QUERY_SELECT_TEST_EMAIL_LIST = null;
    private static String QUERY_SELECT_TEST_CNT_MYSQL = null;
    private static String QUERY_SELECT_TEST_CNT_MSSQL = null;
    private static String QUERY_SELECT_TEST_CNT_ORACLE = null;
    protected List TEST_EMAIL_LIST = new LinkedList();

    @Override
    protected void inner_init(Properties prop) throws Exception {
        this.SCHEDULE_INFO = prop;
        this.composer = Composer.getComposerInstance();
        this.AUTO_KEY_VALUE_PARSER = new SpoolHashParser("|");
        this.POST_ID = prop.getProperty("POST_ID");
        this.LIST_TABLE = prop.getProperty("LIST_TABLE");
        this.setName(this.POST_ID + "'s TestListMaker");
        this.WORK_FILE_ID = this.POST_ID + "_test_" + System.currentTimeMillis();
        this.WORKDAY = null;
        this.SEQNO = null;
    }

    public static String readClobData(Reader reader) throws IOException {
        StringBuffer data = new StringBuffer();
        char[] buf = new char[1024];
        int cnt = 0;
        if (null != reader) {
            while ((cnt = reader.read(buf)) != -1) {
                data.append(buf, 0, cnt);
            }
        }
        return data.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSpoolData() {
        String spool_data = "";
        String lobGetQuery = "";
        String sample_id = "";
        sample_id = this.SCHEDULE_INFO.getProperty("ID");
        lobGetQuery = "SELECT SPOOL_DATA FROM EMS_AUTO_SAMPLING WHERE ID='" + sample_id + "'";
        eMsConnection con = null;
        PreparedStatement psmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionPool.getConnection();
            psmt = con.prepareStatement(lobGetQuery);
            rs = psmt.executeQuery();
        }
        catch (Exception e) {
            log.error("lobGetQuery error", (Throwable)e);
        }
        try {
            if (rs != null && rs.next()) {
                String clobData = TestListMaker.readClobData(rs.getCharacterStream("SPOOL_DATA"));
                spool_data = new String(clobData.getBytes(eMsLocale.FILE_SYSTEM_IN_CHAR_SET), eMsLocale.FILE_SYSTEM_OUT_CHAR_SET);
            }
        }
        catch (Exception e) {
            log.error("clob error", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (psmt != null) {
                try {
                    psmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                con.recycle();
            }
        }
        return spool_data;
    }

    @Override
    protected synchronized void execute_BasicInfoProcess() throws Exception {
        StringBuffer buffer = new StringBuffer(512);
        eMsConnection EMS_CONNECTION = null;
        eMsStatement SELECT_STATEMENT = null;
        eMsResultSet rs = null;
        String test_email = "";
        try {
            EMS_CONNECTION = ConnectionPool.getConnection();
            SELECT_STATEMENT = EMS_CONNECTION.createStatement();
            StringConvertUtil.ConvertString(buffer, QUERY_SELECT_TEST_EMAIL_LIST, this.SCHEDULE_INFO, "${", "}", true, false);
            rs = SELECT_STATEMENT.executeQuery(buffer.toString());
            while (rs.next()) {
                test_email = rs.getString("TEST_EMAIL");
                String[] testList = test_email.split("::");
                for (int i = 0; i < testList.length; ++i) {
                    this.TEST_EMAIL_LIST.add(testList[i]);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            if (EMS_CONNECTION != null) {
                EMS_CONNECTION.recycleStatement(SELECT_STATEMENT);
                SELECT_STATEMENT = null;
                EMS_CONNECTION.recycle();
            }
        }
        if (this.TEST_EMAIL_LIST.size() < 1) {
            throw new NoTargetListException("NO TARGET LIST => " + this.SCHEDULE_INFO.getProperty("SEND_LIST"));
        }
        this.execute_BasicInfoProcess_basic();
    }

    protected synchronized void execute_BasicInfoProcess_basic() throws Exception {
        String this_day = Cal.getDayDate();
        this.LIST_STORE_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".base";
        this.openWriter(this.LIST_STORE_FILE_NAME);
        this.NEXT_BASE_INFO_FILE_NAME = this.LIST_STORE_FILE_NAME;
        String __EXEC_TARGET_QUERY__ = null;
        eMsConnection __TARGET_CONNECTION__ = null;
        eMsStatement stmt = null;
        eMsResultSet rs = null;
        this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", "");
        ConnectInfo __TMP_CONNECTION_INFO__ = (ConnectInfo)this.VECTOR_QUERY_LIST_INFO.get(0);
        StringBuffer buffer = new StringBuffer(1024);
        boolean __APPEND_CHECK__ = false;
        try {
            __TARGET_CONNECTION__ = ConnectionPool.getConnection(__TMP_CONNECTION_INFO__);
            log.debug(".execute_BasicInfoProcess() db url :" + __TMP_CONNECTION_INFO__.getDB_URL());
            log.debug(".execute_BasicInfoProcess() db id :" + __TMP_CONNECTION_INFO__.getDB_UID());
            log.debug(".execute_BasicInfoProcess() db pwd :" + __TMP_CONNECTION_INFO__.getDB_PASS());
            stmt = __TARGET_CONNECTION__.createStatement();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, __TMP_CONNECTION_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
            __EXEC_TARGET_QUERY__ = __TMP_CONNECTION_INFO__.getDB_URL().indexOf("oracle") > 0 ? TestListMaker.setQuerySample_oracle(buffer.toString()) : (__TMP_CONNECTION_INFO__.getDB_URL().indexOf("mysql") > 0 ? TestListMaker.setQuerySample_mysql(buffer.toString()) : TestListMaker.setQuerySample_mssql(buffer.toString()));
            log.debug(".execute_BasicInfoProcess() exe test_query:" + __EXEC_TARGET_QUERY__);
            rs = stmt.executeQuery(__TARGET_CONNECTION__.encode(__EXEC_TARGET_QUERY__));
            log.debug(".execute_BasicInfoProcess() exe query:[OK]");
            String[] header_list = StringUtil.split(rs.getHeaderString(), "|");
            buffer.setLength(0);
            int pwd_index = 0;
            String temp_header = "";
            for (int i = 1; i <= header_list.length; ++i) {
                temp_header = header_list[i - 1];
                if (temp_header.equals(this.PWD)) {
                    pwd_index = i;
                }
                if (i != 1) {
                    buffer.append("|");
                }
                buffer.append(temp_header);
            }
            this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", buffer.toString());
            log.info("TARGET MAPPINGHEADER : " + this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));
            int colcount = rs.getColumnCount();
            while (rs.next()) {
                buffer.setLength(0);
                String temp = rs.getString(1);
                temp = pwd_index == 1 ? this.PWD_STR : rs.getString(1);
                DelimConvertor.encodeToBuffer(buffer, temp == null ? "" : temp.trim());
                for (int count = 2; count <= colcount; ++count) {
                    buffer.append("|");
                    temp = pwd_index == count ? this.PWD_STR : rs.getString(count);
                    DelimConvertor.encodeToBuffer(buffer, temp == null ? "" : temp.trim());
                }
                this.BUFFERED_WRITER.write(buffer.toString());
                this.BUFFERED_WRITER.newLine();
                this.BUFFERED_WRITER.flush();
                __APPEND_CHECK__ = true;
                log.debug("LINE CREATE....");
            }
            if (!__APPEND_CHECK__) {
                throw new NoTargetListException("NO TARGET LIST => " + this.POST_ID);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (__TARGET_CONNECTION__ != null) {
                    __TARGET_CONNECTION__.destroy();
                }
            }
            catch (Exception exception) {}
            try {
                this.BUFFERED_WRITER.flush();
            }
            catch (Exception exception) {}
            try {
                if (this.BUFFERED_WRITER != null) {
                    this.BUFFERED_WRITER.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected static String setQuerySample_mysql(String query) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(query);
        buffer.append(" ");
        buffer.append(QUERY_SELECT_TEST_CNT_MYSQL);
        return buffer.toString();
    }

    protected static String setQuerySample_mssql(String query) {
        String select_str = "SELECT";
        String distinct_str = "DISTINCT";
        String uQuery = query.toUpperCase();
        int point_select = uQuery.indexOf(select_str);
        int point_distinct = uQuery.indexOf(distinct_str);
        int point = 0;
        point = point_distinct >= 0 ? point_distinct + distinct_str.length() : point_select + select_str.length();
        StringBuffer buffer = new StringBuffer();
        buffer.append(query.substring(0, point));
        buffer.append(" ");
        buffer.append(QUERY_SELECT_TEST_CNT_MSSQL.trim());
        buffer.append(" ");
        buffer.append(query.substring(point));
        return buffer.toString();
    }

    protected static String setQuerySample_oracle(String query) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(query);
        buffer.append(" AND ");
        buffer.append(QUERY_SELECT_TEST_CNT_ORACLE);
        return buffer.toString();
    }

    @Override
    protected synchronized void execute_DBInsertProcess() throws Exception {
        String this_day = Cal.getDayDate();
        this.INFO_ADDED_FINAL_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".infoadd";
        if (log.isDebugEnabled()) {
            log.debug(".execute_DBInsertProcess() set spool file :" + this.INFO_ADDED_FINAL_FILE_NAME);
        }
        this.openWriter(this.INFO_ADDED_FINAL_FILE_NAME);
        if (log.isDebugEnabled()) {
            log.debug(".execute_DBInsertProcess() set source file :" + this.NEXT_BASE_INFO_FILE_NAME);
        }
        this.openReader(this.NEXT_BASE_INFO_FILE_NAME);
        this.NEXT_BASE_INFO_FILE_NAME = this.INFO_ADDED_FINAL_FILE_NAME;
        SpoolAnalyzer SPOOL_ANALYZER = SpoolAnalyzer.getSpoolAnalyzer();
        SPOOL_ANALYZER.setSendType("AUTOTEST");
        SPOOL_ANALYZER.setNextSpoolGenerate("N");
        SPOOL_ANALYZER.setLimitDate("19000000");
        SPOOL_ANALYZER.setPostID(this.POST_ID);
        SPOOL_ANALYZER.setListTable("NOTABLE");
        SPOOL_ANALYZER.setStep(0);
        Hashtable __HEADER_MAP__ = new Hashtable();
        String __TMP_READ_LINE__ = null;
        try {
            SpoolHeaderParser.parseSimple(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"), "|", __HEADER_MAP__);
            while (this.BUFFERED_READER.ready()) {
                __TMP_READ_LINE__ = this.BUFFERED_READER.readLine();
                if (log.isDebugEnabled()) {
                    log.debug(" read => " + __TMP_READ_LINE__);
                }
                if (__TMP_READ_LINE__ == null || __TMP_READ_LINE__.trim().length() < 5) continue;
                try {
                    this.AUTO_KEY_VALUE_PARSER.parseSimple(this.__TMP_SIMPLE_HASH__, __TMP_READ_LINE__, __HEADER_MAP__);
                    if (!this.__TMP_SIMPLE_HASH__.containsKey("TMS_M_ID") || !this.__TMP_SIMPLE_HASH__.containsKey("TMS_M_NAME")) continue;
                    Iterator iter = this.TEST_EMAIL_LIST.iterator();
                    while (iter.hasNext()) {
                        SPOOL_ANALYZER.setTokenID(iter.next().toString());
                        SPOOL_ANALYZER.setMemberID(((String)this.__TMP_SIMPLE_HASH__.get("TMS_M_ID")).toString().concat("_1"));
                        SPOOL_ANALYZER.setMemberName(((String)this.__TMP_SIMPLE_HASH__.get("TMS_M_NAME")).toString());
                        SPOOL_ANALYZER.setMapping(__TMP_READ_LINE__);
                        this.BUFFERED_WRITER.write(SPOOL_ANALYZER.composeSingleRcptSend());
                        log.info(" Souce==> " + SPOOL_ANALYZER.composeSingleRcptSend());
                        this.BUFFERED_WRITER.newLine();
                        this.BUFFERED_WRITER.flush();
                    }
                }
                catch (Exception e) {
                    log.error("TEST ID/NAME/EMAIL POPUP FAIL=>" + __TMP_READ_LINE__, (Throwable)e);
                }
            }
            log.info(" Souce File Read Done ");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (this.BUFFERED_READER != null) {
                    this.BUFFERED_READER.close();
                }
            }
            catch (Exception exception) {}
            try {
                this.BUFFERED_WRITER.flush();
            }
            catch (Exception exception) {}
            try {
                if (this.BUFFERED_WRITER != null) {
                    this.BUFFERED_WRITER.close();
                }
            }
            catch (Exception exception) {}
            log.info(" Exit Souce File Read Routine ");
        }
    }

    @Override
    protected synchronized void execute_FinalProcess() throws Exception {
    }

    protected synchronized String StoreLongMapping(String __WORKDAY__, String __SEQNO__, String __MEMBER_ID__, String __MAPPING__) {
        return null;
    }

    protected void execute_HeaderInfoSave() throws Exception {
    }

    @Override
    public Object getTargetList() {
        return this.NEXT_BASE_INFO_FILE_NAME;
    }

    @Override
    protected void updateTaskState(String __STATE__) throws Exception {
    }

    @Override
    protected void deleteCurrentList() throws Exception {
    }

    @Override
    public String getID() {
        return this.POST_ID == null ? null : this.POST_ID;
    }

    static {
        try {
            QUERY_SELECT_TEST_EMAIL_LIST = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_SELECT_TEST_EMAIL_LIST");
            QUERY_SELECT_TEST_CNT_MYSQL = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_SELECT_TEST_CNT_MYSQL");
            QUERY_SELECT_TEST_CNT_MSSQL = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_SELECT_TEST_CNT_MSSQL");
            QUERY_SELECT_TEST_CNT_ORACLE = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_SELECT_TEST_CNT_ORACLE");
        }
        catch (Exception e) {
            log.error("query init error", (Throwable)e);
            System.exit(1);
        }
    }
}

