/*
 * Decompiled with CFR 0.152.
 */
package jupiter.auto.actor;

import java.util.List;
import java.util.Properties;
import jupiter.auto.actor.BasicListMaker;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import mercury.contents.common.producer.ContentPD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.log.Composer;
import pluto.mail.MailSendingInstanceFactory;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import venus.spool.common.parser.SpoolHashParser;

public class RealtimeListMaker
extends BasicListMaker {
    private static final Logger log = LoggerFactory.getLogger(RealtimeListMaker.class);
    public static String QUERY_SELECT_REALTIME_LAST_SCHEDULE = null;
    public static List QUERY_SELECT_REALTIME_INSERT_SCHEDULE_INFO = null;
    public static String QUERY_INSERT_REALTIME_SCHEDULE = null;
    public static String QUERY_UPDATE_QUERY_STATUS_REALTIME = null;
    public static String QUERY_SELECT_BASE_SCHEDULE_INFO = null;
    public static String QUERY_UPDATE_REALTIME_CONTENT_CREATE = null;
    protected static String CONTENT_MAKER_CLASS_NAME;
    Object lock = new Object();

    public static void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        CONTENT_MAKER_CLASS_NAME = prop.getProperty("make.class");
    }

    @Override
    protected void inner_init(Properties prop) throws Exception {
        this.SCHEDULE_INFO = prop;
        this.composer = Composer.getComposerInstance();
        this.AUTO_KEY_VALUE_PARSER = new SpoolHashParser("|");
        this.POST_ID = this.SCHEDULE_INFO.getProperty("MSG_TYPE") + "_" + this.SCHEDULE_INFO.getProperty("MSG_TYPE_SEQ");
        this.SCHEDULE_INFO.setProperty("LUNARDAY", Cal.getLunarDate());
        this.setName(this.POST_ID + "_RealtimeListMaker");
        this.WORK_FILE_ID = this.POST_ID + "_realtime_" + Cal.getSerialDate();
        this.WORKDAY = null;
        this.SEQNO = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String MaxSeqDataSet(String map_header, String mail_type, String mail_type_seq, String channel_type) throws Exception {
        eMsConnection EMS_CONNECTION = null;
        eMsStatement __EMS_EXEC_STMT__ = null;
        eMsResultSet __SELECT_RESULT__ = null;
        Properties prop = new Properties();
        prop.setProperty("MAPPINGHEADER", map_header);
        prop.setProperty("MSG_TYPE", mail_type);
        prop.setProperty("MSG_TYPE_SEQ", mail_type_seq);
        prop.setProperty("CHANNEL_TYPE", channel_type);
        try {
            int count;
            EMS_CONNECTION = ConnectionPool.getConnection();
            __EMS_EXEC_STMT__ = EMS_CONNECTION.createStatement();
            StringBuffer buffer = new StringBuffer();
            List list = QUERY_SELECT_REALTIME_INSERT_SCHEDULE_INFO;
            synchronized (list) {
                for (String __EXEC_QUERY__ : QUERY_SELECT_REALTIME_INSERT_SCHEDULE_INFO) {
                    buffer.setLength(0);
                    StringConvertUtil.ConvertString(buffer, __EXEC_QUERY__, prop, "${", "}", true, false);
                    __SELECT_RESULT__ = __EMS_EXEC_STMT__.executeQuery(buffer.toString());
                    if (!__SELECT_RESULT__.next()) {
                        throw new RuntimeException("INFO RESULT SET SELECT FAIL");
                    }
                    __SELECT_RESULT__.putToMap(prop, false);
                    if (__SELECT_RESULT__ == null) continue;
                    __SELECT_RESULT__.close();
                }
            }
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, QUERY_INSERT_REALTIME_SCHEDULE, prop, "${", "}", true, false);
            if (log.isDebugEnabled()) {
                log.debug("REALTIME SCHEDULE CREATE QUERY", (Object)buffer.toString());
            }
            if ((count = __EMS_EXEC_STMT__.executeUpdate(buffer.toString())) < 1) {
                throw new RuntimeException("SCHEDULE INSERT FAIL");
            }
            String string = prop.getProperty("WORKDAY", "") + "_" + prop.getProperty("SEQNO", "");
            return string;
        }
        catch (Exception e) {
            log.error("Max Seq error", (Throwable)e);
            throw e;
        }
        finally {
            if (__SELECT_RESULT__ != null) {
                __SELECT_RESULT__.close();
            }
            if (__EMS_EXEC_STMT__ != null) {
                __EMS_EXEC_STMT__.close();
            }
            if (EMS_CONNECTION != null) {
                EMS_CONNECTION.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void execute_DBInsertProcess() throws Exception {
        eMsStatement __EMS_EXEC_STMT__ = null;
        eMsResultSet __SELECT_RESULT__ = null;
        StringBuffer buffer = new StringBuffer(1024);
        eMsConnection EMS_CONNECTION = null;
        String workId = Cal.getSerialDate();
        this.SCHEDULE_INFO.setProperty("WORK_ID", workId);
        try {
            EMS_CONNECTION = ConnectionPool.getConnection();
            __EMS_EXEC_STMT__ = EMS_CONNECTION.createStatement();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, QUERY_SELECT_REALTIME_LAST_SCHEDULE, this.SCHEDULE_INFO, "${", "}", true, false);
            __SELECT_RESULT__ = __EMS_EXEC_STMT__.executeQuery(buffer.toString());
            if (__SELECT_RESULT__.next()) {
                __SELECT_RESULT__.putToMap(this.SCHEDULE_INFO, false);
            } else {
                if (__SELECT_RESULT__ != null) {
                    __SELECT_RESULT__.close();
                }
                String map_header = this.SCHEDULE_INFO.getProperty("MAPPINGHEADER", "");
                String key_value = "";
                key_value = RealtimeListMaker.MaxSeqDataSet(map_header, this.SCHEDULE_INFO.getProperty("MSG_TYPE"), this.SCHEDULE_INFO.getProperty("MSG_TYPE_SEQ"), this.SCHEDULE_INFO.getProperty("CHANNEL_TYPE"));
                String[] map_info = key_value.split("\\_");
                this.SCHEDULE_INFO.setProperty("WORKDAY", map_info[0]);
                this.SCHEDULE_INFO.setProperty("SEQNO", map_info[1]);
                this.SCHEDULE_INFO.setProperty("POST_ID", map_info[0] + "_" + map_info[1]);
                buffer.setLength(0);
                Object object = this.lock;
                synchronized (object) {
                    StringConvertUtil.ConvertString(buffer, QUERY_SELECT_BASE_SCHEDULE_INFO, this.SCHEDULE_INFO, "${", "}", true, false);
                    __SELECT_RESULT__ = __EMS_EXEC_STMT__.executeQuery(buffer.toString());
                    if (!__SELECT_RESULT__.next()) {
                        throw new RuntimeException("INFO RESULT SET SELECT FAIL");
                    }
                    __SELECT_RESULT__.putToMap(this.SCHEDULE_INFO, false);
                    if (__SELECT_RESULT__ != null) {
                        __SELECT_RESULT__.close();
                    }
                }
            }
            this.WORKDAY = this.SCHEDULE_INFO.getProperty("WORKDAY");
            this.SEQNO = this.SCHEDULE_INFO.getProperty("SEQNO");
            if (log.isDebugEnabled()) {
                log.debug("REALTIME FINAL SCHEDULE_INFO", (Object)this.SCHEDULE_INFO.toString());
            }
            if (!ContentInfoManager.checkContentInfo(this.SCHEDULE_INFO.getProperty("POST_ID")) || this.SCHEDULE_INFO.getProperty("MODIFY_FLAG", "N").equals("Y")) {
                if (log.isDebugEnabled()) {
                    log.debug("CONTENT INFO MAKE PROPERTIES=>", (Object)this.SCHEDULE_INFO.toString());
                }
                ContentPD INNER_CONTENT_PD = (ContentPD)MailSendingInstanceFactory.getInstance(this.SCHEDULE_INFO, (short)5);
                INNER_CONTENT_PD.process(this.SCHEDULE_INFO);
                ContentInfo __CONTENT_INFO__ = INNER_CONTENT_PD.getContentInfo();
                ContentInfoManager.registContentInfo(__CONTENT_INFO__);
                buffer.setLength(0);
                StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_REALTIME_CONTENT_CREATE, this.SCHEDULE_INFO, "${", "}", true, false);
            }
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            throw e;
        }
        finally {
            if (EMS_CONNECTION != null) {
                EMS_CONNECTION.recycleStatement(__EMS_EXEC_STMT__);
                EMS_CONNECTION.recycle();
            }
        }
        super.execute_DBInsertProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateQueryStatus(String querySeq, String queryType) {
        if (log.isDebugEnabled()) {
            log.debug("updateQueryStatus =>" + this.SCHEDULE_INFO.toString());
        }
        eMsConnection EMS_CONNECTION = null;
        eMsStatement __EMS_EXEC_STATEMENT__ = null;
        StringBuffer buffer = new StringBuffer(512);
        Properties prop = new Properties();
        try {
            prop.setProperty("MSG_TYPE", this.SCHEDULE_INFO.getProperty("MSG_TYPE", ""));
            prop.setProperty("MSG_TYPE_SEQ", this.SCHEDULE_INFO.getProperty("MSG_TYPE_SEQ", ""));
            prop.setProperty("QUERY_SEQ", querySeq);
            prop.setProperty("QUERY_TYPE", queryType);
            EMS_CONNECTION = ConnectionPool.getConnection();
            __EMS_EXEC_STATEMENT__ = EMS_CONNECTION.createStatement();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_QUERY_STATUS_REALTIME, prop, "${", "}", true, false);
            if (log.isDebugEnabled()) {
                log.debug("QUERY_STATUS =>" + buffer.toString());
            }
            if (EMS_CONNECTION != null) {
                EMS_CONNECTION.recycleStatement(__EMS_EXEC_STATEMENT__);
                EMS_CONNECTION.recycle();
            }
        }
        catch (Exception ignore) {
            log.error(this.getName(), (Object)"SKIP.....");
        }
        finally {
            if (EMS_CONNECTION != null) {
                EMS_CONNECTION.recycleStatement(__EMS_EXEC_STATEMENT__);
                EMS_CONNECTION.recycle();
            }
        }
    }

    @Override
    protected void updateTaskState(String __STATE__) throws Exception {
    }

    @Override
    protected void deleteCurrentList() throws Exception {
    }

    static {
        try {
            QUERY_SELECT_REALTIME_LAST_SCHEDULE = SqlManager.getQuery("COMMON", "QUERY_SELECT_REALTIME_LAST_SCHEDULE");
            QUERY_SELECT_REALTIME_INSERT_SCHEDULE_INFO = SqlManager.getMultiQuery("COMMON", "QUERY_SELECT_REALTIME_INSERT_SCHEDULE_INFO");
            QUERY_INSERT_REALTIME_SCHEDULE = SqlManager.getQuery("COMMON", "QUERY_INSERT_REALTIME_SCHEDULE");
            QUERY_UPDATE_QUERY_STATUS_REALTIME = SqlManager.getQuery("COMMON", "QUERY_UPDATE_QUERY_STATUS_REALTIME");
            QUERY_SELECT_BASE_SCHEDULE_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_BASE_SCHEDULE_INFO");
            QUERY_UPDATE_REALTIME_CONTENT_CREATE = SqlManager.getQuery("COMMON", "QUERY_UPDATE_REALTIME_CONTENT_CREATE");
        }
        catch (Exception e) {
            log.error("query init error", (Throwable)e);
            System.exit(1);
        }
        CONTENT_MAKER_CLASS_NAME = null;
    }
}

