/*
 * Decompiled with CFR 0.152.
 */
package jupiter.auto.actor;

import java.io.IOException;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import jupiter.auto.actor.BasicListMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.lang.eMsLocale;
import pluto.log.Composer;
import pluto.util.Cal;
import pluto.util.StringUtil;
import pluto.util.convert.DelimConvertor;
import venus.spool.common.basic.NoTargetListException;
import venus.spool.common.parser.SpoolAnalyzer;
import venus.spool.common.parser.SpoolHashParser;
import venus.spool.common.parser.SpoolHeaderParser;

public class AutoTestListMaker
extends BasicListMaker {
    private static final Logger log = LoggerFactory.getLogger(AutoTestListMaker.class);
    protected String LIST_TABLE = null;
    protected String PA = "PWD";
    protected String PWD_STR = "1111111";
    protected List<String> TEST_MSG_LIST = new LinkedList<String>();

    @Override
    protected void inner_init(Properties prop) throws Exception {
        this.SCHEDULE_INFO = prop;
        this.composer = Composer.getComposerInstance();
        this.AUTO_KEY_VALUE_PARSER = new SpoolHashParser("|");
        this.POST_ID = prop.getProperty("POST_ID");
        this.LIST_TABLE = prop.getProperty("LIST_TABLE");
        this.setName(this.POST_ID + "'s TestListMaker");
        this.WORK_FILE_ID = this.POST_ID + "_test_" + System.currentTimeMillis();
        this.WORKDAY = null;
        this.SEQNO = null;
    }

    public static String readClobData(Reader reader) throws IOException {
        StringBuffer data = new StringBuffer();
        char[] buf = new char[1024];
        int cnt = 0;
        if (null != reader) {
            while ((cnt = reader.read(buf)) != -1) {
                data.append(buf, 0, cnt);
            }
        }
        return data.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSpoolData() {
        String spool_data = "";
        String lobGetQuery = "";
        String sample_id = "";
        sample_id = this.SCHEDULE_INFO.getProperty("ID");
        lobGetQuery = "SELECT SPOOL_DATA FROM EMS_AUTO_SAMPLING WHERE ID='" + sample_id + "'";
        eMsConnection con = null;
        try {
            con = ConnectionPool.getConnection();
        }
        catch (Exception e1) {
            log.error("connection error", (Throwable)e1);
        }
        PreparedStatement psmt = null;
        ResultSet rs = null;
        try {
            if (con != null && (rs = (psmt = con.prepareStatement(lobGetQuery)).executeQuery()).next()) {
                String clobData = AutoTestListMaker.readClobData(rs.getCharacterStream("SPOOL_DATA"));
                spool_data = new String(clobData.getBytes(eMsLocale.FILE_SYSTEM_IN_CHAR_SET), eMsLocale.FILE_SYSTEM_OUT_CHAR_SET);
            }
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (psmt != null) {
                try {
                    psmt.close();
                }
                catch (Exception exception) {}
            }
            if (con != null) {
                con.recycle();
            }
        }
        return spool_data;
    }

    @Override
    protected synchronized void execute_BasicInfoProcess() throws Exception {
        String testMsgTo = this.SCHEDULE_INFO.getProperty("SEND_LIST");
        String[] testList = testMsgTo.split(":");
        for (int i = 0; i < testList.length; ++i) {
            this.TEST_MSG_LIST.add(testList[i]);
        }
        if (!this.TEST_MSG_LIST.isEmpty()) {
            throw new NoTargetListException("NO TARGET LIST => " + this.SCHEDULE_INFO.getProperty("SEND_LIST"));
        }
        this.execute_BasicInfoProcess_basic();
    }

    protected synchronized void execute_BasicInfoProcess_basic() throws Exception {
        String today = Cal.getDayDate();
        this.LIST_STORE_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, today) + "/" + this.WORK_FILE_ID + ".base";
        this.openWriter(this.LIST_STORE_FILE_NAME);
        this.NEXT_BASE_INFO_FILE_NAME = this.LIST_STORE_FILE_NAME;
        String targetQuery = null;
        eMsConnection targetCon = null;
        eMsStatement stmt = null;
        eMsResultSet rs = null;
        this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", "");
        ConnectInfo tmpConnectionInfo = (ConnectInfo)this.VECTOR_QUERY_LIST_INFO.get(0);
        StringBuffer buffer = new StringBuffer(1024);
        try {
            targetQuery = this.SCHEDULE_INFO.getProperty("TEST_QUERY");
            targetCon = ConnectionPool.getConnection(tmpConnectionInfo);
            if (log.isDebugEnabled()) {
                log.debug(".execute_BasicInfoProcess() db url :" + tmpConnectionInfo.getDB_URL());
                log.debug(".execute_BasicInfoProcess() db id :" + tmpConnectionInfo.getDB_UID());
                log.debug(".execute_BasicInfoProcess() db pwd :" + tmpConnectionInfo.getDB_PASS());
            }
            stmt = targetCon.createStatement();
            if (log.isDebugEnabled()) {
                log.debug(".execute_BasicInfoProcess() exe test_query:" + targetQuery);
            }
            rs = stmt.executeQuery(targetCon.encode(targetQuery));
            if (log.isDebugEnabled()) {
                log.debug(".execute_BasicInfoProcess() exe query:[OK]");
            }
            String[] header_list = StringUtil.split(rs.getHeaderString(), "|");
            buffer.setLength(0);
            int pwd_index = 0;
            String tempHeader = "";
            for (int i = 1; i <= header_list.length; ++i) {
                tempHeader = header_list[i - 1];
                if (tempHeader.equals(this.PA)) {
                    pwd_index = i;
                }
                if (i != 1) {
                    buffer.append("|");
                }
                buffer.append(tempHeader);
            }
            this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", buffer.toString());
            log.info("TARGET MAPPINGHEADER : " + this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));
            int colcount = rs.getColumnCount();
            boolean appendCheck = false;
            String temp = "";
            while (rs.next()) {
                buffer.setLength(0);
                temp = rs.getString(1);
                temp = pwd_index == 1 ? this.PWD_STR : rs.getString(1);
                DelimConvertor.encodeToBuffer(buffer, temp == null ? "" : temp.trim());
                for (int count = 2; count <= colcount; ++count) {
                    buffer.append("|");
                    temp = pwd_index == count ? this.PWD_STR : rs.getString(count);
                    DelimConvertor.encodeToBuffer(buffer, temp == null ? "" : temp.trim());
                }
                this.BUFFERED_WRITER.write(buffer.toString());
                this.BUFFERED_WRITER.newLine();
                this.BUFFERED_WRITER.flush();
                appendCheck = true;
                log.debug("LINE CREATE....");
            }
            if (!appendCheck) {
                throw new NoTargetListException("NO TARGET LIST => " + this.POST_ID);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (targetCon != null) {
                    targetCon.destroy();
                }
            }
            catch (Exception exception) {}
            try {
                this.BUFFERED_WRITER.flush();
            }
            catch (Exception exception) {}
            try {
                if (this.BUFFERED_WRITER != null) {
                    this.BUFFERED_WRITER.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected synchronized void execute_DBInsertProcess() throws Exception {
        String this_day = Cal.getDayDate();
        this.INFO_ADDED_FINAL_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".infoadd";
        if (log.isDebugEnabled()) {
            log.debug(".execute_DBInsertProcess() set spool file :" + this.INFO_ADDED_FINAL_FILE_NAME);
        }
        this.openWriter(this.INFO_ADDED_FINAL_FILE_NAME);
        if (log.isDebugEnabled()) {
            log.debug(".execute_DBInsertProcess() set source file :" + this.NEXT_BASE_INFO_FILE_NAME);
        }
        this.openReader(this.NEXT_BASE_INFO_FILE_NAME);
        this.NEXT_BASE_INFO_FILE_NAME = this.INFO_ADDED_FINAL_FILE_NAME;
        SpoolAnalyzer spoolAnalyzer = SpoolAnalyzer.getSpoolAnalyzer();
        spoolAnalyzer.setSendType("AUTOTEST");
        spoolAnalyzer.setNextSpoolGenerate("N");
        spoolAnalyzer.setLimitDate("19000000");
        spoolAnalyzer.setPostID(this.POST_ID);
        spoolAnalyzer.setListTable("NOTABLE");
        spoolAnalyzer.setStep(0);
        HashMap headerMap = new HashMap();
        String tmpReadLine = null;
        try {
            SpoolHeaderParser.parseSimple(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"), "|", headerMap);
            log.info(" Source File Read Ready ");
            String engineChannel = this.SCHEDULE_INFO.getProperty("ENGINE_CHANNEL");
            while (this.BUFFERED_READER.ready()) {
                tmpReadLine = this.BUFFERED_READER.readLine();
                if (log.isDebugEnabled()) {
                    log.debug("engine => " + engineChannel + ", read => " + tmpReadLine);
                }
                if (tmpReadLine == null || tmpReadLine.trim().length() < 5) continue;
                try {
                    this.AUTO_KEY_VALUE_PARSER.parseSimple(this.__TMP_SIMPLE_HASH__, tmpReadLine, headerMap);
                    if (!this.__TMP_SIMPLE_HASH__.containsKey("TMS_M_ID") || !this.__TMP_SIMPLE_HASH__.containsKey("TMS_M_NAME")) continue;
                    log.info(" Source==> " + this.TEST_MSG_LIST.size());
                    int idx = 1;
                    Iterator<String> iter = this.TEST_MSG_LIST.iterator();
                    while (iter.hasNext()) {
                        spoolAnalyzer.setTokenID(iter.next().toString());
                        spoolAnalyzer.setMemberID(((String)this.__TMP_SIMPLE_HASH__.get("TMS_M_ID")).toString().concat("_" + idx));
                        spoolAnalyzer.setMemberName(((String)this.__TMP_SIMPLE_HASH__.get("TMS_M_NAME")).toString());
                        spoolAnalyzer.setMapping(tmpReadLine);
                        this.BUFFERED_WRITER.write(spoolAnalyzer.composeSingleRcptSend());
                        log.info(" Source==> " + spoolAnalyzer.composeSingleRcptSend());
                        this.BUFFERED_WRITER.newLine();
                        this.BUFFERED_WRITER.flush();
                        ++idx;
                    }
                }
                catch (Exception e) {
                    log.error("TEST ID/NAME/MSGTO POPUP FAIL", (Throwable)e);
                }
            }
            log.info(" Souce File Read Done ");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (this.BUFFERED_READER != null) {
                    this.BUFFERED_READER.close();
                }
            }
            catch (Exception exception) {}
            try {
                this.BUFFERED_WRITER.flush();
            }
            catch (Exception exception) {}
            try {
                if (this.BUFFERED_WRITER != null) {
                    this.BUFFERED_WRITER.close();
                }
            }
            catch (Exception exception) {}
            log.info(" Exit Souce File Read Routine ");
        }
    }

    @Override
    protected synchronized void execute_FinalProcess() throws Exception {
    }

    @Override
    public Object getTargetList() {
        return this.NEXT_BASE_INFO_FILE_NAME;
    }

    @Override
    protected void updateTaskState(String state) throws Exception {
    }

    @Override
    protected void deleteCurrentList() throws Exception {
    }

    @Override
    public String getID() {
        return this.POST_ID == null ? null : this.POST_ID;
    }
}

