/*
 * @(#)SpoolControlTask.java            2004. 11. 30.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.parallel.task;

import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

import pluto.compress.ZipFileManager;
import pluto.config.eMsSystem;
import pluto.io.FileElement;
import pluto.io.eMsFileWriter;
import lombok.extern.slf4j.Slf4j;
import pluto.log.Composer;
import pluto.schedule.Task;
import pluto.util.Cal;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.parser.SpoolAnalyzer;
import venus.spool.common.popper.Popper;
import venus.spool.mass.basic.MassBasicDefaultMappingGenerator;
import venus.spool.mass.task.BulkBaseSpoolTask;

/**
 * Spool 생성하는 기본 구조에 대해 정의한다. <br>
 * SpoolInfo를 생성 + 반환하는 로직을 추가함 - 2004.12.1 papai
 * 
 * @version		1.1
 * @author 		dragon
 *
 */
@Slf4j
public abstract class SpoolControlTask extends Task implements pluto.log.Log {
	
	
	/** 스풀 파일을 적을 디렉토리 */
	public static String SPOOL_WORKING_DIRECTORY = null;
	
	/** 스풀 파일이 적힌 디렉토리를 http로 접근할 때 URL */
	public static String SPOOL_WORKING_URL = null;
	
	/** 다음 스풀로 넘어갈 스풀의 라인 수 */
	public static int SPOOL_LIMIT = 100000;
	
	/** 일단은 모두 매핑 헤더가 동일하므로 그냥 간다. */
	public static String DEFAULT_SINGLE_MAPPING_HEADER = null;

	static {
		try {
			SPOOL_WORKING_DIRECTORY = eMsSystem.getProperty( "spool.store.directory" );
			SPOOL_WORKING_URL = eMsSystem.getProperty( "spool.store.url" );
			SPOOL_LIMIT = Integer.parseInt( eMsSystem.getProperty( "spool.limit" , "100000" ) );
			DEFAULT_SINGLE_MAPPING_HEADER=eMsSystem.getProperty( "default.single.mapping.header" );
		}
		catch( Exception e ){
			log.error(e.getMessage());
			System.exit( 1 );
		}
	}
	
	/**지정되는 일의 정보 */
	protected String POST_ID = null;
	
	/** TMS3.0 채널유형(EM,SM,PU,TO) */
	protected String				CHANNEL_TYPE				= null;
	
	/**  TMS3.0 채널순번 : 동일 POST_ID 동일 채널 의경우 SEQ로 중복방지 */
	//protected String				CHANNEL_SEQ					= null;
	
	protected String AB_ID = null;
	
	protected String REAL_POST_ID = null;
	
	/** Result를 가져올 때 TOTAL_SPOOL_LINE이라는 값에 전체 스풀라인을 받아올 것인지 여부 */
	protected boolean APPEND_TOTAL_SPOOL = false;
	
	/** 스풀 적는 writer */
	protected eMsFileWriter BUFFERED_SPOOL_WRITER = null;
	
	/** 현재 작업 중인 스풀 파일 이름 */
	protected String BUFFERED_SPOOL_WRITER_FILE_NAME = null;
	
	/** 첫번째 생성된 스풀 파일 이름 */
	protected String BASE_BUFFERED_SPOOL_WRITER_FILE_NAME = null;
	
	/** 스풀에 추가된 내용이 있는지 여부 */
	protected boolean LIST_APPEND_FLAG = false;
	
	/** 스풀 파일을 압축해서 저장할 것인지 여부 */
	protected boolean  COMPRESS_FLAG = false;
	
	/** 병렬 발송으로 파일을 나눌 것인지 여부 */
	protected boolean  PARALLEL_FLAG = false;
	
	/** 병렬 발송 대상 서버 이름 리스트 */
	protected Vector PARALLEL_SERVER_NAME_LIST = new Vector();
	
	/** 병렬 발송일경우 서버별 발송량 정보 */
	protected Properties PARALLEL_SERVER_SPOOLINFO = new Properties();
	
	/** 병렬 발송일경우 현재 생성중인 스풀파일의 서버이름 */
	protected String PARALLEL_SPOOL_CURRENT_SVRNAME = "";
	
	/** 병렬 발송일경우 현재 생성중인 스풀파일의 서버수 */
	protected int PARALLEL_CURRENT_SVR_CNT = 0;
	
	/** 병렬 발송일경우 현재 생성중인 서버내 스풀파일 수 */
	protected int PARALLEL_CURRENT_SPOOL_CNT = 0;
	
	protected int SPOOL_ATTACH_COUNT = 0;
	
	/** 작업 중인 스풀 파일이 몇 번째인지 정보 */
	protected int SPOOL_FILE_INDEX = 0;
	
	/** 현재 작업 되는 메일의 스풀에 대한 정보 */
	protected SpoolInfo mailSpoolInfo = null; 
	
	/** 로그 조립할 Composer */
	protected Composer composer = null;
	
	/** 스풀을 파싱해야할 녀석 */
	protected SpoolAnalyzer SPOOL_ANALYZER = null;
	
	/** 스풀 패치중 이상이 있는 건을 기록하는 Writer */
	protected eMsFileWriter SPOOL_ERROR_STORE_WRITER = null;
	
	/** 리스트 Popper */
	protected Popper SPOOL_POPPER = null;
	
	/** 스풀 파일을 생성하였을 때 분할된 리스트를 저장한다. */
	protected Vector SPOOL_FILE_LIST = new Vector();
	
	/** 스풀 파일을 생성하였을 때 분할된 리스트의 URL위치를 저장한다. */
	protected Vector SPOOL_FILE_URL_LIST = new Vector();
	
	/** 병렬발송 스풀 파일을 생성하였을 때 분할된 리스트의 URL위치를 저장한다. */
	protected Properties SPOOL_PARALLEL_FILE_URL_LIST = new Properties();
	
	/** 작업중 생성되는 파일의 아이디 */
	protected String WORK_FILE_ID = null;
	
	/** Mapping Header Info per each mail */ 
	protected Properties MAPPING_HEADER_INFO = null;
	
	
	
	/** Creates a new instance of SpoolControlTask */
	public SpoolControlTask()  throws Exception {
		this(TYPE_TRANSACTION , DEFAULT_EXECUTE_INTERVAL);
	}
	
	/** Creates a new instance of SpoolControlTask */
	public SpoolControlTask(short type)  throws Exception {
		this( type , DEFAULT_EXECUTE_INTERVAL );
	}
	
	/** Creates a new instance of SpoolControlTask */
	public SpoolControlTask(short type, long interval) throws Exception {
		
		super( type , interval );
		this.composer = Composer.getComposerInstance();
		this.SPOOL_ANALYZER = SpoolAnalyzer.getSpoolAnalyzer();
		this.SPOOL_FILE_LIST = new Vector();
		this.SPOOL_FILE_URL_LIST = new Vector();
		this.PARALLEL_SERVER_NAME_LIST = new Vector();
		this.PARALLEL_SERVER_SPOOLINFO = new Properties();
		this.SPOOL_PARALLEL_FILE_URL_LIST = new Properties();
		this.COMPRESS_FLAG = "true".equals(eMsSystem.getProperty("spool.compress"))?true:false;
		
	}
	
	/**
	 *	병렬 발송 정보 셋팅 ..	(발송설정 웹 프로그램에서 셋팅하여 설정 한다..)
	 */
	public void setParallelInfo(boolean parallelFlag, String svrPerInfo)  throws Exception {
		
		this.PARALLEL_FLAG = parallelFlag;
		
		//		병렬 발송일 경우 서버 리스트명과 분할 %정보를 저장한다... by duricat
		if ( PARALLEL_FLAG ) {
			StringTokenizer st = new StringTokenizer(svrPerInfo,"=");
			int svrCnt = 0;
			if (st.hasMoreTokens()) {
				StringTokenizer st2 = new StringTokenizer((st.nextToken()).trim(),":");
				while ( st2.hasMoreTokens() ){
					PARALLEL_SERVER_NAME_LIST.add(svrCnt++,(st2.nextToken()).trim());	//	서버 이름을 순서대로 저장한다.
				}
			}
			if (st.hasMoreTokens()) {
				StringTokenizer st2 = new StringTokenizer((st.nextToken()).trim(),":");
				for(int i=0;i<svrCnt;i++){
					if( st2.hasMoreTokens() ){
						PARALLEL_SERVER_SPOOLINFO.setProperty((String)PARALLEL_SERVER_NAME_LIST.get(i),(st2.nextToken()).trim());	//	서버 이름을 순서대로 발송량을 기록
					} else {
						PARALLEL_SERVER_SPOOLINFO.setProperty((String)PARALLEL_SERVER_NAME_LIST.get(i),"0");
					}
				}
			}
		}
		
	}
	
	/**
	 * 처음으로 스풀 파일 열 때 호출된다. 
	 * @param filename
	 * @throws Exception
	 */
	protected void openSpooler( String filename  ) throws Exception {
		
		// 일단 지금 작업 중인게 있음 닫자. 다른 메일과 혹시 섞이면 안되니깐..
		closeSpooler();		
		
		BUFFERED_SPOOL_WRITER = new eMsFileWriter( filename );		
		BUFFERED_SPOOL_WRITER_FILE_NAME = filename;		
		BASE_BUFFERED_SPOOL_WRITER_FILE_NAME = filename;		
		LIST_APPEND_FLAG = false;
	}
	
	/**
	 * 현재 사용하던 스풀이 특정 조건에 걸려 ( 예 : 일정 라인을 넘어섰을 때 )
	 * 다음 스풀을 열 때 호출되는 함수
	 * @return
	 * @throws Exception
	 */
	protected String openNextSpooler() throws Exception {
		
		// 일단 지금 작업하는 것 좀 닫자.
		closeSpooler();
		
		BUFFERED_SPOOL_WRITER_FILE_NAME 
				= BASE_BUFFERED_SPOOL_WRITER_FILE_NAME
						.concat(".")
						.concat( String.valueOf( this.SPOOL_FILE_INDEX++ ) );
		
		BUFFERED_SPOOL_WRITER = new eMsFileWriter( 
				BUFFERED_SPOOL_WRITER_FILE_NAME , false );
				
		return BUFFERED_SPOOL_WRITER_FILE_NAME;
	}
	
	/**
	 * 현재 작업되고 있는 스풀 파일에 기록
	 * @param spool
	 * @throws Exception
	 */
	protected void appendSpooler( String spool ) throws Exception {
		
		BUFFERED_SPOOL_WRITER.write( spool );
		BUFFERED_SPOOL_WRITER.newLine();
		BUFFERED_SPOOL_WRITER.flush();
		LIST_APPEND_FLAG = true;
	}
	
	/**
	 *<Br> 현재 작업되고 있는 spooler를 종료한다.
	 *<Br> 1. 자원 반환
	 *<Br> 2. 메모리에 파일 이름 등록 ( SPOOL_FILE_LIST )
	 *<Br> 3. 압축이 필요한 시 압축 ( spool.compress 가 true인 경우 실행 ) 
	 *<Br> 4. 스풀에 추가된 내용이 없을 경우 파일 삭제
	 */
	protected void closeSpooler(){
		
		if( BUFFERED_SPOOL_WRITER != null ) {
			try{ BUFFERED_SPOOL_WRITER.flush(); }catch( Exception ignore ){}
			try{ BUFFERED_SPOOL_WRITER.close(); }catch( Exception ignore ){}
			
			
			String realFileName = BUFFERED_SPOOL_WRITER_FILE_NAME;
			
			if( this.LIST_APPEND_FLAG ) {
				// 압축을 해야한다면 압축하자
				if ( COMPRESS_FLAG ) {
					int i = BUFFERED_SPOOL_WRITER_FILE_NAME.lastIndexOf("/");
					String base = (i==-1)?"":BUFFERED_SPOOL_WRITER_FILE_NAME.substring(0,i);
					String fileName = BUFFERED_SPOOL_WRITER_FILE_NAME.substring(i+1);
					
					try {
						realFileName = ZipFileManager.makeZip(base,fileName,false);
					} 
					catch(Exception ex) {
						log.error(" Error while creating zip file - " +  BUFFERED_SPOOL_WRITER_FILE_NAME);
					}
				}
			} 
			else {
				return; 
			}
			
			String __SPOOL_FILE_URL_NAME__ =	SPOOL_WORKING_URL 
							+ "/" 
							+ realFileName.substring(SPOOL_WORKING_DIRECTORY.length() + 1);
			
			//	병렬 발송일 경우 키값과 같이 ��는다.
			if ( PARALLEL_FLAG ) {
				this.SPOOL_FILE_LIST.addElement( realFileName );
				this.SPOOL_PARALLEL_FILE_URL_LIST.setProperty(PARALLEL_SPOOL_CURRENT_SVRNAME+"|"+PARALLEL_CURRENT_SPOOL_CNT ,__SPOOL_FILE_URL_NAME__);
				PARALLEL_CURRENT_SPOOL_CNT++;
			} else {
				this.SPOOL_FILE_LIST.addElement( realFileName );
				this.SPOOL_FILE_URL_LIST.addElement(__SPOOL_FILE_URL_NAME__);
			}

			if(log.isDebugEnabled()) 
				log.debug( " Spool Registered : " + realFileName);
			
			// 만일 추가된 라인이 있다면 그냥 돌아가고 아니면 파일을 지워야한다.
			if( this.LIST_APPEND_FLAG ) return;
			
			try {
				boolean fileDel = ( new File( BUFFERED_SPOOL_WRITER_FILE_NAME ) ).delete();
				if(!fileDel) log.error("File deletion failed");
				BUFFERED_SPOOL_WRITER = null;
			}
			catch( Exception e ) {
				log.error( BUFFERED_SPOOL_WRITER_FILE_NAME , e );
			}
		}
	}
	
	protected void deleteSpooler(){
		
		if( BUFFERED_SPOOL_WRITER != null ) {
			try{ BUFFERED_SPOOL_WRITER.flush(); }catch( Exception ignore ){}
			try{ BUFFERED_SPOOL_WRITER.close(); }catch( Exception ignore ){}
			BUFFERED_SPOOL_WRITER = null;

			try{
				boolean fileDel = ( new File( BUFFERED_SPOOL_WRITER_FILE_NAME ) ).delete();
				if(!fileDel) log.error("File deletion failed");
			}
			catch( Exception e ){
				log.error( BUFFERED_SPOOL_WRITER_FILE_NAME , e );
			}
		}
	}
	
	public void release_Resource() {
		
		// 스풀러 닫고
		closeSpooler();
	}

	/* (non-Javadoc)
	 * @see pluto.schedule.Task#execute()
	 */
	public void execute() throws Exception {
		boolean success = true;
		
		Exception x = null;
		
		try {
			execute_Startup();
			makeSpoolFile();
			makeSpoolInfo();
		} 
		catch( Exception ex ) {
			success = false;
			x = ex;
		} 
		finally {
			execute_Finish(success);
		}
		
		if( x != null ) throw x;
	}
	
	/**
	 * 스풀 정보가 담긴 SpoolInfo 객체를 받아온다. 
	 * @return
	 */
	public SpoolInfo getSpoolInfo() {
		
		return this.mailSpoolInfo;
	}
	
	/**
	 * MappingHeader를 가져온다. <br>
	 * 기본적으로는 설정파일의 기본값으로 셋팅된 것만 가져오나 <br>
	 * 이 객체를 상속받은 자식 클래스에서는 다른 방식으로 구현할 수 있다<br>
	 * @return 
	 * @throws Exception
	 */
	protected String getMappingHeader() throws Exception {
	
		String value = this.TASK_PROPERTY.getProperty( "MAPPINGHEADER" );
		
		if( value == null || value.trim().equals("null") || value.trim().equals("") ) {
			return DEFAULT_SINGLE_MAPPING_HEADER;
		} 

		return value;
	}
		
	/**
	 * 스풀 정보를 SpoolInfo 객체에 담는다.
	 * SpoolInfoManager에 담는다
	 * @throws Exception
	 */
	protected void makeSpoolInfo() throws Exception {
		// 만들어진 스풀 정보를 SpoolInfo 객체에 담는다.
		this.mailSpoolInfo = new SpoolInfo();
		this.mailSpoolInfo.setID( TASK_PROPERTY.getProperty("POST_ID") );
		this.mailSpoolInfo.setSendState( TASK_PROPERTY.getProperty("SEND_STATE") );
		
		this.mailSpoolInfo.setMappingHeader( getMappingHeader() );

		
		this.mailSpoolInfo.setSpoolDelimit( eMsSystem.getProperty("spool.delimit","|"));
		String value = TASK_PROPERTY.getProperty("SERIAL_DELIM");
		this.mailSpoolInfo.setSerialDelimit( (value==null)?"|":value);
		this.mailSpoolInfo.setSpoolFilesInfo( SPOOL_FILE_URL_LIST );
		
		//by joo - keyValueMapping 입력 (구역 입력)
		MassBasicDefaultMappingGenerator KEYVALUE_MAPPING_GENERATOR = new MassBasicDefaultMappingGenerator();
		KEYVALUE_MAPPING_GENERATOR.process( this.TASK_PROPERTY );
		this.mailSpoolInfo.setDefaultMapping( KEYVALUE_MAPPING_GENERATOR.getMapOfDefaultMapping() );
		
		// SpoolInfoManager에 담는다 
		if( PARALLEL_FLAG )	{
			//	병렬 발송일 경우
			this.mailSpoolInfo.setSpoolParallelFilesInfo( SPOOL_PARALLEL_FILE_URL_LIST );
			for(int i=0;i<PARALLEL_SERVER_NAME_LIST.size();i++)
				SpoolInfoManager.registParallelSpoolInfo( this.mailSpoolInfo, (String) PARALLEL_SERVER_NAME_LIST.get(i) );
		}
		else	//	일반 발송일 경우
			SpoolInfoManager.registSpoolInfo( this.mailSpoolInfo );
	}
		
	/**
	 * 대상자 정보를 스풀로 작성한다.
	 * @throws Exception
	 */
	public void makeSpoolFile() throws Exception {
		
		String this_day = Cal.getDayDate();
		
		
		String __SPOOL_FILE_NAME__ = 
				FileElement.CheckSubDirectory( SPOOL_WORKING_DIRECTORY, this_day ) 
						+ "/"
						+ this.WORK_FILE_ID 
						+ ".spool";
		
		try {
			// 스풀파일을 준비한다. 
			openSpooler( __SPOOL_FILE_NAME__ );
			
			if (log.isDebugEnabled())  
					log.debug("OPEN Spool=>" + __SPOOL_FILE_NAME__ );
			
			if ( PARALLEL_FLAG )	//	병렬 발송일 경우 ...
				execute_Parallel_ListLoad( this.TASK_PROPERTY );
			else 
				execute_ListLoad( this.TASK_PROPERTY );
		}
		catch( Exception e ) {
			log.error(getName(),e.toString());
			throw e;
		} 
		finally {
			//스풀러 일단 닫고
			closeSpooler();
			
			// 스풀 내용이 없다면 그냥 지워버린다.
			if( !this.LIST_APPEND_FLAG ) {
				//스풀파일도 지우고
				deleteSpooler();
				if (log.isDebugEnabled()) log.debug( "NO APPEND LIST FILE");
			}
		}
	}
	
	/**
	 * @param prop
	 * @throws Exception
	 */
	protected void execute_ListLoad( Properties prop ) throws Exception {
		
	}
	
	/**
	 * @param prop
	 * @throws Exception
	 */
	protected void execute_Parallel_ListLoad( Properties prop ) throws Exception {
		
	}
	
	/**
	 * <br>스풀 생성 시작시 실행하는 부분 
	 * <br>아무것도 안할 경우에도 override하는 것을 막기 위해
	 * <br>abstract로 선언하지는 않았다.
	 * @throws Exception
	 */
	protected void execute_Startup() throws Exception {
		
	}
	
	/**
	 * <br>스풀 생성 완료시 실행하는 부분
	 * <br>아무것도 안할 경우에도 override하는 것을 막기 위해
	 * <br>abstract로 선언하지는 않았다.
	 * @throws Exception
	 */
	protected void execute_Finish(boolean b) throws Exception {
		
	}
		
	/**
	 * 정보를 스풀로 작성한다.
	 */
	protected abstract void addSpool( Properties prop ) throws Exception;
	
	
	/**
	 * 매핑 헤더 정보를 셋팅한다. ( 각 POST_ID 를 key로 하여 매핑 헤더 정보가 닮겨있다. )
	 * 현재는 자동메일에서만 사용한다.  ( 2004.12.25 -- 크리스마스에는 일하지 맙시다 ) 
	 * @param prop
	 */
	public void setMAPPING_HEADER_INFO( Properties prop ) {
		if( prop != null ) {
			this.MAPPING_HEADER_INFO = new Properties();
			this.MAPPING_HEADER_INFO.putAll(prop);
		}
	}
}

