/*
 * @(#)AbstractDbSpoolTask.java            2004. 12. 9.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.parallel.task;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.StringConvertUtil;

/**
 * Spool Task 중 Connection 맺고 끊는 작업을 정의한다. 
 * 
 * @version		
 * @author 		lena
 *
 */
@Slf4j
public abstract class AbstractDbSpoolTask extends SpoolControlTask {

	
	/**지정되는 일의 정보 */
	protected String LIST_TABLE = null;
	
	/** 공통으로 사용하는 Connection */
	protected eMsConnection EMS_CONNECTION = null;
	
	/** Task를 실행하면서 공용을 사용할 StringBuffer 대부분은 쿼리를 전환할때 사용된다. */
	protected StringBuffer TMP_STRING_BUFFER = null;
	
	/** 대상자를 가져오는 쿼리 */
	protected String SELECT_TARGET_LIST_QUERY = null;
	
	/** 대상자 업데이트 하는 쿼리 */
	protected String UPDATE_TARGET_LIST_QUERY = null;
	
	/** 대상자 수(병렬 발송일경우 사용) */
	protected int __TARGET_CNT = 0;
	
	/** Creates a new instance of AbstractDbSpoolTask */
	public AbstractDbSpoolTask()  throws Exception {
		super(TYPE_TRANSACTION , DEFAULT_EXECUTE_INTERVAL);
	}
	
	/** Creates a new instance of AbstractDbSpoolTask */
	public AbstractDbSpoolTask(short type)  throws Exception {
		super( type , DEFAULT_EXECUTE_INTERVAL );
	}
	
	/** Creates a new instance of AbstractDbSpoolTask */
	public AbstractDbSpoolTask(short type, long interval) throws Exception {
		super( type , interval );
	}
	
	/** 
	 * <br>Task를 초기화하는 로직을 구현한다.
	 * <br>발송 로직에서 최초로 구현된다. 하위에서 상속 받는 녀석들이 override 할때는
	 * <br>super.execute_initiate() 를 반드시 호출해줘야한다.
	 * <br>Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록 되어있다.
	 */
	public void execute_initiate() throws Exception {
		super.execute_initiate();
		
		if(log.isDebugEnabled()) log.debug( " Request Connection");
		EMS_CONNECTION = ConnectionPool.getConnection();
		if(log.isDebugEnabled()) log.debug( " Get Connetion " + EMS_CONNECTION.getName());

		// 공용 StringBuffer 초기화 add 2004.11.02
		this.TMP_STRING_BUFFER = new StringBuffer(1024);
	}
	
	/** 
	 * <br>초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다.
	 * <br>Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * <br>에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
	
		log.error( getName() , thw );
	
		//REPORT 데이터베이스 커넥션을 가져오는 과정에서 에러가 발생하였습니다.
		//if( !( thw instanceof SQLException ) ) {
		//	Reporter.report(this.POST_ID,getName(),"mailsendtask.init.err",thw);
		//}
	}
		
	/**
	 *<br>에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다.
	 *<br>할당받은 자원을 free 시키는 로직을 구현한다.
	 *<br>execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 
	 *<br>처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
	
		if( EMS_CONNECTION != null ) {
			EMS_CONNECTION.recycle();
		}
	
		// 공용 StringBuffer 반환 add 2004.11.02
		this.TMP_STRING_BUFFER = null;
	}
	
	/** 리스트 로드
		 */
	protected void execute_ListLoad( Properties TARGET_PROPERTIES ) throws Exception {

		/* 리스트 생성이 끝났기 때문에 ... 데이터 베이스에서 해당 사항을 읽어와 스풀을 만든다. */
		eMsStatement __SELECT_STATEMENT__ = null;
		eMsStatement __UPDATE_STATEMENT__ = null;
		eMsResultSet rs = null;
	
		Exception ex = null;
	
		try {
			__SELECT_STATEMENT__ = EMS_CONNECTION.createStatement();
			__UPDATE_STATEMENT__ = EMS_CONNECTION.createStatement();
			
			this.TMP_STRING_BUFFER.setLength( 0 );
			StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , 
					this.SELECT_TARGET_LIST_QUERY ,  
					TARGET_PROPERTIES , "${" , "}" , true , false );
			
			// log.debug("SELECT_TARGET_LIST_QUERY =>" + this.TMP_STRING_BUFFER);
			
			rs = __SELECT_STATEMENT__.executeQuery( this.TMP_STRING_BUFFER.toString() );

			Properties TARGET_INFO = new Properties();
			
			while( rs.next() ) {
				TARGET_INFO.clear();		
				rs.putToMap( TARGET_INFO , APPEND_TOTAL_SPOOL );
				
				// 리스트 쿼리에 대한 Row Patch 중 업데이트를 할 것이 있으면 다음 로직을 탄다. 2004.11.02
				if( this.UPDATE_TARGET_LIST_QUERY != null ) {
				
					this.TMP_STRING_BUFFER.setLength( 0 );
					StringConvertUtil.ConvertString( 
							this.TMP_STRING_BUFFER , this.UPDATE_TARGET_LIST_QUERY, 
							TARGET_INFO , "${" , "}" , true , false );
						
					if( __UPDATE_STATEMENT__.executeUpdate( this.TMP_STRING_BUFFER.toString() ) < 1  ){
						log.error( "list update fail" );
						continue;
					}
				}
	
				// 일정 수가 넘으면 파일을 바꿔준다.
				if( this.SPOOL_ATTACH_COUNT++ > SPOOL_LIMIT ){
					this.SPOOL_ATTACH_COUNT = 0;
					String __NEXT_SPOOL_FILE_NAME__ = openNextSpooler();
					log.debug( "SWITCH SPOOL"	, __NEXT_SPOOL_FILE_NAME__ );
				}
				TARGET_INFO.setProperty("REAL_POST_ID",TARGET_PROPERTIES.getProperty("REAL_POST_ID"));
	
				// 스풀을 작성한다.
				addSpool( TARGET_INFO );
				this.LIST_APPEND_FLAG = true;
			}		
		}
		catch( Exception e ) {			
			log.error("spool make error", e);
			ex = e;
			throw ex;
		}
		finally {
			try{ rs.close(); }catch( Exception e ){}

			EMS_CONNECTION.recycleStatement( __UPDATE_STATEMENT__ );
			EMS_CONNECTION.recycleStatement( __SELECT_STATEMENT__ );
					
		}
	}
	
	/** 병렬 발송 리스트 로드
	 */
	protected void execute_Parallel_ListLoad( Properties TARGET_PROPERTIES ) throws Exception {

		/* 리스트 생성이 끝났기 때문에 ... 데이터 베이스에서 해당 사항을 읽어와 스풀을 만든다. */
		eMsStatement __SELECT_STATEMENT__ = null;
		eMsStatement __UPDATE_STATEMENT__ = null;
		eMsResultSet rs = null;
	
		Exception ex = null;
	
		try {
			__SELECT_STATEMENT__ = EMS_CONNECTION.createStatement();
			__UPDATE_STATEMENT__ = EMS_CONNECTION.createStatement();
			
			this.TMP_STRING_BUFFER.setLength( 0 );
			StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , 
					this.SELECT_TARGET_LIST_QUERY ,  
					TARGET_PROPERTIES , "${" , "}" , true , false );
			
			// log.debug("SELECT_TARGET_LIST_QUERY =>" + this.TMP_STRING_BUFFER);
			
			rs = __SELECT_STATEMENT__.executeQuery( this.TMP_STRING_BUFFER.toString() );
	
			Properties TARGET_INFO = new Properties();
			
			int currentSpoolCnt = Parallel_Svr_Cnt();	//	현재 생성해야할 리스트 수 ...(병렬발송 시)
			int sPoolParallelCnt = 0;		//	병렬발송 서버별 리스트수
			while( rs.next() ) {
				TARGET_INFO.clear();		
				rs.putToMap( TARGET_INFO , APPEND_TOTAL_SPOOL );
				
				// 리스트 쿼리에 대한 Row Patch 중 업데이트를 할 것이 있으면 다음 로직을 탄다. 2004.11.02
				if( this.UPDATE_TARGET_LIST_QUERY != null ) {
				
					this.TMP_STRING_BUFFER.setLength( 0 );
					StringConvertUtil.ConvertString( 
							this.TMP_STRING_BUFFER , this.UPDATE_TARGET_LIST_QUERY, 
							TARGET_INFO , "${" , "}" , true , false );
						
					if( __UPDATE_STATEMENT__.executeUpdate( this.TMP_STRING_BUFFER.toString() ) < 1  ){
						log.error( "list update fail" );
						continue;
					}
				}
				
				this.SPOOL_ATTACH_COUNT++;
				sPoolParallelCnt++;		//	전체수 증가..
				// 일정 수가 넘으면 파일을 바꿔준다.
				if( this.SPOOL_ATTACH_COUNT > SPOOL_LIMIT || sPoolParallelCnt > currentSpoolCnt ){
					this.SPOOL_ATTACH_COUNT = 0;
					
					String __NEXT_SPOOL_FILE_NAME__ = openNextSpooler();
					log.debug( "SWITCH SPOOL"	, __NEXT_SPOOL_FILE_NAME__ );
					
					//	병렬 발송시 현재 생성수가 넘었을 경우는 서버별 카운트 수 재 셋팅 ...
					if( sPoolParallelCnt > currentSpoolCnt ) {
						sPoolParallelCnt = 0;
						currentSpoolCnt = Parallel_Svr_Cnt();	//	현재 생성해야할 리스트 수 재 셋팅...(병렬발송 시)
					}
				}
				TARGET_INFO.setProperty("REAL_POST_ID",TARGET_PROPERTIES.getProperty("REAL_POST_ID"));
				// 스풀을 작성한다.
				addSpool( TARGET_INFO );
				this.LIST_APPEND_FLAG = true;
			}		
		}
		catch( Exception e ) {
			log.error("Exception", e);
			log.info(e.toString());
			ex = e;
			throw ex;
		}
		finally {
			try{ rs.close(); }catch( Exception e ){}
	
			EMS_CONNECTION.recycleStatement( __UPDATE_STATEMENT__ );
			EMS_CONNECTION.recycleStatement( __SELECT_STATEMENT__ );
					
		}
	}
	
	/**
	 * 병렬 발송 스풀생성중에 현재 생성중인 서버의 스풀 리스트 갯수를 반환한다.
	 * @param svrName
	 * @return
	 * @throws Exception
	 */
	protected int Parallel_Svr_Cnt() throws Exception {
		
		//	현재 생성중인 서버명 셋팅
		if( PARALLEL_CURRENT_SVR_CNT < PARALLEL_SERVER_NAME_LIST.size() )
			PARALLEL_SPOOL_CURRENT_SVRNAME = (String) PARALLEL_SERVER_NAME_LIST.get(PARALLEL_CURRENT_SVR_CNT++);
		
		int svrParlPer = Integer.parseInt(PARALLEL_SERVER_SPOOLINFO.getProperty(PARALLEL_SPOOL_CURRENT_SVRNAME));
		int rsCnt = (svrParlPer*__TARGET_CNT)/100;
		
		if( rsCnt < 1 )	rsCnt = 1;
		
		return rsCnt;
	}
}
