/*
 * @(#)SingleTestSpoolTask.java            2004. 11. 30.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.mass.task;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.mass.basic.MassBasicDefaultMappingGenerator;
import venus.spool.parallel.task.AbstractDbSpoolTask;
/**
 * 대량 1-1 메일 테스트 발송의 경우 Spool 생성 작업을 지원한다  
 * 
 * @version		
 * @author 		lena
 *
 */
@Slf4j
public class SingleTestSpoolTask extends AbstractDbSpoolTask {
	
	
	public static String QUERY_TEST_LIST_SAMPLING_QUERY = null;
	
	public static String QUERY_UPDATE_TEST_SPOOL_CONF = null;
	
	static {
		try {
			QUERY_TEST_LIST_SAMPLING_QUERY = SqlManager.getQuery("WINDFORCE_COMMON","QUERY_TEST_LIST_SAMPLING_QUERY");
			QUERY_UPDATE_TEST_SPOOL_CONF = SqlManager.getQuery("WINDFORCE_COMMON","QUERY_UPDATE_TEST_SPOOL_CONF");
		}
		catch( Exception e ) {
			log.error(e.getMessage());
			System.exit(1);
		}
	}
	
	
	
	/** test 발송의 seq ( table : directdb ), setTaskProperty() 참조  */
	private String seq = null;
	
	/** Creates a new instance of SingleTestSpoolTask */
	public SingleTestSpoolTask() throws Exception{
		super();
	}
	
	public void setTaskProperty(Properties prop) {
		
		this.TASK_PROPERTY = prop;
		
		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		//this.CHANNEL_SEQ = this.TASK_PROPERTY.getProperty( "CHANNEL_SEQ" );
		
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		
		this.setTaskID( this.POST_ID.concat( String.valueOf( System.currentTimeMillis() ) ) );
		
		this.setName( this.POST_ID + "_SingleTestSpoolTask" );
		
		this.setSeq(this.TASK_PROPERTY.getProperty("SEQ"));
		
		this.WORK_FILE_ID = this.POST_ID.concat("_real_test_").concat( Cal.getSerialDate() );
		
		/**스풀에 적을 기본적인 사항을 세팅한다.
		 */
		this.SPOOL_ANALYZER.setSendType( "MTEST" );// one to one
		this.SPOOL_ANALYZER.setNextSpoolGenerate( "N" );// spool attach
		this.SPOOL_ANALYZER.setLimitDate( "19000101" );
		this.SPOOL_ANALYZER.setPostID( this.POST_ID );
		this.SPOOL_ANALYZER.setListTable( this.LIST_TABLE );
		this.SPOOL_ANALYZER.setStep( 0 );
	}
	
	public void makeSpoolFile() throws Exception {
		
		String this_day = Cal.getDayDate();
		
		String __WORK_FILE_NAME__ = 
				FileElement.CheckSubDirectory(SPOOL_WORKING_DIRECTORY,	this_day )
						+ "/"
						+ this.WORK_FILE_ID 
						+ "_test.spool";
						
		if (log.isDebugEnabled())  
				log.debug( "spool filename:" + __WORK_FILE_NAME__ );
				
		openSpooler( __WORK_FILE_NAME__ );
		
		// 일단 리스트를 추출하는 단계
		eMsStatement __EMS_EXEC_STATEMENT__ = null;
		eMsResultSet base_rs = null;
		
		// Exception이 발생하면 이곳에 담는다.
		Exception ex = null;
		
		try {
			__EMS_EXEC_STATEMENT__ = EMS_CONNECTION.createStatement();
			this.TMP_STRING_BUFFER.setLength( 0 );
			
			StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , QUERY_TEST_LIST_SAMPLING_QUERY , this.TASK_PROPERTY , "${" , "}"  , true , false );
			base_rs = __EMS_EXEC_STATEMENT__.executeQuery( this.TMP_STRING_BUFFER.toString() );
			
			Properties prop = new Properties();
			
			if( base_rs.next() ) {
				base_rs.putToMap( prop , true );
			}
			else {
				// 테스트 샘플링 쿼리를 했을때, 즉 타겟팅(60테이블)이 안되었을 경우
				throw new RuntimeException("NO SAMPLE LIST...");
			}
			
			String __TMP_SAMPLING_STRING__ = prop.getProperty( "TOTAL_SPOOL_LINE" );
			
			// TEST_LIST항목이 발송될 이메일이다. ':'로 구분되어 있다. 
			List __TARGET_LIST__ = StringUtil.toStringList( TASK_PROPERTY.getProperty("TEST_LIST") , ":" , new LinkedList() );
			
			if( __TARGET_LIST__ == null || __TARGET_LIST__.size() < 1 ) {
				// 웹에서 이런 경우는 막겠지만, TEST LIST값이 없을 경우
				throw new RuntimeException("NO TEST LIST...");
			}
			
			for( Iterator iter = __TARGET_LIST__.iterator() ; iter.hasNext() ; ) {
				String _TARGET_TOKEN_ = iter.next().toString();
				
				// 이메일 주소가 유효한지를 검사한다.
				if( StringUtil.isError( _TARGET_TOKEN_ ) ) continue;
				
				this.SPOOL_ANALYZER.setTokenID( _TARGET_TOKEN_ );
				this.SPOOL_ANALYZER.setMemberID( prop.getProperty( "TMS_M_ID" ) );
				this.SPOOL_ANALYZER.setMemberName( prop.getProperty( "TMS_M_NAME" ) );
				this.SPOOL_ANALYZER.setMapping( __TMP_SAMPLING_STRING__ );
				
				appendSpooler( this.SPOOL_ANALYZER.composeSingleRcptSend() );
			}
		}
		catch( Exception e ) {
			ex = e;
			throw ex;
		}
		finally {
			try { 
				if(base_rs != null) base_rs.close();																			
			}
			catch( Exception ignore ) {}
			
			EMS_CONNECTION.recycleStatement( __EMS_EXEC_STATEMENT__ );
			
			//스풀러 일단 닫고
			closeSpooler();					
		}
	}
	
	/**정보를 스풀로 작성한다.
	 * 스풀을 파싱하는 것이 아니므로.... 아무일도 하지 않는다. 콜할 일도 없다.
	 */
	protected void addSpool( Properties prop ) throws Exception {
		return;
	}
	
	protected void execute_Finish(boolean success) throws Exception {
		
		super.execute_Finish(success);
	 
	 	if(success) {
			eMsStatement stmt = null;
			try {
				stmt = this.EMS_CONNECTION.createStatement();
			
				Properties prop = new Properties();
				prop.setProperty("SEQ",getSeq());
				prop.setProperty("SPOOL_CONF",SpoolInfoManager.getSpoolInfo(POST_ID).getSpoolInfoPath());
				this.TMP_STRING_BUFFER.setLength( 0 );
			
				StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , QUERY_UPDATE_TEST_SPOOL_CONF  , prop , "${" , "}" , true , false );
				stmt.executeUpdate( this.TMP_STRING_BUFFER.toString() );
			}
			catch( Exception e ){
				log.error( getName() , e );
				success = false;
			}
			finally {
				this.EMS_CONNECTION.recycleStatement( stmt );
			}
	 	}
	}
	
	/**
	 * @return
	 */
	public String getSeq() {
		return seq;
	}

	/**
	 * @param string
	 */
	public void setSeq(String string) {
		seq = string;
	}
	
	protected void makeSpoolInfo() throws Exception {
		
		// 만들어진 스풀 정보를 SpoolInfo 객체에 담는다.
		this.mailSpoolInfo = new SpoolInfo();
		this.mailSpoolInfo.setID( TASK_PROPERTY.getProperty("POST_ID") );
		this.mailSpoolInfo.setSendState( TASK_PROPERTY.getProperty("SEND_STATE") );
		this.mailSpoolInfo.setMappingHeader( getMappingHeader() );
		this.mailSpoolInfo.setSpoolDelimit( eMsSystem.getProperty("spool.delimit","|"));
		String value = TASK_PROPERTY.getProperty("SERIAL_DELIM");
		this.mailSpoolInfo.setSerialDelimit( (value==null)?"|":value);
		this.mailSpoolInfo.setSpoolFilesInfo( SPOOL_FILE_URL_LIST );
	
		
		log.debug("=================START test content ===================");
		//by joo - keyValueMapping 입력 (구역 입력)
		MassBasicDefaultMappingGenerator KEYVALUE_MAPPING_GENERATOR = new MassBasicDefaultMappingGenerator();
		KEYVALUE_MAPPING_GENERATOR.process( this.TASK_PROPERTY );
		this.mailSpoolInfo.setDefaultMapping( KEYVALUE_MAPPING_GENERATOR.getMapOfDefaultMapping() );
		log.debug("========================END===========================");
		
		
		// SpoolInfoManager에 담을 때 이름을 정해줘서 넣어준다.
		// 테스트 발송의 경우는 이게 필요하다. ( 각 발송마다 이름이 다르므로 )
		String file_name = TASK_PROPERTY.getProperty("POST_ID")  
				+ "_TEST_"
				+ TASK_PROPERTY.getProperty("SEQ");
				
		SpoolInfoManager.registSpoolInfo( this.mailSpoolInfo, file_name );
	}
}
