/*
 * @(#)SingleErrorSpoolTask.java            2004. 11. 30.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.mass.task;

import java.util.Properties;

import pluto.config.SqlManager;
import lombok.extern.slf4j.Slf4j;
import pluto.util.Cal;

/**
 * 대량 1-1 메일 보류 메일 발송 시 스풀링 작업을 지원한다. 
 * 
 * @version		
 * @author 		duricat
 *
 */
@Slf4j
public class SingleHoldSpoolTask extends SingleBaseSpoolTask {
	
	
	/**60테이블에서 리스트를 가져오는 쿼리
	 */
	protected static String QUERY_SELECT_QUE_RETRY_LIST = null;
	
	static {
		try {
			QUERY_SELECT_QUE_RETRY_LIST = SqlManager.getQuery("WINDFORCE_COMMON","QUERY_SELECT_ONE_TO_ONE_HOLD_RETRY_LIST");
		}
		catch( Exception ignore ) {
			log.error(ignore.getMessage());
		}
	}
	
	/** Creates a new instance of SingleHoldSpoolTask */
	public SingleHoldSpoolTask() throws Exception {
		super();
	}
	
	public void setTaskProperty(Properties prop){
		this.TASK_PROPERTY = prop;
		
		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		//this.CHANNEL_SEQ = this.TASK_PROPERTY.getProperty( "CHANNEL_SEQ" );
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		
		this.setTaskID( this.POST_ID );
		this.setName( this.POST_ID + "_SingleErrorSpoolTask" );
		
		/**이쿼리를 가지고 리스트를 가져온다.
		 */
		this.SELECT_TARGET_LIST_QUERY = QUERY_SELECT_QUE_RETRY_LIST;
		
		/**리스트에 대한 업데이트는 하지 않으므로 널이다.
		 */
		this.UPDATE_TARGET_LIST_QUERY = null;
		
		/**상위 클래스에서 이거 가지고 업데이트를 해 준다.
		 */
		this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
		
		/**매핑은 따로 추려내야한다.
		 */
		this.APPEND_TOTAL_SPOOL = true;
		
		this.WORK_FILE_ID = this.POST_ID.concat("_real_one_").concat( Cal.getSerialDate() );
		
		/**스풀에 적을 기본적인 사항을 세팅한다.
		 */
		this.SPOOL_ANALYZER.setSendType( "MASS" );// one to one
		this.SPOOL_ANALYZER.setNextSpoolGenerate( "N" );// spool attach
		this.SPOOL_ANALYZER.setLimitDate( "19000101" );
		this.SPOOL_ANALYZER.setPostID( this.POST_ID );
		this.SPOOL_ANALYZER.setListTable( this.LIST_TABLE );
		this.SPOOL_ANALYZER.setStep( 1 );
		
		this.startTaskState = "44";
		this.endSuccessTaskState = "45";
		this.endFailTaskState = "41";
	}
}
