/*
 * @(#)SingleFailOverSpoolTask.java            2004. 11. 30.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.mass.task;

import java.util.Properties;

import pluto.util.Cal;

/**
 * 대량 1-1 메일 중지된 메일 재발송의 스풀링을 지원한다.
 * 
 * @version		
 * @author 		lena
 *
 */
public class SingleFailOverSpoolTask extends SingleBaseSpoolTask {
	
	
	/** Creates a new instance of SingleFailOverSpoolTask */
	public SingleFailOverSpoolTask() throws Exception {
		super();
	}
	
	public void setTaskProperty( Properties prop ) {
		this.TASK_PROPERTY = prop;
		
		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		//this.CHANNEL_SEQ = this.TASK_PROPERTY.getProperty( "CHANNEL_SEQ" );
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		this.WORK_FILE_ID = POST_ID.concat("_real_retry_").concat( Cal.getSerialDate() );
		
		this.REAL_POST_ID = prop.getProperty( "REAL_POST_ID" );
		this.AB_ID        = prop.getProperty( "AB_ID" );
		
		this.setTaskID( this.POST_ID );
		this.setName( this.POST_ID + "_SingleFailOverSpoolTask" );
		
		/**이쿼리를 가지고 리스트를 가져온다.
		 */
		this.SELECT_TARGET_LIST_QUERY = QUERY_SELECT_ONE_TO_ONE_LIST;
		
		/**리스트에 대한 업데이트는 하지 않으므로 널이다.
		 */
		this.UPDATE_TARGET_LIST_QUERY = null;

		/**상위 클래스에서 이거 가지고 업데이트를 해 준다.
		 */
		this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
		
		/**매핑은 따로 추려내야한다.
		 */
		this.APPEND_TOTAL_SPOOL = true;
		
		/**스풀에 적을 기본적인 사항을 세팅한다.
		 */
		this.SPOOL_ANALYZER.setSendType( "MASS" );// one to one
		this.SPOOL_ANALYZER.setNextSpoolGenerate( "Y" );// spool attach
		this.SPOOL_ANALYZER.setLimitDate( this.TASK_PROPERTY.getProperty( "QUE_CLOSE_DATE", Cal.getAddDayDate( 1 ) ) );
		this.SPOOL_ANALYZER.setPostID( this.POST_ID );
		this.SPOOL_ANALYZER.setListTable( this.LIST_TABLE );
		this.SPOOL_ANALYZER.setStep( 0 );
		
		this.startTaskState = "34";
		this.endSuccessTaskState = "36";
		this.endFailTaskState = "41";
	}
}
