/*
 * @(#)SingleBaseSpoolTask.java            2004. 11. 30.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.mass.task;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.parallel.task.AbstractDbSpoolTask;

/**
 * 대량 1-1 메일 기본의 경우 Spool을 생성하는 작업을 지원한다 
 * 
 * @version		
 * @author 		lena
 *
 */
@Slf4j
public class SingleBaseSpoolTask extends AbstractDbSpoolTask {
	
	
	/**스케쥴 테이블 상태값 업데이트 */
	protected static List QUERY_UPDATE_STATE_INFO = null;

	/**60테이블에서 리스트를 가져오는 쿼리 */
	protected static String QUERY_SELECT_ONE_TO_ONE_LIST = null;
	
	/**발송정지 상태를 점검한다.  */
	protected static String QUERY_CHECK_STOP_FLAG = null;
	
	/** 스풀 정보 파일 위치를 넣어주는 쿼리 */
	protected static String QUERY_UPDATE_SPOOL_CONF = null;
	
	/** 스풀 생성 시작해도 되는지 check 하는 쿼리*/
	protected static String QUERY_CHECK_STATUS = null;
	
	/**	병렬발송시 EBAD0070테이블의 spool_conf 파일을 업데이트 하는 쿼리	*/
	protected static String QUERY_UPDATE_PARALLEL_SPOOL_CONF = null;
	
	protected String INSTANCE_QUERY_CHECK_STOP_FLAG = null;
	
	/** 스케쥴 테이블 상태값 업데이트, 상속받은 녀석들은 이것을 알아서 셋팅 해야한다. */
	protected List INSTANCE_QUERY_UPDATE_STATE_INFO = null;
	
	static {
		try {
			QUERY_UPDATE_STATE_INFO = SqlManager.getMultiQuery("WINDFORCE_COMMON","QUERY_UPDATE_STATE_INFO");
			QUERY_SELECT_ONE_TO_ONE_LIST = SqlManager.getQuery("WINDFORCE_COMMON","QUERY_SELECT_ONE_TO_ONE_LIST");
			QUERY_CHECK_STOP_FLAG = SqlManager.getQuery("WINDFORCE_COMMON","QUERY_CHECK_STOP_FLAG");
			QUERY_UPDATE_SPOOL_CONF = SqlManager.getQuery("WINDFORCE_COMMON","QUERY_UPDATE_SPOOL_CONF");
			QUERY_CHECK_STATUS = SqlManager.getQuery("WINDFORCE_COMMON","QUERY_CHECK_STATUS");
			QUERY_UPDATE_PARALLEL_SPOOL_CONF = SqlManager.getQuery("WINDFORCE_COMMON","QUERY_UPDATE_PARALLEL_SPOOL_CONF");
		}
		catch( Exception ignore ) {
			log.error(ignore.getMessage());
		}
	}
	
	/** 시작할 때 20 테이블에서 체크해볼 task state */
	protected String startTaskState = "91";
	
	/** 작업을 성공리에 마쳤을 때 20 테이블에 업데이트 될 task state */
	protected String endSuccessTaskState = "30";
	
	/** 작업이 실패했을 때 20 테이블에 업데이트 될 task state */
	protected String endFailTaskState = "96";
		
	public SingleBaseSpoolTask() throws Exception {
		super();
	}
	
	public void setTaskProperty(Properties prop) {
		
		this.TASK_PROPERTY = prop;
	
		this.POST_ID = prop.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		
		this.LIST_TABLE = prop.getProperty( "LIST_TABLE" );
		this.AB_ID = prop.getProperty("AB_ID");
		this.REAL_POST_ID = prop.getProperty("REAL_POST_ID");
		

		this.setTaskID( POST_ID );
		this.setName( POST_ID + "_SingleBaseSpoolTask" );

		/**이쿼리를 가지고 리스트를 가져온다.
		 */
		this.SELECT_TARGET_LIST_QUERY = QUERY_SELECT_ONE_TO_ONE_LIST;

		/**리스트에 대한 업데이트는 하지 않으므로 널이다.
		 */
		this.UPDATE_TARGET_LIST_QUERY = null;

		/**상위 클래스에서 이거 가지고 업데이트를 해 준다.
		 */
		this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;

		/**매핑은 따로 추려내야한다.
		 */
		this.APPEND_TOTAL_SPOOL = true;

		/**정지를 체크해야 할 쿼리를 지정
		 */
		this.INSTANCE_QUERY_CHECK_STOP_FLAG = QUERY_CHECK_STOP_FLAG;

		this.WORK_FILE_ID = POST_ID.concat("_real_one_").concat( Cal.getSerialDate() );

		/**스풀에 적을 기본적인 사항을 세팅한다.
		 */
		this.SPOOL_ANALYZER.setSendType( "MASS" );// one to one
		this.SPOOL_ANALYZER.setNextSpoolGenerate( "Y" );// spool attach
		this.SPOOL_ANALYZER.setLimitDate( prop.getProperty( "QUE_CLOSE_DATE", Cal.getAddDayDate( 1 ) ) );
		this.SPOOL_ANALYZER.setPostID( POST_ID );
		this.SPOOL_ANALYZER.setListTable( LIST_TABLE );
		this.SPOOL_ANALYZER.setStep( 0 );
	}

	protected void addSpool(Properties prop) throws Exception {
		
		this.SPOOL_ANALYZER.setTokenID( prop.getProperty( "TMS_M_TOKEN" ) );
		this.SPOOL_ANALYZER.setMemberID( prop.getProperty( "TMS_M_ID" ) );
		this.SPOOL_ANALYZER.setMemberName( prop.getProperty( "TMS_M_NAME" ) );
		this.SPOOL_ANALYZER.setMapping( prop.getProperty( "TOTAL_SPOOL_LINE" ) );
		
		appendSpooler( this.SPOOL_ANALYZER.composeSingleRcptSend() );
	}

	/** 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다.
	 * Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error( getName() , thw );
	}
	
	/** 메일의 상태값을 바꾼다.
	 * updateTaskState( __TYPE__ , __STATE__ , "StateUpdate" ) 를 호출한다.
	 */
	protected void updateTaskState( String __TYPE__ , String __STATE__ ) {
		updateTaskState( __TYPE__ , __STATE__ , "StateUpdate" );
	}
	
	/** 메일의 상태값을 바꾸면서 특정 메세지를 같이 남길때 사용한다.
	 * add 2004.11.02
	 */
	protected void updateTaskState( 
			String __TYPE__ , String __STATE__  , String __STATE_MSG__ ) {
			
		this.TASK_PROPERTY.setProperty("UPDATE_JOB_STATUS" , __STATE__ );
	
		// 반복 루틴을 하나의 STMT로 처리하도록 전환 2004.11.02
		eMsConnection emsConnection = null; 
		eMsStatement stmt = null;
		try{
			emsConnection = ConnectionPool.getConnection();
			stmt = emsConnection.createStatement();
		
			// 반복 루틴 내부의 사용이 아니므로 그대로 사용하지만 쿼리를 만드는 것은 버퍼를 사용하도록 전환한다. 2004.11.02
			synchronized( INSTANCE_QUERY_UPDATE_STATE_INFO ){
				for( Iterator iter = this.INSTANCE_QUERY_UPDATE_STATE_INFO.iterator(); iter.hasNext() ; ){
					String query = iter.next().toString();
				
					this.TMP_STRING_BUFFER.setLength( 0 );
					StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , query  , this.TASK_PROPERTY , "${" , "}" , true , false );
					stmt.executeUpdate( this.TMP_STRING_BUFFER.toString() );
				}
			}
		}
		catch( Exception e ){
			log.error( getName() , e );
		}
		finally {		
			
			if(emsConnection != null) {
				emsConnection.recycleStatement( stmt );
				emsConnection.recycle();
			}
			
		}
	}
	
	/**
	 * Start 
	 */
	protected void execute_Startup() throws Exception {

		// 반복 루틴을 하나의 STMT로 처리하도록 전환 2004.11.02
		eMsStatement stmt = null;
		eMsResultSet rs = null;
		
		boolean check = false;
		String status = "";
		try{
			stmt = this.EMS_CONNECTION.createStatement();
		
			// 반복 루틴 내부의 사용이 아니므로 그대로 사용하지만 쿼리를 만드는 것은 버퍼를 사용하도록 전환한다. 2004.11.02
			Properties prop = new Properties();
			prop.setProperty("POST_ID",POST_ID);//AB POST_ID로 변경
			prop.setProperty("LIST_TABLE",this.LIST_TABLE );
			prop.setProperty("REAL_POST_ID", REAL_POST_ID);
			prop.setProperty("AB_ID", AB_ID);
			//prop.setProperty("LIST_TABLE","EMS_MASS_SEND_LIST_" + POST_ID.substring(4, 6));
			//prop.setProperty("STATUS",this.startTaskState);
			
			this.TMP_STRING_BUFFER.setLength( 0 );
			StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , QUERY_CHECK_STATUS  , prop , "${" , "}" , true , false );
			rs = stmt.executeQuery( this.TMP_STRING_BUFFER.toString() );
			
			if(rs.next()) {
				status = rs.getString("JOB_STATUS");
				check = status.equals(this.startTaskState);
				
				//log.debug("baiaba_status: "+status);
				//log.debug("baiaba_this.startTaskState: "+this.startTaskState);
				
				//	타겟 수 (병렬발송에서 쓰임) ..
				try {
					__TARGET_CNT = Integer.parseInt(rs.getString("TARGET_CNT"));
				} catch( Exception ee ) {
					__TARGET_CNT = 0;
				}
			}
			else {
				check = false;
			}
		}
		catch( Exception e ){
			log.error( getName() , e );
			check = false;
		}
		finally {
			if( rs != null ) try { rs.close(); } catch(Exception ex ) {}
			this.EMS_CONNECTION.recycleStatement( stmt );
		}
		
		if(!check) throw new Exception(" INVALID TYPE [" + status + "], NOT STARTED! ");
	}
	
	/**
	 * Finish
	 */
	protected void execute_Finish(boolean success) throws Exception {
		
		super.execute_Finish(success);
				
		if( success ) {
			eMsStatement stmt = null;
			try {
				stmt = this.EMS_CONNECTION.createStatement();
				
				Properties prop = new Properties();
				prop.setProperty("POST_ID",POST_ID);
				prop.setProperty("AB_ID", AB_ID);
				prop.setProperty("REAL_POST_ID", REAL_POST_ID);
				//	병렬 발송 일경우...
				if( PARALLEL_FLAG )	{
					String tmpSvrNm = "";
					for(int i=0;i<PARALLEL_SERVER_NAME_LIST.size();i++) {
						this.TMP_STRING_BUFFER.setLength( 0 );
						tmpSvrNm = (String) PARALLEL_SERVER_NAME_LIST.get(i);
						prop.setProperty("SERVER_ID",tmpSvrNm);
						prop.setProperty("SPOOL_CONF",SpoolInfoManager.getParallelSvrSpoolInfo(POST_ID+"|"+tmpSvrNm));
						
						StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , QUERY_UPDATE_PARALLEL_SPOOL_CONF  , prop , "${" , "}" , true , false );
						
						stmt.executeUpdate( this.TMP_STRING_BUFFER.toString() );
					}
				} else {
					this.TMP_STRING_BUFFER.setLength( 0 );
					prop.setProperty("SERVER_ID","01");		//	병렬이 아닐경우 01 로 셋팅 ...
					prop.setProperty("SPOOL_CONF",SpoolInfoManager.getSpoolInfo(POST_ID).getSpoolInfoPath());
					
					
					StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , QUERY_UPDATE_PARALLEL_SPOOL_CONF  , prop , "${" , "}" , true , false );
					
					stmt.executeUpdate( this.TMP_STRING_BUFFER.toString() );
				}
				//	아래는 일반 발송일 경우이나 20테이블에 spool_conf 는 병렬발송일때는 참조 않기 때문에 else 처리 없이 그냥 둔다.   
				prop.setProperty("SPOOL_CONF",SpoolInfoManager.getSpoolInfo(POST_ID).getSpoolInfoPath());
				this.TMP_STRING_BUFFER.setLength( 0 );
				
				StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , QUERY_UPDATE_SPOOL_CONF  , prop , "${" , "}" , true , false );
				stmt.executeUpdate( this.TMP_STRING_BUFFER.toString() );
			}
			catch( Exception e ){
				log.error( getName() , e );
				success = false;
			}
			finally {
				this.EMS_CONNECTION.recycleStatement( stmt );
			}
		}
		
		if( success ) {
			updateTaskState("",this.endSuccessTaskState);
		}
		else {
			updateTaskState("",this.endFailTaskState);
		}
	}
}
