package venus.spool.mass.task;

import java.sql.SQLException;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.StringConvertUtil;
import venus.spool.auto.task.SmsCampBaseSpoolTask;

/**
 * 피로도 를 체크하여 발송대상자를 필터링한다.<br><br> 
 * 피로도대상자는 98 으로 ERROR_CODE를 업데이트한다.<br><br>
 * 최종적으로 스풀생성단계에서 98은 제외하고 작업한다.
 * @author Lim
 *
 */
@Slf4j
public class RecvFilterPushSpoolTask extends SmsCampBaseSpoolTask {

	/**필터사용여부 확인 */
	protected static String QUERY_SELECT_FILTER_USEYN = null;
	/**피로도대상자 업데이트(98) */
	protected static String QUERY_UPDATE_FATIGUE_LIST_QUERY = null;
	/**피로도대상자 인서트(존재하지않을경우) */
	protected static String QUERY_INSERT_FATIGUE_LIST_QUERY = null;
	/**주기별 피로도 제한건수 */
	protected static String QUERY_SELECT_FATIGUE_PERIOD_LIMIT_CNT = null;
	/**피로도 제한건수(발송건수) 업데이트 */
	protected static String QUERY_UPDATE_FATIGUE_CNT_QUERY = null;
	/**피로도 제한건수 스케쥴에 업데이트 */
	protected static String QUERY_UPDATE_SCHEDULE_FATIGUE_CNT = null;
	
	static {
		try {
			QUERY_SELECT_FILTER_USEYN		= SqlManager.getQuery("FILTER_INFO","QUERY_SELECT_FILTER_USEYN");
			QUERY_UPDATE_FATIGUE_LIST_QUERY	= SqlManager.getQuery("FILTER_INFO","QUERY_UPDATE_FATIGUE_LIST_QUERY");
			QUERY_INSERT_FATIGUE_LIST_QUERY	= SqlManager.getQuery("FILTER_INFO","QUERY_INSERT_FATIGUE_LIST_QUERY");
			QUERY_SELECT_FATIGUE_PERIOD_LIMIT_CNT = SqlManager.getQuery("FILTER_INFO","QUERY_SELECT_FATIGUE_PERIOD_LIMIT_CNT");
			QUERY_UPDATE_FATIGUE_CNT_QUERY	= SqlManager.getQuery("FILTER_INFO","QUERY_UPDATE_FATIGUE_CNT_QUERY");
			QUERY_UPDATE_SCHEDULE_FATIGUE_CNT = SqlManager.getQuery("FILTER_INFO","QUERY_UPDATE_SCHEDULE_FATIGUE_CNT");
		}
		catch( Exception ignore ) {
			log.error(ignore.getMessage());
			System.exit(1);
		}
	}
		
	protected static boolean FATIGUE_USE_YN = false;
	
	
	/**
	 * 기본 생성자
	 * @throws Exception
	 */
	public RecvFilterPushSpoolTask() throws Exception {
		super();
	}

	@Override
	protected void execute_ListLoad(Properties targetProperties) throws Exception {
		this.checkFilterUse(targetProperties);
		
		if ( FATIGUE_USE_YN ) { 
			this.filterFatigueList(targetProperties);
		}
		
		super.execute_ListLoad(targetProperties);
	}

	
	
	/**
	 * 수신거부/피로도 사용여부 세팅
	 * @param TARGET_PROPERTIES
	 * @throws Exception
	 */
	protected void checkFilterUse(Properties targetProperties) throws Exception {
		eMsStatement __SELECT_STATEMENT__ = null;
		eMsResultSet rs = null;
		Exception ex = null;
		try {
			__SELECT_STATEMENT__ = EMS_CONNECTION.createStatement();
			this.TMP_STRING_BUFFER.setLength( 0 );
			StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , QUERY_SELECT_FILTER_USEYN , targetProperties , "${" , "}" , true , false );
			rs = __SELECT_STATEMENT__.executeQuery( this.TMP_STRING_BUFFER.toString() );
			if ( rs.next() ) {				
				FATIGUE_USE_YN = rs.getString( "FATIGUE_USE_YN" ).equals("Y") ? true:false;
			}
		}catch( Exception e ) {
			log.error(e.getMessage());
			ex = e;
			throw ex;
		}finally {
			try{
				if (rs != null) {
					rs.close();
				}
			} catch( Exception e ){}
			if (EMS_CONNECTION != null) {
				EMS_CONNECTION.recycleStatement( __SELECT_STATEMENT__ );
			}			
		}
	}
	
	/**
	 * 피로도리스트 업데이트(35)
	 * @param TARGET_PROPERTIES
	 * @throws Exception
	 */
	protected void filterFatigueList( Properties targetProperties ) throws Exception {
		// 1. 기간별 제한건수 획득
		eMsStatement __SELECT_STATEMENT__ = null;
		eMsResultSet rs = null;
		Exception ex = null;
		try {
			__SELECT_STATEMENT__ = EMS_CONNECTION.createStatement();
			this.TMP_STRING_BUFFER.setLength( 0 );
			StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , QUERY_SELECT_FATIGUE_PERIOD_LIMIT_CNT , targetProperties , "${" , "}" , true , false );
			rs = __SELECT_STATEMENT__.executeQuery( this.TMP_STRING_BUFFER.toString() );
			if(rs.next()){
				targetProperties.setProperty("HOUR_LIMIT",rs.getString("HOUR_LIMIT"));
				targetProperties.setProperty("DAY_LIMIT",rs.getString("DAY_LIMIT"));
				targetProperties.setProperty("WEEK_LIMIT",rs.getString("WEEK_LIMIT"));
				targetProperties.setProperty("MON_LIMIT",rs.getString("MON_LIMIT"));
			}
			
		}catch( Exception e ) {
			log.error(e.getMessage());
			ex = e;
			throw ex;
		}finally {
			try{ 
				if (rs != null) {
					rs.close(); 
				}
			}catch( Exception e ){}
			if (EMS_CONNECTION != null) {
				EMS_CONNECTION.recycleStatement( __SELECT_STATEMENT__ );
			}			
		}
		
		// 2. 제한건수에 맞게 필터링대상자 업데이트
		long sTime = System.currentTimeMillis();
		int fatigueCnt = this.updateFilterList(QUERY_UPDATE_FATIGUE_LIST_QUERY , targetProperties );
		log.error("list update time:["+(System.currentTimeMillis() - sTime)+"] CNT :["+fatigueCnt+"]");
		if ( fatigueCnt < 1 ) {
			log.error( "fatigue list update fail" );
		} else {
			targetProperties.setProperty( "FATIGUE_CNT" , String.valueOf( fatigueCnt ) );
			sTime = System.currentTimeMillis();
			if ( this.updateFilterList( QUERY_UPDATE_SCHEDULE_FATIGUE_CNT , targetProperties) < 1 ) {
				log.error( "fatigue cnt update fail" );
			}
			log.error("schedule update time:["+(System.currentTimeMillis() - sTime)+"]");
		}
		
		// 3. 존재하지않는 대상자 피로도리스트에 업로드
		sTime = System.currentTimeMillis();
		try{
			if ( this.updateFilterList(QUERY_INSERT_FATIGUE_LIST_QUERY , targetProperties ) < 1 ) {
			}
		}catch(Exception e){
			log.error( "fatigue list insert fail", e);
		}
		log.error("fatigue insert time:["+(System.currentTimeMillis() - sTime)+"]");
		
		// 4. 발송 횟수 업데이트(day/week/month)
		sTime = System.currentTimeMillis();
		int fatigueCnt2 = 0;
		try{
			fatigueCnt2 = this.updateFilterList(QUERY_UPDATE_FATIGUE_CNT_QUERY , targetProperties );
			if ( fatigueCnt2 < 1 ) {
				log.error( "fatigue cnt update fail" );
			}
		}catch(SQLException se){
			log.error( "SQLException list insert START", se );
			fatigueCnt2 = this.updateFilterList(QUERY_UPDATE_FATIGUE_CNT_QUERY , targetProperties );
			if ( fatigueCnt < 1 ) {
				log.error( "fatigue cnt update fail" );
			}
			log.error( "SQLException list insert END" );
		}catch(Exception e){
			log.error( "fatigue cnt update fail", e);
		}
		log.error("fatigue update time:["+(System.currentTimeMillis() - sTime)+"] CNT :["+fatigueCnt2+"]");
	}	

	/**
	 * 필터리스트 업데이트
	 * @param query
	 * @param TARGET_PROPERTIES
	 * @return
	 * @throws Exception
	 */
	protected int updateFilterList(String query, Properties targetProperties) throws Exception {
		int successCnt = 0;
		
		eMsStatement	__UPDATE_STATEMENT__ = null;
		Exception ex = null;
		try {
			__UPDATE_STATEMENT__ = EMS_CONNECTION.createStatement();
			
			this.TMP_STRING_BUFFER.setLength( 0 );
			StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , 	query , targetProperties , "${" , "}" , true , false );
			EMS_CONNECTION.setAutoCommit(false);
			successCnt = __UPDATE_STATEMENT__.executeUpdate( this.TMP_STRING_BUFFER.toString() );
			EMS_CONNECTION.commit();
			EMS_CONNECTION.setAutoCommit(true);
		} catch( Exception e ) {
			EMS_CONNECTION.rollback();
			log.error(e.getMessage());
			ex = e;
			throw ex;
		}
		finally {
			EMS_CONNECTION.recycleStatement( __UPDATE_STATEMENT__ );			
		}
		return successCnt;
	}	
	

}
