package venus.spool.mass.task;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import lombok.extern.slf4j.Slf4j;
import pluto.util.Cal;

import venus.spool.auto.basic.BasicDefaultMappingGenerator;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.task.AbstractDbSpoolTask;

@Slf4j
public class PersonalResendSpoolTask extends AbstractDbSpoolTask {

	/*
	 * RESEND 대상이 되는 정보 리스트 
	 */
	protected LinkedList TARGET_INFO_LIST = null;


	/*
	 * Query 
	 */
	protected static String QUERY_SELECT_PERSONAL_RESEND_WORK_INFO = null;
	protected static String QUERY_UPDATE_LIST_STATE_QUERY = null;
	protected static String QUERY_SELECT_LIST_LOAD_QUERY = null;
	protected static String QUERY_SELECT_RESEND_TABLE_INFO = null;
	protected String instance_QUERY_TARGET_TABLE_INFO =null;
	
	//피로도 관련 쿼리 등록
		public static String QUERY_UPDATE_FATIGUE_N_FILTER = null;
			
		public static String QUERY_SELECT_FATIGUE_LIST = null;
		
		public static String QUERY_UPSERT_FATIGUE_LIST = null;
		
		public static String QUERY_UPDATE_SCHD_FILTERED_TARGET = null;
	
	static {
		try {
			QUERY_SELECT_PERSONAL_RESEND_WORK_INFO = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_SELECT_PERSONAL_RESEND_WORK_INFO" );
			QUERY_UPDATE_LIST_STATE_QUERY = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_UPDATE_LIST_STATE_QUERY" );
			QUERY_SELECT_LIST_LOAD_QUERY = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_SELECT_LIST_LOAD_QUERY" );
			QUERY_SELECT_RESEND_TABLE_INFO = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_SELECT_RESEND_TABLE_INFO" );
			
			
			QUERY_UPDATE_FATIGUE_N_FILTER = SqlManager.getQuery("FATIGUE", "QUERY_UPDATE_FATIGUE_N_FILTER");
			
			/** QUERY_SELECT_FATIGUE_LIST  발송시점에 피로도 대상을 추출하여 hashtable에 적제.
			 */
			QUERY_SELECT_FATIGUE_LIST = SqlManager.getQuery("FATIGUE", "QUERY_SELECT_FILTER_USEYN");
			
			QUERY_UPSERT_FATIGUE_LIST = SqlManager.getQuery("FATIGUE", "QUERY_UPSERT_FATIGUE_LIST");
			
			QUERY_UPDATE_SCHD_FILTERED_TARGET = SqlManager.getQuery("FATIGUE","QUERY_UPDATE_SCHD_FILTERED_TARGET");
		}
		catch( Exception e ){
			log.error(e.getMessage());
			System.exit( 1 );
		}
	}
	
	public PersonalResendSpoolTask() throws Exception {

		super( TYPE_INTERVAL , 1 );
		
		this.setName( "PersonalResendSpoolTask" );
		this.setTaskID( "PersonalResendSpoolTask" );
		
		TARGET_INFO_LIST = new LinkedList();
	}

	public static void init( Object tmp ) throws Exception {
		
		//Properties prop = ( Properties )tmp;
	}

	public void execute_initiate() throws Exception {
		super.execute_initiate();
		this.WORK_FILE_ID = "personal_resend_".concat( Cal.getSerialDate() );
		this.SPOOL_ANALYZER.setLimitDate( Cal.getDayDate() );
		this.SPOOL_ANALYZER.setStep( 0 );
	}
		
	public void setTaskProperty( Properties sendInfo ){

		if(this.TASK_PROPERTY == null) {
			this.TASK_PROPERTY = new Properties();
		}
		
		if( sendInfo != null ) {
			this.TASK_PROPERTY.putAll(sendInfo);
		}
		
		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		//this.CHANNEL_SEQ = this.TASK_PROPERTY.getProperty( "CHANNEL_SEQ" );
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		this.WORK_FILE_ID = this.POST_ID.concat("_personal_resend_").concat( Cal.getSerialDate() );
		
		this.setTaskID( this.POST_ID );
		this.setName( this.POST_ID + "_PersonalResendSpoolTask" );
		
		/**이쿼리를 가지고 리스트를 가져온다.
		 */
		this.SELECT_TARGET_LIST_QUERY = QUERY_SELECT_LIST_LOAD_QUERY;
		
		/**리스트에 대한 업데이트는 하지 않으므로 널이다.
		 */
		this.UPDATE_TARGET_LIST_QUERY = QUERY_UPDATE_LIST_STATE_QUERY;
		
		/**대상이 되는 테이블 정보를 읽어오는 쿼리
		 */
		this.instance_QUERY_TARGET_TABLE_INFO = QUERY_SELECT_RESEND_TABLE_INFO;
		
		/** 피로도 테이블 */
		this.SELECT_TARGET_FATIGUE_LIST_QUERY = QUERY_SELECT_FATIGUE_LIST;
		/** 피로도 테이블 */
		this.UPDATE_SCHD_FILTERED_TARGET = QUERY_UPDATE_SCHD_FILTERED_TARGET;
		
		/** 피로도 필터 쿼리 지정*/
		this.UPDATE_FATIGUE_N_FILTER = QUERY_UPDATE_FATIGUE_N_FILTER;
		/** 피로도 테이블 */
		this.UPSERT_FATIGUE_LIST_QUERY =QUERY_UPSERT_FATIGUE_LIST;
		
		
		// 스풀에 적을 기본적인 사항을 세팅한다.
		this.SPOOL_ANALYZER.setSendType( "MASSRESEND" );// one to one
		this.SPOOL_ANALYZER.setNextSpoolGenerate( "Y" );// spool attach
		this.SPOOL_ANALYZER.setLimitDate( Cal.getDayDate() );
		this.SPOOL_ANALYZER.setStep( 0 );
	}
	
	
	public void makeSpoolFile() throws Exception {
		
		eMsStatement __EMS_EXEC_STATEMENT__ = null;
		eMsResultSet RS_SELECTED_SCHEDULE_INFO = null;
		
		LinkedList TARGET_TABLE_LIST = new LinkedList();
		
		if (log.isDebugEnabled())  
				log.debug("CALL GET TARGET TABLE LIST SQL" );
				
		try {
			__EMS_EXEC_STATEMENT__ = EMS_CONNECTION.createStatement();
			
			RS_SELECTED_SCHEDULE_INFO = __EMS_EXEC_STATEMENT__.executeQuery( this.instance_QUERY_TARGET_TABLE_INFO );
			
			while( RS_SELECTED_SCHEDULE_INFO.next() ) {
				Properties prop = new Properties();
				RS_SELECTED_SCHEDULE_INFO.putToMap( prop , false );
				TARGET_TABLE_LIST.addLast( prop );
			}
		}
		catch( Exception e ) {
			log.error(getName(), e);
			throw e;
		}
		finally {
			try{ RS_SELECTED_SCHEDULE_INFO.close(); } catch( Exception ex ){}
			EMS_CONNECTION.recycleStatement( __EMS_EXEC_STATEMENT__ );
		}
		
		String this_day = Cal.getDayDate();
		
		String __SPOOL_FILE_NAME__ = FileElement.CheckSubDirectory( SPOOL_WORKING_DIRECTORY , this_day ) +"/" + this.WORK_FILE_ID + ".spool";
		
		this.SPOOL_FILE_LIST.clear();
		
		this.LIST_APPEND_FLAG = false;
		
		try {
			// 스풀파일을 준비한다.
			openSpooler( __SPOOL_FILE_NAME__ );
			
			for( Iterator iter = TARGET_TABLE_LIST.iterator(); iter.hasNext(); ){
				Properties prop = ( Properties )iter.next();
				/*
				prop.setProperty("WORKDAY",this.TASK_PROPERTY.getProperty("WORKDAY"));
				prop.setProperty("SEQNO",this.TASK_PROPERTY.getProperty("SEQNO"));
				*/
				prop.setProperty("POST_ID",this.TASK_PROPERTY.getProperty("POST_ID"));
				this.execute_ListLoad( prop );
			}
		}
		catch( Exception e ) {
			log.error(getName(), e);
			throw e;
		}
		finally {
			//스풀러 일단 닫고
			closeSpooler();
			
			// 스풀 내용이 없다면 그냥 지워버린다.
			if(!this.LIST_APPEND_FLAG ) {
				deleteSpooler();
				if (log.isDebugEnabled()) log.debug("NO APPEND LIST FILE");
			}
		}
	}
	
	
	protected void makeSpoolInfo() throws Exception {
		
		// String id;
		String mapheader;
		
		this.mailSpoolInfo = new SpoolInfo();
		
		this.mailSpoolInfo.setID( this.POST_ID );
		this.mailSpoolInfo.setSendState( "PERSONAL_RESEND" );
		
		/*
		 * 		mapheader =  (this.MAPPING_HEADER_INFO==null)?"map_":this.MAPPING_HEADER_INFO.getProperty(this.POST_ID);
		*		this.mailSpoolInfo.setMappingHeader((mapheader==null)?getMappingHeader():mapheader );

		 */
		/*by Rough (2005.02.24)
		 * AUTO001에 매핑헤더필드를 넣을 필요가 있을때(ETA)
		 */
		
		mapheader =  (this.MAPPING_HEADER_INFO==null)?this.TASK_PROPERTY.getProperty( "MAPPINGHEADER" ):this.MAPPING_HEADER_INFO.getProperty(this.POST_ID);
		
		
		if(mapheader == null) mapheader = "map_";
		
		//log.debug("MAPPING HEADER : " + mapheader);
		
		//TODO 
		//mapheader == null 이 아니기에 getMappingHeader()가 작동하지 않음
		//this.mailSpoolInfo.setMappingHeader((mapheader==null)?getMappingHeader():mapheader );
		this.mailSpoolInfo.setMappingHeader(mapheader);
		
		this.mailSpoolInfo.setSpoolDelimit( eMsSystem.getProperty("spool.delimit","|"));
		String value = TASK_PROPERTY.getProperty("SERIAL_DELIM");
		this.mailSpoolInfo.setSerialDelimit( (value==null)?"|":value);
		this.mailSpoolInfo.setSpoolFilesInfo( SPOOL_FILE_LIST );		

		/**기본 매핑 생성 Instance 생성
		 */
		/*BasicDefaultMappingGenerator __DEFAULT_MAPPING_GENERATOR__ = new BasicDefaultMappingGenerator();
		__DEFAULT_MAPPING_GENERATOR__.process( this.TASK_PROPERTY );
		this.mailSpoolInfo.setDefaultMapping( __DEFAULT_MAPPING_GENERATOR__.getMapOfDefaultMapping() );
		this.mailSpoolInfo.setDefaultHashMapping( __DEFAULT_MAPPING_GENERATOR__.getMapOfDefaultHashMapping() );
		*/
		SpoolInfo oldSpInfo = SpoolInfoManager.getSpoolInfo(this.POST_ID );
		this.mailSpoolInfo.setDefaultMapping( oldSpInfo.getDefaultMapping()  );
		this.mailSpoolInfo.setDefaultHashMapping( oldSpInfo.getDefaultHashMapping() );
		
		// 발송을 위해 memory에만 적재하면 되고 xml 파일은 만들 필요 없다. 
		SpoolInfoManager.putSpoolInfo( this.mailSpoolInfo, true );
		
		// 이것은 발송을 위해 셋팅한다.
		// SPOOL POPPER가 사용할 것임.
		if ( SPOOL_FILE_LIST != null && SPOOL_FILE_LIST.size() > 0 ) {
			this.mailSpoolInfo.setSpoolFilesInfo( SPOOL_FILE_LIST );
		}
	}
	
	protected void addSpool(Properties prop) throws Exception {
		this.SPOOL_ANALYZER.setPostID( prop.getProperty( "POST_ID" ) );
		this.SPOOL_ANALYZER.setListTable( prop.getProperty( "LIST_TABLE" ) );
		this.SPOOL_ANALYZER.setTokenID( prop.getProperty( "TMS_M_TOKEN" ) );
		this.SPOOL_ANALYZER.setMemberID( prop.getProperty( "TMS_M_ID" ) );
		this.SPOOL_ANALYZER.setMemberName( prop.getProperty( "TMS_M_NAME" ) );
		this.SPOOL_ANALYZER.setSecureFlag( prop.getProperty( "SECURE_FLAG" ) );
		this.SPOOL_ANALYZER.setAdditionalValue( prop.getProperty( "ADDITIONAL_INFO" ) );
		this.SPOOL_ANALYZER.setMapping( prop.getProperty( "MAPPING" ) );
		
		appendSpooler( this.SPOOL_ANALYZER.composeSingleRcptSend() );
	}

	protected boolean execute_StopCheck() {
		log.info("CHECK STOP SIGNAL" );
		return false;
	}

	protected void processSyntaxErrorSpool(String spool) throws Exception {
	}
	
}
