/*
 * @(#)QueRetrySpoolTask.java            2005. 03. 15.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
package venus.spool.mass.task;

import java.util.Properties;

import pluto.config.SqlManager;
import lombok.extern.slf4j.Slf4j;
import pluto.util.Cal;
import venus.spool.auto.task.SmsCampBaseSpoolTask;
/**
 * @author 러프
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
@Slf4j
public class KakaoQueRetrySpoolTask extends SmsCampBaseSpoolTask {

	protected static String QUERY_SELECT_QUE_RETRY_LIST = null;
	
	static {
		try {
			QUERY_SELECT_QUE_RETRY_LIST = SqlManager.getQuery("COMMON","QUERY_SELECT_QUE_RETRY_LIST");
			
			/** QUERY_UPDATE_FATIGUE_N_FILTER  발송시점에 피로도 필터링하여 Spool 생성 하지 않고 필터한다. ( ERROR_CODE 98 )
			 */
			QUERY_UPDATE_FATIGUE_N_FILTER = SqlManager.getQuery("FATIGUE", "QUERY_UPDATE_FATIGUE_N_FILTER");
			
			/** QUERY_SELECT_FATIGUE_LIST  발송시점에 피로도 대상을 추출하여 hashtable에 적제.
			 */
			QUERY_SELECT_FATIGUE_LIST = SqlManager.getQuery("FATIGUE", "QUERY_SELECT_FILTER_USEYN");
			
			QUERY_UPSERT_FATIGUE_LIST = SqlManager.getQuery("FATIGUE", "QUERY_UPSERT_FATIGUE_LIST");
			
			QUERY_UPDATE_SCHD_FILTERED_TARGET = SqlManager.getQuery("FATIGUE","QUERY_UPDATE_SCHD_FILTERED_TARGET");
			
			QUERY_SELECT_BASE_DIVIDE_SEND_LIST = SqlManager.getQuery("COMMON","QUERY_SELECT_BASE_DIVIDE_SEND_LIST");
		}
		catch( Exception ignore ) {
			log.error(ignore.getMessage());
		}
	}
	
	/** Creates a new instance of SingleErrorSpoolTask */
	public KakaoQueRetrySpoolTask() throws Exception {
		super();
	}
	
	public void setTaskProperty(Properties prop){
		this.TASK_PROPERTY = prop;

		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		this.WORK_FILE_ID = this.POST_ID.concat("_real_error_").concat( Cal.getSerialDate() );
		
		this.setTaskID( this.POST_ID );
		this.setName( this.POST_ID + "_AutoErrorSendTask" );
		
		/**이쿼리를 가지고 리스트를 가져온다.
		 */
		this.SELECT_TARGET_LIST_QUERY = QUERY_SELECT_QUE_RETRY_LIST;
		
		/**리스트에 대한 업데이트는 하지 않으므로 널이다.
		 */
		this.UPDATE_TARGET_LIST_QUERY = null;

		/**상위 클래스에서 이거 가지고 업데이트를 해 준다.
		 */
		this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
		
		/** 피로도 테이블 */
		this.SELECT_TARGET_FATIGUE_LIST_QUERY = QUERY_SELECT_FATIGUE_LIST;
		/** 피로도 테이블 */
		this.UPDATE_SCHD_FILTERED_TARGET = QUERY_UPDATE_SCHD_FILTERED_TARGET;
		
		/** 피로도 필터 쿼리 지정*/
		this.UPDATE_FATIGUE_N_FILTER = QUERY_UPDATE_FATIGUE_N_FILTER;
		/** 피로도 테이블 */
		this.UPSERT_FATIGUE_LIST_QUERY =QUERY_UPSERT_FATIGUE_LIST;
		
		/**스풀에 적을 기본적인 사항을 세팅한다.
		 */
		this.SPOOL_ANALYZER.setSendType( "MASS" );// one to one
		this.SPOOL_ANALYZER.setNextSpoolGenerate( "Y" );// spool attach
		this.SPOOL_ANALYZER.setLimitDate( this.TASK_PROPERTY.getProperty( "QUE_CLOSE_DATE", Cal.getAddDayDate( 1 ) ) );
		this.SPOOL_ANALYZER.setPostID( this.POST_ID );
		this.SPOOL_ANALYZER.setListTable( this.LIST_TABLE );
		this.SPOOL_ANALYZER.setStep( 1 );
	}

}
