
 
package venus.spool.mass.task;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import venus.spool.common.basic.NoTargetListException;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.task.AbstractDbSpoolTask;
/**
 * Class description :
 * 
 * @version		
 * @author 		lena
 *
 */
@Slf4j
public class CampTestSpoolTask extends AbstractDbSpoolTask {
	
	protected static List QUERY_UPDATE_STATE_START = null;
	
	protected static List QUERY_UPDATE_STATE_END = null;
	
	protected static List QUERY_UPDATE_STATE_INFO = null;

	public static String QUERY_SELECT_BASE_SEND_LIST = null;
	
	public static String QUERY_CHECK_STOP_FLAG = null;

	/** */
	protected static String QUERY_UPDATE_SPOOL_CONF = null;
	
	protected String INSTANCE_QUERY_CHECK_STOP_FLAG = null;
	
	/** 스케쥴 테이블 상태값 업데이트, 상속받은 녀석들은 이것을 알아서 셋팅 해야한다. */
	protected List INSTANCE_QUERY_UPDATE_STATE_INFO = null;
	
	
	private static String QUERY_SELECT_TEST_EMAIL_LIST = null;
	
	protected List	TEST_EMAIL_LIST	= new LinkedList();
	
	/*
	SELECT TOP 2 
	 */
	private static String QUERY_SELECT_TEST_CNT_MYSQL = null;
	private static String QUERY_SELECT_TEST_CNT_MSSQL = null;
	private static String QUERY_SELECT_TEST_CNT_ORACLE = null;
	
	static {
		try {
			// 발송대상
			QUERY_SELECT_TEST_EMAIL_LIST = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_SELECT_TEST_EMAIL_LIST");
			
			//기본 스플생성 쿼리
			QUERY_SELECT_BASE_SEND_LIST = SqlManager.getQuery("COMMON","QUERY_SELECT_BASE_SEND_LIST_TEST");
			
			//1건을 가져오는 쿼리 => 최초 자동용이기 때문에 두가지 가 존재한다. (자동은 어떤 DB도 접근해서 가져옴)
			QUERY_SELECT_TEST_CNT_MYSQL = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_SELECT_TEST_CNT_MYSQL");
			QUERY_SELECT_TEST_CNT_MSSQL = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_SELECT_TEST_CNT_MSSQL");
			QUERY_SELECT_TEST_CNT_ORACLE = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_SELECT_TEST_CNT_ORACLE");
			
		}
		catch( Exception e ){
			log.error(e.getMessage());
			System.exit( 1 );
		}
	}
	
	/** Creates a new instance of CampTestSpoolTask */
	public CampTestSpoolTask() throws Exception{
		super();
	}
	
	@Override
	public void setTaskProperty( Properties prop ) {
		
		if(this.TASK_PROPERTY == null) {
			this.TASK_PROPERTY = new Properties();
		}
		
		if( prop != null ) {
			this.TASK_PROPERTY.putAll(prop);
		}

		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		this.WORK_FILE_ID = this.POST_ID.concat("_test_one_").concat( Cal.getSerialDate() );
		
		this.setTaskID( this.POST_ID );
		this.setName( this.POST_ID + "_CampTestSpoolTask" );
		
		
		
		/**이쿼리를 가지고 리스트를 가져온다.
		 */
		ConnectInfo conInfo = null;
		try {
			conInfo = eMsConnection.getConnectInfo("ems");
		} catch (Exception e1) {
			log.error("connection error", e1);
		}
		String __EXEC_TARGET_QUERY__ = null;
		
		if(conInfo != null) {
			if(conInfo.getDB_URL().indexOf("oracle")>0){
				// sample count 적용 : rownum<= 5 를 추가
				__EXEC_TARGET_QUERY__ = setQuerySample_oracle(QUERY_SELECT_BASE_SEND_LIST);
			}else if(conInfo.getDB_URL().indexOf("mysql")>0){
				// sample count 적용 : limit 2를 추가
				__EXEC_TARGET_QUERY__ = setQuerySample_mysql(QUERY_SELECT_BASE_SEND_LIST);
			}else{
				// sample count 적용 : top 2를 추가
				__EXEC_TARGET_QUERY__ = setQuerySample_mssql(QUERY_SELECT_BASE_SEND_LIST);
			}
		}
		
		
		this.SELECT_TARGET_LIST_QUERY = __EXEC_TARGET_QUERY__;
		
		/**리스트에 대한 업데이트는 하지 않으므로 널이다.
		 */
		this.UPDATE_TARGET_LIST_QUERY = null;
		
		/**매핑은 따로 추려내야한다.
		 */
		this.APPEND_TOTAL_SPOOL = true;
		
		/**스풀에 적을 기본적인 사항을 세팅한다.
		 */
		this.SPOOL_ANALYZER.setSendType( "TEST" );// one to one
		this.SPOOL_ANALYZER.setNextSpoolGenerate( "Y" );// spool attach
		this.SPOOL_ANALYZER.setLimitDate( this.TASK_PROPERTY.getProperty( "QUE_CLOSE_DATE", Cal.getAddDayDate( 1 ) ) );
		this.SPOOL_ANALYZER.setPostID( this.POST_ID );
		this.SPOOL_ANALYZER.setListTable( this.LIST_TABLE );
		this.SPOOL_ANALYZER.setStep( 0 );

		try {
			getTestTargetList();
		} catch (Exception e) {
			log.error("Exception",e);
			log.error(e.getMessage());
		}
		
	}
	
	/**
	 * mysql 쿼리에서 샘플데이터를 가져오기위한 쿼리 수정 부분이다.
	 * @param query
	 * @return
	 */
	protected static String setQuerySample_mysql(String query){
		StringBuffer buffer = new StringBuffer();
		buffer.append(query);
		buffer.append(" ");
		buffer.append(QUERY_SELECT_TEST_CNT_MYSQL);
		
		return buffer.toString() ;
	}
	
	/**
	 * mssql 쿼리에서 샘플데이터를 가져오기위한 쿼리 수정 부분이다.
	 * @param query
	 * @return
	 */
	protected static String setQuerySample_mssql(String query){
		String select_str = "SELECT";
		String distinct_str = "DISTINCT";
		String uQuery = query.toUpperCase();
		
		int point_select   = uQuery.indexOf(select_str);
		int point_distinct = uQuery.indexOf(distinct_str);
		
		int point  = 0;
		if(point_distinct >=0 ){
			point      = point_distinct + distinct_str.length();
		}else{
			point      = point_select   + select_str.length();
		}
		
		StringBuffer buffer = new StringBuffer();
		buffer.append(query.substring(0, point));
		buffer.append(" ");
		buffer.append(QUERY_SELECT_TEST_CNT_MSSQL.trim());
		buffer.append(" ");
		buffer.append(query.substring(point));
		
		return buffer.toString();
	}
	/**
	 * Oracle에서 샘플데이터를 가져오기 위한 쿼리 수정 부분이다.
	 * @param query
	 * @return
	 */
	protected static String setQuerySample_oracle(String query){
		StringBuffer buffer = new StringBuffer();
		buffer.append(query);
		buffer.append(" and ");
		buffer.append(QUERY_SELECT_TEST_CNT_ORACLE);
		
		return buffer.toString() ;
	}
	
	/**
	 * 발송대상 리스트를 가져온다
	 * @throws Exception
	 */
	protected synchronized void getTestTargetList() throws Exception {
		StringBuffer  buffer           = new StringBuffer(512);
		eMsConnection EMS_CONNECTION   = null;
		eMsStatement  SELECT_STATEMENT = null;
		eMsResultSet  rs               = null;
		String        test_email       = "";
		
		try {
			EMS_CONNECTION = ConnectionPool.getConnection();
			SELECT_STATEMENT = EMS_CONNECTION.createStatement();
			
			StringConvertUtil.ConvertString(buffer,QUERY_SELECT_TEST_EMAIL_LIST, this.TASK_PROPERTY, "${","}", true, false);
			log.info("email test list :"+buffer.toString());			
			rs = SELECT_STATEMENT.executeQuery(buffer.toString());

			while (rs.next()) {
				test_email = rs.getString("TEST_EMAIL");
				
				if(test_email.indexOf("::")>-1){
					String[] emailList = test_email.split("::");
					int size = emailList.length;
					for(int i=0; i< size; i++){
						this.TEST_EMAIL_LIST.add(emailList[i]);
					}
				}else{
					this.TEST_EMAIL_LIST.add(test_email);
				}
			}
		} catch (Exception e) {
			throw e;
		} finally {
			try { if (rs != null) { rs.close(); } } catch (Exception ignore) { }
			EMS_CONNECTION.recycleStatement(SELECT_STATEMENT);
			SELECT_STATEMENT = null;
			EMS_CONNECTION.recycle();
		}
		
		if( TEST_EMAIL_LIST.size() < 1 ) {
			throw new NoTargetListException("NO TARGET LIST => " + this.TASK_PROPERTY.getProperty("SEND_LIST"));
		}
		
	}
	
	protected void addSpool(Properties prop) throws Exception {
		
		String m_email = "";
		for (Iterator iter = TEST_EMAIL_LIST.iterator(); iter.hasNext();) {
			m_email = iter.next().toString();
			this.SPOOL_ANALYZER.setTokenID( m_email );
			this.SPOOL_ANALYZER.setMemberID( prop.getProperty( "TMS_M_ID" ) );
			this.SPOOL_ANALYZER.setMemberName( prop.getProperty( "TMS_M_NAME" ) );
			this.SPOOL_ANALYZER.setMapping( prop.getProperty( "TOTAL_SPOOL_LINE" ) );
			appendSpooler( this.SPOOL_ANALYZER.composeSingleRcptSend() );
		}
	}

	/**
	 * 스풀 정보를 SpoolInfo 객체에 담는다.
	 * SpoolInfoManager에 담는다
	 * @throws Exception
	 */
	protected void makeSpoolInfo() throws Exception {
		
		// 만들어진 스풀 정보를 SpoolInfo 객체에 담는다.
		this.mailSpoolInfo = new SpoolInfo();
		this.mailSpoolInfo.setID( TASK_PROPERTY.getProperty("POST_ID") );
		this.mailSpoolInfo.setSendState( TASK_PROPERTY.getProperty("SEND_STATE") );
		this.mailSpoolInfo.setMappingHeader( getMappingHeader() );
		this.mailSpoolInfo.setSpoolDelimit( eMsSystem.getProperty("spool.delimit","|"));
		String value = TASK_PROPERTY.getProperty("SERIAL_DELIM");
		this.mailSpoolInfo.setSerialDelimit( (value==null)?"|":value);
		this.mailSpoolInfo.setSpoolFilesInfo( SPOOL_FILE_LIST );

		SpoolInfoManager.registSpoolInfo( this.mailSpoolInfo );
	}
		
	/** 최초 시작할때 호출. 일단 아무것도 하지 않는다.
	 */
	protected void execute_Startup() throws Exception {
	}
	
	/** 리스트를 다 뿌리고 나올때 실행
	 */
	protected void execute_Finish(boolean success) throws Exception {
		log.debug("[CampTestSpoolTask]...Finish");
	}
}
