/*
 * @(#)BulkTestSpoolTask.java            2004. 11. 30.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.mass.task;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

import pluto.io.FileElement;
import lombok.extern.slf4j.Slf4j;
import pluto.util.Cal;
import pluto.util.StringUtil;
/**
 * Class description :
 * 
 * @version		
 * @author 		lena
 *
 */
@Slf4j
public class BulkTestSpoolTask extends SingleTestSpoolTask {
	
	
	
	
	/** Creates a new instance of BulkTestSpoolTask */
	public BulkTestSpoolTask() throws Exception{
		super();
	}
	
	public void setTaskProperty(Properties prop){
		
		this.TASK_PROPERTY = prop;
		
		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		
		this.setTaskID( this.POST_ID.concat("_TEST") );
		
		this.setName( this.POST_ID + "_BulkTestSpoolTask" );
		
		this.setSeq(this.TASK_PROPERTY.getProperty("SEQ"));
		
		this.WORK_FILE_ID = this.POST_ID.concat("_bulk_test_").concat( Cal.getSerialDate() );
		
		this.SPOOL_ANALYZER.setSendType( "MTEST" );// one to one
		this.SPOOL_ANALYZER.setNextSpoolGenerate( "N" );// spool attach
		this.SPOOL_ANALYZER.setLimitDate( "19000101" );
		this.SPOOL_ANALYZER.setPostID( this.POST_ID );
		this.SPOOL_ANALYZER.setListTable( this.LIST_TABLE );
		this.SPOOL_ANALYZER.setStep( 0 );
	}
		
	/** 
	 * 리스트 로드
	 */
	public void makeSpoolFile() throws Exception {
		
		String this_day = Cal.getDayDate();
		
		String __WORK_FILE_NAME__ = 
				FileElement.CheckSubDirectory(SPOOL_WORKING_DIRECTORY, this_day )
				+ "/"
				+ this.WORK_FILE_ID 
				+ "_test.spool";
				
		if (log.isDebugEnabled())  
				log.debug( "spool filename:" + __WORK_FILE_NAME__ );
				
		openSpooler( __WORK_FILE_NAME__ );
		
		List __TARGET_EMAILS__ = StringUtil.toStringList( 
				TASK_PROPERTY.getProperty("TEST_LIST") , ":" , new LinkedList() );
		
		if( __TARGET_EMAILS__ == null || __TARGET_EMAILS__.size() < 1 ){
			throw new RuntimeException("NO TEST LIST...");
		}
		
		for( Iterator iter = __TARGET_EMAILS__.iterator() ; iter.hasNext() ; ) {
			String _TARGET_EMAIL_ = iter.next().toString();
			
			// 이메일 주소가 유효한지를 검사한다.
			if( StringUtil.isError( _TARGET_EMAIL_ ) ) continue;
				
			this.SPOOL_ANALYZER.setTokenID( _TARGET_EMAIL_ );
			this.SPOOL_ANALYZER.setMemberID( "testID" );
			
			appendSpooler( this.SPOOL_ANALYZER.composeMultiRcptSend() );
		}
		
		//스풀러 일단 닫고
		closeSpooler();
	}
}
