/*
 * @(#)BulkErrorSpoolTask.java            2004. 11. 30.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.mass.task;

import java.util.Properties;

import pluto.config.SqlManager;
import lombok.extern.slf4j.Slf4j;
import pluto.util.Cal;
/**
 * Class description :
 * 
 * @version		
 * @author 		duricat
 *
 */
@Slf4j
public class BulkHoldSpoolTask extends BulkBaseSpoolTask {
	
	
	// 60테이블에서 리스트를 가져오는 쿼리
	protected static String QUERY_SELECT_BULK_REQUE_LIST = null;
	
	static {
		try {
			QUERY_SELECT_BULK_REQUE_LIST = SqlManager.getQuery("WINDFORCE_COMMON","QUERY_SELECT_BULK_HOLD_LIST");
		}
		catch( Exception ignore ) {
			log.error(ignore.getMessage());
		}
	}
	
	
	
	/** Creates a new instance of BulkHoldSpoolTask */
	public BulkHoldSpoolTask() throws Exception {
		super();
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	
	public void setTaskProperty(Properties prop) {
		
		this.TASK_PROPERTY = prop;
		
		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		this.WORK_FILE_ID = this.POST_ID.concat("_real_bulk_").concat( Cal.getSerialDate() );
		
		this.setTaskID( this.POST_ID );
		this.setName( this.POST_ID + "_BulkErrorSpoolTask" );
		
		/**이쿼리를 가지고 리스트를 가져온다.
		 */
		this.SELECT_TARGET_LIST_QUERY = QUERY_SELECT_BULK_REQUE_LIST;
		
		/**리스트에 대한 업데이트는 하지 않으므로 널이다.
		 */
		this.UPDATE_TARGET_LIST_QUERY = null;
		
		/**상위 클래스에서 이거 가지고 업데이트를 해 준다.
		 */
		this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
		
		/**스풀에 적을 기본적인 사항을 세팅한다.
		 */
		this.SPOOL_ANALYZER.setSendType( "BULK" );// multiple rcpt
		this.SPOOL_ANALYZER.setNextSpoolGenerate( "N" );// spool attach
		this.SPOOL_ANALYZER.setLimitDate( this.TASK_PROPERTY.getProperty( "QUE_CLOSE_DATE", Cal.getAddDayDate( 1 ) ) );
		this.SPOOL_ANALYZER.setPostID( this.POST_ID );
		this.SPOOL_ANALYZER.setListTable( this.LIST_TABLE );
		this.SPOOL_ANALYZER.setStep( 1 );

		this.startTaskState = "44";
		this.endSuccessTaskState = "45";
		this.endFailTaskState = "41";
	}
}

