/*
 * @(#)BasicDefaultMappingGenerator.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package venus.spool.mass.basic;

import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.lang.Name;
import pluto.lang.eMsLocale;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import venus.spool.common.basic.DefaultMappingGenerator;

/**
 * Class description :
 * 
 * @version
 * @author joo
 *  
 */
@Slf4j
public class MassBasicDefaultMappingGenerator extends Name implements DefaultMappingGenerator {

	protected static String			QUERY_SELECT_MASS_KEY_VELUE_MAPPING_SQL			= null;

	static {
		QUERY_SELECT_MASS_KEY_VELUE_MAPPING_SQL = SqlManager.getQuery("DEFAULT_MAPPING", "QUERY_SELECT_MASS_KEY_VELUE_MAPPING_SQL");
	}

	/**
	 * 데이터 베이스 연결
	 */
	protected eMsConnection			EMS_CONNECTION									= null;

	/**
	 * 실행 쿼리를 매핑하는 정보 Hash
	 */
	protected Properties			SCHEDULE_INFO									= null;

	/**
	 * @{}로 매핑되는 기본 실행쿼리 매핑을 저장하는 MAP
	 */
	protected Map					DEFAULT_MAPPPING_MAP							= new Hashtable();


	protected ByteArrayOutputStream	INNER_BYTE_ARRAY_STREAM							= null;

	protected StringBuffer		TMP_STRING_BUFFER								= null;

	/** Creates a new instance of BasicDefaultMappingGenerator */
	public MassBasicDefaultMappingGenerator() {
		INNER_BYTE_ARRAY_STREAM = new ByteArrayOutputStream(1024);
	}

	protected void inner_init(Properties prop) throws Exception {
		// 기본 쿼리 매핑정보를 클리어 하고 다시 세팅을 준비한다.
		this.SCHEDULE_INFO = prop;

		setName(this.SCHEDULE_INFO.getProperty("POST_ID") + "_MassBasicDefaultMappingGenerator");
	}

	
	
	public void process(Properties prop) throws Exception {
		inner_init(prop);
		
		//구역을 정하지 않았다면 그냥 넘어간다.
		String area_id = this.SCHEDULE_INFO.getProperty("AREA_ID", "-");
		if(area_id.equals("-") || StringUtil.isNull(area_id)){
			return ;
		}
		
		try {
			log.debug(getName() + " Request Connection");
			EMS_CONNECTION = ConnectionPool.getConnection();
			log.debug(" Get Connetion " + EMS_CONNECTION.getName());
		}
		catch(Exception e) {
			if( EMS_CONNECTION != null ) {
				EMS_CONNECTION.destroy();
			}

			log.debug(getName() + " Request Connection Error");

			throw e;
		}

		try {
			this.TMP_STRING_BUFFER = new StringBuffer(256);


			/* 첫번째 컬럼을 키로하여 매핑을 하는 녀석을 세팅한다. */
			if (log.isDebugEnabled()) {
				log.debug("exec_setKeyValueDefaultMapping START");
			}
			exec_setKeyValueDefaultMapping();
			if (log.isDebugEnabled()) {
				log.debug("exec_setKeyValueDefaultMapping END");
			}

		}
		catch(Exception e) {
			throw e;
		}
		finally {
			this.TMP_STRING_BUFFER = null;
			EMS_CONNECTION.recycle();
			if (log.isDebugEnabled()) {
				log.debug("default_mapping", this.DEFAULT_MAPPPING_MAP.toString());
			}
		}
	}

	/**
	 * @{} 매핑 정보를 반환
	 */
	public Map getMapOfDefaultMapping() {
		return this.DEFAULT_MAPPPING_MAP;
	}
	
	public Map getMapOfDefaultHashMapping() {
		return null;
	}

	
	/* 하나의 쿼리에서 컬럼이름을 키로한 매핑을 세팅 */
	protected void exec_setKeyValueDefaultMapping() throws Exception {
		eMsResultSet rs = null;
		eMsStatement stmt = null;

		/**
		 * KEY VALUE에서 파일(URL)경로의 내용이 VALUE일 경우에 치환하는 로직 삽입
		 */
		String __KEY_STRING__ = null;
		String __VALUE_STRING__ = null;
		String __EXEC_TARGET_QUERY__ = null;

		try {
			//get connection
			stmt = EMS_CONNECTION.createStatement();
			
			//TODO joo 쿼리 조합이 필요함
			this.TMP_STRING_BUFFER.setLength(0);
			StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_SELECT_MASS_KEY_VELUE_MAPPING_SQL, this.SCHEDULE_INFO, "${", "}", true, false);
			__EXEC_TARGET_QUERY__ = this.TMP_STRING_BUFFER.toString();
			
			if (log.isDebugEnabled()) {
				log.debug("=======================query===========================\n"+__EXEC_TARGET_QUERY__);
				log.debug(getName() + ".setKeyValueDefaultMapping() exe query:" + __EXEC_TARGET_QUERY__);
			}

			rs = stmt.executeQuery(__EXEC_TARGET_QUERY__);
			if (log.isDebugEnabled()) {
				log.debug(getName() + ".setKeyValueDefaultMapping() exe query:[OK]");
			}

			while (rs.next()) {
				__KEY_STRING__ = rs.getString(1);
				__VALUE_STRING__ = rs.getString(2);
				
				//test
				if (log.isDebugEnabled()) {
					log.debug("[KEY]"+__KEY_STRING__+"[VALUE]"+__VALUE_STRING__);
				}

				if( __VALUE_STRING__.startsWith("URL:") ) {
					synchronized (INNER_BYTE_ARRAY_STREAM) {
						INNER_BYTE_ARRAY_STREAM.reset();
						FileElement.putFileBodyToStream(__VALUE_STRING__.substring(4), INNER_BYTE_ARRAY_STREAM);
						this.DEFAULT_MAPPPING_MAP.put(__KEY_STRING__, INNER_BYTE_ARRAY_STREAM.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET));
					}
				}
				else {
					this.DEFAULT_MAPPPING_MAP.put(__KEY_STRING__, __VALUE_STRING__);
				}
			}
		}catch(Exception e) {
			log.error(__EXEC_TARGET_QUERY__, e);
			throw e;
		}
		finally {
			try {
				rs.close();
			}catch(Exception ignore) {}
			EMS_CONNECTION.recycleStatement( stmt );
		}

		if (log.isDebugEnabled()) {
			log.debug("setKeyValueDefaultMapping END");
		}
	}



}
