/*
 * @(#)AbstractDbSpoolTask.java            2004. 12. 9.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package venus.spool.common.task;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.StringConvertUtil;

/**
 * Spool Task 중 Connection 맺고 끊는 작업을 정의한다.
 * 
 * @version
 * @author lena
 *  
 */
@Slf4j
public abstract class AbstractDbSpoolTask extends SpoolControlTask {
	
	protected final int				COMMIT_INTEVER				=1000;
	protected final int				UPDATE_ADDBATCH_CNT			=1000;
	
	/** 지정되는 일의 정보 */
	protected String				LIST_TABLE					= null;

	/** 공통으로 사용하는 Connection */
	protected eMsConnection			EMS_CONNECTION				= null;

	/** Task를 실행하면서 공용을 사용할 StringBuffer 대부분은 쿼리를 전환할때 사용된다. */
	protected StringBuffer			TMP_STRING_BUFFER			= null;

	/** 대상자를 가져오는 쿼리 */
	protected String				SELECT_TARGET_LIST_QUERY	= null;
	
	/** 분할 발송 대상자를 가져오는 쿼리 */
	protected String				SELECT_DIVIDE_TARGET_LIST_QUERY	= null;
	
	/** 발송시점에 MKT FLAG Y => N 으로 변경된 대상 에러코드 업데이트.	 */
	protected String				UPDATE_MKT_N_FILTER = null;
	
	/** 발송시점에 피로도 필터링하여 Spool 생성 하지 않고 필터한다. */
	protected String				UPDATE_FATIGUE_N_FILTER = null;
	/** 발송시점에 피로도 테이블에 upsert 하는 쿼리 */
	protected String				UPSERT_FATIGUE_LIST_TABLE = null;
	
	/** 발송시점에 MKT FLAG Y => N 으로 변경된 대상 스케쥴 업데이트	 */
	protected String				UPDATE_SCHD_FILTERED_TARGET = null;
	
	/** 대상자 업데이트 하는 쿼리 */
	protected String				UPDATE_TARGET_LIST_QUERY	= null;
	
	protected String				UPSERT_FATIGUE_LIST_QUERY	= null;
	
	//protected Hashtable				FATIGUE_LIST = null;
	/** 피로도를 가져오는 쿼리 */
	protected String				SELECT_TARGET_FATIGUE_LIST_QUERY	= null;
	/** 피로도 대상 /리스트 테이블 / 업데이트 관련 리스트  */
	private List<String>			FILTER_TARGET_LIST 					= null;
	/** 피로도를 월별 upsert 저장 리스트  */
	private List<String>			UPSERT_DAY_TARGET_LIST 					= null;
	/** 피로도를 월별 upsert 저장 리스트  */
	private List<String>			UPSERT_MONTH_TARGET_LIST 					= null;
	/** 피로도 완료 후 스케줄 업데이트 조건 */
	private boolean					FILTER_UPDATE_SCHD_FLAG				= false;
	
	/** Creates a new instance of AbstractDbSpoolTask */
	public AbstractDbSpoolTask() throws Exception {
		super(TYPE_TRANSACTION, DEFAULT_EXECUTE_INTERVAL);
	}

	/** Creates a new instance of AbstractDbSpoolTask */
	public AbstractDbSpoolTask(short type) throws Exception {
		super(type, DEFAULT_EXECUTE_INTERVAL);
	}

	/** Creates a new instance of AbstractDbSpoolTask */
	public AbstractDbSpoolTask(short type, long interval) throws Exception {
		super(type, interval);
	}

	/**
	 * <br>
	 * Task를 초기화하는 로직을 구현한다. <br>
	 * 발송 로직에서 최초로 구현된다. 하위에서 상속 받는 녀석들이 override 할때는 <br>
	 * super.execute_initiate() 를 반드시 호출해줘야한다. <br>
	 * Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록 되어있다.
	 */
	public void execute_initiate() throws Exception {
		super.execute_initiate();

		if (log.isDebugEnabled()) {
			log.debug(" Request Connection");
		}
		EMS_CONNECTION = ConnectionPool.getConnection();
		if (log.isDebugEnabled()) {
			log.debug(" Get-Connetion " + EMS_CONNECTION.getName());
		}

		// 공용 StringBuffer 초기화 add 2004.11.02
		this.TMP_STRING_BUFFER = new StringBuffer(1024);
		this.FILTER_TARGET_LIST = new ArrayList<String>();
		this.UPSERT_MONTH_TARGET_LIST = new ArrayList<String>();
		this.UPSERT_DAY_TARGET_LIST = new ArrayList<String>();
		//this.FATIGUE_LIST = new Hashtable();
	}

	/**
	 * <br>
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. <br>
	 * Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ <br>
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {

		log.error(getName(), thw);

		//REPORT 데이터베이스 커넥션을 가져오는 과정에서 에러가 발생하였습니다.
		//if( !( thw instanceof SQLException ) ) {
		//	Reporter.report(this.POST_ID,getName(),"mailsendtask.init.err",thw);
		//}
	}

	/**
	 * <br>
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. <br>
	 * 할당받은 자원을 free 시키는 로직을 구현한다. <br>
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 <br>
	 * 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {

		if( EMS_CONNECTION != null ) {
			EMS_CONNECTION.recycle();
		}

		// 공용 StringBuffer 반환 add 2004.11.02
		this.TMP_STRING_BUFFER = null;
		//this.FATIGUE_LIST.clear();
	}

	/**
	 * 리스트 로드
	 */
	protected void execute_ListLoad(Properties TARGET_PROPERTIES) throws Exception {
		String postId=TARGET_PROPERTIES.getProperty("POST_ID");
		String send_state=TARGET_PROPERTIES.getProperty("SEND_STATE","TEST");
		log.info("spool make start [postId:{}]",postId);
		/* 리스트 생성이 끝났기 때문에 ... 데이터 베이스에서 해당 사항을 읽어와 스풀을 만든다. */
		eMsStatement __SELECT_STATEMENT__ = null;
		eMsStatement __SELECT_FATIGUE_STATEMENT__ = null;
		eMsStatement __UPDATE_STATEMENT__ = null;
		eMsResultSet rs = null;
		eMsResultSet fatigueResultSet = null;

		Exception ex = null;
		
		//발송제한 ---
		eMsPreparedStatement PS_SELECT_SEND_LIMIT_VALUE = null;
		eMsPreparedStatement PS_UPDATE_SEND_RESULT      = null;
		eMsPreparedStatement PS_INSERT_SEND_LIMIT_VALUE = null;
		eMsPreparedStatement PS_UPDATE_SEND_LIMIT_VALUE = null;
		
		try {
			__SELECT_STATEMENT__		 = EMS_CONNECTION.createStatement();
			__SELECT_FATIGUE_STATEMENT__ = EMS_CONNECTION.createStatement();
			__UPDATE_STATEMENT__ 		 = EMS_CONNECTION.createStatement();
							
			int spoolLimit = Integer.parseInt(TARGET_PROPERTIES.getProperty("DIVIDE_CNT","-1"));
			
			if (spoolLimit == -1 
					|| "N".equals(TARGET_PROPERTIES.getProperty("DIVIDE_SEND_USE_YN","N"))) {
				spoolLimit = SPOOL_LIMIT;
			}
			
			this.TMP_STRING_BUFFER.setLength(0);
			
			log.info("TARGET_PROPERTIES : {}" , TARGET_PROPERTIES);
			log.info("TARGET_PROPERTIES_TEST : {}" , this.TASK_PROPERTY );
			
			if ("Y".equals(FATIGUE_USE_YN)) {
				if("Y".equals(TARGET_PROPERTIES.getProperty("FILTER_USE_YN", "N")) && !send_state.equals("TEST")){
					log.info("SELECT_TARGET_FATIGUE_LIST_QUERY : {}",SELECT_TARGET_FATIGUE_LIST_QUERY);
					StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, SELECT_TARGET_FATIGUE_LIST_QUERY, TARGET_PROPERTIES, "${", "}", true, false);
					log.info("fatigueQuery {}",this.TMP_STRING_BUFFER);
					fatigueResultSet = __SELECT_FATIGUE_STATEMENT__.executeQuery(this.TMP_STRING_BUFFER.toString());
					while(fatigueResultSet.next()){
						TARGET_PROPERTIES.setProperty("DAY_LIMIT", fatigueResultSet.getString("FATIGUE_DAY_LIMIT"));
						TARGET_PROPERTIES.setProperty("MONTH_LIMIT", fatigueResultSet.getString("FATIGUE_MONTH_LIMIT"));
					}
					this.TMP_STRING_BUFFER.setLength(0);
				}
			}

			//FATIGUE TABLE SETTING
			if(postId!= null && !send_state.equals("TEST")){
			TARGET_PROPERTIES.setProperty("FATIGUE_DAY_TABLE", getFatigueListTableName(this.CHANNEL_TYPE,"DAY"));
			TARGET_PROPERTIES.setProperty("FATIGUE_MONTH_TABLE", getFatigueListTableName(this.CHANNEL_TYPE,"MONTH"));
			}
			//fatigue table check
			
			if ("Y".equals(TARGET_PROPERTIES.getProperty("DIVIDE_SEND_USE_YN", "N"))) {
				String pkIndexName = "PK_"+TARGET_PROPERTIES.getProperty("LIST_TABLE").substring(4);
				TARGET_PROPERTIES.setProperty("PK_INDEX", pkIndexName);
				TARGET_PROPERTIES.setProperty("SPOOL_LIMIT", String.valueOf(spoolLimit));
				
				StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, SELECT_DIVIDE_TARGET_LIST_QUERY, TARGET_PROPERTIES, "${", "}", true, false);
			} else {	// 분할 발송이 아닌경우는 무조건 처음부터 spool을 생성해야 함
				String pkIndexName = "PK_"+TARGET_PROPERTIES.getProperty("LIST_TABLE").substring(4);
				TARGET_PROPERTIES.setProperty("PK_INDEX", pkIndexName);
				StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, SELECT_TARGET_LIST_QUERY, TARGET_PROPERTIES, "${", "}", true, false);
			}
			
			log.info("TARGET_PROPERTIES : {}",TARGET_PROPERTIES);
			
			log.info("SELECT_TARGET_LIST_QUERY : {} ", TMP_STRING_BUFFER.toString());
			
			rs = __SELECT_STATEMENT__.executeQuery(this.TMP_STRING_BUFFER.toString());

			Properties TARGET_INFO = new Properties();
					
			boolean isCamp = false;
			isCamp = "Y".equalsIgnoreCase(TARGET_PROPERTIES.getProperty("CAMP_YN","N")) ? true:false;
			int filterCnt = 0;
			//마케팅 플래그가 변동되어 발송에서 제외된 대상 리스트
			List<String> filteredMemberId = new ArrayList<String>();
			
			List<Properties> listTargetInfo = new ArrayList<Properties>();
			//피로도 필터링된 내역을 저장한다.
			while (rs.next()) {
				
				if(isCamp && "N".equalsIgnoreCase(rs.getString("MKT_FLAG"))
						&& "Y".equalsIgnoreCase(TARGET_PROPERTIES.getProperty("MKT_YN"))){
					filteredMemberId.add(rs.getString("TMS_M_ID"));
					continue;
				}
				//피로도 필터링
				if ("Y".equals(FATIGUE_USE_YN)) {
					if(!send_state.equals("TEST")){
						if("Y".equalsIgnoreCase(TARGET_PROPERTIES.getProperty("FILTER_USE_YN","N"))
								
								&& (Integer.parseInt(rs.getString("DAY_CNT")) >= Integer.parseInt(TARGET_PROPERTIES.getProperty("DAY_LIMIT","0"))
								|| Integer.parseInt(rs.getString("MONTH_CNT")) >= Integer.parseInt(TARGET_PROPERTIES.getProperty("MONTH_LIMIT","0")))){
								String memberId = rs.getString("TMS_M_ID");
								filterCnt += updateFatigueList(memberId, this.UPDATE_FATIGUE_N_FILTER, false,TARGET_PROPERTIES.getProperty("SITE_ID"));
								continue;
						}
					}
				}

				String memberId = "";
				if(rs.getString("TMS_M_ID").indexOf("_")>0){
					memberId = rs.getString("TMS_M_ID").split("_")[0];
				}else{
					memberId = rs.getString("TMS_M_ID");
				}
				
				if ("Y".equals(FATIGUE_USE_YN)) {
					if(postId != null && !send_state.equals("TEST")){
						upsertFatigueList(this.UPSERT_DAY_TARGET_LIST,memberId, TARGET_PROPERTIES.getProperty("SITE_ID"), this.UPSERT_FATIGUE_LIST_QUERY, "DAY", true , false);
						upsertFatigueList(this.UPSERT_MONTH_TARGET_LIST,memberId, TARGET_PROPERTIES.getProperty("SITE_ID"), this.UPSERT_FATIGUE_LIST_QUERY, "MONTH", true , false);
					}
				}
	
				TARGET_INFO.clear();
				rs.putToMap(TARGET_INFO, APPEND_TOTAL_SPOOL);
				
				
				/*
				// 리스트 쿼리에 대한 Row Patch 중 업데이트를 할 것이 있으면 다음 로직을 탄다. 2004.11.02
				if( this.UPDATE_TARGET_LIST_QUERY != null ) {

					this.TMP_STRING_BUFFER.setLength(0);
					StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.UPDATE_TARGET_LIST_QUERY, TARGET_INFO, "${", "}", true, false);

					if( __UPDATE_STATEMENT__.executeUpdate(this.TMP_STRING_BUFFER.toString()) < 1 ) {
						log.error("list update fail");
						continue;
					}
				}
						
				addSpoolCount++;
				// 일정 수가 넘으면 파일을 바꿔준다.
				if( this.SPOOL_ATTACH_COUNT++ > spoolLimit ) {
					this.SPOOL_ATTACH_COUNT = 0;
					String nextSpoolFileName = openNextSpooler();
					log.debug("SWITCH SPOOL", nextSpoolFileName);
				}

				// 스풀을 작성한다.
				addSpool(TARGET_INFO);
				
				*/
				if( this.UPDATE_TARGET_LIST_QUERY != null ) {
					Properties resultProp = new Properties();
					rs.putToMap(resultProp, false);
					listTargetInfo.add(resultProp);
					if (listTargetInfo.size() % 1000 == 0) {
						listTargetInfo = this.updateBatchSendList(listTargetInfo, spoolLimit);
						for (Properties targetInfo:  listTargetInfo) {
							addSpoolCount++;
							if( this.SPOOL_ATTACH_COUNT++ > spoolLimit ) {
								this.SPOOL_ATTACH_COUNT = 0;
								String nextSpoolFileName = openNextSpooler();
								log.debug("SWITCH SPOOL", nextSpoolFileName);
							}

							// 스풀을 작성한다.
							addSpool(targetInfo);
						}
						listTargetInfo.clear();
					}
				} else {
					addSpoolCount++;
					// 일정 수가 넘으면 파일을 바꿔준다.
					if( this.SPOOL_ATTACH_COUNT++ > spoolLimit ) {
						this.SPOOL_ATTACH_COUNT = 0;
						String nextSpoolFileName = openNextSpooler();
						log.debug("SWITCH SPOOL", nextSpoolFileName);
					}

					// 스풀을 작성한다.
					addSpool(TARGET_INFO);
				}
				this.LIST_APPEND_FLAG = true;
			}
			
			if (listTargetInfo.size() > 0) {
				listTargetInfo = updateBatchSendList(listTargetInfo, spoolLimit);
				for (Properties targetInfo:  listTargetInfo) {
					addSpoolCount++;
					if( this.SPOOL_ATTACH_COUNT++ > spoolLimit ) {
						this.SPOOL_ATTACH_COUNT = 0;
						String nextSpoolFileName = openNextSpooler();
						log.debug("SWITCH SPOOL", nextSpoolFileName);
					}

					// 스풀을 작성한다.
					addSpool(targetInfo);
				}
				listTargetInfo.clear(); 
			}
			
			
			if (TARGET_INFO != null) {
				lastSpoolMemberId = TARGET_INFO.getProperty("TMS_M_ID", "0");
			}
			log.info("make spool end [lastMemberId:"+lastSpoolMemberId+", addSpoolCount:"+addSpoolCount+"]");
			this.FILTER_UPDATE_SCHD_FLAG	= true;
			// 제외된 대상 업데이트 처리
			if(!filteredMemberId.isEmpty()){
				Properties UPDATE_INFO = new Properties();
				UPDATE_INFO.setProperty("LIST_TABLE", this.LIST_TABLE);
				UPDATE_INFO.setProperty("POST_ID", this.POST_ID);
				for(String memberId : filteredMemberId){
					UPDATE_INFO.setProperty("MEMBER_ID", memberId);
					this.TMP_STRING_BUFFER.setLength(0);
					StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.UPDATE_MKT_N_FILTER, UPDATE_INFO, "${", "}", true, false);
					
					if( __UPDATE_STATEMENT__.executeUpdate(this.TMP_STRING_BUFFER.toString()) < 1 ) {
						log.error("MKT_FLAG Y=>N Changed Target User Filter Update Fail / MemberId : " + memberId);
						continue;
					}
					
				}
				
				//스케줄 카운트를 업데이트 위한 Clear 처리 UPDATE_INFO Property 에 필요한 값 이전에 세팅처리 되있음. 카운트값만 별도 추가.
				UPDATE_INFO.setProperty("FILTER_CNT", filteredMemberId.size()+"");
				this.TMP_STRING_BUFFER.setLength(0);
				StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.UPDATE_SCHD_FILTERED_TARGET, UPDATE_INFO, "${", "}", true, false);
				if( __UPDATE_STATEMENT__.executeUpdate(this.TMP_STRING_BUFFER.toString()) < 1 ) {
					log.error("CAMP SCHD FILTER CNT UPDATE FAIL / FILTER_CNT :  " + filteredMemberId.size() );
//					
				}
			}
			
			if ("Y".equals(FATIGUE_USE_YN)) {
				//피로도 관련 로직
				if(!this.UPSERT_DAY_TARGET_LIST.isEmpty()){
					upsertFatigueList(this.UPSERT_DAY_TARGET_LIST, null, TARGET_PROPERTIES.getProperty("SITE_ID"), this.UPSERT_FATIGUE_LIST_QUERY, "DAY", true, true);
				}
				if(!this.UPSERT_MONTH_TARGET_LIST.isEmpty()){
					upsertFatigueList(this.UPSERT_MONTH_TARGET_LIST, null, TARGET_PROPERTIES.getProperty("SITE_ID"), this.UPSERT_FATIGUE_LIST_QUERY, "MONTH", true, true);
				}
				if(!this.FILTER_TARGET_LIST.isEmpty()){
					filterCnt += updateFatigueList(null,this.UPDATE_FATIGUE_N_FILTER, true, TARGET_PROPERTIES.getProperty("SITE_ID"));
				}
				if(FILTER_UPDATE_SCHD_FLAG && postId != null && !send_state.equals("TEST")){
					log.info("FATIGUE FILTER START");
					Properties UPDATE_INFO = new Properties();
					UPDATE_INFO.setProperty("LIST_TABLE", this.LIST_TABLE);
					UPDATE_INFO.setProperty("POST_ID", this.POST_ID);
					UPDATE_INFO.setProperty("CHANNEL_TYPE", this.CHANNEL_TYPE);
					UPDATE_INFO.setProperty("WORKDAY", TARGET_PROPERTIES.getProperty("WORKDAY","0"));
					UPDATE_INFO.setProperty("SEQNO", TARGET_PROPERTIES.getProperty("SEQNO","0"));
					//스케줄 카운트를 업데이트 위한 Clear 처리 UPDATE_INFO Property 에 필요한 값 이전에 세팅처리 되있음. 카운트값만 별도 추가.
					UPDATE_INFO.setProperty("FILTER_CNT", filterCnt+"");
					this.TMP_STRING_BUFFER.setLength(0);
					StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.UPDATE_SCHD_FILTERED_TARGET, UPDATE_INFO, "${", "}", true, false);
					log.info("FILTER_UPDATE_SCHD_FLAG!!! {}",this.TMP_STRING_BUFFER.toString());
					if( __UPDATE_STATEMENT__.executeUpdate(this.TMP_STRING_BUFFER.toString()) < 1 ) {
						log.error("CAMP SCHD FILTER CNT UPDATE FAIL / FILTER_CNT :  {} " , filterCnt);
//						
					}
					log.info("FATIGUE FILTER END (update filterCnt : {})",filterCnt);
				}
			}
		}
		catch(Exception e) {			
			log.error("Exception" ,e);
			log.info(e.toString());
			ex = e;
			throw ex;
		}
		finally {
			log.info("spool make end [postId:{}"+TARGET_PROPERTIES.getProperty("POST_ID")+"]");
			try {
				if(rs != null){rs.close();}
				if(fatigueResultSet != null){fatigueResultSet.close();}
			}
			catch(Exception e) {
			}
			
			if(PS_SELECT_SEND_LIMIT_VALUE!=null){
				PS_SELECT_SEND_LIMIT_VALUE.close();
				PS_SELECT_SEND_LIMIT_VALUE = null;
			}
			if(PS_UPDATE_SEND_RESULT!=null){
				PS_UPDATE_SEND_RESULT.close();
				PS_UPDATE_SEND_RESULT = null;
			}
			if(PS_INSERT_SEND_LIMIT_VALUE!=null){
				PS_INSERT_SEND_LIMIT_VALUE.close();
				PS_INSERT_SEND_LIMIT_VALUE = null;
			}
			if(PS_UPDATE_SEND_LIMIT_VALUE!=null){
				PS_UPDATE_SEND_LIMIT_VALUE.close();
				PS_UPDATE_SEND_LIMIT_VALUE = null;
			}
			

			EMS_CONNECTION.recycleStatement(__UPDATE_STATEMENT__);
			EMS_CONNECTION.recycleStatement(__SELECT_FATIGUE_STATEMENT__);
			EMS_CONNECTION.recycleStatement(__SELECT_STATEMENT__);						
		}
	}
	
	protected int updateFatigueList( String memberId, String query ,boolean lastFlag, String SiteId) throws SQLException{
		int filterCnt = 0;
		if(memberId != null){
			this.FILTER_TARGET_LIST.add(memberId);
		}
		if(this.FILTER_TARGET_LIST.size() >= COMMIT_INTEVER || lastFlag){
			eMsConnection con = null;
			eMsPreparedStatement psUpdateFatigueList = null;
			Properties prop = new Properties();
			prop.clear();
			prop.setProperty("POST_ID", this.POST_ID);
			prop.setProperty("SITE_ID", SiteId);
			prop.setProperty("CHANNEL_TYPE", this.CHANNEL_TYPE);
			query = query.replace("${LIST_TABLE}", this.LIST_TABLE);
			
			try {
				
				con = ConnectionPool.getConnection();
				psUpdateFatigueList = con.prepareStatement(query, "${", "}");
				con.setAutoCommit(false);
				for(String targetMemberId : this.FILTER_TARGET_LIST){
					prop.setProperty("MEMBER_ID", targetMemberId);
					psUpdateFatigueList.addBatch(prop);
					filterCnt ++; 
				}
				psUpdateFatigueList.executeBatch();
			} catch (Exception e) {
				con.rollback();
				filterCnt = 0;
				log.debug(e.toString());
				log.debug("CATCH LOGIC!!!! START :  {}",filterCnt);
				for(String targetMemberId : this.FILTER_TARGET_LIST){
					prop.setProperty("MEMBER_ID", targetMemberId);
					try {
						filterCnt += psUpdateFatigueList.executeUpdate(prop);
						con.commit();
					} catch (Exception e2) {
						log.info(e2.toString());
					}
				}
				log.info("CATCH LOGIC!!!! END :  {}",filterCnt);
			} finally {
				if(psUpdateFatigueList != null){psUpdateFatigueList.close();}
				if(con != null){
					con.commit();
					con.setAutoCommit(true);
					con.close();
					}
			}
			this.FILTER_TARGET_LIST.clear();
			log.debug("FATIGUE TARGET UPDATE SEND_LIST CNT : {}", filterCnt);
		}
		return filterCnt;
	}
	
	protected int upsertFatigueList(List<String> targetList, String memberId, String SiteId, String query , 
			String dateType, boolean useYn, boolean lastYn) throws SQLException{
		int filterCnt = 0;
		if(useYn){
			if(memberId != null){
				targetList.add(memberId);
			}
			if(targetList.size() >= COMMIT_INTEVER || lastYn){
				eMsConnection con = null;
				//eMsStatement sUpsertFatigueList = null;
				eMsPreparedStatement sUpsertFatigueList = null;
				Properties prop = new Properties();
				prop.clear();
				prop.setProperty("CHANNEL_TYPE", this.CHANNEL_TYPE);
				prop.setProperty("SITE_ID", SiteId);
				//StringBuffer targetQuery = new StringBuffer();
				if(dateType.equals("DAY")){
					prop.setProperty("FATIGUE_DATE", this.POST_ID.substring(0, 8));
				}else if(dateType.equals("MONTH")){
					prop.setProperty("FATIGUE_DATE", this.POST_ID.substring(0, 6));
				}
				//prop.setProperty("FATIGUE_TABLE", getFatigueListTableName(this.CHANNEL_TYPE, dateType));
				query = query.replace("${FATIGUE_TABLE}", getFatigueListTableName(this.CHANNEL_TYPE, dateType));
				try {
					con = ConnectionPool.getConnection();
					//sUpsertFatigueList = con.createStatement();
					sUpsertFatigueList = con.prepareStatement(query, "${", "}");
					con.setAutoCommit(false);
					for(String targetMemberId : targetList){
						//targetQuery.setLength(0);
						prop.setProperty("MEMBER_ID", targetMemberId);
						//StringConvertUtil.ConvertString( targetQuery , 	query , prop , "${" , "}" , true , false );
						sUpsertFatigueList.addBatch(prop);
						filterCnt ++ ;
						//filterCnt += sUpsertFatigueList.executeUpdate(targetQuery.toString());
						//filterCnt = sUpsertFatigueList.executeBatch();
					}
					sUpsertFatigueList.executeBatch();
				} catch (Exception e) {
					con.rollback();
					filterCnt = 0;
					log.debug(e.toString());
					log.debug("CATCH LOGIC!!!! START :  {}",filterCnt);
					for(String targetMemberId : targetList){
						try{
						//targetQuery.setLength(0);
						prop.setProperty("MEMBER_ID", targetMemberId);
						//StringConvertUtil.ConvertString( targetQuery , 	query , prop , "${" , "}" , true , false );
						filterCnt += sUpsertFatigueList.executeUpdate(prop);;
						con.commit();
						}catch(Exception ex){
							log.info("error :  {}",ex.toString());
						}
					}
					log.debug("CATCH LOGIC!!!! END :  {}",filterCnt);
					
				} finally {
					con.commit();
					con.setAutoCommit(true);
					con.recycleStatement(sUpsertFatigueList);
					con.recycle();
				}
				targetList.clear();
				log.info("FATIGUE LIST UPSERT CNT : {}", filterCnt);
			}
		}
		return filterCnt;
	}
	protected String getFatigueListTableName(String ChannelType , String dateType){
		String targetFatigueListTable = "";
		log.info("ChannelType {} , dateType {}", ChannelType, dateType  );
		switch (ChannelType) {
		case "EM":
			if(dateType.equals("DAY")){
				targetFatigueListTable = "TMS_FATIGUE_EMAIL_DAY_LIST";
			}else if(dateType.equals("MONTH")){
				targetFatigueListTable = "TMS_FATIGUE_EMAIL_MONTH_LIST";
			}
			break;
		case "SM":
			if(dateType.equals("DAY")){
				targetFatigueListTable = "TMS_FATIGUE_SMS_DAY_LIST";
			}else if(dateType.equals("MONTH")){
				targetFatigueListTable = "TMS_FATIGUE_SMS_MONTH_LIST";
			}
			break;
		case "KA":
			if(dateType.equals("DAY")){
				targetFatigueListTable = "TMS_FATIGUE_KAKAO_DAY_LIST";
			}else if(dateType.equals("MONTH")){
				targetFatigueListTable = "TMS_FATIGUE_KAKAO_MONTH_LIST";
			}	
			break;
		case "PU":
			if(dateType.equals("DAY")){
				targetFatigueListTable = "TMS_FATIGUE_PUSH_DAY_LIST";
			}else if(dateType.equals("MONTH")){
				targetFatigueListTable = "TMS_FATIGUE_PUSH_MONTH_LIST";
			}
			break;

		default:
			if(dateType.equals("DAY")){
				targetFatigueListTable = "TMS_FATIGUE_DAY_LIST";
			}else if(dateType.equals("MONTH")){
				targetFatigueListTable = "TMS_FATIGUE_MONTH_LIST";
			}
			break;
		}
		return targetFatigueListTable;
	}
	
	
	public List<Properties> updateBatchSendList(List<Properties> list, int spoolLimit) throws Exception {
		int insertCnt = 0;
		eMsConnection conn = null;
		eMsPreparedStatement ps = null;
		try {
			conn = ConnectionPool.getConnection();
			conn.setAutoCommit(false);
			String query = this.UPDATE_TARGET_LIST_QUERY.replace("${LIST_TABLE}", this.LIST_TABLE);
			ps = conn.prepareStatement(query, "${", "}");
			for (Properties map : list) {
				insertCnt++;
				ps.addBatch(map);
			}
			ps.executeBatch();
			conn.commit();
		} catch (Exception e) {
			log.error("error:",e);
			conn.rollback();
			insertCnt = 0;
			
			int size = list.size();
			for (int i=size-1; i>=0; i--) {
				try {
					insertCnt += ps.executeUpdate(list.get(size));
				} catch (Exception ee) {
					list.remove(i);
				}
			}			
		} finally {
			if(ps != null){
				conn.recycleStatement(ps);
			}
			if(conn != null){
				conn.commit();
				conn.setAutoCommit(true);
				conn.recycle();
			}
		}
		log.info("updateBatchSendList Cnt:{}",  insertCnt);
		return list;
	}		
	
	public static void main(String args[]) {
		List<Properties> list = new ArrayList<Properties>() ;
		Properties prop = new Properties();
		prop.put("WORKDAY", "2020");
		prop.put("TMS_M_ID", "test19218_4300547");
		list.add(prop);
		prop = new Properties();
		prop.put("WORKDAY", "2020");
		prop.put("TMS_M_ID", "test192185_4300547");
		list.add(prop);
		
		
		for (Properties data : list) {
			System.out.println(data.toString());
		}
		
		
		
	}
}