/*
 * @(#)StringPopper.java            2004. 11. 30.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.common.popper;

import java.io.IOException;

/**
 * <br>라인 단위로 파일을 읽는다.
 * <br>한 파일을 다 읽으면 다음 파일로 넘어간다. 
 * 
 * @version		
 * @author 		dragon
 *
 */
public class StringPopper extends Popper {
	
	
	/** Creates new StringPopper */
	public StringPopper() {
	}
	
	/** 다음의 대상이 되는 Person을 반환한다.
	 * @return 대상의 Person 을 반환하며 존재하지 않을 경우 null을 반환
	 */
	public Object next()  throws Exception {
		
		String readLine = read_next();
		
		if( readLine == null  ) {
			if( check_next() ) {
				readLine = read_next();
			}
			else {
				return null;
			}
		}
		
		return readLine;
	}
	
	/** 현재 작업파일에서 한 라인을 읽어서 반환을 하고
	 * 길이가 0 일경우 다음 라인을 읽는다.
	 * 파일의 마지막일 경우 길이 0 의 스트링을 반환한다.
	 * @return 다음의 0 보다 큰 스트링
	 * 마지막일 경우 길이 0 의 라인을 반환
	 * @throws IOException
	 */
	protected String read_next() throws IOException {
		
		String returnValue = null;
		boolean ready = false;
		
		try {
			ready = this.innerReader.ready();
		}
		catch( IOException e ) {
			return null;
		}
		
		if( ready ) {
			returnValue = this.innerReader.readLine();
		}
		
		return returnValue;
	}
	
	/** 진행에 문제가 없는지를 체크한다.
	 * next() 에서 Exception 이 발생하였을 경우 검증을 수행
	 * @return true : 이상없음<br>
	 * false : 이상있음
	 */
	public boolean check() {
		return true;
	}
}
