/*
 * @(#)Popper.java            2004. 11. 30.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.common.popper;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

import pluto.compress.ZipFileManager;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.io.eMsFileReader;
import lombok.extern.slf4j.Slf4j;
import pluto.util.StringUtil;
import venus.spool.auto.task.AutoBaseSpoolTask;

/**
 * 스풀 파일 집합에서 스풀 내용을 하나씩 꺼내는 법을 제공한다. 
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public abstract class Popper extends Object {
	
	private static String class_name = null;
	
	private Properties task_prop = null;
	
	private static String db_driver = "";
	private static String db_url = "";
	private static String db_id = "";
	private static String db_pw = "";
	private static String filter_backup_path = "";
	private static String spool_filter_path = "";
	
	private static String server_id = "";
	
	private static String R_STATE = "20"; //예약 플래그.
	private static int MEMBER_ID_POINT = 11; //스풀에서 고객 정보의 위치.
	
	
	private int total_deny_cnt = 0;
	/** 초기화 한다.<br>
	 * target.class : 실제 구현된 Popper Class Name
	 * @param prop 초기화 파라미터
	 * @throws Exception 초기화 에러
	 */
	
	/*
	 * 
	 * StringUtil.java
	 * 
	 */
	public static final void ConvertString( StringBuffer tmpBuffer , String src,Properties map,String start,String end, boolean query , boolean empty ) {
		if( src == null ) return;
		if( map == null ){
			tmpBuffer.append( src );
			return;
		}
		
		int idx1 = 0 ;
		int idx2 = 0;
		int idx3 = 0;
		
		String key = null;
		Object value = null;
		
		while( true ) {
			idx1 = src.indexOf(start,idx3);
			if( idx1 < 0 ) break;
			
			idx2 = src.indexOf(end,idx1 + start.length());
			if( idx2 < 0 ) break;
			
			key = src.substring( idx1 + start.length() , idx2 );
			value = map.getProperty( key );
			
			tmpBuffer.append( src.substring(idx3,idx1) );
			if( value == null ){
				if( empty ){
					tmpBuffer.append( start );
					tmpBuffer.append( key );
					tmpBuffer.append( end );
				}
			}
			else{
				if( query ){
					ConvertString( tmpBuffer , value.toString() , "'" , "''");
				}
				else{
					tmpBuffer.append( value.toString() );
				}
			}
			
			idx3 = idx2 + end.length();
		}
		
		tmpBuffer.append( src.substring(idx3) );
		
		return;
	}
	
	
	public static final void ConvertString( StringBuffer tmpBuffer , String source,String target,String dest) {
		if( source == null ) return;
		
		int idx1 = 0;
		int idx2 = 0;
		
		while( true ) {
			idx1 = source.indexOf( target , idx2 );
			
			if( idx1 < 0 ) break;
			
			tmpBuffer.append( source.substring( idx2 , idx1 ) );
			tmpBuffer.append( dest );
			
			idx2 = idx1 + target.length();
		}
		
		tmpBuffer.append( source.substring( idx2) );
		
		return;
	}
	
	
	
	public void setTaskProp(Properties prop){
		task_prop = prop;
	}//동기화 해야함.
	
	public synchronized static void init(Object prop) throws Exception {
		Properties tmp = (Properties)prop;
		class_name = tmp.getProperty( "target.class" );
		Class.forName( class_name ).newInstance();
		
		db_driver = tmp.getProperty( "db.driver" );
		db_url = tmp.getProperty( "db.url" );
		db_id = tmp.getProperty( "db.id" );
		db_pw = tmp.getProperty( "db.pw" );
		filter_backup_path = tmp.getProperty( "back.spool.path" ); //추후 폴더 변경시.
		spool_filter_path =tmp.getProperty( "spool.filter.path" ); // 필터링 된 고객 리스트 파일 정보.
		server_id = tmp.getProperty("server.id");
	}
	
	
	
	/** 등록된 Popper Instance를 반환한다.
	 * @return Popper Instance
	 */
	public synchronized static Popper getInstance() {
		try {
			return (Popper)(Class.forName( class_name ).newInstance() );
		}
		catch( Exception e) {
			return null;
		}
	}
	
	protected eMsFileReader innerReader = null;
	protected String dir = null;
	protected String[] files = null;
	protected int file_index = 0;
	
	/** 기본 생성자
	 */
	protected Popper() {
	}
	
	/** Popper를 초기화 한다.
	 * @param base 기본 디렉토리 만일 null일 경우는 file을 full path로 간주한다.
	 * @param file 파일의 이름
	 * @throws IOException 파일 초기화 에러
	 */
	public void init(String base,String file) throws Exception {
		
		String[] files = new String[1];
		files[0] = file;
		init( base , files );
	}
	
	
	
	public void remakeSpoolFile(Connection conn, eMsConnection EMS_CONNECTION, String base_path, String spool_name ,String spool_path, String spool_back_path,String query) throws SQLException{
		
		FileReader fr = null;
		
		try {
			fr = new FileReader(spool_back_path);
		} catch (FileNotFoundException e) {			
			log.error( " [ File not found Exception ] " + e.toString());
		}
		
		BufferedReader br = new BufferedReader(fr);//spool_back_path
		
		
		
		// spool file 읽고 수신거부하고 삭제하고 리스트테이블에 업데이트 해주기.
		// spool 파일에서 고객아이디로 수신거부 테이블에서 확인하기.
		FileOutputStream fos = null;
		OutputStreamWriter osw = null; // origin spool 정보 쓰기.
		
		FileOutputStream  filter_fos= null;
		OutputStreamWriter filter_osw = null; //필터된 고객 리스트 정보 쓰기.

		String filter_full_path = base_path + "/" +spool_filter_path +"/"+spool_name; //필터링 리스트를 쓸 path.
		
		try {
			fos = new FileOutputStream(spool_path);// real spool.
			osw = new OutputStreamWriter(fos);
			filter_fos = new FileOutputStream(filter_full_path);
			filter_osw = new OutputStreamWriter(filter_fos); // filtering spool.
		} catch (FileNotFoundException e1) {
			log.error("file not found error", e1);
		}
		
		String line = "";
		ResultSet rs = null;
		String checkDeny = ""; // 수신거부 체크. 0 : 수신거부 대상자 아님 , 1: 수신거부 대상자
		String[] spool_info = null; //스풀 파일 | 구분된 각각의 정보들을 배열로 저장.
		String   member_id = ""; 
		PreparedStatement pstmt=null;  //수신거부 전용 preparestatement.

		eMsPreparedStatement listtable_update = null; //list_table udpate 전용.
		
		String updateListQuery = SqlManager.getQuery("ReFilter", "QUERY_UPDATE_ERRORCODE_LISTTABLE");
		
		//preparestatement. start
		Properties prop = new Properties();

		//업데이트 쿼리..
		
		String post_id = task_prop.getProperty("POST_ID").trim();
		String list_table = "";
		
		if(task_prop.getProperty("CHANNEL_TYPE").equals("EM"))
			list_table ="TMS_EMAIL_LIST_"+ post_id.substring(4, 6);
		else if(task_prop.getProperty("CHANNEL_TYPE").equals("SM"))
			list_table ="TMS_SMS_LIST_"+ post_id.substring(4, 6);
		
		prop.setProperty("LIST_TABLE", list_table);
		
		StringBuffer buffer = new StringBuffer(512);
		buffer.setLength(0);
		Popper.ConvertString(buffer, updateListQuery, prop, "@{", "}", false, false);
		updateListQuery = buffer.toString();
		log.debug("[DENY_UPDATE_QUERY]"+updateListQuery);
		
		int updateCnt = 0; 
		int total_cnt = 0; //전체건수
		int send_cnt = 0; //발송건수
		int deny_cnt = 0; //추가 수신거부 건수
		int result_update = 0;

		
		
		try {
			while( (line = br.readLine()) != null ){
				
				
				if(log.isDebugEnabled()) log.debug("kdy0831 ==>"+ line);
				spool_info = line.split("\\|");
				member_id = spool_info[MEMBER_ID_POINT];//11 번째 정보가 고객 ID 임.
				
				if(pstmt == null){
					pstmt = conn.prepareStatement(query); //여기서 수신거부 멤버인지 확인한다.
				}
				
				pstmt.clearParameters();
//				pstmt.setInt(1, Integer.parseInt(member_id));
				pstmt.setString(1, member_id);
				rs = pstmt.executeQuery();
				
				rs.next();
				checkDeny = rs.getString(1); //select cnt 를 받아온다.
				
				if(log.isDebugEnabled()) log.debug("[member_id]"+member_id+"[checkDeny]"+checkDeny);
				
				if(!"0".equals(checkDeny)){
					osw.write(line+"\r\n");
					osw.flush();
					send_cnt++;
				}//real spool
				else{
					prop.clear();
					prop.setProperty("MEMBER_ID", member_id);
					prop.setProperty("POST_ID", post_id);
					if(listtable_update == null){
						try {
							listtable_update = EMS_CONNECTION.prepareStatement(updateListQuery, "${" , "}");
						} catch (Exception e) {
							// TODO Auto-generated catch block
							log.error("Exception", e);							
							log.error(e.getMessage());
						}
					}
					
					//TODO [수신거부된 결과]
					if(log.isDebugEnabled()) log.debug("member_id ==>"+ member_id);
					result_update = listtable_update.executeUpdate(prop);
					
					// 필터링 고객 리스트 파일 쌓기.
					filter_osw.write(line+"\r\n");
					filter_osw.flush();
					if(updateCnt < 1){
					}//FAIL.
					deny_cnt++;
				}
				
				if(rs != null) {
					rs.close();
				}
				
			}//end of while
			total_cnt++;
			total_deny_cnt += deny_cnt;
		} catch (IOException e) {
			log.error("IOException",e);
			log.error( " [ File Read Fail _io] " + e.toString());
		} catch (SQLException se) {
			log.error("SQLException",se);
			log.error( " [ File Read Fail _sql] " + se.toString());
		} catch (Exception e) {
			log.error("Exception", e);
			log.error( " [ Exception] " + e.toString());
		}
		finally{
			if(filter_fos != null){
				try {
					filter_fos.close();
				} catch (IOException e1) {
					log.error("error", e1);
				}
			}
			if(filter_osw != null){
				try {
					filter_osw.close();
				} catch (IOException e1) {
					log.error("error", e1);
				}
				
			}
			if(fos != null){
				try {
					fos.close();
				} catch (IOException e1) {
					log.error("error", e1);
				}
			}
			if(osw != null){
				try {
					osw.close();
				} catch (IOException e1) {
					log.error("error", e1);
				}
				
			}
			if(fr != null){
				try {
					fr.close();
				} catch (IOException e1) {
					log.error("error", e1);
				}
			}
			if(fr != null){
				try {
					br.close();
				} catch (IOException e1) {
					log.error("error", e1);
				}
			}
			if(rs != null){
				try{
					rs.close();
				}catch(SQLException e){}
			}
			if(pstmt!=null){
				try{
					pstmt.close();
					pstmt = null;
					
				}catch(SQLException e){}
			}
			if(listtable_update!=null){
					listtable_update.close();
					listtable_update = null;
			}
			
		}
		
		
		log.debug("[spool_path]"+spool_path+"[total_cnt]"+total_cnt+"[send_cnt]"+send_cnt+"[deny_cnt]"+deny_cnt);
	}
	
	/** 복수개의 파일 그룹으로 초기화 한다.
	 * @param base 기본 디렉토리를 지정한다.<br>
	 * 만일 null 이면 files의 각 파일은 full path로 지정되어야 한다.
	 * @param files 패치할 file리스트
	 * @throws IOException 파일 초기화 에러
	 */
	public void init(String base,String[] files) throws Exception {
		
		boolean queue_yn = false;
		
		if( files.length < 1 ){
			throw new NoSpoolFileException("NO Files");
		}
		
		if( innerReader != null ){
			close();
		}
		
		// compress된 경우 압축을 풀어버린다.
		int files_cnt = files.length;
		String[] convert_files = new String[files_cnt];
		
		for(int i=0;i<files_cnt;i++) {
			if( ZipFileManager.isCompressed(files[i]) ) {
				try {
					convert_files[i] = ZipFileManager.unZip(files[i],base,true);
				}
				catch(Exception ex) {
					log.error( " Unzip Error " + ex.toString());
					convert_files[i] = files[i];
				}
			}
			else {
				convert_files[i] = files[i];
			}
			
			if(convert_files[i].indexOf("mqueue") > 0)
				queue_yn = true;
		}
		
		
		
		
		//KDY0831 START!!
		/*
		 * mail_kind : 정기메일(A) / 광고메일(B) 일반메일 (C)
		 * redeny_flag : 수신거부 재 필터링 여부.(Y/N)
		 * 
		 */
		
		String rstate = "";
		String redeny = "";
		
		if(queue_yn){
			rstate = "";
			redeny = "N";
		}else if(task_prop != null){
			rstate = task_prop.getProperty("SEND_STATE","").trim();
			redeny = task_prop.getProperty("REDENY_FLAG","").trim();
		
			if(R_STATE.equals(rstate)  &&  "Y".equals(redeny)){  // 수신거부 재 필터링 사용할  경우.
					
				String mail_kind = task_prop.getProperty("MAIL_KIND","").trim();
	
				if("A".equals(mail_kind) || "B".equals(mail_kind)){
					
					Connection deny_conn = null; // 수신거부를 위한 Connection.
	
					eMsConnection	EMS_CONNECTION	= null;
					File ori_spool = null;
					File rename_spool = null;
					String query = "";
					String spool_path = "";
					String spool_name = "";
					
					eMsPreparedStatement UPDATE_TYPE_97_SCHD_INFO = null; //list_table udpate 전용.
					
					try {
						String sql = ""; //config 에서 쿼리 가져오기.						
						Class.forName(db_driver).newInstance();
						deny_conn = DriverManager.getConnection(db_url, db_id, db_pw);
						EMS_CONNECTION = ConnectionPool.getConnection();
						
						//메일 종류에 따른 쿼리 선택. 일반 메일일 경우는 수신거부 재 필터링 기능을 사용하지 않는다.
						if("A".equals(mail_kind)){ 
							query = SqlManager.getQuery("ReFilter", "QUERY_SELECT_DENY_COUNT_PERIOD");//정기메일 쿼리
						}else if("B".equals(mail_kind)){
							query = SqlManager.getQuery("ReFilter", "QUERY_SELECT_DENY_COUNT_ADVERTISE");// 광고메일 쿼리
						}
						
						// 대량의 경우 스풀파일이 1개 이상이다. for 로 생성된  스풀 파일만큼 돌린다. remakeSpoolFile() 는 스풀 파일 개수만큼 호출. fileCopy() 도
						for(int i=0; i<convert_files.length; i++){
							ori_spool = new File(convert_files[i]);
							
							spool_path = convert_files[i].substring(0,convert_files[i].toString().lastIndexOf("spool/")+5);
							spool_name = convert_files[i].substring(convert_files[i].toString().lastIndexOf("/")+1, convert_files[i].toString().length());
							
							if(StringUtil.isNull(base))
								base = spool_path;
							
							rename_spool = new File(base+"/"+ filter_backup_path + "/" + spool_name);
							boolean fileRename = ori_spool.renameTo(rename_spool); //rename 으로 원본 파일 이동.
							if(!fileRename) log.error("File name rename failed");
							
							if(ori_spool.exists()){
								//삭제가 완전히 됐는지 확인한다. // 안 그렇다면 중복 발송의 우려가 있다.
								throw new Exception("[ERROR][RENAME][FILE EXIST]"+convert_files[i]);
							}else{
								//기존파일은 삭제가 된상태에서 진행한다.
								remakeSpoolFile(deny_conn, EMS_CONNECTION,base, spool_name,convert_files[i], base+"/"+ filter_backup_path + "/" + spool_name ,query);
								
							}
						}
						
						/*
						 * 스풀 작성을 다 한 후에, 스케쥴(TMS_SCHD_INFO) table 에 target_deny_cnt 를 업데이트 한다.
						 * 
						 */
						String QUERY_UPDATE_FILTER_CNT_SCHD_INFO = SqlManager.getQuery("ReFilter", "QUERY_UPDATE_FILTER_CNT_SCHD_INFO");
						
						UPDATE_TYPE_97_SCHD_INFO = EMS_CONNECTION.prepareStatement(QUERY_UPDATE_FILTER_CNT_SCHD_INFO, "${" , "}");
						Properties prop = new Properties();
						
						//post_id 가 13이 넘을때 처리
						String postId = task_prop.getProperty("POST_ID");
						if(postId.length() >= 13)
							postId = postId.substring(0,13);
						
						prop.setProperty("POST_ID", task_prop.getProperty("POST_ID"));
						prop.setProperty("TYPE_97_ERROR", String.valueOf(total_deny_cnt));
						prop.setProperty("SERVER_ID", server_id);
						total_deny_cnt = 0;
						
						UPDATE_TYPE_97_SCHD_INFO.executeUpdate(prop);//DENY CNT TMS_SCHD_INFO TABLE 에 UPDATE...
						
					} catch (Exception e) {
						log.error("[ERROR][reDenyFilter]", e);
						throw e;
					}finally{
						if(deny_conn != null){
							try{
								deny_conn.close();
								deny_conn = null;
							}catch(Exception ee){
							}
						}
						if(EMS_CONNECTION != null){
							try{
								EMS_CONNECTION.recycle();
								EMS_CONNECTION = null;
							}catch(Exception ee){
							}
						}
						if(UPDATE_TYPE_97_SCHD_INFO!=null){
							UPDATE_TYPE_97_SCHD_INFO.close();
							UPDATE_TYPE_97_SCHD_INFO = null;
						}
					}
					
				}else{//end of if mail_kind
					if(log.isDebugEnabled()) {
						log.debug( "[SKIP reDenyFilter][POST_ID]"+task_prop.getProperty("POST_ID")+"[mail_kind]:"+mail_kind);
					}
				}	
					
			} else {
				if(log.isDebugEnabled()) {
					log.debug( "[SKIP reDenyFilter][POST_ID]"+task_prop.getProperty("POST_ID")+"[rstate]:"+rstate+"[rstate]:"+redeny);
				}
			}
			
		}//end of queue_yn
		//KDY0831 END!!
		
		//kdy0831 end!
		this.files = convert_files;
		
		if(!queue_yn && task_prop != null){
		
			if(log.isDebugEnabled()) {
				log.debug( "[convert_files][POST_ID]"+task_prop.getProperty("POST_ID")+"[convert_files]:"+Arrays.toString(convert_files));
			}
			
			if(log.isDebugEnabled()){
				for(int i=0; i<this.files.length; i++){
					log.debug( "[POST_ID]"+task_prop.getProperty("POST_ID")+"[this.files]"+i+":"+this.files[i]);
				}
			}
		}
		
		
		this.dir = base;
		this.file_index = 0;
						
		innerReader = new eMsFileReader(  this.files[0] );
		
	}
	
	/** 파일의 리스트가 벡터로 존재할경우
	 * @param base 기본 디렉토리 만일 null이라면 file은 full path로 존재하여야 한다.
	 * @param file 파일 리스트를 담은 Vector
	 * @throws IOException 파일 초기화시 에러
	 */
	public void init(String base,List file) throws Exception {
		String[] files = new String[ file.size() ];
		
		for( int i = 0 ; i < file.size() ; i++ ) {
			files[i] = ( String )file.get( i );
		}
		
		init( base , files );
	}
	
	/** 대상이 되는 파일 리스트에서 다음 작업 파일이 존재하는지를 확인하고
	 * 다음 작업 파일로 파일 포인터를 옮긴다.
	 * @return true : 다음 작업파일로의 포인터 이동이 성공
	 * false : 다음 작업파일이 존재하지 않을 경우
	 * @throws IOException 파일 조작 에러
	 */
	protected boolean check_next() throws Exception {
		if( this.file_index++ > this.files.length - 2 ) {
			return false;
		}
		
		this.innerReader.close();
		if (log.isDebugEnabled()) {
			log.debug("dir=["+this.dir+"] // file=["+this.files[ this.file_index ]+"]");
			log.debug("dir=["+this.dir+"] // file=["+this.files[ this.file_index ]+"]");
		}
		
		this.innerReader = new eMsFileReader( this.files[ this.file_index ] );
				
		return true;
	}
	
	/** 오픈된 파일등의 자원을 반환한다.
	 */
	public void close() {
		try{ this.innerReader.close(); } catch( Exception e){}
		this.innerReader = null;
	}
	
	/** 등록된 파일 Array를 반환한다.
	 * @return 대상 파일 리스트
	 */
	public String[] getFiles() {
		return this.files;
	}
	
	/** 다음의 대상이 되는 spool object를 반환한다.
	 * @return next spool Object를 반환하며 존재하지 않을 경우 null을 반환
	 * @throws Exception 에러발생
	 */
	public abstract Object next() throws Exception;
	
	/** 진행에 문제가 없는지를 체크한다.
	 * next() 에서 Exception 이 발생하였을 경우 검증을 수행
	 * @return true : 이상없음<br>
	 * false : 이상있음
	 */
	public abstract boolean check();
}
