/*
 * @(#)StandardSpoolAnalyzer.java            2004. 11. 30.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package venus.spool.common.parser;

import lombok.extern.slf4j.Slf4j;
import pluto.secure.crypto.CryptoUtil;
import pluto.util.StringUtil;
import pluto.util.convert.DelimConvertor;

/**
 * 스풀 한 줄을 읽어서 정보를 꺼내는 역활을 담당한다.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class StandardSpoolAnalyzer extends SpoolAnalyzer {

	protected StringBuffer		__INNER_BUFFER__	= null;

	/** Creates a new instance of StandardSpoolAnalyzer */
	public StandardSpoolAnalyzer() {
		super();
		__INNER_BUFFER__ = new StringBuffer(1024);
		if (log.isDebugEnabled()) {
			// foo
		}
	}

	/**
	 * 세팅된 값으로 스풀을 생성하여 반환한다.
	 * 
	 * @throws Exception
	 *             조립하다가 에러가 나면
	 * @return 완성된 spool을 반환한다.
	 */
	public synchronized String compose() throws Exception {
		return (isNextSpoolValid()) ? composeSingleRcptSend() : null;
	}

	/**
	 * 세팅된 값으로 스풀을 생성하여 반환한다.
	 * 
	 * @throws Exception
	 *             조립하다가 에러가 나면
	 * @return 완성된 spool을 반환한다.
	 */
	public synchronized String composeMultiRcptSend() throws Exception {

		StringBuffer buffer = new StringBuffer(1024);
		
		String email_str = getProperty(LOG_TOKEN_ENCRYPT); 
		if(email_str==null){
			email_str =  getProperty(LOG_TOKEN_ID);
		}

		DelimConvertor.encodeToBuffer(buffer, email_str);
		buffer.append("|");
		buffer.append(getProperty(LOG_SEND_TYPE));
		buffer.append("|");
		buffer.append(getProperty(LOG_NEXT_GENERATE));
		buffer.append("|");
		buffer.append(getProperty(LOG_LIMIT_DATE));
		buffer.append("|");
		buffer.append(getProperty(LOG_STEP));
		buffer.append("|");
		buffer.append(getProperty(LOG_MAIL_ID));
		buffer.append("|");
		buffer.append(getProperty(LOG_LIST_TABLE));
		buffer.append("|");
		buffer.append(getProperty(LOG_SECURE_FLAG));
		buffer.append("|");
		buffer.append(getProperty(LOG_ADDITIONAL_INFO));
		buffer.append("|");
		buffer.append(getProperty(LOG_ROWID));
		buffer.append("|");
		buffer.append(getProperty(LOG_OS));
		buffer.append("|");
		buffer.append(getProperty(LOG_NOTI_FLAG));
		buffer.append("|");
		DelimConvertor.encodeToBuffer(buffer, getProperty(LOG_MEMBER_ID));
		//buffer.append("|");
		//buffer.append(getProperty(LOG_PRIORITY));

		return buffer.toString();
	}

	/**
	 * 세팅된 값으로 스풀을 생성하여 반환한다.
	 * 
	 * @throws Exception
	 *             조립하다가 에러가 나면
	 * @return 완성된 spool을 반환한다.
	 */
	public synchronized String composeSingleRcptSend() throws Exception {

		StringBuffer buffer = new StringBuffer(1024);
		
		//samsunglife
		String email_str = getProperty(LOG_TOKEN_ENCRYPT); 
		if(email_str==null){
			email_str =  getProperty(LOG_TOKEN_ID);
		}
		
		DelimConvertor.encodeToBuffer(buffer, email_str);
		buffer.append("|");
		buffer.append(getProperty(LOG_SEND_TYPE));
		buffer.append("|");
		buffer.append(getProperty(LOG_NEXT_GENERATE));
		buffer.append("|");
		buffer.append(getProperty(LOG_LIMIT_DATE));
		buffer.append("|");
		buffer.append(getProperty(LOG_STEP));
		buffer.append("|");
		buffer.append(getProperty(LOG_MAIL_ID));
		buffer.append("|");
		buffer.append(getProperty(LOG_LIST_TABLE));
		buffer.append("|");
		buffer.append(getProperty(LOG_SECURE_FLAG));
		buffer.append("|");
		buffer.append(getProperty(LOG_ADDITIONAL_INFO));
		buffer.append("|");
		buffer.append(getProperty(LOG_ROWID));
		buffer.append("|");
		buffer.append(getProperty(LOG_OS));
		buffer.append("|");
		buffer.append(getProperty(LOG_NOTI_FLAG));
		buffer.append("|");
		DelimConvertor.encodeToBuffer(buffer, getProperty(LOG_MEMBER_ID));
		buffer.append("|");
		DelimConvertor.encodeToBuffer(buffer, getProperty(LOG_MEMBER_NAME));
		buffer.append("|");
		buffer.append(getProperty(LOG_MAPPING));
		//buffer.append("|");
		//buffer.append(getProperty(LOG_PRIORITY));

		return buffer.toString();
	}

	/**
	 * 스풀중에서 도메인을 추출해온다.
	 * 
	 * @param spool
	 *            파싱할 스풀
	 * @throws Exception
	 *             파싱이 안되면 나는거
	 * @return 스풀의 도메인 null이 반환되면 에러가 있는 도메인이다.
	 */
	public String pickupDomain(String spool) throws Exception {

		if( spool == null )
			return null;

		int idx1 = spool.indexOf("|");

		if( idx1 < 0 )
			return null;

		String email = spool.substring(0, idx1);

		if( StringUtil.isError(email) )
			return null;

		return StringUtil.getDomain(email);
	}

	/**
	 * 이메일과 도메인을 추려내서 등록하는 부분이다.
	 */	
	public void setEmailID( String value ) {
		String email        = null;
		String email_encrypt= null;
		
		int decyper_tag_len = CryptoUtil.TMS_DECRYPT_TAG.length();
		int decyper_idx     = value.indexOf(CryptoUtil.TMS_DECRYPT_TAG); 
		
		if(decyper_idx >= 0){
			email           = value.substring(decyper_idx+decyper_tag_len);
			email_encrypt   = value.substring(0,decyper_idx);
		}else{
			email           = value;
			email_encrypt   = value;
		}
		
		setProperty( LOG_TOKEN_ID , email );
		setProperty( LOG_DOMAIN , StringUtil.getDomain( email ) );
		//암호화된 email
		setProperty( LOG_TOKEN_ENCRYPT , email_encrypt );
		
	}
	
	
	public static void main(String[] args){
		StandardSpoolAnalyzer test = new StandardSpoolAnalyzer();
		
		String value = "xdfasdfasdfasdfasdfasdf<EMAIL_SSLIFE>leejc297@nate.com";
		test.setEmailID(value);
		
		log.debug(test.getTokenID()+"/"+test.getProperty( LOG_TOKEN_ID )+"/"+test.getDomain()+"/"+test.getProperty(LOG_DOMAIN));
	}
	
	/**
	 * 스풀을 파싱해서 반환한다.
	 * 
	 * @param spool
	 *            파싱할 스풀
	 * @throws Exception
	 *             파싱이 안되면 나는거
	 * @return 파싱된 결과 KEY-VALUE Property
	 */
	public SpoolAnalyzer parse(String spool) throws Exception {
		int idx1 = 0;
		int idx2 = 0;

		idx2 = spool.indexOf("|", idx1);

		if( idx2 < 0 )
			return null;

		setEmailID(spool.substring(idx1, idx2));

		idx1 = idx2 + 1;
		/////////////////////////////////////////////////////////////

		idx2 = spool.indexOf("|", idx1);

		if( idx2 < 0 )
			return null;

		super.setSendType(spool.substring(idx1, idx2));

		idx1 = idx2 + 1;
		/////////////////////////////////////////////////////////////

		idx2 = spool.indexOf("|", idx1);

		if( idx2 < 0 )
			return null;

		super.setNextSpoolGenerate(spool.substring(idx1, idx2));

		idx1 = idx2 + 1;
		/////////////////////////////////////////////////////////////

		idx2 = spool.indexOf("|", idx1);

		if( idx2 < 0 )
			return null;

		super.setLimitDate(spool.substring(idx1, idx2));

		idx1 = idx2 + 1;
		/////////////////////////////////////////////////////////////

		idx2 = spool.indexOf("|", idx1);

		if( idx2 < 0 )
			return null;

		super.setStep(spool.substring(idx1, idx2));

		idx1 = idx2 + 1;
		/////////////////////////////////////////////////////////////

		idx2 = spool.indexOf("|", idx1);

		if( idx2 < 0 )
			return null;

		super.setPostID(spool.substring(idx1, idx2));

		idx1 = idx2 + 1;
		/////////////////////////////////////////////////////////////

		idx2 = spool.indexOf("|", idx1);

		if( idx2 < 0 )
			return null;

		super.setListTable(spool.substring(idx1, idx2));

		idx1 = idx2 + 1;
		/////////////////////////////////////////////////////////////

		idx2 = spool.indexOf("|", idx1);

		if( idx2 < 0 )
			return null;

		super.setSecureFlag(spool.substring(idx1, idx2));

		idx1 = idx2 + 1;
		/////////////////////////////////////////////////////////////

		idx2 = spool.indexOf("|", idx1);

		if( idx2 < 0 )
			return null;

		super.setAdditionalValue(spool.substring(idx1, idx2));

		idx1 = idx2 + 1;
		/////////////////////////////////////////////////////////////
		
		idx2 = spool.indexOf("|", idx1);

		if( idx2 < 0 )
			return null;

		super.setRowid(spool.substring(idx1, idx2));	// add TMS3.0 ROWID

		idx1 = idx2 + 1;
		/////////////////////////////////////////////////////////////

		idx2 = spool.indexOf("|", idx1);

		if( idx2 < 0 )
			return null;

		super.setOs(spool.substring(idx1, idx2));	// add TMS3.1 OS

		idx1 = idx2 + 1;
		/////////////////////////////////////////////////////////////
		
		idx2 = spool.indexOf("|", idx1);
		
		if( idx2 < 0 )
			return null;
		
		super.setNotiflag(spool.substring(idx1, idx2));	// add TMS3.1 NOTI_FLAG
		
		idx1 = idx2 + 1;
		/////////////////////////////////////////////////////////////
		
		
		idx2 = spool.indexOf("|", idx1);

		StringBuffer buffer = new StringBuffer(1024);
		
		if( idx2 < 0 ) {
			buffer.setLength(0);
			DelimConvertor.decodeToBuffer(buffer, spool.substring(idx1));
			super.setMemberID(buffer.toString());
			return this;
		}
		buffer.setLength(0);
		DelimConvertor.decodeToBuffer(buffer, spool.substring(idx1, idx2));
		super.setMemberID(buffer.toString());

		idx1 = idx2 + 1;
		/////////////////////////////////////////////////////////////

		idx2 = spool.indexOf("|", idx1);

		if( idx2 < 0 )
			return null;

		//super.setMemberName( DelimConvertor.decode_( spool.substring( idx1 ,
		// idx2 ) ) );
		buffer.setLength(0);
		DelimConvertor.decodeToBuffer(buffer, spool.substring(idx1, idx2));
		super.setMemberName(buffer.toString());

		super.setMapping(spool.substring(idx2 + 1));

		return this;
	}
}
