/*
 * @(#)SpoolHeaderParser.java            2004. 12. 6.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package venus.spool.common.parser;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import pluto.config.eMsSystem;
import pluto.util.PlutoLinkedList;
import pluto.util.StringUtil;

/**
 * <br>
 * 스풀을 읽어들여 Hash에 저장한다. <br>
 * 현재 자동메일 형식의 스풀을 읽어들일 때 사용한다.
 * 
 * @version
 * @author dragon
 *  
 */
public class SpoolHeaderParser {

	private static String		StartOfLoop	= null;

	private static String		EndOfLoop	= null;

	//	private static String StartOfElement = null;
	//		
	//	private static String EndOfElement = null;

	private static List			HEADER_ELM	= new PlutoLinkedList();

	static {
		StartOfLoop = eMsSystem.getProperty("header.loop.start", "[");
		EndOfLoop = eMsSystem.getProperty("header.loop.end", "]");
		//		StartOfElement = eMsSystem.getProperty("header.loop.element.start","{");
		//		EndOfElement = eMsSystem.getProperty("header.loop.element.end","}");
	}

	/**
	 * <br>
	 * src의 기본 매핑 부분을 delim을 구분자로 하여 나누어서 <br>
	 * 순서대로 map_1 , map_2 ... 이런 key값에 넣어서 <br>
	 * hash에 넣는다. 기본 매핑은 src의 처음부터 <br>
	 * 'header.loop.start' 값이 처음 나오는 곳까지를 말한다.
	 * 
	 * @param src
	 * @param delim
	 * @param hash
	 */
	public static void parseSimple(String src, String delim, Map hash) {
		if( src == null )
			return;

		// 일단 비우고...
		hash.clear();

		// 일단 기본 매핑을 먼저 가지고 온다.
		int StartOfLoopMapping = src.indexOf(StartOfLoop);

		String value = StartOfLoopMapping > 0 ? src.substring(0, StartOfLoopMapping) : src;
		parseSimpleElement(value, delim, hash);
	}

	/**
	 * <br>
	 * 기본 매핑부분은 parseSimple(src,delim,hash)와 동일하다. <br>
	 * src의 Loop 매핑 부분은 Looping의 시작, 끝 값으로 구분하여 <br>
	 * 순서대로 rap_1 , rap_2 ... 이런 key값에 넣어서 hash에 넣는다. <br>
	 * 각 sub 매핑은 역시 Map에 담는다.
	 * 
	 * @param src
	 * @param delim
	 * @param hash
	 */
	public static void parse(String src, String delim, Map hash) {
		if( src == null )
			return;

		// 일단 비우고...
		hash.clear();

		// 일단 기본 매핑을 먼저 가지고 온다.
		int StartOfLoopMapping = src.indexOf(StartOfLoop);

		if( StartOfLoopMapping < 0 ) {
			parseSimpleElement(src, delim, hash);
			return;
		}

		parseSimpleElement(src.substring(0, StartOfLoopMapping), delim, hash);

		int loop_idx = 1;

		int EndOfLoopMapping = src.indexOf(EndOfLoop, StartOfLoopMapping + StartOfLoop.length());

		while (true) {

			if( EndOfLoopMapping < 0 )
				return;

			Map sub_map = parseLooping(src.substring(StartOfLoopMapping + StartOfLoop.length(), EndOfLoopMapping), delim);

			hash.put("rap_" + String.valueOf(loop_idx++), sub_map);

			StartOfLoopMapping = src.indexOf(StartOfLoop, EndOfLoopMapping + EndOfLoop.length());

			if( StartOfLoopMapping < 0 )
				return;

			EndOfLoopMapping = src.indexOf(EndOfLoop, StartOfLoopMapping);
		}
	}

	/**
	 * <br>
	 * parse(src,delim,hash) 와 동일하나 hash의 레퍼런스를 전달하지 않고 <br>
	 * 새로 생성시키고 그 곳에 넣어 반환하는 점만이 다르다.
	 * 
	 * @param src
	 * @param delim
	 * @return
	 */
	public static Map parse(String src, String delim) {

		if( src == null )
			return null;

		Map returnValue = new Hashtable();

		parse(src, delim, returnValue);

		return returnValue;
	}

	private synchronized static void parseSimpleElement(String src, String delim, Map __TARGET_HASH__) {

		HEADER_ELM.clear();
		HEADER_ELM = StringUtil.toStringList(src, delim, HEADER_ELM);

		int idx = 0;
		for (Iterator iter = HEADER_ELM.iterator(); iter.hasNext();) {
			idx++;
			String __ELM__ = iter.next().toString();
			__TARGET_HASH__.put("map_" + String.valueOf(idx), StringUtil.trimNull(__ELM__));
		}

		return;
	}

	private synchronized static Map parseLooping(String src, String delim) {

		Map returnValue = new Hashtable();

		HEADER_ELM.clear();
		HEADER_ELM = StringUtil.toStringList(src, delim, HEADER_ELM);
		int idx = 0;
		for (Iterator iter = HEADER_ELM.iterator(); iter.hasNext();) {
			idx++;
			String __ELM__ = iter.next().toString();
			returnValue.put("rap_" + String.valueOf(idx), StringUtil.trimNull(__ELM__));
		}

		return returnValue;
	}
}
