/*
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package venus.spool.common.parser;

import java.util.Iterator;
import java.util.Map;

import pluto.config.eMsSystem;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.util.StringConvertUtil;
import pluto.util.eMsStringTokenizer;
import pluto.util.convert.DelimConvertor;
import venus.spool.auto.task.AutoBaseSpoolTask;
import freemarker20.template.SimpleHash;
import freemarker20.tm.TemplateHashModelData;
import freemarker20.tm.TemplateHashModelListTM;

/**
 * <br>
 * 스풀을 읽어들여 Hash에 저장한다. <br>
 * 현재 자동메일 형식의 스풀을 읽어들일 때 사용한다.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class SpoolHashParser {

	protected eMsStringTokenizer	STR_TOKEN		= null;

	protected StringBuffer			TMP_BUFFER		= null;

	private static String			StartOfLoop		= null;

	private static String			EndOfLoop		= null;

	private static String			StartOfElement	= null;

	private static String			EndOfElement	= null;

	static {
		StartOfLoop = eMsSystem.getProperty("auto.loop.start", "[");
		EndOfLoop = eMsSystem.getProperty("auto.loop.end", "]");
		StartOfElement = eMsSystem.getProperty("auto.element.start", "{");
		EndOfElement = eMsSystem.getProperty("auto.element.end", "}");
	}

	private String					delim;

	// private List __INNER_MAPPING_ELEMENTS__ = new PlutoLinkedList();

	/** Creates new SpoolHashParser */
	public SpoolHashParser() {
		this("|");
	}

	public SpoolHashParser(String de) {

		this.delim = de;
		STR_TOKEN = new eMsStringTokenizer();
		this.TMP_BUFFER = new StringBuffer(1024);
	}

	public synchronized void setDelim(String de) {

		this.delim = de;
	}

	public synchronized void parse(SimpleHash HASH, String src) throws Exception {

		this.parse(HASH, src, null, null);
	}

	public synchronized void parse(SimpleHash HASH, String src, Map key) throws Exception {

		this.parse(HASH, src, key, null);
	}

	public synchronized void parse(SimpleHash HASH, String src, Map key, Object default_value) throws Exception {

		HASH.clear();

		if( src == null ) {
			src = " ";
		}

		// 일단 기본 매핑을 먼저 가지고 온다.
		int StartOfLoopMapping = src.indexOf(StartOfLoop);

		if( StartOfLoopMapping < 0 ) {
			parseSimpleElement(HASH, src, key);
		}
		else {
			// 단순 매핑 부분을 파싱하고.
			parseSimpleElement(HASH, src.substring(0, StartOfLoopMapping), key);
		}

		// 단순 매핑이 포함된 기본매핑을 치환하여 기본매핑을 추가한다.
		if( default_value != null ) {
			putDefaultToMainHash(this.TMP_BUFFER, HASH, default_value);
		}

		// 리스트 매핑 부분이 존재하지 않는다면 Skip.
		if( StartOfLoopMapping < 0 ) {
			return;
		}

		int loop_idx = 1;

		int EndOfLoopMapping = src.indexOf(EndOfLoop, StartOfLoopMapping + StartOfLoop.length());

		while (true) {

			if( EndOfLoopMapping < 0 ) {
				return;
			}

			String looping_key = "rap_" + String.valueOf(loop_idx++);
			String targetString = src.substring(StartOfLoopMapping + StartOfLoop.length(), EndOfLoopMapping);
			TemplateHashModelListTM sub_map = parseLooping(HASH, targetString, key == null ? null : (Map) key.get(looping_key));

			HASH.put(looping_key, sub_map);

			StartOfLoopMapping = src.indexOf(StartOfLoop, EndOfLoopMapping + EndOfLoop.length());

			if( StartOfLoopMapping < 0 ) {
				return;
			}

			EndOfLoopMapping = src.indexOf(EndOfLoop, StartOfLoopMapping);
		}
	}

	/**
	 * map_# 형태로 전환해야 하는 녀석을을 위한 파싱
	 */
	public synchronized void parseSerialMapping(SimpleHash HASH, String src, String __DELIM__) {
		if( src == null )
			return;
		STR_TOKEN.parse(src, __DELIM__);
		int idx = 0;
		StringBuffer buffer = new StringBuffer(256);
		while (STR_TOKEN.hasMoreTokens()) {
			idx++;
			String __NEXT_ELM__ = STR_TOKEN.nextToken();

			// 디코딩하면서 버퍼를 사용하는 모드로 전환 2004.10.31
			buffer.setLength(0);
			DelimConvertor.decodeToBuffer(buffer, __NEXT_ELM__);
			__NEXT_ELM__ = buffer.toString();

			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, __NEXT_ELM__, HASH, "${", "}", false, false);

			if (log.isDebugEnabled()) {
				log.debug("KeyValueParser:" + "map_" + String.valueOf(idx) + "=>" + buffer.toString());
			}

			HASH.put("map_" + String.valueOf(idx), buffer.toString());
		}
	}

	public synchronized void parseSimple(Map HASH, String src, Map key) {
		if( key == null ){
			throw new NullPointerException("KEY MAP IS NULL");
		}
		
		if( src == null ){
			throw new NullPointerException("PARSING SRC IS NULL");
		}

		int delim_idx = src.indexOf("[");

		STR_TOKEN.parse(delim_idx > 0 ? src.substring(0, delim_idx) : src, this.delim);

		int idx = 0;

		StringBuffer buffer = new StringBuffer(256);

		while (STR_TOKEN.hasMoreTokens()) {
			idx++;
			String sDummy = STR_TOKEN.nextToken();
			// 디코딩하면서 버퍼를 사용하는 모드로 전환 2004.10.31
			buffer.setLength(0);
			DelimConvertor.decodeToBuffer(buffer, sDummy);

			if( eMsLocale.HASH_SEND_MAP_PROCESS ) {
				sDummy = buffer.toString();
				
				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, sDummy, HASH, "${", "}", false, false);
			}

			if (log.isDebugEnabled()) {
				log.debug("KeyValueParser:" + (String) key.get("map_" + String.valueOf(idx)) + "=>" + buffer.toString());
			}
			HASH.put(key.get("map_" + String.valueOf(idx)), buffer.toString());
		}
	}

	private synchronized void parseSimpleElement(SimpleHash HASH, String src, Map key) {
		STR_TOKEN.parse(src, this.delim);
		StringBuffer buffer = new StringBuffer(256);
		int idx = 0;
		while (STR_TOKEN.hasMoreTokens()) {
			idx++;
			String sDummy = STR_TOKEN.nextToken();
			// 디코딩하면서 버퍼를 사용하는 모드로 전환 2004.10.31
			buffer.setLength(0);
			DelimConvertor.decodeToBuffer(buffer, sDummy);

			if( eMsLocale.HASH_SEND_MAP_PROCESS ) {
				sDummy = buffer.toString();

				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, sDummy, HASH, "${", "}", false, false);
			}

			if( key == null ) {
				if (log.isDebugEnabled()) {
					log.debug("KeyValueParser:" + "map_" + String.valueOf(idx) + "=>" + buffer.toString());
				}
				HASH.put("map_" + String.valueOf(idx), buffer.toString());
			}
			else {
				if (log.isDebugEnabled()) {
					log.debug("KeyValueParser:" + (String) key.get("map_" + String.valueOf(idx)) + "=>" + buffer.toString());
				}
				HASH.put((String) key.get("map_" + String.valueOf(idx)), buffer.toString());
			}
		}
	}

	private TemplateHashModelListTM parseLooping(SimpleHash HASH, String src, Map key) {

		int idx1 = 0;
		int idx2 = 0;

		TemplateHashModelListTM returnValue = new TemplateHashModelListTM();

		StringBuffer buffer = new StringBuffer(256);

		while (true) {
			idx1 = src.indexOf(StartOfElement, idx2);
			if( idx1 < 0 )
				break;

			idx2 = src.indexOf(EndOfElement, idx1);
			if( idx2 < 0 )
				break;

			STR_TOKEN.parse(src.substring(idx1 + StartOfElement.length(), idx2), this.delim);

			int idx = 0;
			TemplateHashModelData myMapping = new TemplateHashModelData();
			while (STR_TOKEN.hasMoreTokens()) {
				idx++;
				String sDummy = STR_TOKEN.nextToken();
				// 디코딩하면서 버퍼를 사용하는 모드로 전환 2004.10.31
				buffer.setLength(0);
				DelimConvertor.decodeToBuffer(buffer, sDummy);

				// 이중 매핑을 할려면 한번더 걸러준다.
				if( eMsLocale.HASH_SEND_MAP_PROCESS ) {
					sDummy = buffer.toString();

					buffer.setLength(0);
					StringConvertUtil.ConvertString(buffer, sDummy, HASH, "${", "}", false, false);
				}

				if( key == null ) {
					myMapping.put("rap_" + String.valueOf(idx), buffer.toString());
				}
				else {
					myMapping.put((String) key.get("rap_" + String.valueOf(idx)), buffer.toString());
				}
			}
			returnValue.addEntry(myMapping);

			idx2 = idx2 + EndOfElement.length();
		}

		return returnValue;
	}

	// GC 가 호출하면 버퍼를 반환해야한다.
	protected void finalize() throws Throwable {
		this.TMP_BUFFER = null;
	}

	public void destroy() {
		try {
			finalize();
		}
		catch(Throwable e) {			
			log.error("Exception", e);
			log.error(e.getMessage());
		}
	}

	private static final void putDefaultToMainHash(StringBuffer buffer, SimpleHash HASH, Object map) throws Exception {
		// 2차 헤쉬 매핑을 진행하지 않으면 그냥 넣고 돌아간다.
		if( !eMsLocale.HASH_SEND_MAP_PROCESS ) {
			if( map instanceof Map ) {
				HASH.putAll((Map) map);
			}
			else if( map instanceof SimpleHash ) {
				HASH.putAll(((SimpleHash) map).getAsHashmap());
			}
			else {
				throw new RuntimeException("Invalid Default Map Objet Type:" + map.getClass().getName());
			}
		}

		Map mapDefaultMap = null;

		if( map instanceof Map ) {
			mapDefaultMap = (Map) map;
		}
		else if( map instanceof SimpleHash ) {
			mapDefaultMap = ((SimpleHash) map).getAsHashmap();
		}
		else {
			throw new RuntimeException("Invalid Default Map Objet Type:" + map.getClass().getName());
		}

		for (Iterator iter = mapDefaultMap.keySet().iterator(); iter.hasNext();) {
			Object key = iter.next();
			Object value = mapDefaultMap.get(key);

			if( value instanceof TemplateHashModelListTM ) {
				putDefaultListMapToMainHash(buffer, HASH, key.toString(), (TemplateHashModelListTM) value);
			}
			else {
				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, value.toString(), HASH, "${", "}", false, false);
				HASH.put(key.toString(), buffer.toString());
			}
		}
	}

	private static final void putDefaultListMapToMainHash(StringBuffer buffer, SimpleHash HASH, String key, TemplateHashModelListTM map)
			throws Exception {
		int size = map.size();

		// 복사본 만들 인스턴스.
		TemplateHashModelListTM dummyList = new TemplateHashModelListTM();

		for (int i = 0; i < size; i++) {
			Map dummy = ((TemplateHashModelData) map.get(i)).getAsMap();
			TemplateHashModelData dummyHash = new TemplateHashModelData();
			for (Iterator iter = dummy.keySet().iterator(); iter.hasNext();) {
				Object oKey = iter.next();
				Object oValue = dummy.get(oKey);

				// 원본값을 HASH로 매핑해서 치환한 결과를 dummy에 세팅
				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, oValue.toString(), HASH, "${", "}", false, false);
				dummyHash.put(oKey.toString(), buffer.toString());
			}
			dummyList.addEntry(dummyHash);
		}

		// 해당키로 헤쉬에 넣기.
		HASH.put(key, dummyList);
	}
}
