/*
 * @(#)SpoolAnalyzer.java            2004. 11. 30.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.common.parser;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.eMsSystem;
import pluto.log.Log;
import pluto.util.Cal;
import pluto.util.StringUtil;

/**
 * <br>스풀 내용 조립 및 파싱 룰에 대한 기본 틀 제공
 * <br>recycle.limit 값이 설정 파일에 셋팅되어 있어야 한다. 
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public abstract class SpoolAnalyzer extends Properties implements Log {
	
	
	public static final String DEFAULT_ANALYZER_CLASS_NAME 
			= "venus.spool.common.parser.StandardSpoolAnalyzer";
	
	public static int DEFAULT_RECYCLE = 3;
	
	static {
		try {
			DEFAULT_RECYCLE = Integer.parseInt( 
					eMsSystem.getProperty( "recycle.limit" , "3" ) );
		}
		catch( Exception e ){
			log.error("Exception", e);
			log.error(e.getMessage());
			System.exit( 1 );
		}
	}
	
	protected static Class TARGET_CLASS = null;
	
	protected static String TARGET_CLASS_NAME = null;
	
	
	
	/** Creates a new instance of SpoolAnalyzer */
	protected SpoolAnalyzer() {
		super();
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	/** Activator에서 초기화를 위해 호출
	 * @param tmp 초기화 파라미터
	 * @throws Exception 초기화시에 에러나면
	 */	
	public synchronized static final void init( Object tmp ) throws Exception{
		
		Properties prop = ( Properties )tmp;
		
		TARGET_CLASS_NAME = prop.getProperty( "target.class" );
		TARGET_CLASS = Class.forName( TARGET_CLASS_NAME );
	}
	
	public static final SpoolAnalyzer getSpoolAnalyzer() throws Exception {
		
		if( TARGET_CLASS == null ){
			TARGET_CLASS = Class.forName( DEFAULT_ANALYZER_CLASS_NAME );
		}
		return (SpoolAnalyzer)TARGET_CLASS.newInstance();
	}
	
	/** 
	 * 값으로 널이 올때에도 공백으로 처리하기 위해 overide한것
	 * @param key 키값
	 * @param value 키 value
	 * @return 
	 */	
	public synchronized Object setProperty( String key , String value ) {
		
		return super.setProperty( key , value == null ? "" : value );
	}
	
	public void setLimitDate( String value ) {
		
		this.setProperty( LOG_LIMIT_DATE , value );
	}
	
	public String getLimitDate() {
		
		return this.getProperty( LOG_LIMIT_DATE );
	}
	
	public void setNextSpoolGenerate( String value ) {
		
		this.setProperty( LOG_NEXT_GENERATE , value );
	}
	
	public String getNextSpoolGenerate() {
		
		return this.getProperty( LOG_NEXT_GENERATE );
	}
	
	public void setSendType( String value ) {
		
		this.setProperty( LOG_SEND_TYPE , value );
	}
	
	public String getSendType() {
		
		return this.getProperty( LOG_SEND_TYPE );
	}
	
	public void setPostID( String value ) {
		
		this.setProperty( LOG_MAIL_ID , value );
	}
	
	public String getPostID() {
		
		return this.getProperty( LOG_MAIL_ID ,"no post id");
	}
	
	public void setListTable( String value ) {
		
		this.setProperty( LOG_LIST_TABLE , value );
	}
	
	public String getListTable() {
		
		return this.getProperty( LOG_LIST_TABLE );
	}
	
	public void setMemberID( String value ) {
		
		this.setProperty( LOG_MEMBER_ID , value );
	}
	
	public String getMemberID() {
		
		return this.getProperty( LOG_MEMBER_ID ,"no member id");
	}
	
	public void setMemberName( String value ) {
		
		this.setProperty( LOG_MEMBER_NAME , value );
	}
	
	public String getMemberName() {
		
		return this.getProperty( LOG_MEMBER_NAME  ,"no member name");
	}
	
	public void setTokenID( String value ) {
		
		this.setProperty( LOG_TOKEN_ID , value );
		this.setProperty( LOG_DOMAIN , StringUtil.getDomain( value ) );
	}
	
	public String getTokenID() {
		
		return this.getProperty( LOG_TOKEN_ID );
	}
	
	public String getDomain() {
		
		return this.getProperty( LOG_DOMAIN );
	}
	
	public void setMapping( String value ) {
		
		this.setProperty( LOG_MAPPING , value );
	}
	
	public String getMapping() {
		
		return this.getProperty( LOG_MAPPING );
	}
	
	public void setStep( String value ) {
		
		this.setProperty( LOG_STEP , value );
	}
	
	public void setStep( int value ) {
		
		this.setProperty( LOG_STEP , String.valueOf( value ) );
	}
	
	public String getStep() {
		
		return this.getProperty( LOG_STEP );
	}
	
	public int getIntStep() {
		
		return Integer.parseInt( this.getProperty( LOG_STEP ) );
	}
	
	public void setSecureFlag(String value){
		this.setProperty( LOG_SECURE_FLAG , value );
	}
	
	public String getSecureFlag(){
		return this.getProperty( LOG_SECURE_FLAG );
	}
	
	public void setAdditionalValue(String value){
		this.setProperty( LOG_ADDITIONAL_INFO , value );
	}
	
	public String getAdditionalValue(){
		return this.getProperty( LOG_ADDITIONAL_INFO );
	}
	
	// add TMS3.0 ROWID
	public void setRowid(String _rowid) {
		this.setProperty(LOG_ROWID, _rowid);
	}
	
	public String getRowid() {
		return this.getProperty(LOG_ROWID);
	}
	
	// add TMS3.1 OS
	public void setOs(String os){
		this.setProperty(LOG_OS, os);
	}
	public String getOs(){
		return this.getProperty(LOG_OS);
	}
	
	// add TMS3.1 NOTI_FLAG
	public void setNotiflag(String noti_flag){
		this.setProperty(LOG_NOTI_FLAG, noti_flag);
	}
	public String getNotiflag(){
		return this.getProperty(LOG_NOTI_FLAG);
	}
	
	// ADD TMS3.2 PRIORITY
	public void setPriority(String Priority){
		this.setProperty(LOG_PRIORITY, Priority);
	}
	public String getPriority(){
		return this.getProperty(LOG_PRIORITY);
	}
	
	public synchronized boolean isNextSpoolValid() {
		
		return isNextSpoolValid( DEFAULT_RECYCLE );
	}
	
	public boolean isNextSpoolValid( int step ) {
		
		if( getNextSpoolGenerate().equals("N") ) return false;
		
		int limitDate = Integer.parseInt( this.getProperty( LOG_LIMIT_DATE , "19001010" ) );
		int nowDate = Integer.parseInt( Cal.getDayDate() );
		
		return ( nowDate <= limitDate ) && ( step > this.getIntStep() );
	}
	
	/** 스풀을 파싱해서 반환한다.
	 * @param spool 파싱할 스풀
	 * @throws Exception 파싱이 안되면 나는거
	 * @return 파싱된 결과 KEY-VALUE Property
	 */	
	public abstract SpoolAnalyzer parse( String spool ) throws Exception;
	
	/** 스풀중에서 도메인을 추출해온다.
	 * @param spool 파싱할 스풀
	 * @throws Exception 파싱이 안되면 나는거
	 * @return 스풀의 도메인
	 */	
	public abstract String pickupDomain( String spool ) throws Exception;
	
	/** 세팅된 값으로 스풀을 생성하여 반환한다.
	 * @throws Exception 조립하다가 에러가 나면
	 * @return 완성된 spool을 반환한다.
	 */	
	public abstract String compose() throws Exception;
	
	/** 세팅된 값으로 스풀을 생성하여 반환한다.
	 * @throws Exception 조립하다가 에러가 나면
	 * @return 완성된 spool을 반환한다.
	 */	
	public abstract String composeSingleRcptSend() throws Exception;
	
	/** 세팅된 값으로 스풀을 생성하여 반환한다.
	 * @throws Exception 조립하다가 에러가 나면
	 * @return 완성된 spool을 반환한다.
	 */	
	public abstract String composeMultiRcptSend() throws Exception;
}

