/*
 * @(#)MultiSpoolTokenizer.java            2004. 11. 30.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.common.parser;

/**
 * 구분자로 구분되어 나열된 다수의 spool line을 읽어들이는 객체 / 도메인 별 관리
 * 
 * @version		
 * @author 		dragon
 *
 */
public class MultiSpoolTokenizer {
	public static final boolean DEBUG = false;
	
	private String _SOURCE_ = null;
	private String _DELIM_ = null;
	
	private int _INDEX_ = 0;
	private int _STRING_SIZE_ = 0;
	private boolean _REACH_END_ = false;
	
	private String DOMAIN = null;
	
	/** Creates new MultiSpoolTokenizer */
	public MultiSpoolTokenizer( String delim ) {
		this._DELIM_ = delim;
		this._REACH_END_ = true;
	}
	
	public void parse( String src ) {
		this._SOURCE_ = src;
		this._INDEX_ = 0;
		this._STRING_SIZE_ = this._SOURCE_.length();
		this._REACH_END_ = false;
		this.DOMAIN =  nextToken();
	}
	
	public String getDomain(){
		return this.DOMAIN;
	}
	
	public boolean hasMoreTokens() {
		return !this._REACH_END_;
	}
	
	public String nextToken() {
		if( this._REACH_END_ ) return "";
		
		int idx = this._SOURCE_.indexOf( this._DELIM_ , this._INDEX_ );
		
		if( idx < 0 ) {
			this._REACH_END_ = true;
			return ( this._INDEX_ == this._STRING_SIZE_ ) ? "" : this._SOURCE_.substring( this._INDEX_ );
		}
		
		String returnValue = ( this._INDEX_ == idx ) ? "" : this._SOURCE_.substring( this._INDEX_ , idx );
		
		this._INDEX_ = idx + this._DELIM_.length();
		
		return returnValue;
	}
}
