/*
 * @(#)Spooler.java            2004. 11. 30.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.common.handler;

/**
 * 재발송을 위한 스풀을 전달 / 교체하는 표준
 * 
 * @version		
 * @author 		dragon
 *
 */
public interface Spooler {
	
	/** 기존의 저장되어 있는 스풀을 처리하고 모든 관련 자원을 반환한다.
	 */	
	public void clean();
	
	/** 발송중에 재발송이 필요한 스풀을 append한다.
	 * @param spool 스풀 스트링
	 * @throws Exception 에러입니다.
	 */	
	public void addSpool( Object spool ) throws Exception;
	
	/** 스풀을 정리할때가 되었는지를 반환한다.
	 * @return true: 스풀을 처리하고 다시 생성해야함( Manager는 switchSpool 을 호출한다. )<br>
	 * false: 아직은 그냥 더 있어도 된다.
	 */	
	public boolean storeNext();
	
	/** 호출전까지 저장된 스풀을 처리하고 새로운 스풀저장공간을 설정한다.
	 * @throws Exception 에러발생
	 */	
	public void switchSpool() throws Exception;
}

