/*
 * @(#)LongMappingSpooler.java            2004. 11. 30.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.common.handler;

import java.io.File;
import java.io.RandomAccessFile;

import lombok.extern.slf4j.Slf4j;
import pluto.config.eMsSystem;
import pluto.io.FileElement;
import pluto.lang.eMsLocale;

/**
 * spool에서 long mapping 데이터를 읽어들이는 작업 지원
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class LongMappingSpooler {
	
	
	
	
	/**데이터 베이스 사이즈 초과 매핑이 저장되는 디렉토리
	 */
	protected static String LONG_MAPPING_STORE_DIRECTORY = null;
	
	protected static byte[] __NEW_LINE__ = null;

	/**초기화 해야쥐
	 */
	static {
		try{
			LONG_MAPPING_STORE_DIRECTORY = eMsSystem.getProperty( "long.mapping.store.dir" ).trim();
		}
		catch( Exception e ){
			log.error(e.getMessage());
			System.exit( 1 );
		}
		__NEW_LINE__ = new byte[2];
		__NEW_LINE__[0] = (byte)'\r';
		__NEW_LINE__[1] = (byte)'\n';
		if(log.isDebugEnabled()){
			// foo
		}
	}

	protected RandomAccessFile __INNER_WRITER__ = null;
	
	protected String WORKING_FILE_NAME = null;
	
	protected long[] pointers = null;
	
	protected boolean APPEND_FLAG = false;
	
	/** Creates a new instance of LongMappingSpooler */
	public LongMappingSpooler( String TARGET_FILE_NAME ) throws Exception {
		pointers = new long[2];
		
		WORKING_FILE_NAME = FileElement.CheckSubDirectory( LONG_MAPPING_STORE_DIRECTORY , TARGET_FILE_NAME ).concat("/").concat( TARGET_FILE_NAME );
		__INNER_WRITER__ = new RandomAccessFile( WORKING_FILE_NAME , "rw" );
		__INNER_WRITER__.seek( __INNER_WRITER__.length() );
	}
	
	public synchronized String put( String spool ) throws Exception{
		
		StringBuffer buffer = new StringBuffer(4096);
		pointers[0] = __INNER_WRITER__.getFilePointer();
		
		__INNER_WRITER__.write( spool.getBytes( eMsLocale.FILE_SYSTEM_OUT_CHAR_SET ) );
		
		pointers[1] = __INNER_WRITER__.getFilePointer();
		
		__INNER_WRITER__.write( __NEW_LINE__ );
		
		APPEND_FLAG = true;
		
		buffer.append( "isam://" );
		buffer.append( String.valueOf(pointers[0]) );
		buffer.append( "," );
		buffer.append( String.valueOf( pointers[1] ) );
		buffer.append( "@" );
		buffer.append( WORKING_FILE_NAME );
		return buffer.toString();
	}
	
	protected void finalize() throws Throwable{

		if( __INNER_WRITER__ != null ){
			try{ __INNER_WRITER__.close(); }catch( Exception ignore ){}
		}
		if( !APPEND_FLAG ){
			try
			{ 
				boolean fileDel = ( new File( WORKING_FILE_NAME ) ).delete();
				if(!fileDel) log.error("File deletion failed");
			}catch( Exception ignore ){}
		}
		APPEND_FLAG = true;
	}
	
	public void destroy(){
		try{
			finalize();
		}
		catch( Throwable e ){
			log.error("destroy error", e);
		}
	}
}
