/*
 * @(#)LongMappingSpoolReader.java            2004. 11. 30.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.common.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.Tracer;

/**
 * spool에서 long mapping을 처리
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class LongMappingSpoolReader {
	
	
	private static Hashtable INNER_CONTAINER = null;
	
	private static final int CONTAIN_LIMIT = 10;
	
	static{
		INNER_CONTAINER = new Hashtable();
	}
	
	public synchronized static final LongMappingSpoolReader getInstance( String KEY ) throws Exception{
		LongMappingSpoolReader returnValue = ( LongMappingSpoolReader )INNER_CONTAINER.get( KEY );
		if( returnValue != null ){
			return returnValue;
		}
		
		/**수용 기준치보다 낮으면 하나 생성해서 넣어둔다.
		 */
		if( INNER_CONTAINER.size() < CONTAIN_LIMIT ){
			returnValue = new LongMappingSpoolReader();
			if(returnValue != null) returnValue.setTargetFile( KEY );			
			INNER_CONTAINER.put( returnValue.getID() , returnValue );
			return returnValue;
		}
		
		/**수용기준치를 넘었다면 가장 오래전에 읽었던 녀석을 날리고 대치해야한다.
		 */
		long __COMPARE_TIME__ = System.currentTimeMillis();
		for( Enumeration ENUM = INNER_CONTAINER.elements(); ENUM.hasMoreElements(); ){
			LongMappingSpoolReader tmpReader = ( LongMappingSpoolReader )ENUM.nextElement();
			
			if( __COMPARE_TIME__ > tmpReader.getLastTime() ){
				__COMPARE_TIME__ = tmpReader.getLastTime();
				returnValue = tmpReader;
			}
		}
		
		if( returnValue != null ) {
			/**마지막 녀석을 제거하고
			 */
			INNER_CONTAINER.remove( returnValue.getID() );
			/**그녀석에게 새로운 아이디를 발번하고
			 */
			returnValue.setTargetFile( KEY );
			/**발번된 녀석의 키로 헤쉬에 넣는다.
			 */
			INNER_CONTAINER.put( returnValue.getID() , returnValue );
		}
				 						 	
		return returnValue;
	}
	
	public static final int __BUFFER_SIZE__ = 4096;
	
//	private static IndexOutOfBoundsException IOBE = new IndexOutOfBoundsException("Starting point is larger then Ending point");
//	private static IndexOutOfBoundsException NEGATIVE = new IndexOutOfBoundsException("Pointer shoud be POSITIVE");
	private static IOException INTEREX = new IOException("FileRead is Interrupted");
//	private static IOException UNURL = new IOException("Unsuported URL");

	private long LAST_EXEC_TIME = -1;
	private RandomAccessFile INNER_READER = null;
	private String ID = "^^";
	private byte[] __INNER_BUFFER__ = null;
	
	private LongMappingSpoolReader(){
		__INNER_BUFFER__ = new byte[__BUFFER_SIZE__];
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	private void setTargetFile( String filename ) throws Exception{
		if( INNER_READER != null ){
			INNER_READER.close();
		}
		
		INNER_READER = new RandomAccessFile( filename , "r" );
		ID = filename;
	}
	
//	private boolean isTarget( String name ){
//		return name.equals( this.ID );
//	}
	
	private String getID(){
		return this.ID;
	}
	
	private long getLastTime(){
		return LAST_EXEC_TIME;
	}
	
	public synchronized void inner_get( long __START__ , long __END__ , OutputStream __OUT_BUFFER__ ) throws Exception{
		this.LAST_EXEC_TIME = System.currentTimeMillis();
		long __LENGTH__ = __END__ - __START__;
		
		/**일단 스타팅 포인트로 이동
		 */
		this.INNER_READER.seek( __START__ );
		
		for( ; __LENGTH__ > 0 ; __LENGTH__ = __LENGTH__ - __BUFFER_SIZE__ ){
			if( __LENGTH__ > __BUFFER_SIZE__ ){ //버퍼 전체 읽기
				int size = this.INNER_READER.read( __INNER_BUFFER__ );
				if( size != __BUFFER_SIZE__ ){//전체가 다 읽어지지 않았을 경우...
					throw INTEREX;
				}
				__OUT_BUFFER__.write( __INNER_BUFFER__ );
			} else{ // 사이즈만큼 읽기
				int size = this.INNER_READER.read( __INNER_BUFFER__ , 0 , (int)__LENGTH__ );
				if( size != (int)__LENGTH__ ){//전체가 다 읽어지지 않았을 경우...
					throw INTEREX;
				}
				__OUT_BUFFER__.write( __INNER_BUFFER__ , 0 ,  size );
			}
		}
		return;
	}
	
	
}
