/*
 * @(#)SpoolingManager.java            2004. 11. 30.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package venus.spool.common.basic;

import java.lang.reflect.Method;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.schedule.ScheduledMonitor;
import venus.spool.common.handler.Spooler;

/**
 * 스풀링을 관장하는 클래스
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class SpoolingManager extends ScheduledMonitor {
	
	private static Spooler			spooler_class	= null;

	private static SpoolingManager	innerManager	= null;

	/** Creates new SpoolingManager */
	private SpoolingManager(int cycle) {
		super(cycle);
	}

	/**
	 * 초기화 파라미터 <br>
	 * 
	 * <PRE>
	 * 
	 * &lt;TARGET name="SPOOLER"&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;class name="Lib2002.net.smtp.spooler.SpoolingManager"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="spooler.class" value="[Spooler Class
	 * Name]"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="resend.class" value="[Resend Task Class]"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="recycle.limit" value="3"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="work.dir" value="[스풀생성 디렉토리]"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="work.file.header" value="ResendQue"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var
	 * name="work.file.ext" value=".spooling"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="wait.file.header" value="Resending"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="wait.file.ext"
	 * value=".work"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="send.file.header" value="QueProcess"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="send.file.ext" value=".sending"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="end.dir" value="[재발송이 완료된후 스풀 파일을 저장하는 디렉토리]"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="end.file.header" value="ResendDone"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="end.file.ext" value=".done"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="end.dir.timestamp" value="yyyyMMdd"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var
	 * name="store.limit" value="[하나의 스풀 파일에 저장되는 최대 라인수]"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="max.age" value="[하나의 스풀 파일이 rotate되는 주기]"/&gt; &lt;/TARGET&gt;
	 * 
	 * </PRE>
	 * <PRE>
	 * 
	 * spooler.class : Spooling 담당 Class name resend.class : 재발송을 담당하는 발송 Task Class -> 같이 초기화 한다. work.dir : 스풀 파일을 저장하는 디렉토리 work.file.header : 저장중인 spool파일이름 header work.file.ext : 저장중인 spool파일이름
	 * footer wait.file.header : 재발송 대기 파일이름 header wait.file.ext : 재발송 대기 파일이름 footer send.file.header : 재발송중인 파일이름 header send.file.ext : 재발송중인 파일이름 footer end.dir : 재발송을 완료한 spool파일을 옮겨 놓을 디렉토리
	 * end.file.header : 재발송을 완료한 spool파일이름 header end.file.ext : 재발송을 완료한 spool파일이름 footer end.dir.timestamp : 재발송을 완료한 spool파일을 디렉토리로 나누어 저장할때 디렉토리 규칙 store.limit : 하나의 스풀 파일에 기록할수 있는 최대 건수 max.age :
	 * 하나의 스풀 파일을 기록하는 최장 시간
	 * 
	 * </PRE>
	 * 
	 * 
	 * @param prop
	 *        초기화 파라미터
	 * @throws Exception
	 *         초기화중 에러발생
	 */
	public synchronized static void init(Object prop) throws Exception {

		Properties tmp = (Properties) prop;

		Class TargetClass = null;
		Method TargetMethod = null;
		Class[] method_args = new Class[1];
		method_args[0] = Object.class;
		Object[] target_arg = new Object[1];

		String ClassName = tmp.getProperty("spooler.class");

		/*
		 * 스풀링 클래스를 로드하여 초기화한다.
		 */
		TargetClass = Class.forName(ClassName);
		TargetMethod = TargetClass.getDeclaredMethod("init", method_args);

		target_arg[0] = prop;
		TargetMethod.invoke(null, target_arg);

		/*
		 * 스풀링 클래스 인스턴스를 만든다.
		 */
		spooler_class = (Spooler) (TargetClass.newInstance());

		/*
		 * 재발송 클래스를 초기화한다.
		 */
		ClassName = tmp.getProperty("resend.class");

		// 해당 클래스 파일의 인스턴트를 만든다.
		TargetClass = Class.forName(ClassName);
		TargetMethod = TargetClass.getDeclaredMethod("init", method_args);

		target_arg[0] = prop;
		TargetMethod.invoke(null, target_arg);

		int cycle_int_value = 60 * 60 * 1000;
		try {
			cycle_int_value = Integer.parseInt(tmp.getProperty("next.check.recycle")) * 60 * 1000;
		}
		catch(Exception ignore) {
		}

		if(log.isDebugEnabled()){
			log.debug("CHECK INTERVAL:" + cycle_int_value);
		}
		// 내부 모니터 쓰레드를 초기화하고 가동한다.
		innerManager = new SpoolingManager(cycle_int_value);
		innerManager.start();
	}

	/**
	 * 내부 spooler instance로 spool을 전달한다.
	 * 
	 * @param spool
	 *        재발송 spool Object
	 * @throws Exception
	 *         append 실패
	 */
	public synchronized static void registSpool(Object spool) throws Exception {
		if( spooler_class != null ) {
			spooler_class.addSpool(spool);
		}
		else {
			log.error("Spooler is not regist");
		}
	}

	/**
	 * 실질적인 검사를 한다.
	 */
	protected void check() {
		try {
			if(log.isDebugEnabled()){
				log.debug("CHECK NEXT SPOOL");
			}
			if( spooler_class.storeNext() ) {
				if(log.isDebugEnabled()){
					log.debug("BINGO~~~!!!!!");
				}
				spooler_class.switchSpool();
			}
		}
		catch(Exception e) {
			log.error("SpoolingManager Spooler Check Error : ", e);
		}
	}

	/**
	 * 모니터링을 종료한다.
	 */
	public static void destroy() {
		innerManager.close();
	}
}
