/*
 * @(#)SpoolInfo.java            2004. 12. 1.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package venus.spool.common.basic;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import freemarker20.template.SimpleHash;
import lombok.extern.slf4j.Slf4j;
import pluto.io.eMsFileWriter;
import pluto.util.xml.DOMParser;
import pluto.util.xml.XMLUtil;
import pluto.util.xml.XMLWriter;
import venus.spool.common.parser.SpoolHeaderParser;

/**
 * Spool 정보를 담은 xml Document의 생성 및 해석을 정의한다.
 * 
 * @version
 * @author lena
 *  
 */
@Slf4j
public class SpoolInfo implements Cloneable {

	/* 3시간동안 호출이 한번도 일어나지 않은 상태에서 지속된 일정시간이 되면 삭제하도록 한다. */
	public static final long		NO_END_DURATION				= 10 * 60 * 1000L;

	/** DTD 파일 위치 */
	private static String			DTD_LOCATION				= null;

	/** XML 인코딩 타입 */
	private static String			XML_ENC_TYPE				= null;

	/** XML 파일로 적을 ��의 캐릭터 셋 */
//	private static String			XML_OUT_CHARSET				= null;

	/** XML Writer Instance */
	private static XMLWriter		XML_WRITER_INSTANCE			= null;

	/** Spool Info xml 파일의 위치가 담긴 path */
	private String					spoolInfoPath				= "";

	static {
		try {
			XML_WRITER_INSTANCE = new XMLWriter();
		}
		catch(Throwable th) {
			log.error(th.getMessage());
			System.exit(1);
		}
	}

	/** Holds value of property ID. */
	private String					ID							= "";

	/** Holds value of property sendState. */
	private String					sendState					= "";

	/** Holds value of property startTime. */
	private long					startTime;

	/** Holds value of property defaultMapping. */
	private Map						defaultMapping;

	/** Holds value of property scheduleInfo. */
	private Vector					spoolFilesInfo;

	/** Holds Parallel value of property scheduleInfo. */
	private Properties				spoolParallelFilesInfo;

	/** Holds value of property mappingHeader. */
	private String					mappingHeader				= "";

	/** 최종 호출 시간을 기억한다. */
	private long					exec_time					= 0;

	/** Holds value of property sendType. */
	// private String sendType="";
	/** Holds value of property defaultHashMapping. */
	private Map						defaultHashMapping;

	/** Holds value of property RCPT_PATTERN. */
	//private Short RCPT_PATTERN;
	private Map						HEADER_KEY_MAP				= null;

	private String					spoolDelimit				= null;

	private String					serialDelimit				= null;

	private SimpleHash				DEFAULT_HASH_MAPPING_INFO	= null;

	// 분할 발송 seq
	private int						spoolDivideScheduleSeq		= 0;
	private String					startMemberId				= null;
	private String					lastMemberId				= null;
	private int						spoolSize					= 0;
	// private String SPOOL_DELIMIT = null;

	/** Creates new SpoolInfo */
	public SpoolInfo() {

		this.exec_time = System.currentTimeMillis();
	}

	/**
	 * SpoolInfo의 정보를 XML Document로 변환하여 가져온다.
	 * 
	 * @return
	 * @throws Exception
	 */
	protected synchronized Document getXmlDocument() throws Exception {

		if (log.isDebugEnabled()) 
			log.debug("default_hashmapping : {}", this.defaultHashMapping);

		if (log.isDebugEnabled()) 
			log.debug("default_mapping : {}", this.defaultMapping);

		Document returnValue = DOMParser.getEmptyDocument();

		// 최상위 Element
		Element spoolElements = returnValue.createElement("SPOOL");

		// 메일 전체 정보 Element( SPOOL -> POSTID ) 시작
		Element postIdElements = returnValue.createElement("POSTID");
		postIdElements.setAttribute("value", ID);

		// ( SPOOL -> POSTID ) 노드를 ( SPOOL ) 노드에 추가
		spoolElements.appendChild(postIdElements);

		// 스풀 전체 정보 Element( SPOOL -> INFO ) 시작
		Element infoElements = returnValue.createElement("INFO");

		// 진행 상태 Element( SPOOL -> INFO -> SENDSTATE )
		Element sendStateElements = returnValue.createElement("SENDSTATE");
		sendStateElements.setAttribute("value", sendState);
		infoElements.appendChild(sendStateElements);
		
		// 분할 발송 관련 추가
		// ( SPOOL -> SIZE )
		Element spoolSizeElement = returnValue.createElement("SIZE");
		spoolSizeElement.setAttribute("value", String.valueOf(spoolSize));
		spoolElements.appendChild(spoolSizeElement);
		
		Element divideElements = returnValue.createElement("DIVIDE");
		// start memberId Element (SPOOL -> DIVIDE -> START_MEMBER_ID)
		Element startMemberIdElement = returnValue.createElement("START_MEMBER_ID");
		startMemberIdElement.setAttribute("value", startMemberId);
		divideElements.appendChild(startMemberIdElement);
		
		// start memberId Element (SPOOL -> DIVIDE -> LAST_MEMBER_ID)
		Element lastMemberIdElement = returnValue.createElement("LAST_MEMBER_ID");
		lastMemberIdElement.setAttribute("value", lastMemberId);
		divideElements.appendChild(lastMemberIdElement);
		
		// start memberId Element (SPOOL -> DIVIDE -> SEQNO)
		Element divideScheduleSeqNoElement = returnValue.createElement("SEQNO");
		divideScheduleSeqNoElement.setAttribute("value", String.valueOf(spoolDivideScheduleSeq));
		divideElements.appendChild(divideScheduleSeqNoElement);
		
		spoolElements.appendChild(divideElements);
		

		// Spool File 이름들을 꺼내서 꼽아주세요~~~~~
		for (int i = 0; i < spoolFilesInfo.size(); i++) {
			String key = "file" + i;
			String value = (String) spoolFilesInfo.get(i);

			Element varElements = returnValue.createElement("var");

			varElements.setAttribute("name", key);
			varElements.setAttribute("value", value);

			infoElements.appendChild(varElements);
		}

		// ( SPOOL -> INFO ) 노드를 ( SPOOL ) 노드에 추가
		spoolElements.appendChild(infoElements);

		// 매핑 정보( SPOOL -> MAPPING )
		Element mappingElements = returnValue.createElement("MAPPING");

		// 매핑 헤더 정보( SPOOL -> MAPPING -> DELIM )
		Element delimElements = returnValue.createElement("DELIM");
		delimElements.setAttribute("value", spoolDelimit);

		// ( SPOOL -> MAPPING -> DELIM ) 노드를 ( SPOOL -> MAPPING ) 노드에 추가
		mappingElements.appendChild(delimElements);

		// 매핑 헤더 정보( SPOOL -> MAPPING -> HEADER )
		Element headerElements = returnValue.createElement("HEADER");
		headerElements.setAttribute("value", mappingHeader);

		// ( SPOOL -> MAPPING -> HEADER ) 노드를 ( SPOOL -> MAPPING ) 노드에 추가
		mappingElements.appendChild(headerElements);

		// 기본 매핑 정보 정보( SPOOL -> MAPPING -> COMMON )
		Element commonElements = returnValue.createElement("COMMON");

		// 기본 매핑이 널이 아니라면 꺼내서 꼽아주세요~~~~~
		if( defaultMapping != null ) {
			for (Iterator iter = defaultMapping.keySet().iterator(); iter.hasNext();) {
				String key = (String) iter.next();
				String value = (String) defaultMapping.get(key);

				Element varElements = returnValue.createElement("elm");
				varElements.setAttribute("name", key);
				CDATASection originalSection = returnValue.createCDATASection("VALUE");
				originalSection.setData(value);
				varElements.appendChild(originalSection);
				commonElements.appendChild(varElements);
			}
		}

		// ( SPOOL -> MAPPING -> COMMON ) 노드를 ( SPOOL -> MAPPING ) 노드에 추가
		mappingElements.appendChild(commonElements);

		// 기본 헤쉬 매핑 정보 정보( SPOOL -> MAPPING -> HASH )
		Element hashElements = returnValue.createElement("HASH");

		// 기본 해쉬 매핑이 널이 아니면 꺼내서 꼽아주세요~~~~~
		if( defaultHashMapping != null ) {
			for (Iterator iter = defaultHashMapping.keySet().iterator(); iter.hasNext();) {
				String key = (String) iter.next();
				Object value = defaultHashMapping.get(key);

				if( value instanceof String ) {
					Element varElements = returnValue.createElement("elm");
					varElements.setAttribute("name", key);
					CDATASection originalSection = returnValue.createCDATASection("VALUE");
					originalSection.setData(value.toString());
					varElements.appendChild(originalSection);
					hashElements.appendChild(varElements);
				}
				else if( value instanceof List ) {
					Element listElements = returnValue.createElement("list");
					listElements.setAttribute("name", key);

					for (Iterator subiter = ((List) value).iterator(); subiter.hasNext();) {
						Map subMap = (Map) subiter.next();
						Element subLoopElements = returnValue.createElement("loop");

						if (log.isDebugEnabled()) 
							log.debug("new loop", "start....");
						for (Iterator list_elm = subMap.keySet().iterator(); list_elm.hasNext();) {
							String subkey = (String) list_elm.next();
							String subvalue = (String) subMap.get(subkey);
							Element sub_VAR_ELEMENTS = returnValue.createElement("lelm");

							sub_VAR_ELEMENTS.setAttribute("name", subkey);
							//sub_VAR_ELEMENTS.setAttribute( "value" , subvalue
							// );

							CDATASection ORIGINAL_SECTION = returnValue.createCDATASection("VALUE");

							ORIGINAL_SECTION.setData(subvalue);

							sub_VAR_ELEMENTS.appendChild(ORIGINAL_SECTION);

							if (log.isDebugEnabled()) 
								log.debug(subkey, subvalue);

							subLoopElements.appendChild(sub_VAR_ELEMENTS);
						}
						listElements.appendChild(subLoopElements);
					}
					hashElements.appendChild(listElements);
				}
				else {
					log.error("UNKNOWN CONTENT INFO TYPE", value.getClass().toString());
				}
			}
		}

		// ( SPOOL -> MAPPING -> HASH ) 노드를 ( SPOOL -> MAPPING ) 노드에 추가
		mappingElements.appendChild(hashElements);

		// 매핑 관련 파라미터 세팅 종료
		// ( SPOOL -> MAPPING ) 노드를 ( SPOOL ) 노드에 추가
		spoolElements.appendChild(mappingElements);

		returnValue.appendChild(spoolElements);

		return returnValue;
	}

	/**
	 * 병렬 발송에서 쓰이며, SpoolInfo의 정보를 XML Document로 변환하여 가져온다.
	 * 
	 * @return
	 * @throws Exception
	 */
	protected synchronized Document getParallelXmlDocument(String curSvrName) throws Exception {

		if (log.isDebugEnabled()) 
			log.debug("default_hashmapping : {}", this.defaultHashMapping);

		if (log.isDebugEnabled()) 
			log.debug("default_mapping : {}", this.defaultMapping);

		Document returnValue = DOMParser.getEmptyDocument();

		// 최상위 Element
		Element spoolElements = returnValue.createElement("SPOOL");

		// 메일 전체 정보 Element( SPOOL -> POSTID ) 시작
		Element postIdElements = returnValue.createElement("POSTID");
		postIdElements.setAttribute("value", ID);

		// ( SPOOL -> POSTID ) 노드를 ( SPOOL ) 노드에 추가
		spoolElements.appendChild(postIdElements);

		// 스풀 전체 정보 Element( SPOOL -> INFO ) 시작
		Element infoElements = returnValue.createElement("INFO");

		// 진행 상태 Element( SPOOL -> INFO -> SENDSTATE )
		Element sendStateElements = returnValue.createElement("SENDSTATE");
		sendStateElements.setAttribute("value", sendState);
		infoElements.appendChild(sendStateElements);
		
		// 분할 발송 설정
		// ( SPOOL -> SIZE )
		Element spoolSizeElement = returnValue.createElement("SIZE");
		spoolSizeElement.setAttribute("value", String.valueOf(spoolSize));
		spoolElements.appendChild(spoolSizeElement);
				
		Element divideElements = returnValue.createElement("DIVIDE");
		// start memberId Element (SPOOL -> DIVIDE -> START_MEMBER_ID)
		Element startMemberIdElement = returnValue.createElement("START_MEMBER_ID");
		startMemberIdElement.setAttribute("value", startMemberId);
		divideElements.appendChild(startMemberIdElement);
		
		// start memberId Element (SPOOL -> DIVIDE -> LAST_MEMBER_ID)
		Element lastMemberIdElement = returnValue.createElement("LAST_MEMBER_ID");
		lastMemberIdElement.setAttribute("value", lastMemberId);
		divideElements.appendChild(lastMemberIdElement);
		
		// start memberId Element (SPOOL -> DIVIDE -> SEQNO)
		Element divideScheduleSeqNoElement = returnValue.createElement("SEQNO");
		divideScheduleSeqNoElement.setAttribute("value", String.valueOf(spoolDivideScheduleSeq));
		divideElements.appendChild(divideScheduleSeqNoElement);
		
		spoolElements.appendChild(divideElements);
		
		//	서버 이름들을 가져온다..
		Enumeration parallelSvrNms = spoolParallelFilesInfo.propertyNames();

		//		 Spool File 이름들을 꺼내서 꼽아주세요~~~~~
		int i = 0;
		String svrKeyOrg = "";
		String svrKey = "";

		while (parallelSvrNms.hasMoreElements()) {

			svrKeyOrg = (String) parallelSvrNms.nextElement();

			if( svrKeyOrg != null ) {
				svrKey = svrKeyOrg.substring(0, svrKeyOrg.indexOf("|"));
			}

			if( curSvrName != null && curSvrName.equals(svrKey) ) {

				String key = "file" + (i++);
				String value = spoolParallelFilesInfo.getProperty(svrKeyOrg);

				Element varElements = returnValue.createElement("var");

				varElements.setAttribute("name", key);
				varElements.setAttribute("value", value);

				infoElements.appendChild(varElements);
			}

		}

		// ( SPOOL -> INFO ) 노드를 ( SPOOL ) 노드에 추가
		spoolElements.appendChild(infoElements);

		// 매핑 정보( SPOOL -> MAPPING )
		Element mappingElements = returnValue.createElement("MAPPING");

		// 매핑 헤더 정보( SPOOL -> MAPPING -> DELIM )
		Element delimElements = returnValue.createElement("DELIM");
		delimElements.setAttribute("value", spoolDelimit);

		// ( SPOOL -> MAPPING -> DELIM ) 노드를 ( SPOOL -> MAPPING ) 노드에 추가
		mappingElements.appendChild(delimElements);

		// 매핑 헤더 정보( SPOOL -> MAPPING -> HEADER )
		Element headerElements = returnValue.createElement("HEADER");
		headerElements.setAttribute("value", mappingHeader);

		// ( SPOOL -> MAPPING -> HEADER ) 노드를 ( SPOOL -> MAPPING ) 노드에 추가
		mappingElements.appendChild(headerElements);

		// 기본 매핑 정보 정보( SPOOL -> MAPPING -> COMMON )
		Element commonElements = returnValue.createElement("COMMON");

		// 기본 매핑이 널이 아니라면 꺼내서 꼽아주세요~~~~~
		if( defaultMapping != null ) {
			for (Iterator iter = defaultMapping.keySet().iterator(); iter.hasNext();) {
				String key = (String) iter.next();
				String value = (String) defaultMapping.get(key);

				Element varElements = returnValue.createElement("elm");
				varElements.setAttribute("name", key);
				CDATASection originalSection = returnValue.createCDATASection("VALUE");
				originalSection.setData(value);
				varElements.appendChild(originalSection);
				commonElements.appendChild(varElements);
			}
		}

		// ( SPOOL -> MAPPING -> COMMON ) 노드를 ( SPOOL -> MAPPING ) 노드에 추가
		mappingElements.appendChild(commonElements);

		// 기본 헤쉬 매핑 정보 정보( SPOOL -> MAPPING -> HASH )
		Element hashElements = returnValue.createElement("HASH");

		// 기본 해쉬 매핑이 널이 아니면 꺼내서 꼽아주세요~~~~~
		if( defaultHashMapping != null ) {
			for (Iterator iter = defaultHashMapping.keySet().iterator(); iter.hasNext();) {
				String key = (String) iter.next();
				Object value = defaultHashMapping.get(key);

				if( value instanceof String ) {
					Element varElements = returnValue.createElement("elm");
					varElements.setAttribute("name", key);
					CDATASection originalSection = returnValue.createCDATASection("VALUE");
					originalSection.setData(value.toString());
					varElements.appendChild(originalSection);
					hashElements.appendChild(varElements);
				}
				else if( value instanceof List ) {
					Element listElements = returnValue.createElement("list");
					listElements.setAttribute("name", key);

					for (Iterator subiter = ((List) value).iterator(); subiter.hasNext();) {
						Map subMap = (Map) subiter.next();
						Element subLoopElements = returnValue.createElement("loop");

						if (log.isDebugEnabled()) 
							log.debug("new loop", "start....");
						for (Iterator list_elm = subMap.keySet().iterator(); list_elm.hasNext();) {
							String subkey = (String) list_elm.next();
							String subvalue = (String) subMap.get(subkey);
							Element sub_VAR_ELEMENTS = returnValue.createElement("lelm");

							sub_VAR_ELEMENTS.setAttribute("name", subkey);
							//sub_VAR_ELEMENTS.setAttribute( "value" , subvalue
							// );

							CDATASection ORIGINAL_SECTION = returnValue.createCDATASection("VALUE");

							ORIGINAL_SECTION.setData(subvalue);

							sub_VAR_ELEMENTS.appendChild(ORIGINAL_SECTION);

							if (log.isDebugEnabled()) 
								log.debug(subkey, subvalue);

							subLoopElements.appendChild(sub_VAR_ELEMENTS);
						}
						listElements.appendChild(subLoopElements);
					}
					hashElements.appendChild(listElements);
				}
				else {
					log.error("UNKNOWN CONTENT INFO TYPE", value.getClass().toString());
				}
			}
		}

		// ( SPOOL -> MAPPING -> HASH ) 노드를 ( SPOOL -> MAPPING ) 노드에 추가
		mappingElements.appendChild(hashElements);

		// 매핑 관련 파라미터 세팅 종료
		// ( SPOOL -> MAPPING ) 노드를 ( SPOOL ) 노드에 추가
		spoolElements.appendChild(mappingElements);

		returnValue.appendChild(spoolElements);

		return returnValue;
	}

	/**
	 * SpoolInfo객체를 xml File로 적는다.
	 * 
	 * @param out_file
	 *            xml File 이름 ( 절대 경로로 적는다 )
	 * @param info
	 *            SpoolInfo 객체
	 * @throws Exception
	 */
	public synchronized static void toXmlFile(String out_file, SpoolInfo info) throws Exception {
		eMsFileWriter out = new eMsFileWriter(out_file);

		try {
			XML_WRITER_INSTANCE.setEncoding(XML_ENC_TYPE);
			XML_WRITER_INSTANCE.outResult(out, info.getXmlDocument(), DTD_LOCATION);
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			try {
				out.flush();
			}
			catch(Exception e) {
			}
			try {
				out.close();
			}
			catch(Exception e) {
			}
		}
	}

	/**
	 * 병렬 발송 스풀생성에서 쓰이며, SpoolInfo객체를 xml File로 적는다.
	 * 
	 * @param out_file
	 *            xml File 이름 ( 절대 경로로 적는다 )
	 * @param info
	 *            SpoolInfo 객체
	 * @throws Exception
	 */
	public synchronized static void toXmlParallelFile(String out_file, SpoolInfo info, String curSvrName) throws Exception {

		eMsFileWriter out = new eMsFileWriter(out_file);

		try {
			XML_WRITER_INSTANCE.setEncoding(XML_ENC_TYPE);
			XML_WRITER_INSTANCE.outResult(out, info.getParallelXmlDocument(curSvrName), DTD_LOCATION);
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			try {
				out.flush();
			}
			catch(Exception e) {
			}
			try {
				out.close();
			}
			catch(Exception e) {
			}
		}
	}

	/**
	 * SpoolInfo로 생성된 xml 파일을 SpoolInfo 객체로 가져온다.
	 * 
	 * @param url
	 *            xml 파일 위치
	 * @return 생성된 SpoolInfo 객체
	 * @throws Exception
	 */
	public synchronized static SpoolInfo XmlToSpoolInfo(String url) throws Exception {

		Document DOCUMENT = DOMParser.getDocumentFromUrl(url);

		SpoolInfo returnValue = new SpoolInfo();

		Element spoolElements = (Element) DOCUMENT.getElementsByTagName("SPOOL").item(0);

		// 아이디 셋팅
		Element postIdElements = (Element) spoolElements.getElementsByTagName("POSTID").item(0);
		returnValue.setID(postIdElements.getAttribute("value"));

		Element infoElements = (Element) spoolElements.getElementsByTagName("INFO").item(0);

		// 발송진행상태 셋팅
		Element sendStateElements = (Element) infoElements.getElementsByTagName("SENDSTATE").item(0);
		returnValue.setSendState(sendStateElements.getAttribute("value"));
		
		
		// 분할 발송 셋팅
		Element divideElements = (Element) spoolElements.getElementsByTagName("DIVIDE").item(0);
		Element spoolSizeElement = (Element) spoolElements.getElementsByTagName("SIZE").item(0);
		returnValue.setSpoolSize(Integer.parseInt(spoolSizeElement.getAttribute("value")));
		
		Element startMemberIdElements = (Element) divideElements.getElementsByTagName("START_MEMBER_ID").item(0);
		Element lastMemberIdElements = (Element) divideElements.getElementsByTagName("LAST_MEMBER_ID").item(0);
		Element seqNoElements = (Element) divideElements.getElementsByTagName("SEQNO").item(0);
		
		returnValue.setStartMemberId(startMemberIdElements.getAttribute("value"));
		returnValue.setSpoolDivideScheduleSeq(Integer.parseInt(seqNoElements.getAttribute("value")));
		returnValue.setLastMemberId(lastMemberIdElements.getAttribute("value"));
		
		// 나머지 프로퍼티를 세팅한다.
		NodeList propertyNodes = infoElements.getElementsByTagName("var");

		Vector spoolFiles = new Vector();

		for (int i = 0; i < propertyNodes.getLength(); i++) {
			Element varElements = (Element) propertyNodes.item(i);
			spoolFiles.addElement(varElements.getAttribute("value"));
		}

		returnValue.setSpoolFilesInfo(spoolFiles);

		Element mappingElements = (Element) spoolElements.getElementsByTagName("MAPPING").item(0);

		// 매핑 헤더 정보( SPOOL -> MAPPING -> DELIM )
		Element headerDelimElements = (Element) mappingElements.getElementsByTagName("DELIM").item(0);
		returnValue.setSpoolDelimit(headerDelimElements.getAttribute("value"));

		// 매핑 헤더 정보( SPOOL -> MAPPING -> HEADER )
		Element headerElements = (Element) mappingElements.getElementsByTagName("HEADER").item(0);
		returnValue.setMappingHeader(headerElements.getAttribute("value"));

		// 기본 매핑 정보 정보( SPOOL -> MAPPING -> COMMON )
		Element commonElements = (Element) mappingElements.getElementsByTagName("COMMON").item(0);

		propertyNodes = commonElements.getElementsByTagName("elm");

		Properties commonMappingInfo = new Properties();
		for (int i = 0; i < propertyNodes.getLength(); i++) {
			Element varElements = (Element) propertyNodes.item(i);
			commonMappingInfo.setProperty(varElements.getAttribute("name"), XMLUtil.getCDATA_SECTION(varElements, " "));
		}

		returnValue.setDefaultMapping(commonMappingInfo);

		// 기본 매핑 정보 정보( SPOOL -> MAPPING -> HASH )
		Element hashElements = (Element) mappingElements.getElementsByTagName("HASH").item(0);

		propertyNodes = hashElements.getElementsByTagName("elm");

		Map hashMappingInfo = new Hashtable();
		for (int i = 0; i < propertyNodes.getLength(); i++) {
			Element varElements = (Element) propertyNodes.item(i);
			hashMappingInfo.put(varElements.getAttribute("name"), XMLUtil.getCDATA_SECTION(varElements, " "));
		}

		// 리스트 해쉬도 추가해야한다.
		propertyNodes = hashElements.getElementsByTagName("list");

		for (int i = 0; i < propertyNodes.getLength(); i++) {
			LinkedList defaultHashList = new LinkedList();
			Element listElements = (Element) propertyNodes.item(i);
			NodeList subLoopPropertyNodes = listElements.getElementsByTagName("loop");

			for (int sub_loop = 0; sub_loop < subLoopPropertyNodes.getLength(); sub_loop++) {
				Element subLoopElements = (Element) subLoopPropertyNodes.item(sub_loop);
				NodeList subListPropertyNodes = subLoopElements.getElementsByTagName("lelm");

				Properties subListProperty = new Properties();
				for (int sub_i = 0; sub_i < subListPropertyNodes.getLength(); sub_i++) {
					Element varElements = (Element) subListPropertyNodes.item(sub_i);
					subListProperty.setProperty(varElements.getAttribute("name"), XMLUtil.getCDATA_SECTION(varElements, " "));
				}
				defaultHashList.addLast(subListProperty);
			}
			hashMappingInfo.put(listElements.getAttribute("name"), defaultHashList);
		}

		returnValue.setDefaultHashMapping(hashMappingInfo);

		return returnValue;
	}

	/**
	 * 현재의 Content가 유효한지를 반환한다. 지정된 시간동안만 재발송을 하기때문에 기준시간이상이되면 삭제되고 재발송은 진행되지
	 * 않는다. SpoolInfoManager에 의해서 호출이되며 반환되는 값에 따라서 지속여부가 결정이 된다.
	 * 
	 * @return true: 만료기간이 지났으며 파기 되어야 한다. SpoolInfoManager는 이 Content를 삭제한다.
	 *         false: 만료기간이 지나지 않았으며 지속되어야한다.
	 */
	public boolean expire() {

		return System.currentTimeMillis() - this.exec_time > NO_END_DURATION;
	}

	public void execute() {

		this.exec_time = System.currentTimeMillis();
	}

	/**
	 * Getter for property ID.
	 * 
	 * @return Value of property ID.
	 */
	public String getID() {

		return ID;
	}

	/**
	 * Setter for property ID.
	 * 
	 * @param ID
	 *            New value of property ID.
	 */
	public void setID(String ID) {

		this.ID = ID;
	}

	/**
	 * Getter for property sendState.
	 * 
	 * @return Value of property sendState.
	 */
	public String getSendState() {

		return sendState;
	}

	/**
	 * Setter for property jobStatus.
	 * 
	 * @param jobStatus
	 *            New value of property jobStatus.
	 */
	public void setSendState(String sendState) {

		this.sendState = sendState;
	}

	/**
	 * Getter for property startTime.
	 * 
	 * @return Value of property startTime.
	 */
	public long getStartTime() {

		return startTime;
	}

	/**
	 * Setter for property startTime.
	 * 
	 * @param startTime
	 *            New value of property startTime.
	 */
	public void setStartTime(long startTime) {

		this.startTime = startTime;
	}

	/**
	 * Getter for property defaultMapping.
	 * 
	 * @return Value of property defaultMapping.
	 */
	public Map getDefaultMapping() {

		return defaultMapping;
	}

	/**
	 * Setter for property defaultMapping.
	 * 
	 * @param defaultMapping
	 *            New value of property defaultMapping.
	 */
	public void setDefaultMapping(Map defaultMapping) {

		this.defaultMapping = defaultMapping;
	}

	/**
	 * Getter for property scheduleInfo.
	 * 
	 * @return Value of property scheduleInfo.
	 */
	public Vector getSpoolFilesInfo() {

		return spoolFilesInfo;
	}

	/**
	 * Setter for property scheduleInfo.
	 * 
	 * @param scheduleInfo
	 *            New value of property scheduleInfo.
	 */
	public void setSpoolFilesInfo(Vector prop) {
		this.spoolFilesInfo = prop;
	}

	/**
	 * Getter for property scheduleInfo.
	 * 
	 * @return Value of property scheduleInfo.
	 */
	public Properties getSpoolParallelFilesInfo() {

		return spoolParallelFilesInfo;
	}

	/**
	 * Setter for property scheduleInfo.
	 * 
	 * @param scheduleInfo
	 *            New value of property scheduleInfo.
	 */
	public void setSpoolParallelFilesInfo(Properties prop) {

		this.spoolParallelFilesInfo = prop;
	}

	/**
	 * Getter for property mappingHeader.
	 * 
	 * @return Value of property mappingHeader.
	 */
	public String getMappingHeader() {

		return mappingHeader;
	}

	/**
	 * Setter for property mappingHeader.
	 * 
	 * @param mappingHeader
	 *            New value of property mappingHeader.
	 */
	public void setMappingHeader(String mappingHeader) {

		this.mappingHeader = mappingHeader;
	}

	/**
	 * Getter for property defaultHashMapping.
	 * 
	 * @return Value of property defaultHashMapping.
	 */
	public Map getDefaultHashMapping() {

		return defaultHashMapping;
	}

	public synchronized SimpleHash getDefaultSimpleHashMapping() {

		if( DEFAULT_HASH_MAPPING_INFO == null ) {
			DEFAULT_HASH_MAPPING_INFO = SimpleHash.MapToSimpleHash(defaultHashMapping);
		}

		return DEFAULT_HASH_MAPPING_INFO;
	}

	/**
	 * Setter for property defaultHashMapping.
	 * 
	 * @param defaultHashMapping
	 *            New value of property defaultHashMapping.
	 */
	public void setDefaultHashMapping(Map defaultHashMapping) {

		this.defaultHashMapping = defaultHashMapping;
	}

	/**
	 * Getter for property spoolDelimit.
	 * 
	 * @return Value of property spoolDelimit.
	 */
	public String getSpoolDelimit() {

		return spoolDelimit;
	}

	/**
	 * Setter for property spoolDelimit.
	 * 
	 * @param spoolDelimit
	 *            New value of property spoolDelimit.
	 */
	public void setSpoolDelimit(String spoolDelimit) {

		this.spoolDelimit = spoolDelimit;
	}

	/**
	 * Getter for property serialDelimit.
	 * 
	 * @return Value of property serialDelimit.
	 */
	public String getSerialDelimit() {

		return serialDelimit;
	}

	/**
	 * Setter for property serialDelimit.
	 * 
	 * @param serialDelim
	 *            New value of property serialDelimit.
	 */
	public void setSerialDelimit(String serialDelimit) {

		this.serialDelimit = serialDelimit;
	}

	public SpoolInfo getClone() throws Exception {

		return (SpoolInfo) clone();
	}

	/**
	 * SpoolInfo의 매핑 정보로 부터 스풀 헤더 정보를 읽어들인다.
	 * 
	 * @param delim
	 * @return
	 */
	public synchronized Map getHEADER_KEY_MAP(String delim) {

		if( mappingHeader == null || mappingHeader.length() < 10 )
			return null;

		if( HEADER_KEY_MAP == null ) {
			HEADER_KEY_MAP = SpoolHeaderParser.parse(mappingHeader, delim);
		}

		return HEADER_KEY_MAP;
	}

	/**
	 * DTD 파일 위치를 정의한다.
	 * 
	 * @param location
	 *            DTD 파일 위치
	 * @throws Exception
	 */
	public synchronized static void setDTDLocation(String location) throws Exception {

		DTD_LOCATION = location;
	}

	/**
	 * XML 인코딩 타입을 정의한다.
	 * 
	 * @param enc
	 *            인코딩 종류
	 * @throws Exception
	 */
	public synchronized static void setEncoding(String enc) throws Exception {

		XML_ENC_TYPE = enc;
	}

	/**
	 * XML 파일을 적을 때의 인코딩 타입을 정의한다.
	 * 
	 * @param enc
	 *            인코딩 종
	 * @throws Exception
	 */
	public synchronized static void setFileEncoding(String enc) throws Exception {

//		XML_OUT_CHARSET = enc;
	}

	/**
	 * @return
	 */
	public String getSpoolInfoPath() {
		return spoolInfoPath;
	}

	/**
	 * @param string
	 */
	public void setSpoolInfoPath(String string) {
		spoolInfoPath = string;
	}

	public int getSpoolDivideScheduleSeq() {
		return spoolDivideScheduleSeq;
	}

	public int getNextSpoolDivideScheduleSeq() {
		return this.spoolDivideScheduleSeq + 1;
	}
	
	public void setSpoolDivideScheduleSeq(int spoolDivideScheduleSeq) {
		this.spoolDivideScheduleSeq = spoolDivideScheduleSeq;
	}

	public String getStartMemberId() {
		return startMemberId;
	}

	public void setStartMemberId(String startMemberId) {
		this.startMemberId = startMemberId;
	}

	public String getLastMemberId() {
		return lastMemberId;
	}

	public void setLastMemberId(String lastMemberId) {
		this.lastMemberId = lastMemberId;
	}

	public int getSpoolSize() {
		return spoolSize;
	}

	public void setSpoolSize(int spoolSize) {
		this.spoolSize = spoolSize;
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("id:").append(this.ID).append(",")
		.append("lastMemberId:").append(this.lastMemberId).append(",")
		.append("sendState:").append(this.sendState).append(",")
		.append("spoolSize:").append(this.spoolSize).append(",")
		.append("spoolDivideScheduleSeq:").append(this.spoolDivideScheduleSeq).append(",")
		.append("startMemberId:").append(this.startMemberId);
		return sb.toString();
	}
}
