/*
 * @(#)InstanceFactory.java            2004. 11. 30.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package venus.spool.common.basic;

import java.util.Hashtable;
import java.util.Properties;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsTypes;
import venus.spool.auto.task.AutoBaseSpoolTask;

/**
 * Class description :
 * 
 * @version
 * @author lena
 *  
 */
@Slf4j
public class InstanceFactory {

	/**	 */
	public static final String		__UNDER_BAR__	= "_";

	/**	 */
	private static final String		name			= "InstanceFactory";

	/**	 */
	private static Hashtable		InstanceMap		= new Hashtable();

	/**
	 * 이름을 반환한다.
	 * 
	 * @return 이름
	 */
	public static String getName() {
		return name;
	}

	/**
	 * 초기화 파라미터
	 * 
	 * <PRE>
	 * 
	 * &lt;TARGET name="EXT SEND TASK POPPER"&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;class
	 * name="Lib2002.schedule.ExternalSendTaskPopper"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;var name="DEFAULT"
	 * value="Auto2002.tasks.MailSendTask"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;var
	 * name="DEFAULT_TEST" value="Auto2002.tasks.TestMailSendTask"/&gt;
	 * &lt;/TARGET&gt;
	 * 
	 * </PRE>
	 * <PRE>
	 * 
	 * name에는 SEND_TYPE의 값이 설정되고 value에는 담당하는 SendTask Class Name을 세팅한다.
	 * name="O" value="hellow" => "O"라는 SEND_TYPE에 대해서는 hellow.class를 선택하게 된다.
	 * 시험발송일 경우에는 _TEST 라고 지정을 한다. 만일 인덱스에 없을 경우에는 DEFAULT가 선택된다. 그러므로 위에 두 라인은
	 * 꼭! 있어야 한다. 추가로 SMS 나 FAX 등의 변형된 패턴의 발송이 추가될때에 등록을 해주면 된다.
	 * 
	 * </PRE>
	 * 
	 * @param tmp
	 *            초기화 파라미터
	 * @throws Exception
	 *             초기화 에러
	 */
	public static void init(Object tmp) throws Exception {
		Element TargetNode = (Element) tmp;
		Element SubNode = null;

		String SendTypeName = null;
		String SendStateName = null;

		String InstanceName = null;
		String InstanceClassName = null;
		//String InstanceTestClassName = null;

		NodeList TargetNodeList = TargetNode.getElementsByTagName("type");
		int TargetNodeCount = TargetNodeList.getLength();

		/**
		 * 각 type 별로 지정된 클래스를 내부에 저장한다.
		 */
		for (int i = 0; i < TargetNodeCount; i++) {
			TargetNode = (Element) TargetNodeList.item(i);

			/**
			 * 발송 타입이름을 가져온다.
			 */
			SendTypeName = TargetNode.getAttribute("value");
			SendStateName = TargetNode.getAttribute("state");

			/**
			 * Sub Instance Node에 대해 지정된 클래스를 Load한다.
			 */
			NodeList TargetInstanceNodeList = TargetNode.getElementsByTagName("Instance");

			for (int j = 0; j < TargetInstanceNodeList.getLength(); j++) {
				SubNode = (Element) TargetInstanceNodeList.item(j);

				InstanceName = SubNode.getAttribute("name");
				InstanceClassName = SubNode.getAttribute("class");

				Class targetClass = Class.forName(InstanceClassName);

				InstanceMap.put(SendStateName.concat("_").concat(SendTypeName).concat("_").concat(InstanceName), targetClass);
			}
		}
	}

	/**
	 * 발송에서 사용하는 클래스의 Instance를 반환한다.
	 * 
	 * @param info
	 *            발송정보 [ SEND_TYPE , SEND_STATE ] 가 포함되어 있어야 한다.
	 * @param instance_type
	 *            인스턴스 정보
	 * @throws Exception
	 *             생성에러
	 * @return 지정된 종류의 Instance
	 * @see mercury.contents.basic.InstanceFactory#getInstance( String , String ,
	 *      short )
	 */
	public static Object getInstance(Properties info, short instance_type) throws Exception {

		Object returnValue = getInstance(info.getProperty("SEND_TYPE"), info.getProperty("SEND_STATE"), instance_type);

		if (log.isDebugEnabled()) 
			log.debug(info.toString(), returnValue.getClass().getName());

		return returnValue;
	}

	/**
	 * 발송에서 사용하는 클래스의 Instance를 반환한다.
	 * 
	 * @param state
	 *            발송상태 지정
	 * @param type
	 *            발송타입지정
	 * @param instance_type
	 *            인스턴스 타입을 정한다
	 * @return 지정된 종류의 Instance
	 * @throws Exception
	 *             등록되지 않은 Send Type지정 <br>
	 *             등록되지 않은 type의 Instance를 지정
	 * @see venus.spool.lang.SpoolTypes#SPOOLTASK_INSTANCE
	 */
	public static Object getInstance(String type, String state, short instance_type) throws Exception {

		String TargetKey = null;

		/* 각 경우에 따라서 Class배열중 하나를 선택하여 인스턴스를 반환한다. */
		switch (instance_type) {
			case eMsTypes.SPOOLTASK_INSTANCE: {
				TargetKey = state.concat("_").concat(type).concat("_SpoolTask");
				break;
			}
			default: {
				throw new RuntimeException("Invalid Instance Type");
			}
		}

		Class classes = (Class) InstanceMap.get(TargetKey);

		if( classes == null ) {
			throw new RuntimeException("Unregist Instance Type=>" + TargetKey);
		}

		return classes.newInstance();
	}
}
