/*
 * @(#)RealTimeSpoolTask.java            2004. 12. 9.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.auto.task;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.log.Log;
import lombok.extern.slf4j.Slf4j;
import pluto.util.Cal;
import venus.spool.auto.basic.BasicDefaultMappingGenerator;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.task.AbstractDbSpoolTask;
/**
 * Class description :
 * 
 * @version		
 * @author 		lena
 *
 */
@Slf4j
public class RealTimeSpoolTask extends AbstractDbSpoolTask {
	
	
	//실시간 검색 대상 메일의 리스트를 가져온다.
	public static String QUERY_SELECT_REALTIME_SCHEDULE_INFO = null;
	
	//실시간 검색/입력 대상 메일발송 대상 리스트를 가져온다.
	public static String QUERY_SELECT_LIST_LOAD_QUERY = null;
	
	//실시간 검색/입력 대상 메일발송 대상 리스트를 업데이트 한다. 그래야 다시 안가져온다.
	public static String QUERY_UPDATE_LIST_STATE_QUERY = null;
	
	//실시간 검색/입력 대상 리스트 테이블의 리스트를 가져온다. 그래야 그 테이블들을 검색할수 있으니까.
	protected static String QUERY_SELECT_REALTIME_TABLE_INFO = null;
	
	//실시간 입력으로 생성된 100번 테이블을 검색하여 컨텐트가 만들어져 있지 않으면 만드는데 사용하는 쿼리
	protected static String QUERY_SELECT_REALTIME_INPUT_SCHEDULE_INFO = null;
	
	//피로도 관련 쿼리 등록
		public static String QUERY_UPDATE_SCHD_FILTERED_TARGET = null;
		
		public static String QUERY_UPDATE_FATIGUE_N_FILTER = null;
		
		public static String QUERY_SELECT_FATIGUE_LIST = null;
		
		public static String QUERY_UPSERT_FATIGUE_LIST = null;
	
	static {
		try {
			QUERY_SELECT_REALTIME_SCHEDULE_INFO = SqlManager.getQuery("COMMON","QUERY_SELECT_REALTIME_SCHEDULE_INFO");
			
			QUERY_SELECT_LIST_LOAD_QUERY = SqlManager.getQuery("COMMON","QUERY_SELECT_LIST_LOAD_QUERY");
			
			QUERY_UPDATE_LIST_STATE_QUERY = SqlManager.getQuery("COMMON","QUERY_UPDATE_LIST_STATE_QUERY");
			
			QUERY_SELECT_REALTIME_TABLE_INFO = SqlManager.getQuery("COMMON","QUERY_SELECT_REALTIME_TABLE_INFO");
			
			QUERY_SELECT_REALTIME_INPUT_SCHEDULE_INFO = SqlManager.getQuery("COMMON","QUERY_SELECT_REALTIME_INPUT_SCHEDULE_INFO");
			
			/** QUERY_UPDATE_FATIGUE_N_FILTER  발송시점에 피로도 필터링하여 Spool 생성 하지 않고 필터한다. ( ERROR_CODE 98 )
			 */
			QUERY_UPDATE_FATIGUE_N_FILTER = SqlManager.getQuery("FATIGUE", "QUERY_UPDATE_FATIGUE_N_FILTER");
			
			/** QUERY_SELECT_FATIGUE_LIST  발송시점에 피로도 대상을 추출하여 hashtable에 적제.
			 */
			QUERY_SELECT_FATIGUE_LIST = SqlManager.getQuery("FATIGUE", "QUERY_SELECT_FILTER_USEYN");
			
			QUERY_UPSERT_FATIGUE_LIST = SqlManager.getQuery("FATIGUE", "QUERY_UPSERT_FATIGUE_LIST");
			
			QUERY_UPDATE_SCHD_FILTERED_TARGET = SqlManager.getQuery("FATIGUE","QUERY_UPDATE_SCHD_FILTERED_TARGET");
		}
		catch( Exception e ){
			log.error(e.getMessage());
			System.exit( 1 );
		}
	}
	
	/**발송 리스트 검색 대상이 되는 테이블 리스트를 동적으로 담아놓는 리스트 */
	
	/**대상 테이블을 검색하는 쿼리 */
	protected String instance_QUERY_TARGET_TABLE_INFO =null;
	
	
	
	
	/** Creates a new instance of RealTimeSpoolTask */
	public RealTimeSpoolTask() throws Exception {
		
		super( TYPE_INTERVAL , 1 );
		this.setName( "RealTimeSpoolTask" );
		this.setTaskID( "RealTimeSpoolTask" );
		
	}
	
	public static void init( Object tmp ) throws Exception {
	}
	
	public void setTaskProperty( Properties send_info ){

		if(this.TASK_PROPERTY == null) {
			this.TASK_PROPERTY = new Properties();
		}
		
		if( send_info != null ) {
			this.TASK_PROPERTY.putAll(send_info);
		}
		
		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		// add TMS 3.0 ROWID
		this.rowid = this.TASK_PROPERTY.getProperty(Log.LOG_ROWID);
		// add TMS 3.1 OS
		this.os = this.TASK_PROPERTY.getProperty(Log.LOG_OS);
		// add TMS 3.1 NOFI_FLAG
		this.notiflag = this.TASK_PROPERTY.getProperty(Log.LOG_NOTI_FLAG);
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		this.WORK_FILE_ID = this.POST_ID.concat("_real_one_").concat( Cal.getSerialDateMilli() ); //ex) _real_one_+ wrokday_seqno_ + YYYYMMDDHH24MISSss
		
		this.setTaskID( this.POST_ID );
		this.setName( this.POST_ID + "_RealTimeSpoolTask" );
		
		/**이쿼리를 가지고 리스트를 가져온다.
		 */
		this.SELECT_TARGET_LIST_QUERY = QUERY_SELECT_LIST_LOAD_QUERY;
		
		/**리스트에 대한 업데이트는 하지 않으므로 널이다.
		 */
		this.UPDATE_TARGET_LIST_QUERY = QUERY_UPDATE_LIST_STATE_QUERY;
		
		/**대상이 되는 테이블 정보를 읽어오는 쿼리
		 */
		this.instance_QUERY_TARGET_TABLE_INFO = QUERY_SELECT_REALTIME_TABLE_INFO;
		
		/** 피로도 필터 쿼리 지정
		 */
		this.UPDATE_FATIGUE_N_FILTER = QUERY_UPDATE_FATIGUE_N_FILTER;
		
		this.UPSERT_FATIGUE_LIST_QUERY =QUERY_UPSERT_FATIGUE_LIST;
		
		this.SELECT_TARGET_FATIGUE_LIST_QUERY = QUERY_SELECT_FATIGUE_LIST;
		
		this.UPDATE_SCHD_FILTERED_TARGET = QUERY_UPDATE_SCHD_FILTERED_TARGET;
		
		// 스풀에 적을 기본적인 사항을 세팅한다.
		this.SPOOL_ANALYZER.setSendType( "AUTO" );// one to one
		this.SPOOL_ANALYZER.setNextSpoolGenerate( "Y" );// spool attach
		this.SPOOL_ANALYZER.setLimitDate( Cal.getDayDate() );
		this.SPOOL_ANALYZER.setStep( 0 );
		/*if(Integer.parseInt(send_info.getProperty("PRIORITY"))>0){
			this.SPOOL_ANALYZER.setPriority("FASTSEND");
		}else{
			this.SPOOL_ANALYZER.setPriority("NORMALSEND");
		}*/
	}
	
	/** 
	 * 본격적인 실행 프로세스 전에 실행
	 */
	public void execute_initiate() throws Exception {
		super.execute_initiate();
		this.WORK_FILE_ID = "realtime_".concat( this.POST_ID + "_" ).concat( Cal.getSerialDateMilli() );
		this.SPOOL_ANALYZER.setLimitDate( Cal.getDayDate() );
		this.SPOOL_ANALYZER.setStep( 0 );
	}
	
	/**
	 * <br>여러테이블을 돌려가면서 리스트를 로딩해야하기 때문에 
	 * <br>makeSpoolFile() 를 OVERRIDE 한다.
	 */
	public void makeSpoolFile() throws Exception {
		
		eMsStatement __EMS_EXEC_STATEMENT__ = null;
		eMsResultSet RS_SELECTED_SCHEDULE_INFO = null;
		
		LinkedList TARGET_TABLE_LIST = new LinkedList();
		
		if (log.isDebugEnabled())  
				log.debug( "CALL GET TARGET TABLE LIST SQL" );
				
		try {
			__EMS_EXEC_STATEMENT__ = EMS_CONNECTION.createStatement();
			
			RS_SELECTED_SCHEDULE_INFO = __EMS_EXEC_STATEMENT__.executeQuery( this.instance_QUERY_TARGET_TABLE_INFO );
			
			while( RS_SELECTED_SCHEDULE_INFO.next() ) {
				Properties prop = new Properties();
				RS_SELECTED_SCHEDULE_INFO.putToMap( prop , false );
				TARGET_TABLE_LIST.addLast( prop );
			}
		}
		catch( Exception e ) {
			log.error("error", e);
			throw e;
		}
		finally {
			try{ RS_SELECTED_SCHEDULE_INFO.close(); } catch( Exception ex ){}
			EMS_CONNECTION.recycleStatement( __EMS_EXEC_STATEMENT__ );
		}
		
		String this_day = Cal.getDayDate();
		
		String __SPOOL_FILE_NAME__ = FileElement.CheckSubDirectory( SPOOL_WORKING_DIRECTORY , this_day ) +"/" + this.WORK_FILE_ID + ".spool";
	
		this.SPOOL_FILE_LIST.clear();
		
		this.LIST_APPEND_FLAG = false;
		
		try {
			// 스풀파일을 준비한다.
			openSpooler( __SPOOL_FILE_NAME__ );
			
			for( Iterator iter = TARGET_TABLE_LIST.iterator(); iter.hasNext(); ){
				Properties prop = ( Properties )iter.next();
				prop.setProperty("WORKDAY",this.TASK_PROPERTY.getProperty("WORKDAY"));
				prop.setProperty("SEQNO",this.TASK_PROPERTY.getProperty("SEQNO"));
				this.execute_ListLoad( prop );
			}
		}
		catch( Exception e ) {
			log.error("error", e);
			throw e;
		}
		finally {
			//스풀러 일단 닫고
			closeSpooler();
			
			
			// 스풀 내용이 없다면 그냥 지워버린다.
			if(!this.LIST_APPEND_FLAG ) {
				deleteSpooler();
				if (log.isDebugEnabled()) {
					log.debug( getName() + "NO APPEND LIST FILE");
				}
			}
		}
	}

	/**
	 * Spool Info 만드는 로직이 다르다.
	 * 실시간 메일의 경우는 여러 메일이 병합되어 한꺼번에 스풀에 쌓이므로
	 * 이들을 각각 참조하여 생성하는 것이 맞다.
	 */
	protected void makeSpoolInfo() throws Exception {
		
		// String id;
		String mapheader;
		
		this.mailSpoolInfo = new SpoolInfo();
		
		this.mailSpoolInfo.setID( this.POST_ID );
		this.mailSpoolInfo.setSendState( "REAL" );
		
		/*
		 * 		mapheader =  (this.MAPPING_HEADER_INFO==null)?"map_":this.MAPPING_HEADER_INFO.getProperty(this.POST_ID);
		*		this.mailSpoolInfo.setMappingHeader((mapheader==null)?getMappingHeader():mapheader );

		 */
		/*by Rough (2005.02.24)
		 * AUTO001에 매핑헤더필드를 넣을 필요가 있을때(ETA)
		 */
		
		mapheader =  (this.MAPPING_HEADER_INFO==null)?this.TASK_PROPERTY.getProperty( "MAPPINGHEADER" ):this.MAPPING_HEADER_INFO.getProperty(this.POST_ID);
		
		
		if(mapheader == null) mapheader = "map_";
		//TODO
		//mapheader가 null 이 될수 없는 상황이므로 getMappingHeader()가 작동하지 않음 
		//this.mailSpoolInfo.setMappingHeader((mapheader==null)?getMappingHeader():mapheader );
		this.mailSpoolInfo.setMappingHeader(mapheader);
		
		this.mailSpoolInfo.setSpoolDelimit( eMsSystem.getProperty("spool.delimit","|"));
		String value = TASK_PROPERTY.getProperty("SERIAL_DELIM");
		this.mailSpoolInfo.setSerialDelimit( (value==null)?"|":value);
		this.mailSpoolInfo.setSpoolFilesInfo( SPOOL_FILE_LIST );

		// 기본 매핑 생성 Instance 생성
		BasicDefaultMappingGenerator __DEFAULT_MAPPING_GENERATOR__ = new BasicDefaultMappingGenerator();
		__DEFAULT_MAPPING_GENERATOR__.process( this.TASK_PROPERTY );
		this.mailSpoolInfo.setDefaultMapping( __DEFAULT_MAPPING_GENERATOR__.getMapOfDefaultMapping() );
		this.mailSpoolInfo.setDefaultHashMapping( __DEFAULT_MAPPING_GENERATOR__.getMapOfDefaultHashMapping() );
					
		// 발송을 위해 memory에만 적재하면 되고 xml 파일은 만들 필요 없다.
		//by joo - 어차피 또한다. 이부분은 필요없는 부분이다.
		//SpoolInfoManager.putSpoolInfo( this.mailSpoolInfo, true );
		
		
		// 이것은 발송을 위해 셋팅한다.
		// SPOOL POPPER가 사용할 것임.
		//by joo - 위에서 처리했는데 또하고 있다.그래서 삭제한다.
//		if ( SPOOL_FILE_LIST != null && SPOOL_FILE_LIST.size() > 0 ) {
//			this.mailSpoolInfo.setSpoolFilesInfo( SPOOL_FILE_LIST );
//		}
		
		
		//by joo - realTimeSendTask에서 하던 것을 일관성있게 가져왔다. 
		// spool_info 등록은 여기서 하는것이 기능상으로 맞다.		
		// SpoolInfoManager에 담는다
		SpoolInfoManager.registSpoolInfo( this.mailSpoolInfo );
	}
		
	protected void addSpool(Properties prop) throws Exception {
		this.SPOOL_ANALYZER.setRowid( prop.getProperty( "ROW_ID" ) );
		this.SPOOL_ANALYZER.setOs( prop.getProperty( "OS" ) );
		this.SPOOL_ANALYZER.setNotiflag( prop.getProperty( "NOTI_FLAG" ) );
		this.SPOOL_ANALYZER.setPostID( prop.getProperty( "POST_ID" ) );
		this.SPOOL_ANALYZER.setListTable( prop.getProperty( "LIST_TABLE" ) );
		this.SPOOL_ANALYZER.setTokenID( prop.getProperty( "TMS_M_TOKEN" ) );
		this.SPOOL_ANALYZER.setMemberID( prop.getProperty( "TMS_M_ID" ) );
		this.SPOOL_ANALYZER.setMemberName( prop.getProperty( "TMS_M_NAME" ) );
		this.SPOOL_ANALYZER.setSecureFlag( prop.getProperty( "SECURE_FLAG" ) );
		this.SPOOL_ANALYZER.setAdditionalValue( prop.getProperty( "ADDITIONAL_INFO" ) );
		this.SPOOL_ANALYZER.setMapping( prop.getProperty( "MAPPING" ) );
		
		appendSpooler( this.SPOOL_ANALYZER.composeSingleRcptSend() );
	}
	
	/** 발송 정지 상태를 점검하고 정지되었다면 로그를 작성한다.
	 */
	protected boolean execute_StopCheck() {
		log.info("CHECK STOP SIGNAL" );
		return false;
	}
	
	/** Syntax Error 스풀을 처리한다.
	 */
	protected void processSyntaxErrorSpool(String spool) throws Exception {
	}
}
