/*
 * @(#)AutoTestSpoolTask.java            2005. 1. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.auto.task;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;

import pluto.config.eMsSystem;
import pluto.io.FileElement;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.util.Cal;
import venus.spool.auto.basic.TestDefaultMappingGenerator;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.task.SpoolControlTask;

@Slf4j
public class AutoTestSpoolTask extends SpoolControlTask {
	
	
	protected String targetfile = null;
	
	public AutoTestSpoolTask() throws Exception {
		super();
	}
	
	public void setTaskProperty( Properties prop ) {
		
		if(this.TASK_PROPERTY == null) this.TASK_PROPERTY = new Properties();
		
		if( prop != null ) {
			this.TASK_PROPERTY.putAll(prop);
		}

		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		//this.CHANNEL_SEQ = this.TASK_PROPERTY.getProperty( "CHANNEL_SEQ" );
				
		this.WORK_FILE_ID = this.POST_ID.concat("_test_one_").concat( Cal.getSerialDate() );
		
		this.setTaskID( this.POST_ID );
		this.setName( this.POST_ID + "_AutoTestSpoolTask" );
		
		//List Make로 만들어진 파일 정보를 받아온다.
		this.targetfile = this.TASK_PROPERTY.getProperty( "TARGET_LIST_FILE" );
		
		//스풀에 적을 기본적인 사항을 세팅한다.
		/*
		this.SPOOL_ANALYZER.setSendType( "AUTO" );// one to one
		this.SPOOL_ANALYZER.setNextSpoolGenerate( "Y" );// spool attach
		this.SPOOL_ANALYZER.setLimitDate( this.TASK_PROPERTY.getProperty( "QUE_CLOSE_DATE", Cal.getAddDayDate( 1 ) ) );
		this.SPOOL_ANALYZER.setPostID( this.POST_ID );
		this.SPOOL_ANALYZER.setListTable( "NOTABLE" );
		this.SPOOL_ANALYZER.setStep( 0 );
		*/
		
	}
	
	/**
	 * 스풀 작성 방법이 상이하다. 
	 * 여기서는 ListMake에서 만들어진 소스를 그대로 복사해버린다.
	 * @throws Exception
	 */
	public void makeSpoolFile() throws Exception {
		
		String this_day = Cal.getDayDate();
		
		String __SPOOL_FILE_NAME__ = 
				FileElement.CheckSubDirectory( SPOOL_WORKING_DIRECTORY, this_day ) 
						+ "/"
						+ this.WORK_FILE_ID 
						+ ".spool";
		
		BufferedReader br = null;
		
		try {
			// 스풀파일을 준비한다. 
			openSpooler( __SPOOL_FILE_NAME__ );
			
			// ListMake에서 만들어진 file을 읽는다.
//			BufferedReader br = new BufferedReader(new FileReader(this.targetfile));

			br = 
			      new BufferedReader(
			          new InputStreamReader(new FileInputStream(this.targetfile),
			        		  eMsLocale.FILE_SYSTEM_IN_CHAR_SET));
			// String temp_line = null;
			
			while(br.ready()) {
				// copy!
				appendSpooler( br.readLine() );
			}
			
		}
		catch( Exception e ) {
			log.error(getName(), e);
			throw e;
		} 
		finally {
			//스풀러 일단 닫고
			closeSpooler();
			
			// 스풀 내용이 없다면 그냥 지워버린다.
			if( !this.LIST_APPEND_FLAG ) {
				//스풀파일도 지우고
				deleteSpooler();
			}
			
			if(br != null) {				
				try {
					br.close();
				}
				catch(Exception e) {
				}
			}
		}
	}

	
	/**
	 * 스풀 작성 방법이 상이하다. 
	 * 여기서는 ListMake에서 만들어진 소스를 그대로 복사해버린다.
	 * @throws Exception
	 */
	public void makeSpoolFile_TEST() throws Exception {

		String this_day = Cal.getDayDate();

		String __SPOOL_FILE_NAME__ = FileElement.CheckSubDirectory(
				SPOOL_WORKING_DIRECTORY, this_day)
				+ "/" + this.WORK_FILE_ID + ".spool";

		InputStream in = null;
		OutputStream out = null;

		try {
			// // 스풀파일을 준비한다.
			 openSpooler( __SPOOL_FILE_NAME__ );
			//			
			// // ListMake에서 만들어진 file을 읽는다.
			// BufferedReader br = new BufferedReader(new
			// FileReader(this.targetfile));
			//
			// // String temp_line = null;
			//			
			// while(br.ready()) {
			// // copy!
//			appendSpooler( br.readLine() );
			// }
			// br.close();

			in = new FileInputStream(this.targetfile);
			out = new FileOutputStream(__SPOOL_FILE_NAME__);

			byte[] buf = new byte[1024];
			int len;
			while ((len = in.read(buf)) > 0) {
				out.write(buf, 0, len);
			}

		} catch (Exception e) {
			log.error(getName(), e.toString());
			throw e;
		} finally {					
			if( in != null ) {
				try {
					in.close();
				}
				catch(Exception e) {
				}
			}
			if( out != null ) {
				try {
					out.close();
				}
				catch(Exception e) {
				}
			}

		}
	}
	
	
	
	// SpoolControlTask를 직접 extends한경우에는 아래를 반드시 명시해 주어야 한다. 안그러면 동일한 스풀을 두번
	// 적재한다..
	public void release_Resource() {
	}
	
	public void addSpool(Properties prop) {
		// 사용되지 않으므로 할일이 없다.
	}
	
	public void execute_initiateError(Throwable thw) {
	
		log.error( getName() , thw );
	}
	
	/**
	 * 스풀 정보를 SpoolInfo 객체에 담는다.
	 * SpoolInfoManager에 담는다
	 * @throws Exception
	 */
	protected void makeSpoolInfo() throws Exception {
		
		// 만들어진 스풀 정보를 SpoolInfo 객체에 담는다.
		this.mailSpoolInfo = new SpoolInfo();
		this.mailSpoolInfo.setID( TASK_PROPERTY.getProperty("POST_ID") );
		this.mailSpoolInfo.setSendState( TASK_PROPERTY.getProperty("SEND_STATE") );
		this.mailSpoolInfo.setMappingHeader( getMappingHeader() );
		this.mailSpoolInfo.setSpoolDelimit( eMsSystem.getProperty("spool.delimit","|"));
		String value = TASK_PROPERTY.getProperty("SERIAL_DELIM");
		this.mailSpoolInfo.setSerialDelimit( (value==null)?"|":value);
		this.mailSpoolInfo.setSpoolFilesInfo( SPOOL_FILE_LIST );
		
		/*
	     for (Enumeration e = SPOOL_FILE_LIST.elements() ; e.hasMoreElements() ;) {
	     	log.debug("SPOOL_FILE_LIST =====>" + e.nextElement());
	     }
	    */ 	
		
		/**기본 매핑 생성 Instance 생성
		 */
		TestDefaultMappingGenerator __DEFAULT_MAPPING_GENERATOR__ = new TestDefaultMappingGenerator();
		__DEFAULT_MAPPING_GENERATOR__.process( this.TASK_PROPERTY );
		this.mailSpoolInfo.setDefaultMapping( __DEFAULT_MAPPING_GENERATOR__.getMapOfDefaultMapping() );
		this.mailSpoolInfo.setDefaultHashMapping( __DEFAULT_MAPPING_GENERATOR__.getMapOfDefaultHashMapping() );
		
		// SpoolInfoManager에 담는다
		SpoolInfoManager.putSpoolInfo( this.mailSpoolInfo , false);
	}
}
 
