/*
 * @(#)AutoBaseSpoolTask.java            2004. 12. 9.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package venus.spool.auto.task;

import java.util.List;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.eMsStatement;
import pluto.log.Log;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import venus.spool.auto.basic.BasicDefaultMappingGenerator;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.task.AbstractDbSpoolTask;
/**
 * Class description :
 * 
 * @version		
 * @author 		lena
 *
 */
@Slf4j
public class AutoBaseSpoolTask extends AbstractDbSpoolTask {
	
	protected static List QUERY_UPDATE_STATE_START = null;
	
	protected static List QUERY_UPDATE_STATE_END = null;
	
	protected static List QUERY_UPDATE_STATE_INFO = null;

	public static String QUERY_SELECT_BASE_SEND_LIST = null;
	
	public static String QUERY_SELECT_BASE_DIVIDE_SEND_LIST = null;
	
	public static String QUERY_CHECK_STOP_FLAG = null;
	
	//피로도 관련 쿼리 등록
	public static String QUERY_UPDATE_SCHD_FILTERED_TARGET = null;
	
	public static String QUERY_UPDATE_FATIGUE_N_FILTER = null;
	
	public static String QUERY_SELECT_FATIGUE_LIST = null;
	
	public static String QUERY_UPSERT_FATIGUE_LIST = null;
	
	protected static String QUERY_UPDATE_SPOOL_CONF = null;
	
	protected String INSTANCE_QUERY_CHECK_STOP_FLAG = null;
	
	/** 스케쥴 테이블 상태값 업데이트, 상속받은 녀석들은 이것을 알아서 셋팅 해야한다. */
	protected List INSTANCE_QUERY_UPDATE_STATE_INFO = null;
	
	static {
		try {
			/**멤버지정하지 않고 시작를 업데이트 한다.
			 */
			QUERY_UPDATE_STATE_START = SqlManager.getMultiQuery("COMMON","QUERY_UPDATE_STATE_START");
			
			/**멤버지정하지 않고 종료를 업데이트 한다.
			 */
			QUERY_UPDATE_STATE_END = SqlManager.getMultiQuery("COMMON","QUERY_UPDATE_STATE_END");
			
			/** 멤버변수에 지정이 되는 것이 아닌 그냥 사용된다.
			 */
			QUERY_CHECK_STOP_FLAG = SqlManager.getQuery("COMMON","QUERY_CHECK_STOP_FLAG");
			
			/** INSTANCE_QUERY_UPDATE_STATE_INFO 멤버 변수에 지정되어 스테이트를 업데이트 해준다.
			 */
			QUERY_UPDATE_STATE_INFO = SqlManager.getMultiQuery("COMMON","QUERY_UPDATE_STATE_INFO");

			/** SELECT_TARGET_LIST_QUERY 멤버변수에 세팅이되어 리스트를 가지고 온다.
			 */
			QUERY_SELECT_BASE_SEND_LIST = SqlManager.getQuery("COMMON","QUERY_SELECT_BASE_SEND_LIST");
			
			QUERY_SELECT_BASE_DIVIDE_SEND_LIST = SqlManager.getQuery("COMMON","QUERY_SELECT_BASE_DIVIDE_SEND_LIST");
			
			QUERY_UPDATE_SPOOL_CONF = SqlManager.getQuery("COMMON","QUERY_UPDATE_SPOOL_CONF");
			
			QUERY_UPDATE_SCHD_FILTERED_TARGET = SqlManager.getQuery("FATIGUE","QUERY_UPDATE_SCHD_FILTERED_TARGET");
			
			/** QUERY_UPDATE_FATIGUE_N_FILTER  발송시점에 피로도 필터링하여 Spool 생성 하지 않고 필터한다. ( ERROR_CODE 98 )
			 */
			QUERY_UPDATE_FATIGUE_N_FILTER = SqlManager.getQuery("FATIGUE", "QUERY_UPDATE_FATIGUE_N_FILTER");
			
			/** QUERY_SELECT_FATIGUE_LIST  발송시점에 피로도 대상을 추출하여 hashtable에 적제.
			 */
			QUERY_SELECT_FATIGUE_LIST = SqlManager.getQuery("FATIGUE", "QUERY_SELECT_FILTER_USEYN");
			
			QUERY_UPSERT_FATIGUE_LIST = SqlManager.getQuery("FATIGUE", "QUERY_UPSERT_FATIGUE_LIST");
		}
		catch( Exception e ){
			log.error(e.getMessage());
			System.exit( 1 );
		}
	}
	
	/** Creates a new instance of AutoBaseSpoolTask */
	public AutoBaseSpoolTask() throws Exception{
		super();
	}
	
	public void setTaskProperty( Properties prop ) {
		// 쿼리 결과를 Properties 객체로 
		if(this.TASK_PROPERTY == null) this.TASK_PROPERTY = new Properties();
		
		if( prop != null ) {
			log.info("prop !!!!!!! {}",prop);
			this.TASK_PROPERTY.putAll(prop);
		}

		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		// TMS 3.0 ROWID 추가
		this.rowid = this.TASK_PROPERTY.getProperty(Log.LOG_ROWID);
		// TMS 3.1 OS 추가
		this.os = this.TASK_PROPERTY.getProperty(Log.LOG_OS);
		// TMS 3.1 NOTI_FLAG 추가
		this.notiflag = this.TASK_PROPERTY.getProperty(Log.LOG_NOTI_FLAG);
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		this.WORK_FILE_ID = this.POST_ID.concat("_real_one_").concat( Cal.getSerialDate() );
		
		this.setTaskID( this.POST_ID );
		this.setName( this.POST_ID + "_AutoBaseSpoolTask" );
		
		/**이쿼리를 가지고 리스트를 가져온다.
		 */
		this.SELECT_TARGET_LIST_QUERY = QUERY_SELECT_BASE_SEND_LIST;
		
		this.SELECT_DIVIDE_TARGET_LIST_QUERY = QUERY_SELECT_BASE_DIVIDE_SEND_LIST;
		
		this.SELECT_TARGET_FATIGUE_LIST_QUERY = QUERY_SELECT_FATIGUE_LIST;
		
		/**리스트에 대한 업데이트는 하지 않으므로 널이다.
		 */
		this.UPDATE_TARGET_LIST_QUERY = null;

		/**상위 클래스에서 이거 가지고 업데이트를 해 준다.
		 */
		this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
		
		this.UPDATE_SCHD_FILTERED_TARGET = QUERY_UPDATE_SCHD_FILTERED_TARGET;
		
		/**매핑은 따로 추려내야한다.
		 */
		this.APPEND_TOTAL_SPOOL = false;
		
		/**정지를 체크해야할 쿼리를 지정( AbstractDBMailSendTask에서 사용 )
		 */
		this.INSTANCE_QUERY_CHECK_STOP_FLAG = QUERY_CHECK_STOP_FLAG;
		
		/** 피로도 필터 쿼리 지정
		 */
		this.UPDATE_FATIGUE_N_FILTER = QUERY_UPDATE_FATIGUE_N_FILTER;
		
		this.UPSERT_FATIGUE_LIST_QUERY =QUERY_UPSERT_FATIGUE_LIST;
		
		/**스풀에 적을 기본적인 사항을 세팅한다.
		 */
		//쿼리 결과 -> SPOOL_ANALYZER 로 설정
		this.SPOOL_ANALYZER.setSendType( "AUTO" );// one to one
		this.SPOOL_ANALYZER.setNextSpoolGenerate( "Y" );// spool attach
		this.SPOOL_ANALYZER.setLimitDate( this.TASK_PROPERTY.getProperty( "QUE_CLOSE_DATE", Cal.getAddDayDate( 1 ) ) );
		this.SPOOL_ANALYZER.setPostID( this.POST_ID );
		this.SPOOL_ANALYZER.setListTable( this.LIST_TABLE );
		this.SPOOL_ANALYZER.setRowid(this.rowid);	// TMS 3.0 ROWID 추가.
		this.SPOOL_ANALYZER.setOs(this.os);
//		this.SPOOL_ANALYZER.setOs(this.notiflag); //error ???
		this.SPOOL_ANALYZER.setNotiflag(this.notiflag);
/*		if(Integer.parseInt(prop.getProperty("PRIORITY").)>0){
			this.SPOOL_ANALYZER.setPriority("FASTSEND");
		}else{
			this.SPOOL_ANALYZER.setPriority("NORMALSEND");
		}*/
		this.SPOOL_ANALYZER.setStep( 0 );
	}
	
	protected void addSpool(Properties prop) throws Exception {
		log.debug("spoolAnalyzer: {}", prop.toString());
		this.SPOOL_ANALYZER.setRowid( prop.getProperty( "ROW_ID" ) );
		this.SPOOL_ANALYZER.setOs( prop.getProperty( "OS" ) );
		this.SPOOL_ANALYZER.setNotiflag( prop.getProperty( "NOTI_FLAG" ) );
		this.SPOOL_ANALYZER.setTokenID( prop.getProperty( "TMS_M_TOKEN" ) );
		this.SPOOL_ANALYZER.setMemberID( prop.getProperty( "TMS_M_ID" ) );
		this.SPOOL_ANALYZER.setMemberName( prop.getProperty( "TMS_M_NAME" ) );
		this.SPOOL_ANALYZER.setSecureFlag( prop.getProperty( "SECURE_FLAG" ) );
		this.SPOOL_ANALYZER.setAdditionalValue( prop.getProperty( "ADDITIONAL_INFO" ) );
		this.SPOOL_ANALYZER.setMapping( prop.getProperty( "MAPPING" ) );
		appendSpooler( this.SPOOL_ANALYZER.composeSingleRcptSend() );
	}

	/**
	 * 스풀 정보를 SpoolInfo 객체에 담는다.
	 * SpoolInfoManager에 담는다
	 * @throws Exception
	 */
	protected void makeSpoolInfo() throws Exception {
		
		// 만들어진 스풀 정보를 SpoolInfo 객체에 담는다.
		this.mailSpoolInfo = new SpoolInfo();
		this.mailSpoolInfo.setID( TASK_PROPERTY.getProperty("POST_ID") );
		this.mailSpoolInfo.setSendState( TASK_PROPERTY.getProperty("SEND_STATE") );
		this.mailSpoolInfo.setMappingHeader( getMappingHeader() );
		this.mailSpoolInfo.setSpoolDelimit( eMsSystem.getProperty("spool.delimit","|"));
		String value = TASK_PROPERTY.getProperty("SERIAL_DELIM");
		this.mailSpoolInfo.setSerialDelimit( (value==null)?"|":value);
		this.mailSpoolInfo.setSpoolFilesInfo( SPOOL_FILE_LIST );
		
		// 기본 매핑 생성 Instance 생성
		BasicDefaultMappingGenerator __DEFAULT_MAPPING_GENERATOR__ = new BasicDefaultMappingGenerator();
		__DEFAULT_MAPPING_GENERATOR__.process( this.TASK_PROPERTY );
		this.mailSpoolInfo.setDefaultMapping( __DEFAULT_MAPPING_GENERATOR__.getMapOfDefaultMapping() );
		this.mailSpoolInfo.setDefaultHashMapping( __DEFAULT_MAPPING_GENERATOR__.getMapOfDefaultHashMapping() );
		
		// SpoolInfoManager에 담는다
		SpoolInfoManager.registSpoolInfo( this.mailSpoolInfo );
	}
		
	/** 최초 시작할때 호출. 일단 아무것도 하지 않는다.
	 */
	protected void execute_Startup() throws Exception {
		
	}
	
	/** 리스트를 다 뿌리고 나올때 실행
	 */
	protected void execute_Finish(boolean success) throws Exception {
		
		eMsStatement stmt = null;
		try {
			stmt = this.EMS_CONNECTION.createStatement();
			
			Properties prop = new Properties();
			prop.setProperty("WORKDAY",this.TASK_PROPERTY.getProperty("WORKDAY"));
			prop.setProperty("SEQNO",this.TASK_PROPERTY.getProperty("SEQNO"));
			//prop.setProperty("POST_ID",this.TASK_PROPERTY.getProperty("POST_ID"));
			prop.setProperty("CHANNEL_TYPE",this.TASK_PROPERTY.getProperty("CHANNEL_TYPE"));
			prop.setProperty("SPOOL_CONF",SpoolInfoManager.getSpoolInfo(this.TASK_PROPERTY.getProperty("POST_ID")).getSpoolInfoPath());
			this.TMP_STRING_BUFFER.setLength( 0 );
			
			StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , QUERY_UPDATE_SPOOL_CONF  , prop , "${" , "}" , true , false );
			stmt.executeUpdate( this.TMP_STRING_BUFFER.toString() );
		}
		catch( Exception e ){
			log.error( getName() , e );
		}
		finally {
			this.EMS_CONNECTION.recycleStatement( stmt );
		}
	}
}
