/*
 * @(#)BasicDefaultMappingGenerator.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package venus.spool.auto.basic;

import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

import com.humuson.tms.common.security.HumusonDecryptor;
import pluto.config.SqlManager;
import pluto.db.ConnectInfo;
import pluto.config.eMsSystem;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.lang.Name;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.util.StringConvertUtil;
import venus.spool.common.basic.DefaultMappingGenerator;

/**
 * Class description :
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class BasicDefaultMappingGenerator extends Name implements DefaultMappingGenerator {

	protected static String			QUERY_SELECT_DEFAULT_MAPPING_SQL_INFO			= null;
	
	protected static String encKey													= null;

	static {
		QUERY_SELECT_DEFAULT_MAPPING_SQL_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_DEFAULT_MAPPING_SQL_INFO");
		encKey = eMsSystem.getProperty("member.info.encrypt.key");
	}

	protected String				INSTANCE_QUERY_SELECT_DEFAULT_MAPPING_SQL_INFO	= null;

	/**
	 * 데이터 베이스 연결
	 */
	protected eMsConnection			EMS_CONNECTION									= null;

	/**
	 * 실행 쿼리를 매핑하는 정보 Hash
	 */
	protected Properties			SCHEDULE_INFO									= null;

	/**
	 * @{}로 매핑되는 기본 실행쿼리 매핑을 저장하는 MAP
	 */
	protected Map					DEFAULT_MAPPPING_MAP							= new Hashtable();

	/**
	 * 개인 매핑에 기본으로 삽입되는 MAP 리스트 매핑도 포함
	 */
	protected Map					DEFAULT_HASH_MAPPPING_MAP						= new Hashtable();

	/**
	 * 쿼리 매핑정보추출 쿼리를 저장하는 VECTOR
	 */
	protected Vector				VECTOR_QUERY_MAPPING_INFO						= new Vector();

	/**
	 * 기본 리스트 매핑 쿼리를 저장하는 VECTOR
	 */
	protected Vector				VECTOR_LIST_MAPPING_INFOS						= new Vector();

	/**
	 * @{}로 매핑 되는 SIMPLE MAPPING QUERY를 저장하는 VECTOR
	 */
	protected Vector				VECTOR_SIMPLE_DEFAULT_MAPPING_INFOS				= new Vector();

	/**
	 * @{}로 매핑 되는 KEY - VALUE MAPPING QUERY저장 VECTOR
	 */
	protected Vector				VECTOR_KEY_VALUE_MAPPING_INFOS					= new Vector();

	/**
	 * SIMPLE HASH에 기본으로 장착되는 SIMPLE MAPPING QUERY 저장 VECTOR
	 */
	protected Vector				VECTOR_SIMPLE_HASH_DEFAULT_MAPPING_INFOS		= new Vector();

	/**
	 * SIMPLE HASH에 기본으로 장착되는 KEY VALUE MAPPING QUERY 저장 VECTOR
	 */
	protected Vector				VECTOR_KEY_VALUE_HASH_MAPPING_INFOS				= new Vector();

	protected ByteArrayOutputStream	INNER_BYTE_ARRAY_STREAM							= null;

	protected StringBuffer		TMP_STRING_BUFFER								= null;

	/** Creates a new instance of BasicDefaultMappingGenerator */
	public BasicDefaultMappingGenerator() {
		INNER_BYTE_ARRAY_STREAM = new ByteArrayOutputStream(1024);
		INSTANCE_QUERY_SELECT_DEFAULT_MAPPING_SQL_INFO = QUERY_SELECT_DEFAULT_MAPPING_SQL_INFO;
	}

	protected void inner_init(Properties prop) throws Exception {
		// 기본 쿼리 매핑정보를 클리어 하고 다시 세팅을 준비한다.
		this.SCHEDULE_INFO = prop;

		setName(this.SCHEDULE_INFO.getProperty("WORKDAY") + "_" + this.SCHEDULE_INFO.getProperty("SEQNO") + "_BasicDefaultMappingGenerator");
	}

	public void process(Properties prop) throws Exception {
		inner_init(prop);
		try {
			log.debug(getName() + " Request Connection");
			EMS_CONNECTION = ConnectionPool.getConnection();
			log.debug(" Get Connetion " + EMS_CONNECTION.getName());
		}
		catch(Exception e) {
			if( EMS_CONNECTION != null ) {
				EMS_CONNECTION.destroy();
			}

			log.debug(getName() + " Request Connection Error");

			//Reporter.report(getName(),getName(),"db.connection.init.error",e);
			throw e;
		}

		try {
			this.TMP_STRING_BUFFER = new StringBuffer(256);

			/* 쿼리매핑과 기본매핑에 필요한 쿼리를 초기화한다. */
			if (log.isDebugEnabled()) {
				log.debug("exec_getConnectInfo START");
			}
			exec_getConnectInfo();
			if (log.isDebugEnabled()) {
				log.debug("exec_getConnectInfo END");
			}

			/* 쿼리에 매핑을 할 정보를 초기화하여 쿼리 매핑 Hashtable을 세팅하는 */
			if (log.isDebugEnabled()) {
				log.debug("exec_QueryMappingInfoProcess START");
			}
			exec_QueryMappingInfoProcess();
			if (log.isDebugEnabled()) {
				log.debug("exec_QueryMappingInfoProcess END");
			}

			/* 컬럼이름을 키로 하여 기본 매핑을 하는 쿼리를 실행하여 각 파라미터값을 세팅 */
			if (log.isDebugEnabled()) {
				log.debug("exec_setSimpleDefaultMapping START");
			}
			exec_setSimpleDefaultMapping();
			if (log.isDebugEnabled()) {
				log.debug("exec_setSimpleDefaultMapping END");
			}

			/* 컬럼이름을 키로 하여 기본 매핑을 하는 쿼리를 실행하여 각 파라미터값을 세팅 */
			if (log.isDebugEnabled()) {
				log.debug("exec_setListDefaultMapping START");
			}
			exec_setListDefaultMapping();
			if (log.isDebugEnabled()) {
				log.debug("exec_setListDefaultMapping END");
			}

			/* 첫번째 컬럼을 키로하여 매핑을 하는 녀석을 세팅한다. */
			if (log.isDebugEnabled()) {
				log.debug("exec_setKeyValueDefaultMapping START");
			}
			exec_setKeyValueDefaultMapping();
			if (log.isDebugEnabled()) {
				log.debug("exec_setKeyValueDefaultMapping END");
			}

			/* 리스트 기본 매핑을 설정한다. */
			if (log.isDebugEnabled()) {
				log.debug("exec_setSimpleHashDefaultMapping START");
			}
			exec_setSimpleHashDefaultMapping();
			if (log.isDebugEnabled()) {
				log.debug("exec_setSimpleHashDefaultMapping END");
			}

			/* 리스트 기본 매핑을 설정한다. */
			if (log.isDebugEnabled()) {
				log.debug("exec_setKeyValueHashDefaultMapping START");
			}
			exec_setKeyValueHashDefaultMapping();
			if (log.isDebugEnabled()) {
				log.debug("exec_setKeyValueHashDefaultMapping END");
			}
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			this.TMP_STRING_BUFFER = null;
			EMS_CONNECTION.recycle();
			if (log.isDebugEnabled()) {
				log.debug("default_hashmapping :{}", this.DEFAULT_HASH_MAPPPING_MAP.toString());
				log.debug("default_mapping debug", this.DEFAULT_MAPPPING_MAP.toString());
			}
		}
	}

	/**
	 * @{} 매핑 정보를 반환
	 */
	public Map getMapOfDefaultMapping() {
		return this.DEFAULT_MAPPPING_MAP;
	}

	/**
	 * SimpleHash에 머징될 정보 반환
	 */
	public Map getMapOfDefaultHashMapping() {
		return this.DEFAULT_HASH_MAPPPING_MAP;
	}

	protected void exec_getConnectInfo() throws Exception {
		// 가져오기 전에 에러로 다시돌 경우에 대비해서 벡터를 비운다.
		this.VECTOR_QUERY_MAPPING_INFO.clear();
		this.VECTOR_LIST_MAPPING_INFOS.clear();
		this.VECTOR_SIMPLE_DEFAULT_MAPPING_INFOS.clear();
		this.VECTOR_KEY_VALUE_MAPPING_INFOS.clear();
		this.VECTOR_SIMPLE_HASH_DEFAULT_MAPPING_INFOS.clear();
		this.VECTOR_KEY_VALUE_HASH_MAPPING_INFOS.clear();

		eMsStatement __SELECT_STATEMENT__ = null;
		eMsResultSet rs = null;

		try {
			__SELECT_STATEMENT__ = EMS_CONNECTION.createStatement();

			// 스트링 버퍼로 전환 2004.11.04
			this.TMP_STRING_BUFFER.setLength(0);
			StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, INSTANCE_QUERY_SELECT_DEFAULT_MAPPING_SQL_INFO, this.SCHEDULE_INFO, "${", "}", true, false);
			//rs = __SELECT_STATEMENT__.executeQuery( INSTANCE_QUERY_SELECT_DEFAULT_MAPPING_SQL_INFO , this.SCHEDULE_INFO , "${" , "}" );
			rs = __SELECT_STATEMENT__.executeQuery(this.TMP_STRING_BUFFER.toString());

			Properties __TMP_CONNECT_INFOS__ = new Properties();

			while (rs.next()) {
				__TMP_CONNECT_INFOS__.clear();

				rs.putToMap(__TMP_CONNECT_INFOS__, false);

				ConnectInfo __TMP_CONNECTION_INFO__ = null;

				switch (eMsConnection.GET_CONNECTION_TYPE) {
					case eMsConnection.__CONNECTION_INDEX_TYPE__: {
						__TMP_CONNECTION_INFO__ = eMsConnection.getConnectInfo(__TMP_CONNECT_INFOS__.getProperty(eMsConnection.GET_CONNECTION_INDEX));
						break;
					}
					default: {
						__TMP_CONNECTION_INFO__ = new ConnectInfo();

						__TMP_CONNECTION_INFO__.setDB_ID(this.getName());
						__TMP_CONNECTION_INFO__.setDB_NAME(this.getName());

						__TMP_CONNECTION_INFO__.setDRIVER(__TMP_CONNECT_INFOS__.getProperty("CONNECT_DRIVER"));
						__TMP_CONNECTION_INFO__.setDB_URL(__TMP_CONNECT_INFOS__.getProperty("CONNECT_IP"));
						__TMP_CONNECTION_INFO__.setDB_UID(__TMP_CONNECT_INFOS__.getProperty("CONNECT_ID"));
						__TMP_CONNECTION_INFO__.setDB_PASS(HumusonDecryptor.decrypt( __TMP_CONNECT_INFOS__.getProperty("CONNECT_PWD"), encKey));
						__TMP_CONNECTION_INFO__.setDB_BASE_CHARSET(__TMP_CONNECT_INFOS__.getProperty("BASE_CHARSET"));
						__TMP_CONNECTION_INFO__.setDB_IN_CHARSET(__TMP_CONNECT_INFOS__.getProperty("IN_CHARSET"));
						__TMP_CONNECTION_INFO__.setDB_OUT_CHARSET(__TMP_CONNECT_INFOS__.getProperty("OUT_CHARSET"));
					}
				}

				__TMP_CONNECTION_INFO__.setQUERY(__TMP_CONNECT_INFOS__.getProperty("QUERY_SELECT"));
				__TMP_CONNECTION_INFO__.setAPPEND_NULL(__TMP_CONNECT_INFOS__.getProperty("APPEND_NULL", "N").equalsIgnoreCase("Y"));

				switch (Integer.parseInt(__TMP_CONNECT_INFOS__.getProperty("QUERY_TYPE"))) {
					/* 쿼리 매핑 정보 가져오는 */
					case 50: {
						this.VECTOR_QUERY_MAPPING_INFO.addElement(__TMP_CONNECTION_INFO__);
						break;
					}

					/* 컬럼 이름으로 매핑하는 사항들 */
					case 60: {
						this.VECTOR_SIMPLE_DEFAULT_MAPPING_INFOS.addElement(__TMP_CONNECTION_INFO__);
						break;
					}

					/* 두개의 컬럼을 가져와서 첫번째는 키 두번째는 값이 되는 쿼리 */
					case 70: {
						this.VECTOR_KEY_VALUE_MAPPING_INFOS.addElement(__TMP_CONNECTION_INFO__);
						break;
					}

					/* 기본 리스트 매핑을 가져오는 쿼리 */
					case 80: {
						this.VECTOR_LIST_MAPPING_INFOS.addElement(__TMP_CONNECTION_INFO__);
						break;
					}

					/* 기본 리스트 매핑을 가져오는 쿼리 */
					case 90: {
						this.VECTOR_SIMPLE_HASH_DEFAULT_MAPPING_INFOS.addElement(__TMP_CONNECTION_INFO__);
						break;
					}

					/* 기본 리스트 매핑을 가져오는 쿼리 */
					case 95: {
						this.VECTOR_KEY_VALUE_HASH_MAPPING_INFOS.addElement(__TMP_CONNECTION_INFO__);
						break;
					}

					default: {
						throw new RuntimeException("DB QUERY TYPE IS INVALID");
					}
				}
			}
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			try {
				rs.close();
			}
			catch(Exception ignore) {
			}
			EMS_CONNECTION.recycleStatement(__SELECT_STATEMENT__);
		}
	}

	protected void exec_QueryMappingInfoProcess() throws Exception {
		eMsConnection __TARGET_CONNECTION__ = null;
		eMsStatement stmt = null;
		eMsResultSet rs = null;

		int __QUERY_SIZE__ = this.VECTOR_QUERY_MAPPING_INFO.size();
		ConnectInfo __TARGET_CONNECT_INFO__ = null;
		String __EXEC_TARGET_QUERY__ = null;

		for (int i = 0; i < __QUERY_SIZE__; i++) {
			__TARGET_CONNECT_INFO__ = (ConnectInfo) this.VECTOR_QUERY_MAPPING_INFO.get(i);

			try {
				__TARGET_CONNECTION__ = ConnectionPool.getConnection(__TARGET_CONNECT_INFO__);

				stmt = __TARGET_CONNECTION__.createStatement();

				if (log.isDebugEnabled()) {
					log.info(getName() + ".QueryMappingInfoProcess() db url :" + __TARGET_CONNECT_INFO__.getDB_URL());
					log.info(getName() + ".QueryMappingInfoProcess() db id :" + __TARGET_CONNECT_INFO__.getDB_UID());
					log.info(getName() + ".QueryMappingInfoProcess() db pwd :" + __TARGET_CONNECT_INFO__.getDB_PASS());
				}

				this.TMP_STRING_BUFFER.setLength(0);
				StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, __TARGET_CONNECT_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
				__EXEC_TARGET_QUERY__ = this.TMP_STRING_BUFFER.toString();

				log.info(getName() + ".QueryMappingInfoProcess() exe query:" + __EXEC_TARGET_QUERY__);
				rs = stmt.executeQuery(__EXEC_TARGET_QUERY__);
				log.info(getName() + ".QueryMappingInfoProcess() exe query:[OK]");

				if( rs.next() ) {
					rs.putToMap(this.SCHEDULE_INFO, false);
				}
			}
			catch(Exception e) {
				log.error(getName(), __EXEC_TARGET_QUERY__);
				throw e;
			}
			finally {
				try {
					rs.close();
				}
				catch(Exception ignore) {
				}
				try {
					stmt.close();
				}
				catch(Exception ignore) {
				}
				try {
					__TARGET_CONNECTION__.destroy();
				}
				catch(Exception ignore) {
				}
			}
		}

		if (log.isDebugEnabled()) {
			log.debug( "QueryMappingInfoProcess END");
		}
	}

	/**
	 * 하나의 쿼리에서 컬럼이름을 키로한 매핑을 세팅
	 */
	protected void exec_setSimpleDefaultMapping() throws Exception {

		eMsConnection __TARGET_CONNECTION__ = null;
		eMsResultSet rs = null;
		eMsStatement stmt = null;

		int __QUERY_SIZE__ = this.VECTOR_SIMPLE_DEFAULT_MAPPING_INFOS.size();
		String __EXEC_TARGET_QUERY__ = null;
		ConnectInfo __TMP_CONNECTION_INFO__ = null;

		for (int i = 0; i < __QUERY_SIZE__; i++) {
			__TMP_CONNECTION_INFO__ = (ConnectInfo) this.VECTOR_SIMPLE_DEFAULT_MAPPING_INFOS.get(i);

			try {
				__TARGET_CONNECTION__ = ConnectionPool.getConnection(__TMP_CONNECTION_INFO__);

				stmt = __TARGET_CONNECTION__.createStatement();
				if (log.isDebugEnabled()) {
					log.info(getName() + ".setSimpleDefaultMapping() db url :" + __TMP_CONNECTION_INFO__.getDB_URL());
					log.info(getName() + ".setSimpleDefaultMapping() db id :" + __TMP_CONNECTION_INFO__.getDB_UID());
					log.info(getName() + ".setSimpleDefaultMapping() db pwd :" + __TMP_CONNECTION_INFO__.getDB_PASS());
				}

				this.TMP_STRING_BUFFER.setLength(0);
				StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, __TMP_CONNECTION_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
				__EXEC_TARGET_QUERY__ = this.TMP_STRING_BUFFER.toString();

				log.info(getName() + ".setSimpleDefaultMapping() exe query:" + __EXEC_TARGET_QUERY__);
				rs = stmt.executeQuery(__EXEC_TARGET_QUERY__);
				log.info(getName() + ".setSimpleDefaultMapping() exe query:[OK]");

				if( rs.next() ) {
					rs.putToMap(this.DEFAULT_MAPPPING_MAP, false);
				}
			}
			catch(Exception e) {
				log.error(getName(), __EXEC_TARGET_QUERY__);
				throw e;
			}
			finally {
				try {
					rs.close();
				}
				catch(Exception ignore) {
				}
				try {
					stmt.close();
				}
				catch(Exception ignore) {
				}
				try {
					__TARGET_CONNECTION__.destroy();
				}
				catch(Exception ignore) {
				}
			}
		}
		if (log.isDebugEnabled()) {
			log.debug( "setSimpleDefaultMapping END");
		}
	}

	protected void exec_setListDefaultMapping() throws Exception {

		eMsConnection __TARGET_CONNECTION__ = null;
		eMsResultSet rs = null;
		eMsStatement stmt = null;

		int __QUERY_SIZE__ = this.VECTOR_LIST_MAPPING_INFOS.size();
		String __EXEC_TARGET_QUERY__ = null;
		ConnectInfo __TMP_CONNECTION_INFO__ = null;

		log.debug( "setListDefaultMapping has " + __QUERY_SIZE__ + "querys");

		for (int i = 0; i < __QUERY_SIZE__; i++) {
			__TMP_CONNECTION_INFO__ = (ConnectInfo) this.VECTOR_LIST_MAPPING_INFOS.get(i);

			try {
				__TARGET_CONNECTION__ = ConnectionPool.getConnection(__TMP_CONNECTION_INFO__);

				stmt = __TARGET_CONNECTION__.createStatement();
				if (log.isDebugEnabled()) {
					log.info(getName() + ".setListDefaultMapping() db url :" + __TMP_CONNECTION_INFO__.getDB_URL());
					log.info(getName() + ".setListDefaultMapping() db id :" + __TMP_CONNECTION_INFO__.getDB_UID());
					log.info(getName() + ".setListDefaultMapping() db pwd :" + __TMP_CONNECTION_INFO__.getDB_PASS());
				}

				LinkedList __TMP_LIST_MAPPING_LIST__ = new LinkedList();

				this.TMP_STRING_BUFFER.setLength(0);
				StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, __TMP_CONNECTION_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
				__EXEC_TARGET_QUERY__ = this.TMP_STRING_BUFFER.toString();

				log.info(getName() + ".setListDefaultMapping() exe query:" + __EXEC_TARGET_QUERY__);
				rs = stmt.executeQuery(__EXEC_TARGET_QUERY__);
				log.info(getName() + ".setListDefaultMapping() exe query:[OK]");

				//				String key = null;
				//				String value = null;

				while (rs.next()) {
					Properties prop = new Properties();
					rs.putToMap(prop, false);
					__TMP_LIST_MAPPING_LIST__.addLast(prop);
				}

				this.DEFAULT_HASH_MAPPPING_MAP.put("default_rap_" + String.valueOf(i + 1), __TMP_LIST_MAPPING_LIST__);
			}
			catch(Exception e) {
				log.error(getName(), __EXEC_TARGET_QUERY__);
				throw e;
			}
			finally {
				try {
					rs.close();
				}
				catch(Exception ignore) {
				}
				try {
					stmt.close();
				}
				catch(Exception ignore) {
				}
				try {
					__TARGET_CONNECTION__.destroy();
				}
				catch(Exception ignore) {
				}
			}
		}

		if (log.isDebugEnabled()) {
			log.debug( "setListDefaultMapping END");
		}
	}

	/* 하나의 쿼리에서 컬럼이름을 키로한 매핑을 세팅 */
	protected void exec_setKeyValueDefaultMapping() throws Exception {

		eMsConnection __TARGET_CONNECTION__ = null;
		eMsResultSet rs = null;
		eMsStatement stmt = null;

		int __QUERY_SIZE__ = this.VECTOR_KEY_VALUE_MAPPING_INFOS.size();
		String __EXEC_TARGET_QUERY__ = null;
		ConnectInfo __TMP_CONNECTION_INFO__ = null;

		/**
		 * KEY VALUE에서 파일(URL)경로의 내용이 VALUE일 경우에 치환하는 로직 삽입
		 */
		String __KEY_STRING__ = null;
		String __VALUE_STRING__ = null;

		for (int i = 0; i < __QUERY_SIZE__; i++) {
			__TMP_CONNECTION_INFO__ = (ConnectInfo) this.VECTOR_KEY_VALUE_MAPPING_INFOS.get(i);

			try {
				__TARGET_CONNECTION__ = ConnectionPool.getConnection(__TMP_CONNECTION_INFO__);

				stmt = __TARGET_CONNECTION__.createStatement();
				if (log.isDebugEnabled()) {
					log.info(getName() + ".setKeyValueDefaultMapping() db url :" + __TMP_CONNECTION_INFO__.getDB_URL());
					log.info(getName() + ".setKeyValueDefaultMapping() db id :" + __TMP_CONNECTION_INFO__.getDB_UID());
					log.info(getName() + ".setKeyValueDefaultMapping() db pwd :" + __TMP_CONNECTION_INFO__.getDB_PASS());
				}

				this.TMP_STRING_BUFFER.setLength(0);
				StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, __TMP_CONNECTION_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
				__EXEC_TARGET_QUERY__ = this.TMP_STRING_BUFFER.toString();

				log.info(getName() + ".setKeyValueDefaultMapping() exe query:" + __EXEC_TARGET_QUERY__);
				rs = stmt.executeQuery(__EXEC_TARGET_QUERY__);
				log.info(getName() + ".setKeyValueDefaultMapping() exe query:[OK]");

				while (rs.next()) {
					__KEY_STRING__ = rs.getString(1);
					__VALUE_STRING__ = rs.getString(2);

					if( __VALUE_STRING__.startsWith("URL:") ) {
						synchronized (INNER_BYTE_ARRAY_STREAM) {
							INNER_BYTE_ARRAY_STREAM.reset();
							FileElement.putFileBodyToStream(__VALUE_STRING__.substring(4), INNER_BYTE_ARRAY_STREAM);
							this.DEFAULT_MAPPPING_MAP.put(__KEY_STRING__, INNER_BYTE_ARRAY_STREAM.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET));
						}
					}
					else {
						this.DEFAULT_MAPPPING_MAP.put(__KEY_STRING__, __VALUE_STRING__);
					}
				}
			}
			catch(Exception e) {
				log.error(getName(), __EXEC_TARGET_QUERY__);
				throw e;
			}
			finally {
				try {
					rs.close();
				}
				catch(Exception ignore) {
				}
				try {
					stmt.close();
				}
				catch(Exception ignore) {
				}
				try {
					__TARGET_CONNECTION__.destroy();
				}
				catch(Exception ignore) {
				}
				//				if (log.isDebugEnabled())  log.debug( getName() + ".setKeyValueDefaultMapping()" , this.DEFAULT_MAPPPING_MAP.toString() );
			}
		}
		if (log.isDebugEnabled()) {
			log.debug( "setKeyValueDefaultMapping END");
		}
	}

	/*
	 * 하나의 쿼리에서 컬럼이름을 키로한 매핑을 세팅 이것은 @{} 로 매핑이 아니라 ${} 로 매핑이된다. 프리마커의 함수를 사용할수 있도록 하는 것은 이것으로 소화를 해야한다.
	 */
	protected void exec_setKeyValueHashDefaultMapping() throws Exception {
		eMsConnection __TARGET_CONNECTION__ = null;
		eMsResultSet rs = null;
		eMsStatement stmt = null;

		int __QUERY_SIZE__ = this.VECTOR_KEY_VALUE_HASH_MAPPING_INFOS.size();
		String __EXEC_TARGET_QUERY__ = null;
		ConnectInfo __TMP_CONNECTION_INFO__ = null;

		/**
		 * KEY VALUE에서 파일(URL)경로의 내용이 VALUE일 경우에 치환하는 로직 삽입
		 */
		String __KEY_STRING__ = null;
		String __VALUE_STRING__ = null;

		for (int i = 0; i < __QUERY_SIZE__; i++) {
			__TMP_CONNECTION_INFO__ = (ConnectInfo) this.VECTOR_KEY_VALUE_HASH_MAPPING_INFOS.get(i);

			try {
				__TARGET_CONNECTION__ = ConnectionPool.getConnection(__TMP_CONNECTION_INFO__);

				stmt = __TARGET_CONNECTION__.createStatement();
				if (log.isDebugEnabled()) {
					log.info(getName() + ".setKeyValueHashDefaultMapping() db url :" + __TMP_CONNECTION_INFO__.getDB_URL());
					log.info(getName() + ".setKeyValueHashDefaultMapping() db id :" + __TMP_CONNECTION_INFO__.getDB_UID());
					log.info(getName() + ".setKeyValueHashDefaultMapping() db pwd :" + __TMP_CONNECTION_INFO__.getDB_PASS());
				}

				this.TMP_STRING_BUFFER.setLength(0);
				StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, __TMP_CONNECTION_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
				__EXEC_TARGET_QUERY__ = this.TMP_STRING_BUFFER.toString();

				log.info(getName() + ".setKeyValueHashDefaultMapping() exe query:" + __EXEC_TARGET_QUERY__);
				rs = stmt.executeQuery(__EXEC_TARGET_QUERY__);
				log.info(getName() + ".setKeyValueHashDefaultMapping() exe query:[OK]");

				while (rs.next()) {
					__KEY_STRING__ = rs.getString(1);
					__VALUE_STRING__ = rs.getString(2);

					if( __VALUE_STRING__.startsWith("URL:") ) {
						synchronized (INNER_BYTE_ARRAY_STREAM) {
							INNER_BYTE_ARRAY_STREAM.reset();
							FileElement.putFileBodyToStream(__VALUE_STRING__.substring(4), INNER_BYTE_ARRAY_STREAM);
							this.DEFAULT_HASH_MAPPPING_MAP.put(__KEY_STRING__, INNER_BYTE_ARRAY_STREAM.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET));
						}
					}
					else {
						this.DEFAULT_HASH_MAPPPING_MAP.put(__KEY_STRING__, __VALUE_STRING__);
					}
				}
			}
			catch(Exception e) {
				log.error(getName(), __EXEC_TARGET_QUERY__);
				throw e;
			}
			finally {
				try {
					rs.close();
				}
				catch(Exception ignore) {
				}
				try {
					stmt.close();
				}
				catch(Exception ignore) {
				}
				try {
					__TARGET_CONNECTION__.destroy();
				}
				catch(Exception ignore) {
				}
			}
		}
		if (log.isDebugEnabled()) {
			log.debug( "setKeyValueHashDefaultMapping END");
		}
	}

	/* 하나의 쿼리에서 컬럼이름을 키로한 매핑을 세팅 */
	protected void exec_setSimpleHashDefaultMapping() throws Exception {
		eMsConnection __TARGET_CONNECTION__ = null;
		eMsResultSet rs = null;
		eMsStatement stmt = null;

		int __QUERY_SIZE__ = this.VECTOR_SIMPLE_HASH_DEFAULT_MAPPING_INFOS.size();
		String __EXEC_TARGET_QUERY__ = null;
		ConnectInfo __TMP_CONNECTION_INFO__ = null;

		for (int i = 0; i < __QUERY_SIZE__; i++) {
			__TMP_CONNECTION_INFO__ = (ConnectInfo) this.VECTOR_SIMPLE_HASH_DEFAULT_MAPPING_INFOS.get(i);

			try {
				__TARGET_CONNECTION__ = ConnectionPool.getConnection(__TMP_CONNECTION_INFO__);

				stmt = __TARGET_CONNECTION__.createStatement();
				if (log.isDebugEnabled()) {
					log.info(getName() + ".exec_setSimpleHashDefaultMapping() db url :" + __TMP_CONNECTION_INFO__.getDB_URL());
					log.info(getName() + ".exec_setSimpleHashDefaultMapping() db id :" + __TMP_CONNECTION_INFO__.getDB_UID());
					log.info(getName() + ".exec_setSimpleHashDefaultMapping() db pwd :" + __TMP_CONNECTION_INFO__.getDB_PASS());
				}

				this.TMP_STRING_BUFFER.setLength(0);
				StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, __TMP_CONNECTION_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
				__EXEC_TARGET_QUERY__ = this.TMP_STRING_BUFFER.toString();

				log.info(getName() + ".exec_setSimpleHashDefaultMapping() exe query:" + __EXEC_TARGET_QUERY__);
				rs = stmt.executeQuery(__EXEC_TARGET_QUERY__);
				log.info(getName() + ".exec_setSimpleHashDefaultMapping() exe query:[OK]");

				if( rs.next() ) {
					rs.putToMap(this.DEFAULT_HASH_MAPPPING_MAP, false);
				}
			}
			catch(Exception e) {
				log.error(getName(), __EXEC_TARGET_QUERY__);
				throw e;
			}
			finally {
				try {
					rs.close();
				}
				catch(Exception ignore) {
				}
				try {
					stmt.close();
				}
				catch(Exception ignore) {
				}
				try {
					__TARGET_CONNECTION__.destroy();
				}
				catch(Exception ignore) {
				}
			}
		}
		if (log.isDebugEnabled()) {
			log.debug( "setSimpleHashDefaultMapping END");
		}
	}
}
