/*
 * eMsXmlErrorHandler.java
 *
 * Created on 2003년 11월 17일 (월), 오후 10:52
 */

package pluto.util.xml;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
/**
 *
 * @author  Administrator
 */
public class eMsXmlErrorHandler implements org.xml.sax.ErrorHandler{
	
	/** Creates a new instance of eMsXmlErrorHandler */
	public eMsXmlErrorHandler() {
	}
	
	public void warning(org.xml.sax.SAXParseException ex) throws org.xml.sax.SAXException {
		System.err.println("[Warning] "+ getLocationString(ex)+": "+ ex.getMessage());
	}
	
	public void error(org.xml.sax.SAXParseException ex) throws org.xml.sax.SAXException {
		System.err.println("[Error] "+ getLocationString(ex)+": "+ ex.getMessage());
	}
	
	public void fatalError(SAXParseException ex) throws SAXException {
		System.err.println("[Fatal Error] "+ getLocationString(ex)+": "+ ex.getMessage());
		throw ex;
	}
	
	private String getLocationString(SAXParseException ex) {
		StringBuffer str = new StringBuffer();
		
		String systemId = ex.getSystemId();
		
		if (systemId != null) {
			int index = systemId.lastIndexOf('/');
			if (index != -1)
				systemId = systemId.substring(index + 1);
			str.append(systemId);
		}
		str.append(':');
		str.append(ex.getLineNumber());
		str.append(':');
		str.append(ex.getColumnNumber());
		
		return str.toString();
	}
}
