/*
 * XMLWriter.java
 * 
 * Created on 2003년 4월 7일 월, 오전 10:09
 */

package pluto.util.xml;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import pluto.io.eMsFileWriter;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class XMLWriter {
	

	private static final String		__TAB								= "\t";

	private static final String		__TAG_OPEN							= "<";

	private static final String		__END_TAG_OPEN						= "</";

	private static final String		__TAG_CLOSE							= ">";

	private static final String		__NO_CHILD_TAG_CLOSE				= "/>";

	private static final String		__ATTR_OPEN							= "=\"";

	private static final String		__ATTR_CLOSE						= "\"";

	private static final String		__BLANK								= " ";

	private static final String		__PROCESSING_INSTRUCTION_NODE_OPEN	= "<?";

	private static final String		__PROCESSING_INSTRUCTION_NODE_CLOSE	= "?>";

	private static final String		__N_PERCENT							= "&";

	private static final String		__SEMICOLON							= ";";

	private static final String		__CDATA_OPEN						= "<![CDATA[";

	private static final String		__CDATA_CLOSE						= "]]>";

	private String					PRINTWRITER_ENCODING				= "euc-kr";

	private boolean					canonical							= false;

	private eMsFileWriter			WRITER								= null;

	private String					DTDFile								= null;

	private StringBuffer			__INNER_WORK_BUFFER					= null;

	/** Creates new XMLWriter */
	public XMLWriter() throws Exception {
		this.canonical = false;
		__INNER_WORK_BUFFER = new StringBuffer(256);
	}

	public void outResult(eMsFileWriter __STREAM, Document myDoc, String df) throws Exception {
		this.DTDFile = df;
		this.WRITER = __STREAM;
		this.WRITER.println("<?xml version=\"1.0\" encoding=\"" + getWriterEncoding() + "\"?>");

		Node node = myDoc.getFirstChild();

		if( node.getNodeType() == Node.ELEMENT_NODE ) {
			this.WRITER.println("<!DOCTYPE " + ((Element) node).getTagName() + " SYSTEM \"" + DTDFile + "\">");
		}
		print(myDoc, 0);
	}

	public void setEncoding(String enc) {
		this.PRINTWRITER_ENCODING = enc;
	}

	public void setCanonical(boolean can) {
		this.canonical = can;
	}

	private Attr[] sortAttributes(NamedNodeMap attrs) {
		int len = (attrs != null) ? attrs.getLength() : 0;

		Attr array[] = new Attr[len];

		for (int i = 0; i < len; i++) {
			array[i] = (Attr) attrs.item(i);
		}
		return (array);

	} // sortAttributes(NamedNodeMap):Attr[]

	private void print(Node node, int depth) throws Exception {
		// is there anything to do?
		if( node == null ) {
			return;
		}

		int type = node.getNodeType();

		boolean __HAS_CHILD__ = false;

		switch (type) {
			// print document

			case Node.DOCUMENT_NODE: {
				NodeList children = node.getChildNodes();

				for (int iChild = 0; iChild < children.getLength(); iChild++) {
					print(children.item(iChild), depth);
				}
				break;
			}

			case Node.DOCUMENT_TYPE_NODE: {
				this.WRITER.println("<!DOCTYPE " + ((DocumentType) node).getName() + " SYSTEM \"" + DTDFile + "\">");
				break;
			}

			// print element with attributes
			case Node.ELEMENT_NODE: {
				//print("type ELEMENT_NODE:" + type);
				for (int k = 0; k < depth; k++) {
					this.WRITER.print(__TAB);
				}

				this.WRITER.print(__TAG_OPEN);
				this.WRITER.print(node.getNodeName());
				Attr attrs[] = sortAttributes(node.getAttributes());
				//Attr attrs[] = node.getAttributes();

				for (int i = 0; i < attrs.length; i++) {
					Attr attr = attrs[i];
					this.WRITER.print(__BLANK);
					this.WRITER.print(attr.getNodeName());
					this.WRITER.print(__ATTR_OPEN);
					this.WRITER.print(normalize(attr.getNodeValue()));
					this.WRITER.print(__ATTR_CLOSE);
				}

				NodeList children = node.getChildNodes();

				if( children != null ) {
					int len = children.getLength();
					if( len > 0 ) {
						__HAS_CHILD__ = true;
						this.WRITER.println(__TAG_CLOSE);
						for (int i = 0; i < len; i++) {
							print(children.item(i), depth + 1);
						}
					}
					else {
						__HAS_CHILD__ = false;
						this.WRITER.println(__NO_CHILD_TAG_CLOSE);
					}
				}

				break;
			}

			// handle entity reference nodes
			case Node.ENTITY_REFERENCE_NODE: {
				//print("type ENTITY_REFERENCE_NODE:" + type);

				if( canonical ) {
					NodeList children = node.getChildNodes();
					if( children != null ) {
						int len = children.getLength();
						for (int i = 0; i < len; i++) {
							print(children.item(i), depth + 1);
						}
					}
				}
				else {
					this.WRITER.print(__N_PERCENT);
					this.WRITER.print(node.getNodeName());
					this.WRITER.print(__SEMICOLON);
				}
				break;
			}

			// print cdata sections
			case Node.CDATA_SECTION_NODE: {
				//print("type CDATA_SECTION_NODE:" + type);
				for (int k = 0; k < depth; k++) {
					this.WRITER.print(__TAB);
				}

				if( canonical ) {
					this.WRITER.print(normalize(node.getNodeValue()));
				}
				else {
					this.WRITER.print(__CDATA_OPEN);
					if (log.isDebugEnabled()) {
						log.debug("CDATA:" + node.getNodeValue());
					}
					this.WRITER.print(node.getNodeValue());
					this.WRITER.println(__CDATA_CLOSE);
				}
				break;
			}

			// print text
			case Node.TEXT_NODE: {
				//print("type TEXT_NODE:" + type);

				String nodeValue = node.getNodeValue();

				if( nodeValue.trim().length() == 0 )
					break;

				for (int k = 0; k < depth; k++) {
					this.WRITER.print(__TAB);
				}
				this.WRITER.println(normalize(nodeValue));
				break;
			}

			// print processing instruction
			case Node.PROCESSING_INSTRUCTION_NODE: {
				//print("type PROCESSING_INSTRUCTION_NODE:" + type);
				for (int k = 0; k < depth; k++) {
					this.WRITER.print(__TAB);
				}
				this.WRITER.print(__PROCESSING_INSTRUCTION_NODE_OPEN);
				this.WRITER.print(node.getNodeName());
				String data = node.getNodeValue();
				if( data != null && data.length() > 0 ) {
					this.WRITER.print(__BLANK);
					this.WRITER.print(data);
				}
				this.WRITER.println(__PROCESSING_INSTRUCTION_NODE_CLOSE);
				break;
			}

			default:
		//println("default:" + type);

		}

		if( type == Node.ELEMENT_NODE && __HAS_CHILD__ ) {
			for (int k = 0; k < depth; k++) {
				this.WRITER.print(__TAB);
			}
			this.WRITER.print(__END_TAG_OPEN);
			this.WRITER.print(node.getNodeName());
			this.WRITER.println(__TAG_CLOSE);
		}

		this.WRITER.flush();

	} // print(Node)

	private synchronized String normalize(String s) {
		__INNER_WORK_BUFFER.setLength(0);

		int len = (s != null) ? s.length() : 0;

		for (int i = 0; i < len; i++) {
			char ch = s.charAt(i);
			switch (ch) {
				case '<': {
					__INNER_WORK_BUFFER.append("&lt;");
					break;
				}

				case '>': {
					__INNER_WORK_BUFFER.append("&gt;");
					break;
				}
				case '&': {
					__INNER_WORK_BUFFER.append("&amp;");
					break;
				}
				case '"': {
					__INNER_WORK_BUFFER.append("&quot;");
					break;
				}

				case '\\': {
					__INNER_WORK_BUFFER.append("\\\\");
					break;
				}

				case '\r':

				case '\n': {
					if( canonical ) {
						__INNER_WORK_BUFFER.append("&#");
						__INNER_WORK_BUFFER.append(Integer.toString(ch));
						__INNER_WORK_BUFFER.append(';');
						break;
					}
					// else, default append char
				}


				default: {
					__INNER_WORK_BUFFER.append(ch);
				}
			}
		}

		return (__INNER_WORK_BUFFER.toString());

	}

	private String getWriterEncoding() {
		return PRINTWRITER_ENCODING;
	}
}
