/*
 * XMLUtil.java
 *
 * Created on 2003년 3월 20일 목, 오전 10:44
 */

package pluto.util.xml;

import java.util.List;

import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import lombok.extern.slf4j.Slf4j;
import pluto.util.PlutoLinkedList;
import pluto.util.StringLinkedList;
/**
 *
 * @author  Administrator
 * @version
 */
@Slf4j
public class XMLUtil extends java.lang.Object {
	
	/** Creates new XMLUtil */
	public XMLUtil() {
	}
	/**
	 * public static void main( String[] args ) throws Exception
	 * {
	 * Document doc = new DocumentImpl();
	 * Element add = doc.createElement( "root" );
	 *
	 * uniqueAppend( doc , add , "db" , "d1" );
	 * uniqueAppend( doc , add , "db" , "d2" );
	 * uniqueAppend( doc , add , "db" , "d2" );
	 * uniqueAppend( doc , add , "db" , "d3" );
	 * uniqueAppend( doc , add , "db" , "d3" );
	 * uniqueAppend( doc , add , "db" , "d3" );
	 * uniqueAppend( doc , add , "db" , "d4" );
	 *
	 * uniqueAppend( doc , uniqueAppend( doc , add , "db" , "d2" ) , "table" , "t1" );
	 * uniqueAppend( doc , uniqueAppend( doc , add , "db" , "d2" ) , "table" , "t1" );
	 * uniqueAppend( doc , uniqueAppend( doc , add , "db" , "d2" ) , "table" , "t2" );
	 * uniqueAppend( doc , uniqueAppend( doc , add , "db" , "d2" ) , "table" , "t2" );
	 * uniqueAppend( doc , uniqueAppend( doc , add , "db" , "d2" ) , "table" , "t3" );
	 *
	 * doc.appendChild( add );
	 *
	 * OutputFormat    format  = new OutputFormat( doc );   //Serialize DOM
	 * StringWriter  stringOut = new StringWriter();        //Writer will be a String
	 * XMLSerializer    serial = new XMLSerializer( stringOut, format );
	 * serial.asDOMSerializer();                            // As a DOM Serializer
	 *
	 * serial.serialize( doc.getDocumentElement() );
	 *
	 * log.debug( "STRXML = " + stringOut.toString() ); //Spit out DOM as a String
	 * }
	 **/
	//	private static Document DOCUMENT= new DocumentImpl();
	
	public static final Element append( Document doc , Element root , String node_name , String node_value ) throws Exception {
		Element add = doc.createElement( node_name );
		add.setAttribute( "value" , node_value );
		return (Element)root.appendChild( add );
	}
	
	public static final Element uniqueAppend( Document doc , Element root , String node_name , String node_value ) throws Exception {
		NodeList sub_list = root.getChildNodes();
		
		Node tmp_node = null;
		
		/**sub Node가 없을 경우에는 하나 생성해서 append한다.
		 */
		for( int idx = 0 ; idx < sub_list.getLength() ; idx++ ) {
			tmp_node = sub_list.item(idx);
			
			/**Element노드가 아니면 검사할 필요가 없다.
			 */
			if( tmp_node.getNodeType() != Node.ELEMENT_NODE ) continue;
			
			/**대상을 발견한다면
			 */
			if( tmp_node.getNodeName().equals( node_name ) && ( (Element)tmp_node).getAttribute("value").equals( node_value ) ) {
				/**대상을 발견하면 그녀석을 반환하면 된다.
				 */
				return (Element)tmp_node;
			}
		}
		
		return append( doc , root , node_name , node_value );
	}
	
	public static final String getCDATA_SECTION( Node __TARGET_NODE__ ) {
		return getCDATA_SECTION( __TARGET_NODE__ , null );
	}
	
	public static final String getCDATA_SECTION( Node __TARGET_NODE__ , String defaultValue ) {
		NodeList __SUB_NODES__ = __TARGET_NODE__.getChildNodes();
		
		Node __SUB_NODE__ = null;
		
		for( int j = 0 ; j < __SUB_NODES__.getLength() ; j++ ) {
			__SUB_NODE__ = __SUB_NODES__.item(j);
			
			if( __SUB_NODE__.getNodeType() == Node.CDATA_SECTION_NODE ) {
				return ((CharacterData)__SUB_NODE__).getData();
			}
		}
		
		return defaultValue;
	}
	
	public static final String getCDATA_SECTION_OR_TEXT_NODE( Node __TARGET_NODE__ ) {
		NodeList __SUB_NODES__ = __TARGET_NODE__.getChildNodes();
		
		Node __SUB_NODE__ = null;
		
		for( int j = 0 ; j < __SUB_NODES__.getLength() ; j++ ) {
			__SUB_NODE__ = __SUB_NODES__.item(j);
			
			if( __SUB_NODE__.getNodeType() == Node.CDATA_SECTION_NODE ) {
				return ((CharacterData)__SUB_NODE__).getData();
			}
			
			if( __SUB_NODE__.getNodeType() == Node.TEXT_NODE ) {
				String tmpValue = ((Text)__SUB_NODE__).getData();
				if( tmpValue.length() > 0 ) return tmpValue;
			}
		}
		
		return null;
	}
	
	/**여러개의 텍스트 노드를 List로 엮어서 반환한다. 이때 trim()해서 사이즈가 0 인 녀석은 제외된다.
	 */
	public static final List getMultiCDATA_SECTION( Node __TARGET_NODE__ ) {
		NodeList __SUB_NODES__ = __TARGET_NODE__.getChildNodes();
		
		Node __SUB_NODE__ = null;
		
		List returnValue = new PlutoLinkedList();
		
		String targetValue = null;
		for( int j = 0 ; j < __SUB_NODES__.getLength() ; j++ ) {
			__SUB_NODE__ = __SUB_NODES__.item(j);
			
			if( __SUB_NODE__.getNodeType() == Node.CDATA_SECTION_NODE ) {
				targetValue = ((CharacterData)__SUB_NODE__).getData().trim();
				if( targetValue.length() > 0 ){
					returnValue.add( targetValue );
				}
			}
		}
		
		return returnValue;
	}
	
	/**여러개의 텍스트 노드를 List로 엮어서 반환한다. 이때 trim()해서 사이즈가 0 인 녀석은 제외된다.
	 */
	public static final void getMultiCDATA_SECTION( Node __TARGET_NODE__ , List returnValue ) {
		NodeList __SUB_NODES__ = __TARGET_NODE__.getChildNodes();
		
		Node __SUB_NODE__ = null;
		
		String targetValue = null;
		for( int j = 0 ; j < __SUB_NODES__.getLength() ; j++ ) {
			__SUB_NODE__ = __SUB_NODES__.item(j);
			
			if( __SUB_NODE__.getNodeType() == Node.CDATA_SECTION_NODE ) {
				targetValue = ((CharacterData)__SUB_NODE__).getData().trim();
				if( targetValue.length() > 0 ){
					returnValue.add( targetValue );
				}
			}
		}
	}
	
	/**여러개의 텍스트 노드를 List로 엮어서 반환한다. 이때 trim()해서 사이즈가 0 인 녀석은 제외된다.
	 */
	public static final void putMultiCDATASectionToStringLinkedList( Node __TARGET_NODE__ , StringLinkedList returnValue ) {
		NodeList __SUB_NODES__ = __TARGET_NODE__.getChildNodes();
		
		Node __SUB_NODE__ = null;
		String targetValue = null;
		for( int j = 0 ; j < __SUB_NODES__.getLength() ; j++ ) {
			__SUB_NODE__ = __SUB_NODES__.item(j);
			
			if( __SUB_NODE__.getNodeType() == Node.CDATA_SECTION_NODE ) {
				targetValue = ((CharacterData)__SUB_NODE__).getData();
				if( targetValue.length() > 0 ){
					returnValue.add( targetValue );
				}
			}
		}
	}
	
	/**여러개의 텍스트 노드를 List로 엮어서 반환한다. 이때 trim()해서 사이즈가 0 인 녀석은 제외된다.
	 */
	public static final List getMultiCDATA_SECTION_OR_TEXT_NODE( Node __TARGET_NODE__ ) {
		NodeList __SUB_NODES__ = __TARGET_NODE__.getChildNodes();
		
		Node __SUB_NODE__ = null;
		
		List returnValue = new PlutoLinkedList();
		
		for( int j = 0 ; j < __SUB_NODES__.getLength() ; j++ ) {
			__SUB_NODE__ = __SUB_NODES__.item(j);
			String tmpValue = null;
			if( __SUB_NODE__.getNodeType() == Node.CDATA_SECTION_NODE ) {
				tmpValue = ((CharacterData)__SUB_NODE__).getData().trim();
				if( tmpValue.length() > 0 ){
					returnValue.add( tmpValue );
				}
			}
			if( __SUB_NODE__.getNodeType() == Node.TEXT_NODE ) {
				tmpValue = ((Text)__SUB_NODE__).getData().trim();
				if( tmpValue.length() > 0 ){
					returnValue.add( tmpValue );
				}
			}
		}
		
		return returnValue;
	}
	
	public static final String getSubElementAttribute( Element __ROOT_ELEMENT__ , String elm_name , String att_name ) {
		return getSubElementAttribute( __ROOT_ELEMENT__ , elm_name , att_name , null );
	}
	
	public static final String getSubElementAttribute( Element __ROOT_ELEMENT__ , String elm_name , String att_name , String default_value ) {
		NodeList sublist = __ROOT_ELEMENT__.getElementsByTagName( elm_name );
		
		if( sublist == null ) return default_value;
		
		//return pluto.init.Activator.convert( new Hashtable(), ( ( Element )sublist.item( 0 ) ).getAttribute( att_name ) );
		return ( ( Element )sublist.item( 0 ) ).getAttribute( att_name );
	}
	
	public static final Element getFirstNamedElement( Element __ROOT_ELEMENT__ , String elm_name ) {
		NodeList sublist = __ROOT_ELEMENT__.getElementsByTagName( elm_name );
		
		if( sublist == null ) return null;
		
		return ( Element )sublist.item( 0 );
	}
}
